;         ENVCOUNT.ASM -- Counts the number of bytes used in the Environment

CSEG            Segment
                Assume        CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                Org         100h                ; For COM file
Entry:          Jmp        Begin

;------------------- All Data is here:
notice          db 'Copyright 1986 Ziff-Davis Publishing Co.'
notice2         db 'Programmed by Richard Hale Shaw'
Message         db 'The Environment is currently using: '  ; message to print
Count           db '      bytes',13,10,'$'      ; Place for count

Max_count       Equ 4
           ;-----------------------------------------------------------------------

Begin:
                Push       DS                   ; Save DS on stack
                Mov        AX,CS:[2Ch]          ; Get Environment address
                Mov        DS,AX                ; into DS

                Mov        DI,0                 ; Set DI to offset 0
                Xor        SI,SI                ; Clear SI to 0

Next_byte:
                Cmp        Word Ptr[SI],0000    ; Check for End of Environment
                Je         Found_end            ; If found, break out of loop
                Inc        SI                   ; Point to next byte

                Jmp        Next_byte            ; Loop back to check next byte

Found_end:
                Mov        AX,SI
                Add        AX,4                 ; Add for current bytes
                                                ; and "word-count"

                Pop        DS                   ; Restore DS from stack

                ; The size of Environment space in use is now in AX

                Mov        CX,Max_count         ; Length of count into CX
                Mov        DI,Offset Count+4    ; Point DI to End of string
                Mov        SI,10                ; Set SI to divide AX by 10
                Xor        DX,DX                ; Clear DX
Another:        Div        SI                   ; Divide AX by 10, rem. in DX
                Add        DX,'0'               ; Convert DX to ASCII
                Mov        Byte Ptr [DI],DL     ; Move Ascii value to buffer
                Dec        DI                   ; Decrement Pointer
                Xor        DX,DX                ; Clear DX
                Cmp        AX,SI                ; If AX is >= 10
                Jae        Another              ; Loop back
                Add        AX,'0'               ; Else Convert DX to ASCII
                Mov        Byte Ptr [DI],AL     ; Move Ascii value to buffer


Print_result:   Mov        DX,Offset Message    ; Load Message address
                Mov        AH,9                 ; Function to print message
                Int        21h                  ; Call DOS

Exit:           Int        20h                  ; All DONE!!, Quit

EndProg         Label      Byte                 ; End of program
CSEG            Ends
                End Entry
                                                 