;-----------------------------------------------------------
; ASC2PS.ASM -- ASCII to PostScript Pipe Program
;               PC Magazine * Charles Petzold, 7/88
;               Copyright (c) 1988, Ziff Communications Co.
;-----------------------------------------------------------

		EXTRN DosRead:FAR, DosWrite:FAR, DosExit:FAR

		IFDEF DOSVERSION
			PushI	MACRO Value
				Mov	AX, Value
				Push	AX
				ENDM
		ELSE
			.286
			PushI	MACRO Value
				Push	Value
				ENDM
		ENDIF

		DOSSEG
		.MODEL	SMALL, PASCAL
		.STACK	4096

;--------------------------------------------
; Entry point of program and main processing
;--------------------------------------------

		.DATA?

AsciiBuffer	db	200 dup (?)

		.CODE

Entry		PROC
                LOCAL   LineNum:WORD, ColNum:WORD

		IFDEF DOSVERSION
			Mov	AX, DGROUP	; For DOS, set DS to
			Mov	DS, AX		;   DGROUP segment
		ENDIF

		Push	DS			; Set ES to DS
		Pop	ES

GetNextLine:	Mov	DI, Offset AsciiBuffer	; Point DI to buffer begiining
		Mov	ColNum, 0		; Initialize to 1st column

GetNextChar:	Call	getchar			; Get a character from SI

		Cmp	AX, -1			; Check if end of file
		Jnz	HaveValidData		; If not, continue
		Jmp	EndOfData		; If so, time to clean up

HaveValidData:	Cmp	AL, 9			; Check if tab character
		Jb	GetNextChar		; If below, ignore it
		Je	TabChar			; Otherwise, process it

		Cmp	AL, 10			; Check if line feed
		Je	LineFeed		; If so, process it

		Cmp	AL, 12			; Check if form feed
		Je	EndOfPage		; If so, process it

		Cmp	AL, ' '			; Check if space
		Jb	GetNextChar		; If below, ignore character
		
		Cmp	AL, 127			; Check if high order
		Jb	NormalChar		; If not, process character
		Mov	AL, ' '			; Otherwise set to space
		Jmp	NormalChar		; And process it

TabChar:	Mov	AL, ' '			; For tabs, store a space
		Stosb
		Inc	ColNum			; Until column number is
		Test	ColNum, 7		;   increment of 8
		Jnz	TabChar
		Jmp	TestEndOfLine		; Now check for end of line

LineFeed:	Sub	AL, AL			; Mark end of line
		Stosb				;   with zero

PrintLine:      PushI	<Offset AsciiBuffer>	; Address of buffer
                PushI	LineNum			; Text line number
		Call	LineOut			; Output the line
		Mov	LineNum, AX		; Get new line number
		Jmp	GetNextLine		; And do the next line

EndOfPage:	Sub	AL, AL			; Mark end of line
		Stosb				;   with zero
                PushI	<Offset AsciiBuffer>	; Address of buffer
                PushI	LineNum			; Rext line number
		Call	LineOut			; Output the line

		Mov	[AsciiBuffer], 0	; Make a blank line
		Mov	LineNum, 65		; Set line number to bottom

		Jmp	PrintLine		; And continue for new page

NormalChar:	Cmp	AL, '('			; Check for left paren,
		Je	Special
		Cmp	AL, ')'			;   right paren, 
		Je	Special
		Cmp	AL, '\'			;   or back slash.
		Jne	NotSpecial

Special:	Mov	AH, AL			; Save the character
		Mov	AL, '\'			; Store a backslash
		Stosb
		Mov	AL, AH			; Now get back real character

NotSpecial:	Stosb				; Store the character
		Inc	ColNum			; Bump up the column counter

TestEndOfLine:	Cmp	ColNum, 80		; Check for 80 columns
		Jz	LineFeed		; If so, do a new line
		Jmp	GetNextChar		; And get the next character

EndOfData:	Cmp	ColNum, 0		; See if anything in line
		Jnz	DumpTheLine		; If so, must print it
	
		Cmp	LineNum, 0		; See if anything on page
		Jnz	DumpThePage		; If so, must print it
		Jz	ExitProgram		; Otherwise, get out fast

DumpTheLine:	Sub	AL, AL			; Mark end of line with zero
		Stosb
                PushI	<Offset AsciiBuffer>	; Address of buffer
                PushI	LineNum			; Text line number
		Call	LineOut			; Output the line

DumpThePage:	Mov	[AsciiBuffer], 0	; Make a blank line
		Mov	LineNum, 65		; Set to bottom of page

                PushI	<Offset AsciiBuffer>	; Address of buffer
                PushI	LineNum			; Text line number
		Call	LineOut			; Output the line

ExitProgram:    PushI	1			; Terminate all threads
		PushI	0			; Return code
		Call	DosExit			; Terminate

Entry		ENDP

;-------------------------------------------------------------------
; LineOut -- Converts ASCII line to PostScript, returns new LineNum
;-------------------------------------------------------------------

		.DATA?

PsBuffer	db	200 dup (?)

		.DATA

PsTransScale	db	"36 36 translate .9375 .9091 scale", 0
PsSetFont	db	"/Courier findfont 12 scalefont setfont", 0
PsMoveTo1	db	"0 ", 0
PsMoveTo2	db	" moveto", 0
PsShow1		db	" (", 0
PsShow2		db	") show", 0
PsShowPage	db	"showpage", 0

		.CODE

LineOut		PROC	USES DX BX, String:PTR BYTE, LineNum:WORD

		Mov	DX, LineNum		; Set DX to line number
		Or	DX, DX			; If zero, skip some stuff
		Jnz	PrintLine

                PushI	<Offset PsTransScale>	; Output initialization string
		Call	puts

                PushI	<Offset PsSetFont>	; Output setfont code
		Call	puts

PrintLine:	Mov	BX, String		; Address of line buffer
		Cmp	Byte Ptr [BX], 0	; See if blank line
		Jz	CheckEndPage		; If so, check for last line

                PushI	<Offset PsBuffer>	; Copy PsMoveTo1 string to
                PushI	<Offset PsMoveTo1>	;   PsBuffer area
		Call	strcpy

		Mov	BX, Offset PsBuffer	; Find length of PsBuffer
		Push	BX
		Call	strlen
		Add	BX, AX			; Points to end of PsBuffer

		Mov	AL, 12			; Vertical points per line
		Mul	DL			; Multiply by line number
		Sub	AX, 780			; Subtract 780
		Neg	AX			; Negate to measure from top

		Push	AX			; Number to convert
		Push	BX			; Area to receive ASCII value
		Call	itoa10			; Convert the number

                PushI	<Offset PsBuffer>	; Append the PsMoveTo2 string
                PushI	<Offset PsMoveTo2>	;   to PsBuffer
		Call	strcat

                PushI	<Offset PsBuffer>	; Append the PsShow1 string
                PushI	<Offset PsShow1>	;   to PsBuffer
		Call	strcat

                PushI	<Offset PsBuffer>	; Append the input string
                PushI	String			;   to PsBuffer
		Call	strcat

                PushI	<Offset PsBuffer>	; Append the PsShow2 string
                PushI	<Offset PsShow2>	;   to PsBuffer
		Call	strcat

                PushI	<Offset PsBuffer>	; Output PsBuffer
		Call	puts

CheckEndPage:	Inc	DX			; Increment line counter
		Cmp	DX, 66			; Check if end of page
		Jb	Return			; If no, get out

                PushI	<Offset PsShowPage>	; Output PsShowPage string
		Call	puts

		Sub	DX, DX			; Set new line counter to 0
Return:		Mov	AX, DX			; Return new line counter
		Ret

LineOut		ENDP

;-----------------------------------------------------------------------------
; getchar -- Gets 1 character from standard input, returns -1 if no more data
;-----------------------------------------------------------------------------

		.DATA?

GetCharBuffer	db	4096 dup (?)
GetCharBufSize	equ	$ - GetCharBuffer

		.DATA

GetCharPtr	dw	GetCharBuffer
GetCharEnd	dw	GetCharBuffer

		.CODE

getchar		PROC 	USES BX
		LOCAL	BytesRead:WORD

		Mov	BX, GetCharPtr		; See if point to buffer
		Cmp	BX, GetCharEnd		; Is at the end
                Jb      GetNextChar		; If not, get next character

		PushI	0			; Standard output handle
		Push	DS			; Address of buffer for data
		PushI	<Offset GetCharBuffer>
		PushI	GetCharBufSize		; Size of input buffer
		Push	SS			; Address to receive bytes
		Lea	AX, BytesRead		;   read value
		Push	AX
		Call	DosRead			; Read input

		Or	AX, AX			; Check for error return
		Jnz	NoMoreData		; If error, read no more

		Cmp	BytesRead, 0		; Check if bytes read is 0
		Jz	NoMoreData		; If so, read no more

		Mov	BX, Offset GetCharBuffer	; Address of buffer
		Mov	GetCharPtr, BX		; Save it
		Add	BX, BytesRead		; Add number of bytes
		Mov	GetCharEnd, BX		; Save it as end of buffer

GetNextChar:	Mov	BX, GetCharPtr		; Current pointer to buffer
		Mov	AL, [BX]		; Get the character there
		Inc	BX			; Increment the pointer
		Mov	GetCharPtr, BX		; Save it
		Jmp	Short Return		; And return

NoMoreData:	Mov	AX, -1			; Set error code for return
Return:		Ret

getchar		ENDP

;---------------------------------------------------------------
; puts -- Writes 0-terminated string as line to standard output
;---------------------------------------------------------------

		.DATA

CrLf		db	13, 10

		.CODE
puts            PROC    USES CX, PutsBuffer:PTR BYTE
		LOCAL	BytesWritten:WORD

                PushI	PutsBuffer		; Find length of line
		Call	strlen
                Mov     CX, AX			; Set that to CX

		PushI	1			; Standard output handle
		Push	DS			; Address of output buffer
		Push	PutsBuffer
		Push	CX			; Length of buffer
		Push	SS			; Address for bytes written
		Lea	AX, BytesWritten
		Push	AX
		Call	DosWrite		; Write to standard output

		Or	AX, AX			; Check for error return
		Jnz	Error			; If error, leave

		Cmp	BytesWritten, CX	; See if all bytes written
                Jne     Error			; If not, leave

		PushI	1			; Standard output handle
		Push	DS			; Address of output buffer
		PushI	<Offset CrLf>
		PushI	2			; Length of buffer
		Push	SS			; Address of bytes written
		Lea	AX, BytesWritten
		Push	AX
		Call	DosWrite		; Write to standard output

		Or	AX, AX			; Check for error return
		Jz	Return			; If no error, normal exit

		Cmp	BytesWritten, 2		; See if all bytes written
		Je	Return			; If so, normal exit

Error:		Mov	AX, 1			; Return error code
Return:		Ret

puts		ENDP

;-----------------------------------------------
; strlen -- Finds length of 0-terminated string
;-----------------------------------------------

		.CODE

strlen		PROC	USES ES DI CX, String:PTR BYTE

		Push	DS			; Set ES to DS
		Pop	ES

		Mov	DI, String		; Address of string
		Mov	CX, -1			; Initialize CX
		Sub	AL, AL			; Search for 0
		Repnz	Scasb			; Do the search
		Mov	AX, CX			; New CX
		Not	AX			; Flip the bits
		Dec	AX			; Decremented value is length
		Ret

strlen		ENDP

;-----------------------------------------
; strcpy -- Copies SrcString to DstString
;-----------------------------------------

		.CODE

strcpy         	PROC	USES ES SI DI, DstString:PTR BYTE, SrcString:PTR BYTE

		Push	DS
		Pop	ES
		Mov	SI, SrcString		; Source string
		Mov	DI, DstString		; Destination string

TryAnother:	Lodsb				; Get byte
		Stosb				; Store bytes
		Or	AL, AL			; See if byte was zero
		Jz	AllDone			; If so, we're done
		Jmp	TryAnother		; Otherwise, loop around

AllDone:	Mov	AX, DstString		; Return ptr to destination
		Ret

strcpy		ENDP

;------------------------------------------------------
; strcat -- Concatenates SrcString to end of DstString
;------------------------------------------------------

		.CODE

strcat         	PROC	USES BX, DstString:PTR BYTE, SrcString:PTR BYTE

		Mov	BX, DstString		; Find length of destination
		Push	BX
		Call	strlen

		Add	BX, AX			; Find ptr beyond old string
		Push	BX
                PushI	SrcString
		Call	strcpy			; Copy the new string

		Ret

strcat		ENDP

;---------------------------------------------------------
; itoa10 -- Converts Number to ASCII and stores in String
;---------------------------------------------------------

		.CODE

itoa10         	PROC	USES ES DI DX CX BX, Number:WORD, String:PTR BYTE

		Push	DS
		Pop	ES

		Mov	AX, Number		; Number to convert
		Mov	DI, String		; Destination of ASCII
		Mov	BX, 10			; Divisor
		Sub	CX, CX			; Digit counter

DivLoop:	Sub	DX, DX			; Convert AX to DX:AX DWord
		Div	BX			; Divide by 10
		Push	DX			; Push the quotient on stack
		Inc	CX			; Increment counter
		Or	AX, AX			; See if left with zero
		Jnz	DivLoop			; If not, continue

PutLoop:	Pop	AX			; Get quotients from stack
		Add	AL, '0'			; Convert to ASCII
		Stosb				; Store in DI
		Loop	PutLoop			; And continue

		Sub	AL, AL			; Terminate with 0
		Stosb

		Mov	AX, String		; Return address of string
		Ret

itoa10		ENDP
		END	Entry
