/* numlist.c
    List programs with line numbers.  For MSC 4.0/5.0 and TC 1.0 
        To compile for MSC:  cl numlist.c
        To compile for TC:   tcc numlist
 */
#include <stdio.h>
#include <string.h>

FILE *infil;                   /* FILE TO BE CHECKED */
char linebuf[BUFSIZ];          /* LINE BUFFER FOR READING FROM FILE */

main(argc,argv)
char *argv[];
int argc;
{
    int line_cnt;

        /* Check arguments for filename or '?' (help) flag */
    if((argc < 2) || strchr(argv[1],'?'))
    {
        fputs("\007Usage:",stderr);
        fputs("  numlist [d:path\\]inputfile\n",stderr);
        fputs("                or  numlist \
            [d:path\\]inputfile > [d:path\\]outputfile",stderr);
        exit(1);
    }

    if(!(infil = fopen(argv[1],"r")))   /* open input file */
    {
        fprintf(stderr,"\007CAN'T OPEN INPUT FILE: %s!",argv[1]);
        exit(1);
    }

        /* get each line and print it preceded by the line number */
    for( line_cnt = 1; fgets(linebuf,BUFSIZ,infil); line_cnt++)
        printf ("%3d %s",line_cnt, linebuf);
    
    fclose(infil);                        /* open the file */
    exit(0);
}

