{$R+}
PROGRAM MemSizeTest;

  FUNCTION MemSize : Integer;
  TYPE
    Regs = RECORD
             AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : Integer;
           END;
  VAR Registers : regs;
  BEGIN
    Intr($12, Registers);
    MemSize := Registers.AX;
  END;

  FUNCTION KAvail : Integer;
  { We multiply the high and low bytes of MemAvail }
  { separately in order to avoid problems when its }
  { value is > 32767.  Turbo will treat an integer }
  { > 32767 as a negative number, but bytes are    }
  { always positive.                               }
  BEGIN
    KAvail := Trunc((Hi(MemAvail)*256.0+Lo(MemAvail))/64.0);
  END;

BEGIN
  WriteLn('TOTAL RAM installed is ', MemSize, 'K.');
  WriteLn('TOTAL RAM available within this program is ', KAvail, 'K.');
END.