/*+
	Name:       HLGRSUBS.C
	Author:     Kent J. Quirk
		    (c) Copyright 1988 Ziff Communications Co.
	Date:       April 1988
	Abstract:   A set of graphic subroutines which allow the
		    benchmarks to have code which is independent of the
		    video mode. This also sets a set of useful colors. 
		    Color 0 is always black, and color 15 is always white. 
		    The colors in the middle are designed to be relatively
		    pleasing in sequential combinations from beginning to
		    the end.  The global variable colorlist always points
		    to an array of 16 integer colors.
	History:    09-Sep-88	kjq	Version 1.00
-*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <graph.h>
#include <string.h>
#include <malloc.h>

static int egacolorlist[]     = { 0,1,2,4, 5,3,6,7, 8,9,10,12, 13,11,14,15 };
static int cgacolorlist[]     = { 0,1,2,3, 1,2,3,3, 0,1,2,3,   1,2,3,3 };
static int monocolorlist[]    = { 0,1,1,1, 1,1,1,1, 1,1,1,1,   1,1,1,1 };
static int vgamonocolorlist[] = { 0,3,1,3, 1,3,1,3, 1,3,1,3,   1,3,1,3 };
int *colorlist;

/**** c h e c k _ v g a _ m o n o ****
    Abstract:	Check to see if the VGA monochrome screen is present
    Parameters: none
    Returns:	1 if it is, 0 if it's color
****************************/
int check_vga_mono()
{
    union REGS regs;

    regs.x.ax = 0x1A00;         /* get display combination mode */
    int86(0x10, &regs, &regs);  /* video BIOS interrupt */
    if (regs.h.al == 0x1A)      /* is this function supported? */
    {
	if ((regs.h.bl == 0x07) || (regs.h.bl == 0x0B))
	    return(1);          /* monochrome present */
	else
	    return(0);          /* not mono */
    }
    return(0);                  /* just don't know */
}

/**** i n i t _ v i d e o ****
    Abstract:	Initialize the video display to the highest-resolution 
		graphics mode available.
    Parameters: configp -- A pointer to an area to put the video configuration
			    info.
    Returns:	1 if successful, 0 if not
    Comments:	If the environment variable HLGRAPH is present, uses it
		to obtain the video mode information.
****************************/
int init_video(configp)
struct videoconfig far *configp;
{	
	char *buf;
	
    if ((buf = getenv("HLGRAPH")) == NULL)	/* if no extern video mode */
    {	 
	if (_setvideomode(_VRES16COLOR))
		colorlist = egacolorlist;
	else if (_setvideomode(_HERCMONO))
		colorlist = monocolorlist;
	else if (_setvideomode(_ERESCOLOR))
		colorlist = egacolorlist;
	else if (_setvideomode(_HRES16COLOR))
		colorlist = egacolorlist;
	else if (_setvideomode(_MRES16COLOR))
		colorlist = egacolorlist;
	else if (_setvideomode(_MRES4COLOR))
		colorlist = cgacolorlist;
	else if (_setvideomode(_HRESBW))
		colorlist = monocolorlist;
	else
		return(0);
    }
    else 
    {
	_setvideomode(atoi(buf));	    /* set desired mode */
	_getvideoconfig(configp);
	if (configp->numcolors >= 16)
	    colorlist = egacolorlist;
	else if (configp->numcolors >= 4)
	    colorlist = cgacolorlist;
	else if (configp->numcolors >= 2)
	    colorlist = vgamonocolorlist;
	else if (configp->numcolors >= 1)
	    colorlist = monocolorlist;
    }
    
    if (check_vga_mono())
    {
	    _setvideomode(_ERESNOCOLOR);
	    colorlist = vgamonocolorlist;
    }

    _getvideoconfig(configp);
    return(1);
}

/**** p l o t s t r ****
    Given a string, a position, and a color, this plots the string at
    that position on the screen.  It does so by first drawing it using _outtext
    on the top line of the screen.  Then it uses _getimage to read the image
    into a buffer, then uses _putimage to place it at the desired location.
****************************/
int plotstr(char *s, int x, int y, int color, int mode)
{
	int i, c;
	int height, width;
	struct xycoord ul, lr;
	char far *image;
	struct videoconfig config;

	_getvideoconfig(&config);

	_settextcolor(color);
	_settextposition(1,1);
	_outtext(s);

	width = config.numxpixels/config.numtextcols * strlen(s);
	height = config.numypixels/config.numtextrows;
	if ((image = _fmalloc((int)_imagesize(0, 0, width, height))) == NULL)
	    return(0);

	lr = _getlogcoord(width, height);
	ul = _getlogcoord(0, 0);
	_getimage(ul.xcoord, ul.ycoord, lr.xcoord, lr.ycoord, image);
	_settextcolor(0);               /* erase string */
	_settextposition(1,1);
	_outtext(s);
	_putimage(x, y, image, mode);
	_ffree(image);
	return(1);
}
