/*+
    Name:       HLTIMER.C
    Author:     Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:   This file contains timer routines for
		use in benchmarking.
    History:	kjq - Mar 88 - Original Version
		kjq - Sep 88 - Version 1.00
-*/

#ifdef C_terp
#define NDEBUG
#endif

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <assert.h>
#include "hl.h"

#define MAXTIMERS 10
static long start_tick[MAXTIMERS];
static long end_tick;

/**** s t a r t _ t i m e r ****
    This routine simply records the current time in a static array
    (indexed by an input parameter) for later use by end_timer.
 *******************************/
void start_timer(n)
int n;
{
    assert(((n >= 0) && (n < MAXTIMERS)))
    _bios_timeofday(_TIME_GETCLOCK, &(start_tick[n]));
}

/**** s t o p _ t i m e r ****
	Saves the current time in end timer.
 *****************************/
void stop_timer()
{
	_bios_timeofday(_TIME_GETCLOCK, &end_tick);
}

/**** g e t _ t i m e r ****
    Finds the time difference between the end_timer and the selected
    start_timer.
 ****************************/
long get_timer(n)
int n;
{
    assert((n >= 0) && (n < MAXTIMERS));
    return(end_tick - start_tick[n]);
}

char *time_pct(tick1, tick2)
long tick1, tick2;
{
	static char buf[40];
	static int next = 0;
	ldiv_t rel;

	next = (next + 10) % sizeof(buf);
	if ((tick1 < 0) | (tick2 < 0))
		strcpy(buf + next, " N/A  ");
	else
	{
		rel = ldiv(tick2*100L, tick1);
		sprintf(buf + next, "%4ld%%", rel.quot);
	}
	return(buf + next);
}

char *time_secs(ticks)
long ticks;
{
	ldiv_t secs, fracs;
	static char buf[40];
	static int next = 0;

	next = (next + 10) % sizeof(buf);
	if (ticks < 0)
		strcpy(buf + next, " N/A  ");
	else
	{
		ticks *= 5L;        /* so we can divide by 91 and be accurate */
		secs = ldiv(ticks, 91L);    /* 91 = 18.2 ticks/sec * 5 */
		fracs = ldiv(secs.rem * 100L, 91L);
		sprintf(buf + next, "%3ld.%02ld", secs.quot, fracs.quot);
	}
	return(buf + next);
}
