/* This program requires Release 4.01 of REND386 to compile */
// This is currently the BETA Version 0.90


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <dos.h>
#include <math.h>
#include <string.h>
#include "\rend4\3dstruct.h"
#include "\rend4\rend386.h"
#include "\rend4\userint.h"
#include "\rend4\plg.h"
#include "\rend4\splits.h"
#include "\rend4\tasks.h"
#include "\rend4\pointer.h"
#include "\rend4\cursor.h"
#include "\rend4\segio.h"
#include "\rend4\intmath.h"
#include "\rend4\segasupp.h"
#include "serial.h"

#define to_rad(a) ((a) * 3.14159262 / 180.0)
#define sine(x)   sin(to_rad(x/65536L))
#define cosine(x) cos(to_rad(x/65536L))

#define LEG_ANGLE_MOVE 15*65536L
#define PAN_ANGLE      5*65536L
#define MOVE_STEP      250


#define HOME      0x4700
#define END       0x4F00
#define PGUP      0x4900
#define PGDN      0x5100
#define LEFT      0x4B00
#define RIGHT     0x4D00
#define UP        0x4800
#define DOWN      0x5000
#define SHLEFT    0x4B01
#define SHRIGHT   0x4D01
#define SHUP      0x4801
#define SHDOWN    0x5001
#define SHPGUP    0x4901
#define SHPGDN    0x5101
#define CTRLLEFT  0x7300
#define CTRLRIGHT 0x7400
#define CTRLHOME  0x7700
#define CTRLEND   0x7500
#define CTRLPGUP  0x8400
#define CTRLPGDN  0x7600
#define ESC       0x001B

#define OK	  0
#define CONNECT   1
#define RING	  2
#define NOCARRIER 3
#define ERROR	  4
#define NODIALTONE 6
#define BUSY	   7
#define NOANSWER   8
#define CONNECT300 1
#define CONNECT1200 5
#define CONNECT2400 10
#define CONNECT9600 13
#define CONNECT4800 18
#define CONNECT14400 25
#define CONNECTARQ 14
#define CONNECT300ARQ 14
#define CONNECT1200ARQ 15
#define CONNECT2400ARQ 16
#define CONNECT9600ARQ 17
#define CONNECT4800ARQ 19
#define CONNECT14400ARQ 26


//#define DEBUG 1

extern unsigned _stklen = 25000;

/* Global variables */
/* This is our main object list.
   Files used:  keyboard, world, cursors
*/
OBJLIST         *objlist;

/* This is the default values for stereo viewing.
   Files used:  keyboard, world, render
*/
STEREO          default_stereo = {1000,250,320,50, 1000000, 1*65536L};

/* This variable indicates the type of viewing.
   Declared in file: render.c
   Files used: keyboard, gloveptr, world, render
*/
int             stereo_type = MONOSCOPIC;

/* This variable declares the default startup view of the program.
   Files used: keyboard, world
*/
VIEW            default_view =  {
				0,0,-1000,
				0,0,0,
				9*65536L,
				1000,15000,-5000,
				0,319,0,199,
				1,100000,
				1/1.25*65535L,
				0
				};

/* This pointer points to the location of the default view
   Files used: keyboard, world, render
*/
VIEW            *current_view = &default_view;

/* This pointer in the beginning of the split tree for the program.  We
   will only one however, that is not a requirement.
   Files used: keyboard, world, render, cursors, hdmanip
*/
SPLIT           *split_tree = NULL;

/* This variable holds a palette.
   Files used: world
*/
unsigned char   palette[256*3];

/* This pointer is the start of a set of tasks.
   Files used: world
*/
TASK            *tasklist = NULL;

/* This pointer holds a handle to the current video driver installed.
   Files used: main program
*/
void            *v_driver_pointer = NULL;

/* This variable holds a loadpath specified in the configuration file or
   in a world file.
   Files used: world
*/
char            loadpath[100] = "";

/* This variable holds a temporary filename including a loadpath.
   Files used: main program
*/
static char     tempname[100];


char            framefname[100];

/* Delcares an extern function. */
extern void     *screen_data();

/* This variable is used to hold information about the current screen setup.
   File used: gloveptr, mouseptr, render, userint
*/
extern struct   Screeninfo *screeninfo;

/* This variable is used in the userint file.  Purpose ?
*/
PDRIVER         *menu_device = NULL;

/* These variable are used as the configuration settings for the glove
   pointer device, translation and rotation.
   Files used: world
*/
float           gpdo_x = 1, gpdo_y = 1, gpdo_z = 2,
		gpdo_rx = 1, gpdo_ry = 1, gpdo_rz = 1;

/* These varaiables are used as the configuration settings for the head
   tracker device, relative position to neck, and rotation. */
float           hdo_x = 0, hdo_y = 0, hdo_z = 0; /* relative pos'n to neck */
float           hdo_rx = 0, hdo_ry = 0, hdo_rz = 0;

/* These variables are used as the configuration settings for the STEREOLEFT
   command in a world file.  Check world.doc for description.
   Files used: world keyboard
*/
int             sl_xflip = 0, sl_xoff = 0;
long            sl_left = -1, sl_top, sl_right, sl_bottom;

/* These variables are used as the configuration settings for the
   STEREORIGHT command in a world file.  Check world.doc for description.
   Files used: world keyboard
*/
int             sr_xflip = 0, sr_xoff = 0;
long            sr_left = -1, sr_top, sr_right, sr_bottom;

/* These variables are used as the configuration settings for the rotation
   of the STEREORIGHT and STEREOLEFT commands in the world file.  Check
   world.doc for description.
   Files used: world keyboard.
*/
float           sl_xrot = 0, sr_xrot = 0;

/* This variable indicates whether or not a glove is being used.
   0 = false.
   Files used: cursors hdmanip
*/
int             use_glove = 0;

/* This variable indicates whether or not a head tracker is being used.
   0 = false.
   Files used: render
*/
int             use_ht = 0;

/* This variable indicates whether or not a wide-angle dual VGA
   head mounted display system is being used.
   0 = false.
   Files used: render
*/
int             use_wide = 0;

/* This variable indicates whether or not a monochrome system is being used.
   0 = false.
   Files used: render
*/
int             use_BW = 0;

/* This variable is set to 1 if the eyes are to be switched when using
   the Sega 3D glasses.
   Files used: render
*/
int             swap_eyes = 0;

/* This variable is set to display a fancy background
   Files used: keyboard render
*/
int             fancy_background = 0;

/* This variable is set to draw a reflection pool at the bottom of the
   screen.
   Files used: keybaord render
*/
int             reflection_pool = 0;

/* This variable is set to indicate we have a logo to display.
   Files used: render
*/
int             have_logo = 0;

/* This variable is set to show our logo, if we have one.
   Files used: render keyboard
*/
int             show_logo = 0;

/* This variable is set to show the current location on-screen.
   Files used: render keyboard
*/
int             show_location = 0;

/* This variable is set to show the 3D compass on-screen.
   Files used: render keyboard
*/
int             show_compass = 0;

/* This variable is set to display the frames/second rate on-screen.
   Files used: render keyboard
*/
int             show_framerate = 0;

/* This variable is set to clear the screen on each frame.
   Files used: render world keyboard
*/
int             do_screen_clear = 1;

/* This variable is set to draw a "frame".
   Files used: world render
*/
int             use_frame = 0;

/* These variabels define the location of a "frame".
   Files used: world render
*/
int             frame_x = 0, frame_y = 0, frame_w = 320, frame_h = 200;

/* This variable is set to the current display mode to use.
   Files used: render world
*/
int             vdmode = 0x14;

/* This variable is set to 1 if we need to recompute the current view.
   Files used: world keyboard
*/
int             review = 1;

/* This variable is set to 1 if we need to copy our gram back on-screen.
   Files used: keyboard world colormap render rendrep
*/
int             reframe = 0;


/* This variable is set if the shift key is used by the user.
   Files used: main program keyboard
*/
int             shifted = 0;

/* This variable is used to hold the current visual page being used.
   Files used: render userint
*/
int             v_page = 0;

/* This variable is set if a glove is available.
   Files used: world cursors
*/
int             have_glove = 0;

/* This variable is set if a pointer device is available.
   Files used: world cursors
*/
int             have_ptr = 0;

/* This variable is set if we can do mouse manipulations.
   Files used: keyboard
*/
int             manip_2D_avail = 0;

/* This variable is set to run the main execution loop.
   Files used: main
*/
int             execution = 1;

/* This variable is set to indicate a screen redraw is necessary.
   Files used: keyboard anim world cursors render hdmanip
*/
int             redraw = 1;

/* This variable is set if a horizon should be drawn.
   Files used: keyboard render colormap
*/
int             do_horizon = 0;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the top
   half of the screen after it is cleared; if the do_horizon variable is
   set to 1.
   Files used: world render colormap
*/
extern          sky_color;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the bottom
   half of the screen after it is cleared; if the do_horizon variable is
   set to 1.
   Files used: world render colormap
*/
extern          ground_color;

/* This variable is not necessary because it is define elsewhere and can
   be set with a world file.  It is the color the system paints the screen
   after it is cleared; if the do_horizon variable is set to 0.
   Files used: world render colormap
*/
extern int      screen_clear_color;


/* This variable holds the highest possible color value.
   Files used: render colormap
*/
extern          highest_color;

/* This variable is set to 0 if no palette is loaded and
   non-zero if a palette is loaded
   Files used: world
*/
int             npalette = 0;

/* This variable holds the name of the current switcher driver.
   Files used: world
*/
char            swdname[40] = "sega";

/* This variable holds the name of the current glove pointer driver.
   Files used: world
*/
char            gpdname[40] = "pglove";

/* This variable holds the name of the current head tracker driver.
   Files used: world
*/
char            hdname[40] = "none";

/* This variable holds the name of the glove pointer driver cursor figure.
   Files used: world
*/
char            gpcursor[40] = "handsm.fig";

/* This variable holds the name of the current video driver.
   Files used: main program and world
*/
char            vdname[40] = "vd256.rvd";

/* This variable holds the name of the current mouse driver.
   Files used: world
*/
char            mdname[40] = "mouse";

extern SEGMENT *body_seg;
int             head_device = 0,
		joy_return = 0,
		joystick = 0,
		person = 0;
joystick_data   joy_data;
//int    first_time = 0;
VIEW other_guys_view;


int weight = 0, total_pieces = 0;
piece_struct pieces_places[100];
char *pieces[100];

/***
***/
SEGMENT *their_head,
	*their_car,
	*glove_joints[20],
	*body_seg,
	*wrist_seg,
	*temp,
	*our_car,
	*lgrip,
	*rgrip,
	*attached_piece,
	*correct_seg;


OBJECT	*flag1,
	*flag2,
	*flag3,
	*flag4,
	*flag5,
	*found_obj;

int heavy;

int PORT = 2, connected = 0;

int busy=0,
    flags[4],
    num_stored=0,
    our_flag_count = 0,			// count of # flag in home port
    waiting_for_w = 0,
    null_modem = 0,			// 1 = we are using null modem
    got_one = 0,			// 1 = we have a flag
    hit =0;				// 1 = collision has occured
long SPEED = 19200,
     collide_x,
     collide_y,
     collide_z;
OBJECT *current_obj = NULL;
FILE *debug;


////////////VICTORMAXX STUNTMASTER VARIABLES//////////
int use_stuntmaster = 0;
int x_stunt_value = 0,
    y_stunt_value = 0,
    stunt_position = 0,
    stunt_angle = 15;
joystick_data stunt_data;



void refresh_display(){

  initialize_screen_factors ( current_view );
  fast_view_factors ( current_view );
  screen_refresh ( current_view );
}


void hangup()
{
  com_lower_dtr(PORT);
  delay(1100);
  if (com_carrier(PORT))
  {
    com_tx_string_with_delay(PORT, "+++", 10, 10);
    delay(1100);
    com_tx(PORT, 13); delay(10);
    com_tx_string_with_delay(PORT, "ATH", 10, 10);
    com_tx(PORT, 13); delay(10);
  }
  com_flush_rx(PORT);
  com_flush_tx(PORT);
  busy = num_stored = null_modem = connected = 0;

  if (their_head != NULL)
  {

    abs_move_segment ( their_head, 100000,100000,100000);
    update_segment ( their_head);
    remove_from_objlist ( seg_get_object (their_head));
    delete_segment (their_head, NULL);
    their_head = NULL;
    refresh_display();
  }

}

void printcenter ( char *string )
{
  int i;

  for(i=0;i<((80-strlen(string))/2); i++)
   printf (" ");
  printf ( "%s", string );
}



/**************************************************************************
   This function is used by the file render.c to display various things
   on the screen to the user.  This is not needed by any program just
   an option.  However, render.c needs access to this function
***************************************************************************/
void status_on_screen()
{
}


/**************************************************************************
   This function concatenates the loadpath to the string name IF
   name is not "\\" and not "/" and loadpath is not empty.  It is used by
   the files: world.c.
**************************************************************************/
char *fix_fname(char *name)
{

	if (loadpath[0] && !strchr(name, '\\') && !strchr(name, '/'))
	  sprintf(tempname, "%s\\%s", loadpath, name);
	else
	  strcpy(tempname, name);
	return tempname;
}


/**************************************************************************
  This function is called when the user ends the graphics program.  It
  shuts done the graphics system and exits the renders and finally exits
  the progam.
**************************************************************************/
void closeall(){

  exit_graphics();
  reset_render();

  com_tx_string(PORT, "ATH0");
  com_tx(PORT, 13); delay(500);
  com_lower_dtr(PORT);

  com_deinstall(PORT);

}


void prprint(int x,int y, int color, char *t)
{
  int bk = (color>8) ? 0 : 15;

  printxyr(x,y,bk,t,0);
  printxyr(x+1,y+1,color,t,0);
}


/**************************************************************************
   This function is from Rend386 demo2.c program and is used to get
   keyboard input from the user.
***************************************************************************/
unsigned getkey(){
  unsigned c;
  union REGS regs;

  regs.h.ah = 2;

  int86(0x16, &regs,&regs );
  shifted = (regs.h.al & 3);

  if ((c=bioskey (0)) & 0xff) c &= 0xff;
  else if ( shifted ) c |= 1;
  return c;
}

int find_piece(char *match)
{

 int count = 0;
 while (strcmpi(match, pieces[count])) count++;
 return count;

}




char current_name[20];
void find_object ( OBJECT *obj )
{
   if (strcmpi (seg_getname ((SEGMENT *)get_object_owner(obj)), current_name) == 0)
     found_obj = obj;
}


void find_segment ( OBJECT *obj )
{

   if (strcmpi (seg_getname ((SEGMENT *)get_object_owner(obj)), current_name) == 0)
     correct_seg = (SEGMENT *)get_object_owner(obj);

}


void check_list ( OBJECT *obj )
{
  long dist;

  if (((obj->oflags & 0x0008 )) && (!hit))
  {
   dist = sphere_pretest ( obj, collide_x, collide_y, collide_z );
   if (( dist > 5 ) && ( dist < 150 )) { hit = 1; current_obj = obj; }
   else current_obj = NULL;
  }
}



int yes_or_no()
{
  char ch;

  refresh_display();
  popmsg ( "Are You Sure? (y/n)" );
  ch = getkey();
  if ( (ch == 'Y') || (ch == 'y') ) ch = 1;
  else ch = 0;

  refresh_display();
  return ch;

}



char *helpmenu[] = {
		"",
		"a,A = Answer Call",
		"b,B = Reset Game",
		"d,D = Dial A Number",
		"g,G = Goodbye - Hangup",
		"h,H = This Screen",
		"m,M = Send Message",
		"o,O = Originate Call - No Dial",
		"q,Q = Quit",
		"x,X = Initiate Null Modem Connect",
		"z,Z = Answer Null Modem Connect",
		"",
		"Press any Key",
		NULL
	       };


void reset_board()
{
  int i;


  detach_segment (our_car);
  detach_segment (their_car);
  if ( person == 0 )
  {
    current_view->ex = 200;
    current_view->ey = 325;
    current_view->ez = 200;
    abs_move_segment ( body_seg, 200, 325, 200 );
    abs_rot_segment (body_seg, 0,0,0, RXYZ);
    update_segment ( body_seg );
    current_view->pan = 0;

    abs_rot_segment (our_car, 0,-90*65536L,0,RYXZ);
    abs_move_segment (our_car, 323,145,-200);
    update_segment (our_car);
    attach_segment (our_car, body_seg);

    other_guys_view.ex = 1000;
    other_guys_view.ey = 325;
    other_guys_view.ez = 3500;
//    other_guys_view.pan = 180 * 65536L;

    abs_move_segment (their_head, 1000,325,3500);
    abs_rot_segment (their_head,0,0,0,RXYZ);
    update_segment ( their_head );

    abs_rot_segment (their_car, 0,90*65536L,0,RXYZ);
    abs_move_segment (their_car, 877,145,3900);
    update_segment (their_car);
    attach_segment (their_car, their_head);

  }
  else
  {
    current_view->ex = 1000;
    current_view->ey = 325;
    current_view->ez = 3500;
    abs_move_segment ( body_seg, 1000, 325, 3500 );
    abs_rot_segment (body_seg, 0, 0, 0, RXYZ);
    update_segment ( body_seg );

    abs_rot_segment (our_car, 0,90*65536L,0,RXYZ);
    abs_move_segment (our_car, 877,145,3900);
    update_segment (our_car);
    attach_segment (our_car, body_seg);

    current_view->pan = 180*65536L;

    other_guys_view.ex = 200;
    other_guys_view.ey = 325;
    other_guys_view.ez = 200;

    other_guys_view.pan = 0;
    abs_move_segment (their_head,200,325,200);
    abs_rot_segment(their_head, 0, 0, 0, RXYZ);
    update_segment (their_head);

    abs_rot_segment (their_car, 0,-90*65536L,0,RYXZ);
    abs_move_segment (their_car, 323,145,-200);
    update_segment (their_car);
    attach_segment (their_car, their_head);

  }
  refresh_display();
}


void send_flag_pos()
{
  long x,y,z;

    seg_getposxyz(get_object_owner(flag1), &x, &y, &z);
    com_tx(PORT,(char)((x&0x0000FF00)>>8));
    com_tx(PORT,(char)x&0x000000FF);
    com_tx(PORT,(char)((y&0x0000FF00)>>8));
    com_tx(PORT,(char)y&0x000000FF);
    com_tx(PORT,(char)((z&0x0000FF00)>>8));
    com_tx(PORT,(char)z&0x000000FF);
    delay(500);

    seg_getposxyz(get_object_owner(flag2), &x, &y, &z);
    com_tx(PORT,(char)((x&0x0000FF00)>>8));
    com_tx(PORT,(char)x&0x000000FF);
    com_tx(PORT,(char)((y&0x0000FF00)>>8));
    com_tx(PORT,(char)y&0x000000FF);
    com_tx(PORT,(char)((z&0x0000FF00)>>8));
    com_tx(PORT,(char)z&0x000000FF);
    delay(500);

    seg_getposxyz(get_object_owner(flag3), &x, &y, &z);
    com_tx(PORT,(char)((x&0x0000FF00)>>8));
    com_tx(PORT,(char)x&0x000000FF);
    com_tx(PORT,(char)((y&0x0000FF00)>>8));
    com_tx(PORT,(char)y&0x000000FF);
    com_tx(PORT,(char)((z&0x0000FF00)>>8));
    com_tx(PORT,(char)z&0x000000FF);
    delay(500);

    seg_getposxyz(get_object_owner(flag4), &x, &y, &z);
    com_tx(PORT,(char)((x&0x0000FF00)>>8));
    com_tx(PORT,(char)x&0x000000FF);
    com_tx(PORT,(char)((y&0x0000FF00)>>8));
    com_tx(PORT,(char)y&0x000000FF);
    com_tx(PORT,(char)((z&0x0000FF00)>>8));
    com_tx(PORT,(char)z&0x000000FF);
    delay(500);

    seg_getposxyz(get_object_owner(flag5), &x, &y, &z);
    com_tx(PORT,(char)((x&0x0000FF00)>>8));
    com_tx(PORT,(char)x&0x000000FF);
    com_tx(PORT,(char)((y&0x0000FF00)>>8));
    com_tx(PORT,(char)y&0x000000FF);
    com_tx(PORT,(char)((z&0x0000FF00)>>8));
    com_tx(PORT,(char)z&0x000000FF);
    delay(500);
}


void get_flag_pos()
  {

    long x, y, z;

    x = com_rx(PORT); x<<=8;
    x = x + com_rx(PORT);
    y = com_rx(PORT); y<<=8;
    y = y + com_rx(PORT);
    z = com_rx(PORT); z<<=8;
    z = z + com_rx(PORT);

    abs_move_segment(get_object_owner(flag1), x, y, z);
    update_segment (get_object_owner(flag1));

    x = com_rx(PORT); x<<=8;
    x = x + com_rx(PORT);
    y = com_rx(PORT); y<<=8;
    y = y + com_rx(PORT);
    z = com_rx(PORT); z<<=8;
    z = z + com_rx(PORT);

    abs_move_segment(get_object_owner(flag2), x, y, z);
    update_segment (get_object_owner(flag2));

    x = com_rx(PORT); x<<=8;
    x = x + com_rx(PORT);
    y = com_rx(PORT); y<<=8;
    y = y + com_rx(PORT);
    z = com_rx(PORT); z<<=8;
    z = z + com_rx(PORT);

    abs_move_segment(get_object_owner(flag3), x, y, z);
    update_segment (get_object_owner(flag3));

    x = com_rx(PORT); x<<=8;
    x = x + com_rx(PORT);
    y = com_rx(PORT); y<<=8;
    y = y + com_rx(PORT);
    z = com_rx(PORT); z<<=8;
    z = z + com_rx(PORT);

    abs_move_segment(get_object_owner(flag4), x, y, z);
    update_segment (get_object_owner(flag4));

    x = com_rx(PORT); x<<=8;
    x = x + com_rx(PORT);
    y = com_rx(PORT); y<<=8;
    y = y + com_rx(PORT);
    z = com_rx(PORT); z<<=8;
    z = z + com_rx(PORT);

    abs_move_segment(get_object_owner(flag5), x, y, z);
    update_segment (get_object_owner(flag5));

  }


void do_link()
{
  char ours, theirs, do_again = 1;
  long x, y, z;

  randomize();
  while ( do_again )
  {
    do_again = 0;
    randomize();
    ours = random(50);

    com_tx(PORT, ours);
    theirs = com_rx(PORT);

#ifdef DEBUG
  fprintf(debug, "Ours = %d, theirs = %d\n", ours, theirs);
#endif
    if (ours<theirs) person = 0;
    else person = 1;

    if (ours==theirs) do_again = 1;
  }

  reset_board();

  if (person==0)  popmsg("Your home base is BLUE");
  else            popmsg("Your home base is RED");
  delay(3000);

  if (person==0) send_flag_pos();
  else get_flag_pos();
}


void read_flags()
{
  OBJECT *obj;
  int i;

  for(i=0;i<5;i++)
    flags[i] = 1;

  strcpy (current_name, "flag1");
  walk_split_tree (split_tree, find_object);
  flag1 = found_obj;

  strcpy (current_name, "flag2");
  walk_split_tree (split_tree, find_object);
  flag2 = found_obj;

  strcpy (current_name, "flag3");
  walk_split_tree (split_tree, find_object);
  flag3 = found_obj;

  strcpy (current_name, "flag4");
  walk_split_tree (split_tree, find_object);
  flag4 = found_obj;

  strcpy (current_name, "flag5");
  walk_split_tree (split_tree, find_object);
  flag5 = found_obj;


  abs_move_segment (get_object_owner(flag1), random(20000), 0, random(20000));
  update_segment (get_object_owner(flag1));

  abs_move_segment (get_object_owner(flag2), random(20000), 0, random(20000));
  update_segment (get_object_owner(flag2));

  abs_move_segment (get_object_owner(flag3), random(20000), 0, random(20000));
  update_segment (get_object_owner(flag3));

  abs_move_segment (get_object_owner(flag4), random(20000), 0, random(20000));
  update_segment (get_object_owner(flag4));

  abs_move_segment (get_object_owner(flag5), random(20000), 0, random(20000));
  update_segment (get_object_owner(flag5));

}


void they_won()
{
  int i;

  our_flag_count == 0;
  popmsg ("The other player has won");
  delay(5000);

  com_tx(PORT, 'a');

  reset_board();
  get_flag_pos();

  for(i=0;i<5;i++)
   flags[i] = 1;
}


void we_won()
{
  our_flag_count == 0;
  com_tx(PORT, 'q');

  popmsg("You have won");
  while (com_rx(PORT) != 'a');

  reset_board();
  read_flags();
  send_flag_pos();
}



long current_pan;
/**************************************************************************
   This function handles keys pressed by the user.Handle any user keys.
**************************************************************************/
void handle_key ( unsigned int c ){
OBJECT *obj;
long x, y, z, tempx, tempz, pan;
char buff[12], inbuff[80], result;
char a,b,d;
int serial, i;
FILE *infile;

  switch ( c )
  {
    case 'q':
    case 'Q':    popmsg ( "Do you wish to quit? (y/n)" );
		 if ( toupper(getkey())== 'Y' )
		 {
		   execution = 0;
		   hangup();
		 }
		 else redraw = 1;
		 break;

    case 'a':
    case 'A':    /*answer call*/
	       if (!connected)
	       {
		 com_raise_dtr(PORT);
		 com_flush_rx(PORT);
		 delay(1100);
		 com_tx_string_with_delay(PORT, "ATE0X4V0A", 10, 10 );
		 com_tx(PORT, 13); delay(10);
		 popmsg ("Answering...");
		 delay(3500);

		 a=b=d=0;
		 while((!bioskey(1))&&(a==0)&&(!com_carrier(PORT)))
		   if(!com_rx_empty(PORT))
		   {
		     a = com_rx(PORT);
		     if ( a == 50 )
		     {
		       b = com_rx(PORT);
		       if (b==13)
		       {
			 a = com_rx(PORT);
			 b = 0;
		       }
		     }
		   }

		 delay(2000);

		 if (!bioskey(1))
		 {
		   if(b==0)  b = com_rx(PORT);
		   if(b!=13) d = com_rx(PORT);
		 }

		 if ( b == 13 ) result = a - 48;
		 else if ( d == 13 ) result = (a-48)*10 + (b-48);

		 if (bioskey(1))
		 {
		   getkey();
		   if (!com_carrier(PORT))
		      com_tx(PORT,13);
		   else
		     hangup();
		   return;
		 }

		 if ((com_carrier(PORT))&&(result!=ERROR)&&(result!= NODIALTONE)&&(result!=NOCARRIER))
		 {
		   refresh_display();
		   if ( result == CONNECT300 ) popmsg ( "Waiting to connect at 300...");
		   else if ( result == CONNECT1200 ) popmsg ( "Waiting to connect at 1200...");
		   else if ( result == CONNECT2400 ) popmsg ( "Waiting to connect at 2400...");
		   else if ( result == CONNECT4800 ) popmsg ( "Waiting to connect at 4800...");
		   else if ( result == CONNECT9600 ) popmsg ( "Waiting to connect at 9600...");
		   else if ( result == CONNECT14400 ) popmsg ( "Waiting to connect at 14400...");

		   else if ( result == CONNECT300ARQ) popmsg ( "Waiting to connect at 300/ARQ...");
		   else if ( result == CONNECT1200ARQ ) popmsg ( "Waiting to connect at 1200/ARQ...");
		   else if ( result == CONNECT2400ARQ ) popmsg ( "Waiting to connect at 2400/ARQ...");
		   else if ( result == CONNECT4800ARQ ) popmsg ( "Waiting to connect at 4800/ARQ...");
		   else if ( result == CONNECT9600ARQ ) popmsg ( "Waiting to connect at 9600/ARQ...");
		   else if ( result == CONNECT14400ARQ ) popmsg ( "Waiting to connect at 14400/ARQ...");

		   else if ( result == CONNECTARQ ) popmsg ( "Waiting to connect/ARQ...");
		   else popmsg ( "Waiting to connect...");
		   com_flush_rx(PORT);
		   connected = 1;
		   delay(5000);
	   do_link();
		 }

		 else if ( result == NODIALTONE )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg ("No Dial Tone");
		   delay(5000);
		   refresh_display();
		 }
		 else if ( result == NOCARRIER )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg("No Carrier" );
		   delay(5000);
		   refresh_display();
		 }
		 else
		 {
		   hangup();
		   popmsg("Unable to connect. Please try again.");
		   delay(5000);
		   refresh_display();
		   busy = 1;
		 }
	       }
	       else
	       {
		 refresh_display();
		 popmsg ("Unable to perform this operation");
		 delay(5000);
		 refresh_display();
	       }

		 break;


    case 'b':
    case 'B':    /* Reset Game to original Position */
		 if (yes_or_no())
		 {
		   reset_board();
		   if(connected)com_tx(PORT, 'r');
		 }
		 break;


    case 'd':
    case 'D':    /*Dial other party*/
	       if (!connected)
	       {
		 if ( busy && num_stored )
		 {
		   popmsg ("Redial Previous Number? (y/n)");
		   a = getkey();
		   while ( (a!='y') && (a!='n'))
		     a = getkey();

		   if ( a == 'y' )
		   {
		     com_raise_dtr(PORT);
		     com_flush_rx(PORT);
		     delay(1100);
		     com_tx_string_with_delay(PORT, "A/", 10, 10);
		     com_tx(PORT,13);
		   }
		 }

		 if ( (!busy) || (a == 'n') )
		 {
		     refresh_display();
		     askfor("Number: ", inbuff, 15 );
		     com_flush_rx(PORT);
		     com_raise_dtr(PORT);
		     refresh_display();
		     popmsg("Dialing...");
		     num_stored = 1;

		     delay(1100);
		     com_tx_string_with_delay(PORT, "ATE0X4V0DT", 10, 10 );
		     com_tx_string_with_delay(PORT, inbuff, 10, 10);
		     com_tx(PORT, 13);
		 }

		 delay(3500);
		 a=0;

		 while ((!bioskey(1))&&(!com_carrier(PORT)&&(a==0)))
		   if(!com_rx_empty(PORT)) a = com_rx(PORT);

		 delay(2000);

		 if (!bioskey(1))
		 {
		   b = com_rx(PORT);
		   if(b!=13) d = com_rx(PORT);
		 }

		 if ( b == 13 ) result = a - 48;
		 else if ( d == 13 ) result = (a-48)*10 + (b-48);

		 if (bioskey(1))
		 {
		   getkey();
		   if (!com_carrier(PORT))
		      com_tx(PORT,13);
		   else
		     hangup();
		   return;
		 }

		 if ((com_carrier(PORT))&&(result!=ERROR)&&(result!=NODIALTONE)&&(result!=NOCARRIER)&&(result!=BUSY))
		 {
		   busy = num_stored = 0;
		   refresh_display();
		   if ( result == CONNECT300) popmsg ( "Waiting to connect at 300...");
		   else if ( result == CONNECT1200 ) popmsg ( "Waiting to connect at 1200...");
		   else if ( result == CONNECT2400 ) popmsg ( "Waiting to connect at 2400...");
		   else if ( result == CONNECT4800 ) popmsg ( "Waiting to connect at 4800...");
		   else if ( result == CONNECT9600 ) popmsg ( "Waiting to connect at 9600...");
		   else if ( result == CONNECT14400 ) popmsg ( "Waiting to connect at 14400...");

		   else if ( result == CONNECT300ARQ) popmsg ( "Waiting to connect at 300/ARQ...");
		   else if ( result == CONNECT1200ARQ ) popmsg ( "Waiting to connect at 1200/ARQ...");
		   else if ( result == CONNECT2400ARQ ) popmsg ( "Waiting to connect at 2400/ARQ...");
		   else if ( result == CONNECT4800ARQ ) popmsg ( "Waiting to connect at 4800/ARQ...");
		   else if ( result == CONNECT9600ARQ ) popmsg ( "Waiting to connect at 9600/ARQ...");
		   else if ( result == CONNECT14400ARQ ) popmsg ( "Waiting to connect at 14400/ARQ...");

		   else if ( result == CONNECTARQ ) popmsg ( "Waiting to connect/ARQ...");
		   else popmsg ( "Waiting to connect...");
		   com_flush_rx(PORT);
		   connected = busy = 1;
		   delay(5000);
	   do_link();
		 }
		 else if ( result == NODIALTONE )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg ("No Dial Tone");
		   delay(5000);
		   refresh_display();
		 }
		 else if ( result == BUSY )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg ( "Busy" );
		   delay(5000);
		   refresh_display();
		 }
		 else if ( result == NOCARRIER )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg("No Carrier" );
		   delay(5000);
		   refresh_display();
		 }
		 else
		 {
		   hangup();
		   popmsg("Unable to connect. Please try again.");
		   delay(5000);
		   refresh_display();
		   busy = 1;
		 }
	       }
	       else
	       {
		 refresh_display();
		 popmsg ("Unable to perform this operation");
		 delay(5000);
		 refresh_display();
	       }
		 break;

    case 'o':
    case 'O':    /*originate a no-dial call*/
	       if (!connected)
	       {
		 com_raise_dtr(PORT);
		 com_flush_rx(PORT);
		 delay(1100);
		 com_tx_string_with_delay(PORT, "ATE0V0X1D", 10, 10);
		 com_tx(PORT, 13);
		 delay(3500);
		 a=0;

		 while ((!bioskey(1))&&(!com_carrier(PORT)&&(a==0)))
		   if(!com_rx_empty(PORT)) a = com_rx(PORT);

		 delay(2000);

		 if (!bioskey(1))
		 {
		   b = com_rx(PORT);
		   if(b!=13) d = com_rx(PORT);
		 }

		 if ( b == 13 ) result = a - 48;
		 else if ( d == 13 ) result = (a-48)*10 + (b-48);

		 if (bioskey(1))
		 {
		   getkey();
		   if (!com_carrier(PORT))
		      com_tx(PORT,13);
		   else
		     hangup();
		   return;
		 }

		 if ((com_carrier(PORT))&&(result!=ERROR)&&(result!=NODIALTONE)&&(result!=NOCARRIER)&&(result!=BUSY))
		 {
		   busy = num_stored = 0;
		   refresh_display();
		   if ( result == CONNECT300) popmsg ( "Waiting to connect at 300...");
		   else if ( result == CONNECT1200 ) popmsg ( "Waiting to connect at 1200...");
		   else if ( result == CONNECT2400 ) popmsg ( "Waiting to connect at 2400...");
		   else if ( result == CONNECT4800 ) popmsg ( "Waiting to connect at 4800...");
		   else if ( result == CONNECT9600 ) popmsg ( "Waiting to connect at 9600...");
		   else if ( result == CONNECT14400 ) popmsg ( "Waiting to connect at 14400...");

		   else if ( result == CONNECT300ARQ) popmsg ( "Waiting to connect at 300/ARQ...");
		   else if ( result == CONNECT1200ARQ ) popmsg ( "Waiting to connect at 1200/ARQ...");
		   else if ( result == CONNECT2400ARQ ) popmsg ( "Waiting to connect at 2400/ARQ...");
		   else if ( result == CONNECT4800ARQ ) popmsg ( "Waiting to connect at 4800/ARQ...");
		   else if ( result == CONNECT9600ARQ ) popmsg ( "Waiting to connect at 9600/ARQ...");
		   else if ( result == CONNECT14400ARQ ) popmsg ( "Waiting to connect at 14400/ARQ...");

		   else if ( result == CONNECTARQ ) popmsg ( "Waiting to connect/ARQ...");
		   else popmsg ( "Waiting to connect...");
		   com_flush_rx(PORT);
		   connected = 1;
		   delay(5000);
	   do_link();
		 }
		 else if ( result == NODIALTONE )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg ("No Dial Tone");
		   delay(5000);
		   refresh_display();
		 }
		 else if ( result == BUSY )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg ( "Busy" );
		   delay(5000);
		   refresh_display();
		 }
		 else if ( result == NOCARRIER )
		 {
		   busy = 1;
		   refresh_display();
		   popmsg("No Carrier" );
		   delay(5000);
		   refresh_display();
		 }
		 else
		 {
		   hangup();
		   popmsg("Unable to connect. Please try again.");
		   delay(5000);
		   refresh_display();
		   busy = 1;
		 }
	       }
	       else
	       {
		 refresh_display();
		 popmsg ("Unable to perform this operation");
		 delay(5000);
		 refresh_display();
	       }

		 break;

    case 'h':
    case 'H':    poptext(helpmenu);
		 getkey();
		 /*help menu*/
		 break;

    case 'g':
    case 'G':    /*hangup*/
		 if(yes_or_no())
		 {
		   popmsg("Hanging Up");
		   hangup();
		   delay(5000);
		 }
		 break;


    case 'z':    com_flush_rx(PORT);
		 com_flush_tx(PORT);
		 com_raise_dtr(PORT);
		 popmsg("Waiting to connect");
		 delay(4000);
		 refresh_display();
		 null_modem = connected = 1;
		 do_link();
		 break;

    case 'x':    com_flush_rx(PORT);
		 com_flush_tx(PORT);
		 com_raise_dtr(PORT);
		 popmsg("Waiting to connect");
		 delay(4000);
		 refresh_display();
		 null_modem = connected = 1;
		 do_link();
		 break;


    case UP:    /* Forward */
	      x = 350 * sine(current_view->pan);
	      z = 350 * cosine(current_view->pan);

	      tempx = current_view->ex + x;
	      tempz = current_view->ez + z;

	      if ((tempx > 0) &&
		  (tempx < 20000)&&
		  (tempz > 0) &&
		  (tempz < 20000))
	      {
		current_view->ex = tempx;  //+= x;
		current_view->ez = tempz;  //+= z;

		rel_move_segment ( body_seg, x, 0, z );
		update_segment ( body_seg );

		redraw = 1;
		if(connected)com_tx(PORT, 'a' );
	      }
	      break;


    case LEFT: current_view->pan -= 10*65536L;
	       rel_rot_segment ( body_seg, 0, (-10*65536L), 0, RYXZ);
	       update_segment ( body_seg );
	       if(connected)com_tx(PORT, 'e' );
	       break;


    case RIGHT: current_view->pan += 10*65536L;
		rel_rot_segment ( body_seg, 0, (10*65536L), 0, RYXZ);
		update_segment ( body_seg );

		if(connected)com_tx (PORT, 'f' );
		break;

    case ' ': get_object_bounds (current_obj, &x, &y, &z);
	      if (person ==0)
	      {
		if ((x>9000)&&(x<12000)&&(z<1000)&&(z>0))
		{
		  detach_segment (get_object_owner(current_obj));
		  got_one = 0;
//          current_obj->oflags = current_obj->oflags & 0xFFFF7;
		  if (connected) com_tx(PORT, 'n');
		  our_flag_count++;
		}
	      }
	      else
	      {
		if ((x>9000)&&(x<12000)&&(z<20000)&&(z>19000))
		{
		  detach_segment (get_object_owner(current_obj));
		  got_one = 0;
//          current_obj->oflags = current_obj->oflags & 0xFFFF7;
		  if (connected) com_tx(PORT, 'n');
		  our_flag_count++;
		}
	      }
	      break;


  }

}

long other_pan;
void handle_com( int chint )
{
  int i, num;
  char buf[35];
  long x,y,z;
  int x1, y1, z1;
  char a, b, c,d, buttons;
  long lb,lc, ax, az, tempx, tempz, pan;
  OBJECT *obj;


  switch (chint)
  {


	case 'a': ax = 150 * sine(other_guys_view.pan);
		  az = 150 * cosine(other_guys_view.pan);

	      other_guys_view.ex += ax;
	      other_guys_view.ez += az;

	      rel_move_segment ( their_head, ax, 0, az );
	      update_segment ( their_head );

	      redraw = 1;
		  break;

	case 'b':
	case 'c':
	case 'd': break;

	case 'e':
	      other_guys_view.pan -= ( 5 * 65536L );
	      abs_move_segment ( temp, other_guys_view.ex,
					   other_guys_view.ey,
					   other_guys_view.ez );
	      update_segment ( temp );

	      rel_rot_segment ( their_head, 0, (-5*65536L), 0, RYXZ);
	      rel_rot_segment ( temp, 0, (-5*65536L), 0, RYXZ );
	      update_segment ( their_head );
	      update_segment ( temp);
	      redraw = 1;
	      break;

	case 'f':
	      abs_move_segment ( temp, other_guys_view.ex,
					   other_guys_view.ey,
					   other_guys_view.ez );
	      update_segment ( temp );

	      other_guys_view.pan += (5 * 65536L );
	      rel_rot_segment ( their_head, 0, (5*65536L), 0, RYXZ);
	      rel_rot_segment ( temp, 0, (5*65536L), 0, RYXZ );
	      update_segment ( temp );
	      update_segment ( their_head );
	      redraw = 1;
	      break;

	case 'g':
	case 'h':
	case 'i': break;

	case 'j': a = com_rx(PORT);
		  b = com_rx(PORT);
		    if ( a != 0 )
		    {
		      other_guys_view.pan += ( a/10 * 65536L );
		      rel_rot_segment ( their_head, 0, (a/10*65536L), 0, RYXZ);
		      update_segment ( their_head );
		      redraw = 1;
		    }


	    if (b!=0)
	    {
	      ax = 2*b * sine(other_guys_view.pan);
	      az = 2*b * cosine(other_guys_view.pan);

	      tempx = current_view->ex + ax;
	      tempz = current_view->ez + az;

	      if ((tempx > 0) &&
		  (tempx < 20000)&&
		  (tempz > 0) &&
		  (tempz < 20000))
	      {

		other_guys_view.ex += ax;
		other_guys_view.ez += az;

		rel_move_segment ( their_head, ax, 0, az );
		update_segment ( their_head );

		redraw = 1;
	      }
	    }

	case 'm': num = com_rx(PORT);
		  flags[num] = 0;
		  strcpy(current_name, pieces[num] );
		  walk_split_tree (split_tree, find_segment);
		  attach_segment ( correct_seg, their_car );
		  attached_piece = correct_seg;
		  break;

	case 'n': detach_segment (attached_piece);
		  break;

	case 'q': they_won();
		  break;

	case 'r': reset_board();
		  break;
  }
}


void check_joystick()
{
  int x, y, chint, i;
  float thecos, thesin;
  long ax, az, tempx, tempz, pan, ay;


  joystick_read ( &joy_data );
  x = joy_data.x;
  y = joy_data.y;

  if ( x>15 ) x -= 15;
  else
  {
    if ( x > -15) x = 0;
    else x += 15;
  }
  if ( y > 15 ) y -= 15;
  else
  {
    if(y>-15) y = 0;
    else y+=15;
  }

  if ((connected) && ((x!=0) || (y!=0)))
  {
    com_tx(PORT, 'j');
    com_tx(PORT, (char)x);
    com_tx(PORT, (char)y);
  }


  switch ( joy_data.buttons )
  {
    case 0:

	   if (x!=0)
	   {
	      current_view->pan += ( x/10 * 65536L );
	      rel_rot_segment ( body_seg, 0, (x/10*65536L), 0, RYXZ);
	      update_segment ( body_seg );
	      redraw = 1;
	   }

	    if (y!=0)
	    {
	      ax = -2*y * sine(current_view->pan);
	      az = -2*y * cosine(current_view->pan);

	      tempx = current_view->ex + ax;
	      tempz = current_view->ez + az;

	      if ((tempx > 0) &&
		  (tempx < 20000)&&
		  (tempz > 0) &&
		  (tempz < 20000))
	      {
		current_view->ex += ax;
		current_view->ez += az;

		rel_move_segment ( body_seg, ax, 0, az );
		update_segment ( body_seg );

		redraw = 1;
	      }

	    }

	    break;

    case 1:   get_object_bounds (current_obj, &ax, &ay, &az);
	      if (person==0)
	      {
		if ((ax>9000)&&(ax<12000)&&(az<1000)&&(az>0))
		{
		  detach_segment (get_object_owner(current_obj));
		  got_one = 0;
//          current_obj->oflags = current_obj->oflags & 0xFFFF7;
		  if (connected) com_tx(PORT, 'n');
		}
		our_flag_count++;
	      }
	      else
	      {
		if ((ax>9000)&&(ax<12000)&&(az<20000)&&(az>19000))
		{
		  detach_segment (get_object_owner(current_obj));
		  got_one = 0;
//          current_obj->oflags = current_obj->oflags & 0xFFFF7;
		  if (connected) com_tx(PORT, 'n');
		  our_flag_count++;
		}
	      }
	      break;
  }
}


void check_flags()
{
  OBJECT *obj;
  char num;

  hit = 0;

  collide_x = current_view->ex + 700 * sine(current_view->pan);
  collide_y = current_view->ey;
  collide_z = current_view->ez + 700 * cosine(current_view->pan);

  walk_split_tree (split_tree, check_list);
  if (hit)
  {
    num = find_piece(seg_getname((SEGMENT *)get_object_owner(current_obj)));
    if (flags[num]==1)
    {
      flags[num] = 1;
      if (connected)
      {
	com_tx(PORT, 'm');
	com_tx(PORT, num);
      }
      attach_segment ((SEGMENT *)get_object_owner(current_obj),our_car);
      got_one = 1;
    }
  }
}

void get_stunt()
{

  int x1, x2, x3, x4, y1, y2, y3, y4;
  char *stunt_text[] = {
			"",
			"Please put Stuntmaster on your head.",
			"Look straight ahead and press the",
			"reset button.",
			"",
			NULL
		      };


  joystick_init (&stunt_data, use_stuntmaster-1);

  poptext ( stunt_text );
  delay(10000);

  joystick_read ( &stunt_data ); x1 = stunt_data.x; y1 = stunt_data.y;
  delay(150);
  joystick_read ( &stunt_data ); x2 = stunt_data.x; y2 = stunt_data.y;
  delay(150);
  joystick_read ( &stunt_data ); x3 = stunt_data.x; y3 = stunt_data.y;
  delay(150);
  joystick_read ( &stunt_data ); x4 = stunt_data.x; y4 = stunt_data.y;
  delay(150);

  x_stunt_value = (x1+x2+x3+x4)/4;
  y_stunt_value = (y1+y2+y3+y4)/4;

  stunt_position = 0;
}


void check_stunt()
{
 int x1, x2, x3, x4, y1, y2, y3, y4;
 int x, y;

 joystick_read(&stunt_data); x1 = stunt_data.x; y1 = stunt_data.y;
 joystick_read(&stunt_data); x2 = stunt_data.x; y2 = stunt_data.y;
 joystick_read(&stunt_data); x3 = stunt_data.x; y3 = stunt_data.y;
 joystick_read(&stunt_data); x4 = stunt_data.x; y4 = stunt_data.y;

 x = (x1+x2+x3+x4)/4;
 y = (y1+y2+y3+y4)/4;


 if ((x > x_stunt_value) && (stunt_position != -1) && (y<y_stunt_value))
 {
   if (stunt_position == 0)
     current_view->pan -= stunt_angle*65536L;
   else
     current_view->pan -= 2*stunt_angle*65536L;
   stunt_position = -1;
 }
 else if ((y > y_stunt_value) && (stunt_position != 1)&&(x<x_stunt_value))
 {
   if (stunt_position == 0)
     current_view->pan += stunt_angle*65536L;
   else
     current_view->pan += 2*stunt_angle*65536L;
   stunt_position = 1;
 }
 else if ((x == x_stunt_value)&&(y == y_stunt_value))
 {
   if (stunt_position == -1)
   {
     stunt_position = 0;
     current_view->pan += stunt_angle*65536L;
   }
   else if (stunt_position == 1)
   {
     stunt_position = 0;
     current_view->pan -= stunt_angle*65536L;
   }
 }
 redraw =1;
}


/**************************************************************************
  This function performs the functions of the program.  The loop terminates
  when execution = 1.
**************************************************************************/
void main_loop()
{
  while ( execution )
    {

      if ((connected) && ((!com_carrier(PORT))&&(!null_modem)))
      {
	hangup();
	popmsg("Lost Carrier. Call Dropped");
	delay(5000);
      }

      if (bioskey(1))             handle_key (getkey());
      if (joystick)               check_joystick();
      if (!com_rx_empty(PORT))    handle_com(com_rx(PORT));
      if (redraw)                 refresh_display();
      if (!got_one)		  check_flags();
      if (our_flag_count > 2)     we_won();
      if (use_stuntmaster)        check_stunt();
    }
}


/**************************************************************************
  This function is called to load video drivers.  The pointer
  v_driver_pointer is set to a handle representing the video driver.
  The variable v_driver_pointer is used by the files: main only.
**************************************************************************/
void load_video_driver ( char *dfile )
{
  v_driver_pointer = load_driver ( dfile );
  if ( v_driver_pointer == NULL )
  {
	fprintf ( stderr, "Bad video driver/n" );
	exit ( 1 );
  }
}

int check_port()
{
  char a;
  long test;


    com_raise_dtr(PORT);
    com_flush_rx(PORT);
    delay(1100);
    com_tx_string_with_delay(PORT, "ATE0V0", 10, 10 );
    com_tx(PORT, 13); delay(10);
    delay(3500);

    a=test=0;
    while((com_rx_empty(PORT))&&(test<1500000))
      test++;

    if (!com_rx_empty(PORT)) a = com_rx(PORT);
    if (!com_rx_empty(PORT)) com_rx(PORT);
    com_lower_dtr(PORT);

    if (a == 48 ) return 1;
    else return 0;


}

void setup_com()
{

    int com, ok = 0;
    char ch;

    if ((com = com_install(PORT)))
    {
      printf("com_install() error: %d\n", com);
      delay(10000);
      exit(0);
    }
    com_set_speed(PORT, SPEED );
    com_set_parity(PORT, COM_NONE, 1);
    com_lower_dtr(PORT);
    com_raise_dtr(PORT);
    com_lower_dtr(PORT);

    printf ( "\n\nPlease enter startup choice: [N]ull modem connection or [M]odem?  (N/M):");
    ch = getkey();
  if ( (ch=='M')||(ch=='m'))
   {
    printf ( "\n");

    printf ( "\nChecking Modem at COM Port %d...\n", PORT );

    if (check_port())
    {
      com_raise_dtr(PORT);
      com_tx_string ( PORT, "ATV0E0S0=0");
      com_tx(PORT,13);
      com_lower_dtr(PORT);
      ok = 1;
    }

    if ((!ok)&&check_port())
    {
      com_raise_dtr(PORT);
      com_tx_string ( PORT, "ATV0E0S0=0");
      com_tx(PORT,13);
      com_lower_dtr(PORT);
      ok = 1;
    }

    if ((!ok)&&check_port())
    {
      com_raise_dtr(PORT);
      com_tx_string ( PORT, "ATV0E0S0=0");
      com_tx(PORT,13);
      com_lower_dtr(PORT);
      ok = 1;
    }

    if (!ok)
    {
      clrscr();
      printf ( "\n\n\nThe system was unable to locate a modem at the COM port specified" );
      printf ( "\n\nPlease check the connection and COM port.  It is imperative that" );
      printf ( "\nthe modem has a dedicated IRQ line.  Check the following chart to");
      printf ( "\ndetermine if you have a possible conflict");
      printf ( "\n\n\n");
      printf ( "          Modem COM Port		       COM Ports Not to Use");
      printf ( "\n\n");
      printf ( "            COM Port 1			            Ports - 3\n");
      printf ( "            COM Port 2			            Ports - 4\n");
      printf ( "            COM Port 3			            Ports - 1\n");
      printf ( "            COM Port 4                              Ports - 2\n");
      printf ( "\n\n\n\n\n\n\n");
      exit(1);
    }
   }
   else
   {
     printf ( "\n\nBypassing Modem setup...\n");
     delay(1000);
   }

}


void open_person_file()
{
  char ch;

  clrscr();
  printf ( "\n");
  printcenter ( "Select the COM port to which your modem or NULL modem connection"); printf ( "\n");
  printcenter ( "is attached.");printf ( "\n\n");
  printcenter ( "Enter COM port number ( 1,2,3, or 4):");
  ch = getkey();
  while ( (ch<49) || (ch>52))
  {
    printf ( "\n");
    printcenter ( "Enter COM port number ( 1,2,3, or 4):");
    ch = getkey();
  }
  PORT = ch-48;


  printf ( "\n\nLoading...\n\n");
}


void read_our_car(int person)
{
  FILE *in;


  if ((in = fopen ( "capcar.fig", "r" )) == NULL )
    {
      popmsg ( "Capcar.fig file not found");
      delay(4000);
      exit(1);
    }

  set_readseg_objlist ( objlist );
  set_readseg_scale ( 0.25,0.25,0.25 );
  our_car = readseg (in, NULL);
  fclose(in);

  if (person == 0)
  {
    abs_rot_segment (our_car, 0,-90*65536L,0,RYXZ);
    abs_move_segment (our_car, 323,145,-200);
    update_segment (our_car);
    attach_segment (our_car, body_seg);
  }
  else
  {
    abs_rot_segment (our_car, 0,90*65536L,0,RXYZ);
    abs_move_segment (our_car, 877,145,3900);
    update_segment (our_car);
    attach_segment (our_car, body_seg);
  }

  rgrip = find_segment_by_name (our_car, "right grip");
  lgrip = find_segment_by_name (our_car, "left grip");

}


void read_their_car(int person)
{
  FILE *in;


  if ((in = fopen ( "capcar.fig", "r" )) == NULL )
    {
      popmsg ( "Capcar.fig file not found");
      delay(4000);
      exit(1);
    }

  set_readseg_objlist ( objlist );
  set_readseg_scale ( 0.25,0.25,0.25 );
  their_car = readseg (in, NULL);
  fclose(in);

  if (person == 1)
  {
    abs_rot_segment (their_car, 0,-90*65536L,0,RYXZ);
    abs_move_segment (their_car, 323,145,-200);
    update_segment (their_car);
    attach_segment (their_car, their_head);
  }
  else
  {
    abs_rot_segment (their_car, 0,90*65536L,0,RXYZ);
    abs_move_segment (their_car, 877,145,3900);
    update_segment (their_car);
    attach_segment (their_car, their_head);
  }

}

void main(int argc, char *argv[]){
  int i;
  char *fname, *in_filename;
  FILE *in;
  OBJECT *obj;

  debug = fopen ("debug", "w");
  randomize();
  open_person_file();
  setup_com();

  for (i=1; i < argc; ++i)
  {
    if (argv[i][0] == '/' || argv[i][0] == '-')
    {
      switch(toupper(argv[i][1]))
      {

      case 'S': use_stunt = 1;
		break;
      }
    }
  }


  setup_render(50,2000);
  atexit(closeall);
  set_global_split_root ( &split_tree );
  initial_world_split ( &split_tree );
  set_move_handler ( split_move_handler );
  objlist = new_objlist();

  load_video_driver ( vdname );
  screeninfo = screen_data();
  highest_color = screeninfo->colors-1;
  preset_default_colors();

  frame_x = screeninfo->xmin;
  frame_y = screeninfo->ymin;
  frame_w = screeninfo->xmax - screeninfo->xmin+1;
  frame_h = screeninfo->ymax - screeninfo->ymin+1;

  default_view.left = screeninfo->xmin;
  default_view.top = screeninfo->ymin;
  default_view.right = screeninfo->xmax;
  default_view.bottom = screeninfo->ymax;
  default_view.aspect = screeninfo->aspect;

  if (enter_graphics())
  {
    fprintf ( stderr, "could not enter graphics mode\n\n");
    exit(1);
  }

  screen_clear_color = 0;

  sky_color  = 0; ground_color = 0;

  if ((in = fopen ( "attack.wld", "r" )) == NULL )
  {
	  fprintf ( stderr, "Error opening world file.\n" );
	  exit(1);
  }
  if (read_world(in))
   {
     fprintf ( stderr, "Error reading world file.\n");
     exit(1);
   }
  fclose(in);


  body_seg = new_seg(NULL);
  their_head = new_seg(NULL);
  temp = new_seg(NULL);

  other_pan = 0;
  if ( person == 0 )
  {
    current_view->ex = 200;
    current_view->ey = 325;
    current_view->ez = 200;
    abs_move_segment ( body_seg, 200, 325, 200 );
    update_segment ( body_seg );
    current_view->pan = 0;

    other_guys_view.ex = 1000;
    other_guys_view.ey = 325;
    other_guys_view.ez = 3500;
    other_guys_view.pan = 0;
  }
  else
  {
    current_view->ex = 1000;
    current_view->ey = 325;
    current_view->ez = 3500;
    abs_move_segment ( body_seg, 1000, 325, 3500 );
    update_segment ( body_seg );

    current_view->pan = 0;

    other_guys_view.ex = 200;
    other_guys_view.ey = 325;
    other_guys_view.ez = 200;

    other_guys_view.pan = 0;
  }

  initialize_screen_factors ( current_view );
  fast_view_factors ( current_view );
  update_segment ( body_seg );


  if (!use_stuntmaster)
  {
  if ((joy_return = joystick_check()) == 0 )
  {
    popmsg ( "Joystick was not found" );
    delay ( 1000 );
  }
  else
  {
    if ( joy_return & 1 ) joystick_init ( &joy_data, 0 );
    if ( joy_return & 2 ) joystick_init ( &joy_data, 1 );
    joystick_setscale ( &joy_data, 100 );
    joystick = 1;
  }
  }
  else
      get_stunt();

  read_our_car(person);
  read_their_car(person);
  read_flags();
  main_loop();
  fclose(debug);
}
