  >>> Source code to convert Dmodem video commands into screen images <<<


DMG.PIX:
  ' DMGC$ contains string of video information
  ' String starts with CHR$(31)+"!2 x/"+{data}
  ' Strip CHR$(31) off before coming here
  ' set DMG.PARM(2) equal to the VAL of x above (x is the video fucntion)
  
  IF DMG.PARM(2) = 0 AND LEN(DMGC$) = 103 THEN GOTO DMG.PIX.00
  IF DMG.PARM(2) = 1 AND LEN(DMGC$) = 103 THEN GOTO DMG.PIX.01
  IF DMG.PARM(2) = 2 AND LEN(DMGC$) = 57 THEN GOTO DMG.PIX.02
  IF DMG.PARM(2) = 3 AND LEN(DMGC$) = 107 THEN GOTO DMG.PIX.03
  IF DMG.PARM(2) = 4 AND LEN(DMGC$) = 57 THEN GOTO DMG.PIX.04
  IF DMG.PARM(2) = 9 AND LEN(DMGC$) = 56 THEN GOTO DMG.PIX.09

  GOTO DMG.GGEN.END


DMG.PIX.00:
  ' Do graphics set up
  SCREEN 12
  DMG.MODE = 12
  CLS

  ' Create palette
  FOR I = 1 TO 16
    V = (I - 1) * 4
    PAL&(I) = 65536 * V + 256 * V + V
  NEXT I

  PALETTE USING PAL&(1)

DMG.PIX.01:
  C.COUNT = 0
  R.CELL = VAL(MID$(DMGC$, 6, 1))
  C.CELL = VAL(MID$(DMGC$, 7, 1))
  R.POS = R.CELL * 120
  C.POS = C.CELL * 160
 
  IF R.CELL < 0 OR R.CELL > 3 OR C.CELL < 0 OR C.CELL > 3 THEN GOTO DMG.GGEN.END

  FOR I1 = 1 TO 96
    ' Unpack byte
    A = ASC(MID$(DMGC$, I1 + 7, 1)) - 40
    PB(1) = INT(A / 8)
    PB(2) = A - PB(1) * 8

    FOR I3 = 1 TO 2
      ' Set pixel value
      PIXEL = PB(I3) * 2

      ' Write 100 pixels
      LINE (C.POS, R.POS)-(C.POS + 9, R.POS + 9), PIXEL, BF

      ' Set next pixel position
      C.COUNT = C.COUNT + 1
      C.POS = C.POS + 10
      IF C.COUNT > 15 THEN R.POS = R.POS + 10: C.POS = C.POS - 160: C.COUNT = 0

    NEXT I3
  NEXT I1

  GOTO DMG.GGEN.END


DMG.PIX.02:
  C.COUNT = 0
  R.SUBCELL = ASC(MID$(DMGC$, 6, 1)) - 65
  C.SUBCELL = ASC(MID$(DMGC$, 7, 1)) - 65
  R.POS = R.CELL * 120 + R.SUBCELL * 10
  C.POS = C.CELL * 160 + C.SUBCELL * 10

  IF R.CELL < 0 OR R.CELL > 3 OR C.CELL < 0 OR C.CELL > 3 THEN GOTO DMG.GGEN.END
  IF R.SUBCELL < 0 OR R.SUBCELL > 11 THEN GOTO DMG.GGEN.END
  IF C.SUBCELL < 0 OR C.SUBCELL > 15 THEN GOTO DMG.GGEN.END

  FOR I1 = 1 TO 50
    ' Unpack byte
    A = ASC(MID$(DMGC$, I1 + 7, 1)) - 40
    PB(1) = INT(A / 8)
    PB(2) = A - PB(1) * 8

    FOR I3 = 1 TO 2
      ' Set pixel value
      PIXEL = PB(I3) * 2

      ' Write 1 pixel
      PSET (C.POS, R.POS), PIXEL

      ' Set next pixel position
      C.COUNT = C.COUNT + 1
      C.POS = C.POS + 1
      IF C.COUNT > 9 THEN R.POS = R.POS + 1: C.POS = C.POS - 10: C.COUNT = 0

    NEXT I3
  NEXT I1
   
  GOTO DMG.GGEN.END


DMG.PIX.03:
  C.COUNT = 0
  R.SUBCELL = ASC(MID$(DMGC$, 6, 1)) - 65
  C.SUBCELL = ASC(MID$(DMGC$, 7, 1)) - 65
  R.POS = R.CELL * 120 + R.SUBCELL * 10
  C.POS = C.CELL * 160 + C.SUBCELL * 10

  IF R.CELL < 0 OR R.CELL > 3 OR C.CELL < 0 OR C.CELL > 3 THEN GOTO DMG.GGEN.END
  IF R.SUBCELL < 0 OR R.SUBCELL > 11 THEN GOTO DMG.GGEN.END
  IF C.SUBCELL < 0 OR C.SUBCELL > 15 THEN GOTO DMG.GGEN.END

  FOR I1 = 1 TO 100
    ' Unpack byte
    PIXEL = ASC(MID$(DMGC$, I1 + 7, 1)) - 40

    ' Write 1 pixel
    PSET (C.POS, R.POS), PIXEL

    ' Set next pixel position
    C.COUNT = C.COUNT + 1
    C.POS = C.POS + 1
    IF C.COUNT > 9 THEN R.POS = R.POS + 1: C.POS = C.POS - 10: C.COUNT = 0

  NEXT I1
    
  GOTO DMG.GGEN.END


DMG.PIX.04:
  C.COUNT = 0
  R.SUBCELL = ASC(MID$(DMGC$, 6, 1)) - 65
  C.SUBCELL = ASC(MID$(DMGC$, 7, 1)) - 65
  R.POS = R.CELL * 120 + R.SUBCELL * 10
  C.POS = C.CELL * 160 + C.SUBCELL * 10

  IF R.CELL < 0 OR R.CELL > 3 OR C.CELL < 0 OR C.CELL > 3 THEN GOTO DMG.GGEN.END
  IF R.SUBCELL < 0 OR R.SUBCELL > 11 THEN GOTO DMG.GGEN.END
  IF C.SUBCELL < 0 OR C.SUBCELL > 15 THEN GOTO DMG.GGEN.END

  FOR I1 = 1 TO 50
    ' Unpack byte
    PIXEL = ASC(MID$(DMGC$, I1 + 7, 1)) - 40

    FOR I3 = 1 TO 2
      ' Write 1 pixel
      PSET (C.POS, R.POS), PIXEL

      ' Set next pixel position
      C.COUNT = C.COUNT + 1
      C.POS = C.POS + 1
      IF C.COUNT > 9 THEN R.POS = R.POS + 1: C.POS = C.POS - 10: C.COUNT = 0

    NEXT I3
  NEXT I1
   
  GOTO DMG.GGEN.END


DMG.PIX.09:
  ' See if prompt is desired
  S = VAL(MID$(DMGC$, 6, 2))
  IF S = 0 OR TELEOP.FLAG > 0 THEN GOTO DMG.PIX.09.END

  IF S < 0 THEN S = 0
 
  IF DMG.MODE = 0 THEN COLOR 15, 0
  IF DMG.MODE = 9 THEN COLOR 15, 0
  IF DMG.MODE = 12 THEN COLOR 15

  ' Set temporary maximum lines
  TEMP.MAX.LINES = MAX.LINES
  IF DMG.MODE = 12 THEN TEMP.MAX.LINES = 30
 
  LOCATE TEMP.MAX.LINES, 1
  PRINT STRING$(79, " ");
  LOCATE TEMP.MAX.LINES, 16
  PRINT MID$(DMGC$, 8, 48);

  IF DMG.MODE = 0 THEN COLOR FC1, BC1
  IF DMG.MODE = 9 THEN COLOR FC1, 0
  IF DMG.MODE = 12 THEN COLOR FC1

  LOCATE RR1, CC1

  SLEEP S
  KI$ = INKEY$

 
DMG.PIX.09.END:
  ' Set normal screen mode
  DMG.MODE = 0
  SCREEN 0
  WIDTH 80, MAX.LINES
 
  RESTORE.SCREEN

  GOTO DMG.GGEN.END
