;MEMCOPY.ASM   copy block of RAM to RAM by Cornel Huth
;
;QuickBASIC subroutine:
;
;   CALL MemCopy (FromSeg%, FromOff%, ToSeg%, ToOff%, count%, dir%)
;
;If dir% is positive, memory is copied from low to high RAM
;           negative, memory is copied from high to low RAM
;           zero, immediate exit
;
;If memory blocks do not overlap, generally a positive dir% should
;be used.
;
PARMS   =       6

ArgFromSeg      EQU     [bp+16]
ArgFromOff      EQU     [bp+14]
ArgToSeg        EQU     [bp+12]
ArgToOff        EQU     [bp+10]
ArgCount        EQU     [bp+08]
ArgDirection    EQU     [bp+06]

MemCopy_TEXT    SEGMENT word public 'CODE'
                ASSUME  cs:MemCopy_TEXT

                PUBLIC  MemCopy
MemCopy         PROC    far

                push    bp
                mov     bp,sp
                push    di
                push    si
                push    ds
                pushf

                mov     bx,ArgDirection
                mov     ax,[bx]
                or      ax,ax
                je      MemCopyXit      ;0 dir then exit
                std                     ;pos. dir then copy up memory
                js      CopyBackward    ;neg. dir then copy down memory
                cld
CopyBackward:   mov     bx,ArgCount
                mov     cx,[bx]
                jcxz    MemCopyXit

                mov     bx,ArgToOff     ;set up destination
                mov     di,[bx]
                mov     bx,ArgToSeg
                mov     es,[bx]
                mov     bx,ArgFromOff   ;set up source
                mov     si,[bx]
                mov     bx,ArgFromSeg
                mov     ds,[bx]

                repz    movsb           ;copy

 MemCopyXit:    popf
                pop     ds
                pop     si
                pop     di
                pop     bp

                RET     PARMS*2
MemCopy         endp
MemCopy_TEXT    ends
                END

