      REM:  EX_WIDTH.BAS, Unregistered Version 1.0
      REM:  Example of using WidthString to break a line.

      DECLARE FUNCTION WidthString% (Text$, FontArray%())

      DECLARE SUB BLOADFont (FlName$, FontArray%(), RetCode%)
      DECLARE SUB FastString (Text$, FClr%, X%, Y%, FontArray%())
     
      '...setup a VGA screen mode...
      SCREEN 12
     
      '...dimension array for font data (use REDIM so they're DYNAMIC)...
      REDIM FontArray%(1)
    
      '...load in a fonts and check the return code...
      CALL BLOADFont("DTCH_BLD.BIN", FontArray%(), RetCode%)
      IF (RetCode% <> 0) THEN STOP
     
      '...define x-limits in which to display, y start, and text color...
      XMin% = 100: XMax% = 300: YRow% = 100: FClr% = 7

      Text$ = "This is a simple demonstration of breaking text between "
      Text$ = Text$ + "words to fit on a line."

      '...compute line width...
      BxWidth% = XMax% - XMin% + 1
    
      '...start at the first char and a min x-coord...
      i% = 1: X% = XMin%
   
      '...set row spacing - vertical spacing + any vertical padding...
      DRow% = FontArray%(7) + FontArray%(10)
   
      DO
   
        '...find the next word break (the next space)...
        j% = INSTR(i%, Text$, " ")

        '...if no space found before the end, skip to the end...
        IF (j% <= 0) THEN j% = LEN(Text$)
     
        '...pull the word...
        Word$ = MID$(Text$, i%, j% - i% + 1)

        '...compute its width...
        WordWidth% = WidthString%(Word$, FontArray%())

        '...will this word exceed the length of the box or end of text...
        IF (CurrLine% + WordWidth% > BxWidth%) THEN
         
          '...display the text for the line...
          CALL FastString(LineText$, FClr%, X%, YRow%, FontArray%())

          '...set to rwo start and add line spacing to next row...
          X% = XMin%: YRow% = YRow% + DRow%
         
          '...the word we just found starts the new line...
          LineText$ = Word$: CurrLine% = WordWidth%
       
        ELSE
         
          '...just add the text to the line and the width counter...
          LineText$ = LineText$ + Word$: CurrLine% = CurrLine% + WordWidth%

        END IF

        '...if we reached end of string, display any remaining text...
        IF (j% >= LEN(Text$)) THEN
          CALL FastString(LineText$, FClr%, X%, YRow%, FontArray%())
        END IF

        '...set i% to the start of the next word...
        i% = j% + 1
     
      LOOP UNTIL (i% > LEN(Text$))

      END

'     ************************************************************************
      SUB BoxText (Text$, X%, Y%, FClr%, FontArray%())
'     ************************************************************************
  
'     ------------------------------------------------------------------------
'     This is a very simple routine to break text at words to fit in the box
'     defined by (XMin%,YMin%)-(XMax%,YMax%).  The box must be defined in the
'     main module to be shared.
'
'     The routine returns the X%, Y% values updated to the coordinates of the
'     start of the next character.  This allows successive strings to be
'     displayed in the box.
'
'     This is a simple demo routine.  If a word is longer than the box, the
'     entire word is displayed anyway.  No checking is performed for going
'     out the bottom of the box.  Multiple spaces at the end of a line may
'     be carried over to the next line, instead of dropped.  Only the upper
'     edges of the characters are aligned, not the baselines. This means
'     lines with different size fonts will be a mess.
'     ------------------------------------------------------------------------

      SHARED XMin%, YMin%, XMax%, YMax%

      '...compute box width...
      BxWidth% = XMax% - XMin% + 1
     
      '...start at the first char...
      i% = 1
    
      '...start at the supplied x and y-coordx...
      CurrLine% = X% - XMin%: YRow% = Y%
    
      '...set row spacing - vertical spacing + any vertical padding...
      DRow% = FontArray%(7) + FontArray%(10)
    
      DO
    
        '...find the next word break (the next space)...
        j% = INSTR(i%, Text$, " ")

        '...if no space found before the end, skip to the end...
        IF (j% <= 0) THEN j% = LEN(Text$)
      
        '...pull the word and compute its width...
        Word$ = MID$(Text$, i%, j% - i% + 1)
        WordWidth% = WidthString%(Word$, FontArray%())

        '...see if this word fits...
        CurrLine% = CurrLine% + WordWidth%

        '...has the line exceeded the length of the box or end of text...
        IF (CurrLine% >= BxWidth%) THEN
          
          '...display the text for the line...
          CALL FastString(LineText$, FClr%, X%, YRow%, FontArray%())

          '...set to rwo start and add line spacing to next row...
          X% = XMin%: YRow% = YRow% + DRow%
          
          '...the word we just found starts the new line...
          LineText$ = Word$

          '...and it's width is the length of the new line...
          CurrLine% = WordWidth%
        
        ELSE
          
          '...just add the text to the line...
          LineText$ = LineText$ + Word$
       
        END IF

        '...if we reached end of string, display any remaining text...
        IF (j% >= LEN(Text$)) THEN
          CALL FastString(LineText$, FClr%, X%, YRow%, FontArray%())
        END IF

        '...set i% to the start of the next word...
        i% = j% + 1
      
      LOOP UNTIL (i% > LEN(Text$))

      '...leave X%, Y% pointing to the start of the next word...
      X% = XMin% + CurrLine% + 1: Y% = YRow%
     
      END SUB

