/*
   A quick hack to set the refresh timer to a longer period than the
   standard 15 microseconds. This is to help out people who have to
   have their Cx486DLC flush the internal cache on every DRAM refresh,
   because their motherboard doesn't support the Cx's FLUSH input.

						Paul Gortmaker.
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

unsigned short dram_refresh;
unsigned char dram_timer_lo;
unsigned char dram_timer_hi;

int main(int argc, char *argv[]) {

if (argc!=2) {
    fprintf(stderr,"\nUsage: %s <time>\n\t\twhere <time> is the DRAM refresh period in s.\n",argv[0]);
    exit(0);
}

dram_refresh=atoi(argv[1]);

if (dram_refresh<15) {
	fprintf(stderr,"\nDRAM refresh more freqent than 15 microseconds? Ha!\n");
	exit(1);
}
else if (dram_refresh>55000) {
	fprintf(stderr,"\nDRAM refresh period must be less than 55000 microseconds.\n");
	exit(1);
}

dram_refresh=(unsigned short)(dram_refresh*1.193+.5);
/* timer is clocked at 1.19 MHz -- PC std. */

dram_timer_hi=dram_refresh/0x100;
dram_timer_lo=dram_refresh%0x100;

_outp(0x43,0x74);
_outp(0x41,dram_timer_lo);
_outp(0x41,dram_timer_hi);

return (0);

}
