unit Env;

{$X+}

interface

uses
  Dos,
  Objects,
  Strings;

type

  PMcb = ^TMcb;
  TMcb = record
    McbType : Char;
    Owner   : Word;
    Size    : Word;
    Unused  : array[1..3] of Char;
    Dos4Name: array[1..8] of Char
  end;

  PHandleTable = ^THandleTable;
  THandleTable = array[0..255] of Byte;

  PPsp = ^TPsp;
  TPsp = record
    Int20       : Word;
    Unused1     : Word;
    Filler      : Byte;
    Int21CPM    : array[0..4] of Byte;
    Int22       : Pointer;
    Int23       : Pointer;
    Int24       : Pointer;
    ParentPspSeg: Word;
    Handles     : array[0..19] of Byte;
    EnvSeg      : Word;
    SavedSSSP   : LongInt;
    NumHandles  : Word;
    HandleTable : PHandleTable;
    SharePsp    : Pointer;
    Unused2     : array[0..19] of Byte;
    Int21b      : Word;
    RetF        : Byte;
    Unused3     : array[0..8] of Byte;
    FCB1        : array[0..15] of Byte;
    FCB2        : array[0..15] of Byte;
    Unknown     : array[0..3] of Byte;
    CommandTail : String[127]
  end;

  PEnvVar = ^TEnvVar;
  TEnvVar = object (TObject)
    constructor Init (AName,AValue: PChar);
    destructor Done; virtual;
    procedure AddValue (const AValue: String);
    procedure ChangeValue (const AValue: String);
    function GetLen: Word;
    function GetName: PChar;
    function GetValue: PChar;
  private
    Name,Value: PChar;
  end;

  PEnvArray = ^TEnvArray;
  TEnvArray = array[0..32767] of Char;

  PEnvironment = ^TEnvironment;
  TEnvironment = object (TObject)
    constructor Init (Segment: Word);
    destructor Done; virtual;
    procedure ChangeEnvVar (const AName,AValue: String);
    procedure ExpandPath;
    function GetEnvError: Integer;
    function GetEnvLen: Word;
    function GetEnvSize: Word;
    function GetEnvVarByIndex (Index: Integer): PEnvVar;
    function GetEnvVarByName (const Name: String): PEnvVar;
    function GetEnvVarCount: Word;
    function GetPathLen: Word;
    function GetProgName: String;
    function PathToExpand: Boolean;
    procedure WriteEnv;
  private
    Error      : Integer;
    EnvColl    : PCollection;
    PathColl   : PStringCollection;
    EnvPtr     : PEnvArray;
    MaxSize,Len: Word;
    ProgName   : PString;
  end;

function FindActiveEnv: Word;

implementation

{ TEnvVar }

constructor TEnvVar.Init (AName,AValue: PChar);

begin
  inherited Init;
  Name := AName;
  Value := AValue
end;

destructor TEnvVar.Done;

begin
  StrDispose (Name);
  StrDispose (Value);
  inherited Done
end;

procedure TEnvVar.AddValue (const AValue: String);

var
  V: PChar;

begin
  GetMem (V,StrLen (Value) + 1);
  StrECopy (V,Value);
  StrDispose (Value);
  GetMem (Value,StrLen (V) + Length (AValue) + 1);
  StrECopy (Value,V);
  StrDispose (V);
  GetMem (V,Length (AValue) + 1);
  StrPCopy (V,AValue);
  StrCat (Value,V);
  StrDispose (V)
end;

procedure TEnvVar.ChangeValue (const AValue: String);

begin
  StrDispose (Value);
  GetMem (Value,Length (AValue) + 1);
  StrPCopy (Value,AValue)
end;

function TEnvVar.GetLen: Word;

begin
  GetLen := StrLen (Name) + StrLen (Value) + 2
end;

function TEnvVar.GetName: PChar;

begin
  GetName := Name
end;

function TEnvVar.GetValue: PChar;

begin
  GetValue := Value
end;

{ TEnvironment }

constructor TEnvironment.Init (Segment: Word);

var
  Head,Tail : Word;
  Name,Value: PChar;
  E         : PEnvVar;
  Temp      : PChar;
  S         : String;

begin
  inherited Init;
  EnvColl := New (PCollection,Init (5,1));
  PathColl := New (PStringCollection,Init (2,1));
  EnvPtr := Ptr (Segment,0);
  MaxSize := PMcb (Ptr (Seg (EnvPtr^) - 1,0))^.Size * 16;
  Head := 0;
  repeat
    Tail := 0;
    while EnvPtr^[Head + Tail] <> '=' do Inc (Tail);
    GetMem (Name,Tail + 1);
    Temp := @EnvPtr^[Head];
    StrLCopy (Name,Temp,Tail);
    if Swap (DosVersion) < $0700 then StrUpper (Name);
    Inc (Head,Tail + 1);
    Tail := 0;
    while EnvPtr^[Head + Tail] <> #0 do Inc (Tail);
    GetMem (Value,Tail + 1);
    Temp := @EnvPtr^[Head];
    StrLCopy (Value,Temp,Tail);
    GetMem (Temp,10);
    StrMove (Temp,Name,9);
    if StrLIComp (Temp,'PATHBLOCK',9) = 0 then
    begin
      S := StrPas (Name) + '=' + StrPas (Value);
      PathColl^.Insert (NewStr (S))
    end
    else begin
      E := New (PEnvVar,Init (Name,Value));
      EnvColl^.Insert (E)
    end;
    FreeMem (Temp,10);
    Inc (Head,Tail + 1)
  until EnvPtr^[Head] = #0;
  Inc (Head);
  Len := Head;
  if Swap (DosVersion) >= $0300 then
  begin
    Move (EnvPtr^[Head],Tail,SizeOf (Word));
    if Tail = 1 then
    begin
      GetMem (Name,256);
      Temp := @EnvPtr^[Head + 2];
      StrLCopy (Name,Temp,255);
      if Name^ <> '' then
      begin
        ProgName := NewStr (StrPas (Name));
        Inc (Len,Length (ProgName^) + 1)
      end;
      FreeMem (Name,256);
    end
  end
end;

destructor TEnvironment.Done;

begin
  Dispose (EnvColl,Done);
  Dispose (PathColl,Done);
  DisposeStr (ProgName)
end;

procedure TEnvironment.ChangeEnvVar (const AName,AValue: String);

var
  E  : PEnvVar;
  N,V: PChar;

begin
  E := GetEnvVarByName (AName);
  if (E = NIL) and (AValue = '') then
  begin
    Error := 1;
    Exit
  end;
  if E = NIL then
  begin
    GetMem (N,Length (AName) + 1);
    StrPCopy (N,AName);
    GetMem (V,Length (AValue) + 1);
    StrPCopy (V,AValue);
    E := New (PEnvVar,Init (N,V));
    EnvColl^.Insert (E)
  end
  else if AValue = '' then
    EnvColl^.Free (E)
  else E^.ChangeValue (AValue)
end;

procedure TEnvironment.ExpandPath;

var
  E  : PEnvVar;
  N,V: PChar;

procedure Add (P: PString); far;

var
  I: Byte;
  S: String;
  C: PChar;

begin
  I := Pos ('=',P^);
  S := Copy (P^,I + 1,255);
  C := E^.GetValue;
  if StrLen (C) > 0 then
  begin
    if (C[StrLen (C) - 1] = ';') and (S[1] = ';') then
      Delete (S,1,1)
    else if (C[StrLen (C) - 1] <> ';') and (S[1] <> ';') then
      S := ';' + S
  end
  else if S[1] = ';' then Delete (S,1,1);
  E^.AddValue (S)
end;

begin
  E := GetEnvVarByName ('PATH');
  if E = NIL then
  begin
    GetMem (N,5);
    StrPCopy (N,'PATH');
    GetMem (V,1);
    E := New (PEnvVar,Init (N,V));
    EnvColl^.Insert (E)
  end;
  PathColl^.ForEach (@Add)
end;

function TEnvironment.GetEnvError: Integer;

begin
  GetEnvError := Error;
  Error := 0
end;

function TEnvironment.GetEnvLen: Word;

begin
  GetEnvLen := Len
end;

function TEnvironment.GetEnvSize: Word;

begin
  GetEnvSize := MaxSize
end;

function TEnvironment.GetEnvVarByIndex (Index: Integer): PEnvVar;

begin
  if (Index < 0) or (Index > EnvColl^.Count) then
    GetEnvVarByIndex := NIL
  else GetEnvVarByIndex := PEnvVar (EnvColl^.At (Index - 1))
end;

function TEnvironment.GetEnvVarByName (const Name: String): PEnvVar;

function Matches (Item: PEnvVar): Boolean; far;

var
  P: PChar;

begin
  GetMem (P,Length (Name) + 1);
  StrPCopy (P,Name);
  Matches := StrLIComp (Item^.GetName,P,Length (Name)) = 0;
  FreeMem (P,Length (Name) + 1)
end;

begin
  GetEnvVarByName := EnvColl^.FirstThat (@Matches)
end;

function TEnvironment.GetEnvVarCount: Word;

begin
  GetEnvVarCount := EnvColl^.Count
end;

function TEnvironment.GetPathLen: Word;

var
  E: PEnvVar;

begin
  E := GetEnvVarByName ('PATH');
  if E = NIL then GetPathLen := 0 else GetPathLen := E^.GetLen - 1
end;

function TEnvironment.GetProgName: String;

begin
  if ProgName = NIL then
    GetProgName := ''
  else GetProgName := ProgName^
end;

function TEnvironment.PathToExpand: Boolean;

begin
  PathToExpand := PathColl^.Count > 0
end;

procedure TEnvironment.WriteEnv;

var
  W,W1,TotalSize: Word;

procedure CalcSize (E: PEnvVar); far;

begin
  Inc (TotalSize,E^.GetLen)
end;

procedure DoWrite (E: PEnvVar); far;

var
  P: PChar;
  L: Word;

begin
  P := E^.GetName;
  L := StrLen (P);
  Move (P[0],EnvPtr^[W1],L);
  Inc (W1,L);
  EnvPtr^[W1] := '=';
  Inc (W1);
  if E^.GetValue <> NIL then
  begin
    P := E^.GetValue;
    L := StrLen (P);
    Move (P[0],EnvPtr^[W1],L);
    Inc (W1,L)
  end;
  EnvPtr^[W1] := #0;
  Inc (W1)
end;

begin
  if Error > 0 then Exit;
  TotalSize := 0;
  EnvColl^.ForEach (@CalcSize);
  Inc (TotalSize,3);
  if ProgName <> NIL then Inc (TotalSize,Length (ProgName^) + 1);
  if TotalSize < MaxSize then
  begin
    W1 := 0;
    EnvColl^.ForEach (@DoWrite);
    EnvPtr^[W1] := #0;
    Inc (W1);
    W := 0;
    if Swap (DosVersion) >= $0300 then if ProgName = NIL then
      Move (W,EnvPtr^[W1],SizeOf (Word))
    else begin
      W := 1;
      Move (W,EnvPtr^[W1],SizeOf (Word));
      Inc (W1,SizeOf (Word));
      Move (ProgName^[1],EnvPtr^[W1],Length (ProgName^));
      Inc (W1,Length (ProgName^));
      EnvPtr^[W1] := #0
    end
  end
  else Error := 2
end;

function FindActiveEnv: Word;

var
  Psp  : PPsp;
  Mc,Me: PMcb;
  E    : Word;

begin
  FindActiveEnv := 0;
  Psp := Ptr (PrefixSeg,0);
  while Psp^.ParentPspSeg <> Seg (Psp^) do Psp := Ptr (Psp^.ParentPspSeg,0);
  Mc := Ptr (Seg (Psp^) - 1,0);
  if (Psp^.EnvSeg <> 0) and (Swap (DosVersion) <> $0314) then
    E := Psp^.EnvSeg
  else E := Seg (Psp^) + Mc^.Size + 1;
  Me := Ptr (E - 1,0);
  if Mc^.Owner <> Me^.Owner then Exit;
  FindActiveEnv := E
end;

end.
