//			   GFX, graphical extension for Turbo Vision.
//					   Written By: Simor Balazs
//								V 2.10
//
//	  This software can be freely distributed provided, that the author
//	 message remains intact, and it is not used for professional purposes.
// If you make modifications to the software and you want to redistribute it,
//	   please let the user know, that it is not the original version.
//   	  You may NOT redistribute the source code of the software, it is
//	            			not shareware

#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TKeys
#define Uses_TScreen
#define Uses_TMouse
#define Uses_MsgBox
#define Uses_TWindow
#define Uses_TDialog
#define Uses_TButton
#define Uses_TInputLine
#define Uses_fpstream
#define Uses_TStaticText
#include <tvision\tv.h>

#include <graphics.h>
#include "gfx.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

#include <time.h>

#include <alloc.h>

#if defined(__DPMI32__) || defined(__DPMI16__)
#define CatchExceptions
#endif

#ifdef CatchExceptions
#include "tvexcdlg.h"
#endif

//undefine this symbol, if you want to see the speed difference between the
//cached and non-cached graphics view at "File/Pop Up Graphics" menu.
#define Graphics_caching

const GRFX = 120;
const toGR = 121;
const toTX = 122;
const About= 123;
const MVMNT = 124;
const BarCh = 125;
const TxtTst = 126;
const PieCh = 127;
const toDOS = 128;

ushort startMode = smDefault;


class IdleObject
{
public:
	virtual void idle_function(void) {}

	IdleObject *n; //pointer to next IdleObject
};

class Movie : public GView, public IdleObject
{
	int states;
	long sz;
	char *pict;
	int state;
public:
	Movie(const TRect& bounds);
	~Movie(void);
	virtual void idle_function(void);
	virtual void paint(void);
};

class MyMoving : public GView, public IdleObject
{
public:
	MyMoving(const TRect& bounds);
	~MyMoving(void);
	virtual void idle_function(void);
	void paint(void);

private:
	int state;
	int max;
	TPoint cntr;
};

class MyDrawing : public GView
{
#ifdef Graphics_caching
	Boolean stored;
	void *img;
	GRect ex; //extent, for  which the img is stored
#endif
public:
	MyDrawing (const TRect& bounds) : GView(bounds) {
#ifdef Graphics_caching
	stored = False;
	img = 0;
#endif
	}
#ifdef Graphics_caching
	~MyDrawing () { if (img) farfree(img); }
#endif
	virtual void paint(void);
};

class BarChart : public GView
{
public:
	BarChart (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class TextTst : public GView
{
public:
	TextTst (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class PieChart : public GView
{
public:
	PieChart (const TRect& bounds) : GView(bounds) {}
	virtual void paint(void);
};

class TMyApp : public GApplication
	{
	public:
		TMyApp(ushort mode, char *bgiPath);

		virtual void handleEvent(TEvent &event);
        static TStatusLine *initStatusLine( TRect r );
		static TMenuBar *initMenuBar( TRect r );
		virtual void idle(void);
		int registeridle(IdleObject *obj);
		void unregisteridle(IdleObject *obj);

	private:
	IdleObject *idleobj;

	clock_t idle_timer;
	};


TMyApp *app;



Movie::Movie(const TRect& bounds) : GView(bounds)
{
	sz = 3963;
	states = 4;
	pict = (char *)farmalloc(sz*states);
	state=0;

fpstream in;	//reading the file containing the silly head.
	in.open("images",ios::binary|ios::in|ios::nocreate);
	if (in.fail())
		{
		free(pict);
		pict = 0;
		return;
		}
	in.readBytes(pict, size_t(sz*states));
	in.close();

unsigned w,h;
	if (ScreenModeIsGraphic())  //only in graphics modes
		{
		imagedimensions(pict, &w, &h);
		growTo(w/_xCharSize, h/_yCharSize+1); //growing to the necessary size
		}
}

Movie::~Movie(void)
{
	app->unregisteridle(this);
	if (pict) free(pict);
}

void Movie::paint(void)
{
	TView::draw(); //original background
	if (!pict) return;
	putimage(0,0,pict+sz*state,COPY_PUT);
}

void Movie::idle_function(void)
{
	if (!pict) return;
	if (1 != beginPaint()) return;
	state = (state+1)%states;
	putimage(0,0,pict+sz*state,COPY_PUT);
	endPaint();
}


MyMoving::~MyMoving(void)
{
	app->unregisteridle(this);
}

MyMoving::MyMoving(const TRect& bounds) : GView(bounds)
{
GRect ext;

	ext = getGExtent();

	cntr.x = ext.b.x/2;
	cntr.y = ext.b.y/2;

	max = (cntr.x > cntr.y ? cntr.x : cntr.y);
	state = 0;
}

void MyMoving::paint(void)
{
	clearviewport();
}

void MyMoving::idle_function(void)
{
	if (1 != beginPaint()) return;
	setcolor(BLACK);
	circle (cntr.x , cntr.y , state);

	GRect ext = getGExtent(); //New part ensures that the circles will be in
	cntr.x = ext.b.x/2; //the center even after bound changes
	cntr.y = ext.b.y/2;
	max = (cntr.x > cntr.y ? cntr.x : cntr.y);

	state = max < state+4 ? 0 : state + 4;

	setcolor(YELLOW);
	circle (cntr.x , cntr.y , state);
	endPaint();
}

void MyDrawing::paint(void)
{
	GRect ext = getGExtent();
#ifdef Graphics_caching
	if (stored && ext == ex)
		{
		putimage (0, 0, img, COPY_PUT);
		return;
		} //if
#endif
	TPoint cntr;   //Centerpoint
	cntr.x = ext.b.x/2;
	cntr.y = ext.b.y/2;
	int max = (cntr.x > cntr.y ? cntr.x : cntr.y);

	clearviewport();
	//TView::draw();

	for (int i = max; i>0; i-=4)
		{
		setcolor ( (i/4)%16);
		setfillstyle (SOLID_FILL, (i/4)%16);
		fillellipse (cntr.x , cntr.y , i,i);
		} //for

#ifdef Graphics_caching
	if (!isClear()) return;

	if (stored)
		farfree(img);

	ex = ext;

	GRect a = getGAbsBounds();

    unsigned long imgSz = imagesize(a.a.x, a.a.y, a.b.x, a.b.y);
	img = farmalloc(imgSz);

	//::setviewport(0,0,getmaxx(),getmaxy(),1);
	getimage(a.a.x, a.a.y, a.b.x, a.b.y, img);

	stored = True;
#endif
}

void BarChart::paint(void)
{
	clearviewport();
	GRect ext = getGExtent();

	setcolor(WHITE);
	for (int i=0; i<4; i++)
		{
		setfillstyle(SOLID_FILL, i+9);
		bar3d(i*ext.b.x/4+5, 10+i*5, (i+1)*ext.b.x/4-5, ext.b.y, 10, 1);
		} //for
}

void TextTst::paint()
{
	GRect ext = getGExtent();
	clearviewport();
	setcolor(WHITE);
	settextstyle (GOTHIC_FONT, HORIZ_DIR,6);
	settextjustify(CENTER_TEXT, CENTER_TEXT);
	outtextxy(ext.b.x/2, ext.b.y/2, "A Test");
}

void PieChart::paint()
{
int data[5]={13, 32, 100, 54, 90};
int xas, yas;

	GRect ext = getGExtent();
	getaspectratio(&xas, &yas);
	int r = (int) (((long)ext.b.y*yas>(long)ext.b.x*xas ?
			(long)ext.b.x*xas/yas : (long)ext.b.y*yas/xas) *7/8/2);
	clearviewport();
	setcolor(WHITE);
	int s = 0;
	for (int i=0; i<5; i++)
		{
		setfillstyle(SOLID_FILL, 9+i);
		pieslice(ext.b.x/2, ext.b.y/2, s, s+data[i], r);
		s += data[i];
		} //for

	setfillstyle(SOLID_FILL, 9+i);
	pieslice(ext.b.x/2+10, ext.b.y/2 + 5, s, 359, r);
}

void TMyApp::idle(void)
{
	TProgram::idle();

	if (idle_timer == clock())
		{
		return;
		} //if
	idle_timer = clock();

IdleObject *p=idleobj;

	while (p)
		{
		p->idle_function();
		p = p->n;
		} //while
}


int TMyApp::registeridle( IdleObject *obj )
{
const Number_of_idle_objects = 5;
IdleObject *p0 = 0;
IdleObject *p = idleobj;
int i = 1;

	while (p && i<Number_of_idle_objects)
		{
		p0 = p;
		p = p->n;
		i++;
		}//while
	if (p) return 0; // too many idle objects
	if (p0)
		p0->n=obj;// adding to queue
	else
		idleobj = obj;
	obj->n = 0; //closing queue
	return 1;
}

void TMyApp::unregisteridle(IdleObject *obj)
{
IdleObject *p = idleobj;
IdleObject *p0;

	if (idleobj == obj)
		{
		idleobj = idleobj->n; //unlinking the first
		return;
		} //if

	while(p)
		{
		p0 = p;
		p = p->n;
		if(p == obj)
			{
			p0->n = p->n; //unlinking p
			return;
			} //if
		} //while
}

void TMyApp::handleEvent (TEvent &event)
{
    TDialog *w;

	if (event.what == evCommand)
    {
		switch (event.message.command)
		{
		case GRFX:
            {
			w = new TDialog(TRect(0,0, 70, 27), "Graphics");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (58, 24, 68, 26), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 24, 36,25),32) );
//			w->insert (new MyDrawing(TRect(2, 2, 24, 6) ));
			w->insert (new MyDrawing(TRect(2, 2, 68, 22) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case BarCh:
            {
			w = new TDialog(TRect(0,0, 50, 11), "Bar Chart");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (38, 8, 48, 10), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 8, 36,9),32) );
			w->insert (new BarChart(TRect(2, 2, 24, 6) ));
			w->insert (new BarChart(TRect(26, 2, 48, 6) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case TxtTst:
            {
			w = new TDialog(TRect(0,0, 50, 11), "Text Test");
			w->options &= ~ofBuffered;
			w->insert (new TButton( TRect (38, 8, 48, 10), "~O~K", cmOK, bfDefault));
			w->insert (new TInputLine(TRect (2, 8, 36,9),32) );
			w->insert (new TextTst(TRect(2, 2, 24, 6) ));
			w->insert (new TextTst(TRect(26, 2, 48, 6) ));
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case PieCh:
            {
			w = new TDialog(TRect(0,0, 35, 11), "Pie Chart");
			w->options &= ~ofBuffered;
			w->flags |= wfGrow;
			TView *pch = new PieChart( TRect (1, 1, 34, 10));
			pch->growMode = gfGrowHiX | gfGrowHiY; //moves with its owner.
			w->insert (pch);
			deskTop->insert(w);
			clearEvent(event);
            }
		break;

		case MVMNT:
            {
			TDialog *m = new TDialog(TRect(0,0, 50, 11), "Moving Graphics");
			m->options &= ~ofBuffered;
			m->flags |= wfGrow;
			MyMoving *p = new MyMoving(TRect(1, 1, 49, 10) );
			p->growMode = gfGrowHiX | gfGrowHiY;
			m->insert (p);
			if (registeridle(p))
				deskTop->insert(m);
			else
				{
				messageBox("\x03 Sorry, cannot insert more Moving Graphics.",
					mfError | mfOKButton);
				destroy (m);
				}
			clearEvent(event);
            }
		break;

		case toTX:
			disableCommand(toTX);
			enableCommand(toGR);

			setScreenMode(smCO80);
		break;

		case toGR:
			disableCommand(toGR);
			enableCommand(toTX);

			setScreenMode(smDefault);
			if ( ScreenModeIsText() ) {
				disableCommand(toTX);
				enableCommand(toGR);
			}
		break;

		case toDOS:
            suspend();
#ifdef CatchExceptions
            DPMIExceptionHandler::releaseExceptions();
#endif
            system("cls");
            cout << "Type EXIT to return...";
            system( getenv( "COMSPEC"));
#ifdef CatchExceptions
            DPMIExceptionHandler::trapExceptions();
#endif
            resume();
            redraw();
		break;

		case About:
            {
            char mem_amount[30];
            int ma_len;
            sprintf(mem_amount, "coreleft() = %ld", coreleft());
            ma_len = strlen(mem_amount);
			w = new TDialog(TRect(20, 5, 66, 17), "About");
			w->insert (new TButton( TRect (7, 9, 17, 11), "~O~K", cmOK, bfDefault));
			w->insert (new TStaticText(TRect(20, 9, 20 + 1 + ma_len, 11), mem_amount));
			w->insert (new TStaticText(TRect(2,2,32,8),
					"\x03TV in Graphics mode\n"
					"\x03Written By Simor Balazs\n"
					"\x03Ported to TV 2.0\n"
#if defined(__DPMI32__)
					"\x03(32-bit p-mode)\n"
#elif defined(__DPMI16__)
					"\x03(16-bit p-mode)\n"
#else

#if defined(__OVERLAY__)
					"\x03(real overlayed mode)\n"
#else
					"\x03(real mode)\n"
#endif

#endif
					"\x03 By Michael Fainstein\n"
					"\x03Source is (C) 1993, 1994, 1995") );
			Movie *mv= new Movie(TRect(33,1,34,2));
			if (!registeridle(mv))
				destroy(mv);
			else
				w->insert(mv);

			executeDialog(w, NULL);
            }
		break;
		} // switch
	} // if

	TApplication::handleEvent(event);
}//handleEvent

TMyApp::TMyApp(ushort mode, char *bgiPath) :
		TProgInit( &TMyApp::initStatusLine, &TMyApp::initMenuBar,
				&TMyApp::initDeskTop )
		, GApplication(mode, bgiPath)
	{
	idleobj = 0;
	idle_timer = clock();
	}

TStatusLine *TMyApp::initStatusLine(TRect r)
{
    r.a.y = r.b.y - 1;     // move top to 1 line above bottom
    return new TStatusLine( r,
        *new TStatusDef( 0, 0xFFFF ) +
            *new TStatusItem( 0, kbF10, cmMenu ) +
            *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
            *new TStatusItem( "~Alt-F3~ Close", kbAltF3, cmClose ) +
            *new TStatusItem( 0, kbF5, cmZoom ) +
            *new TStatusItem( "~F6~ NextWnd", kbF6, cmNext ) +
            *new TStatusItem( 0, kbCtrlF5, cmResize )
        );
}

TMenuBar *TMyApp::initMenuBar( TRect r )
	{
	r.b.y = r.a.y+1;

	return new TMenuBar( r,
		*new TSubMenu( "~F~ile", kbNoKey )+
			*new TMenuItem( "Pop up graphics", GRFX, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up movement", MVMNT, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up bar chart", BarCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up pie chart", PieCh, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "Pop up text test", TxtTst, kbNoKey, hcNoContext,0) +
			newLine() +
			*new TMenuItem( "~G~raphics mode", toGR, kbNoKey, hcNoContext,0) +
			*new TMenuItem( "~T~ext mode", toTX, kbNoKey, hcNoContext,0) +
			newLine() +
            *new TMenuItem( "Shell to ~D~OS", toDOS, kbNoKey ) +
			newLine() +
			*new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, 0 ) +
		*new TSubMenu( "~H~elp", kbNoKey )+
			*new TMenuItem( "~A~bout", About, kbNoKey)
		);
	}


int main(int argc, char* argv[])
{
    char *bgi_path = 0;

#ifdef CatchExceptions
    TVExceptionCatcher ex;
#endif

    if ( argc > 1 && toupper(argv[1][0]) == 'T' ) {
        startMode = smCO80;
    }
    if ( argc > 2 ) {
        bgi_path = argv[2];
    }

	app = new TMyApp(startMode, bgi_path);

    if ( ScreenModeIsText() ) {
    	app->disableCommand(toTX);
    }
    else {
    	app->disableCommand(toGR);
    }

	app->run();
	delete app;

	return 0;
}
