













                       INSTALLATION MANUAL
  
                        CITADEL-86  V3.03

                           by Hue, Jr.

                     C-86 Test System Sysop

                        (612) 866-1804

                            88Mar01













































                         Table of Contents

     I. Introduction & Requirements                                  2
        I.1 ... but first, a caveat.                                 2
        I.2 Introduction                                             2
        I.2 Requirements                                             3

     II. INSTALLATION                                                4
         II.1 Tickling DOS configurations                            4
         II.2 Making your modem do the right thing                   4
         II.3 Citadel-86 Operating Procedures
                         (and other epic fantasies)                  5
              II.3.a Who's this masked Temporary file, anyways?      6
         II.3 (con't)                                                6
         II.4 Other Data Files                                       7
         II.5 The ole' configuration file                            8
              II.5.a But first, a word on moral values ...           8
              II.5.b Section 1 of CTDLCNFG.SYS                       9
                Part 1 of Section 1: MEANINGLESS MISCELLANEA        10
                Part 2 of Section 1: REQUIRED ODD STUFF             11
                Part 3 of Section 1: DATA FILE SIZES                12
                Part 4 of Section 1: DATA FILE LOCATIONS            14
                Part 5 of Section 1: POLICY OPTIONS                 15
                Part 6 of Section 1: MODEM HANDLING                 16
              II.5.c Section 2 of CTDLCNFG.SYS                      18
              II.5.d Section 3 of CTDLCNFG.SYS                      24
         II.6 The Big Step -- Your first experience with CONFG      27
         II.7 CTDL -- That Childhood Experience                     28
         II.8 When the inevitable happens                           29
         II.9 Installation -- Advanced Topics                       29
              II.9.a Command Line options                           30
              II.9.b BAT files and program termination ERRORLEVELS  31
              II.9.c Making BAT files and command line options
                                                     work for you   31
              II.9.d Extreme options in CTDLCNFG.SYS                33

     Appendix -- Exhibit copy of CTDLCNFG.SYS.                      36






















                                    -1-






     I. Introduction & Requirements
        Hi.  This is the Citadel-86 Installation Manual.  This manual comes in
     two parts.  In the first part we hope to present a very short intro-
     duction to Citadel-86 and give you an idea of the requirements of running
     Citadel-86.
 
        The second part of the Manual will contain a comprehensive (we hope!)
     discussion of general operation of Citadel-86 and a step-by-step
     installation guide.
 
        If you are looking for documentation covering the day to day operations
     of Citadel-86, please read MANUAL3.DOC.  Just ignore the blood spots
     in there -- we sweated blood to write that.
 
     I.1 ... but first, a caveat.
        Citadel-86 has a number of eccentricities in it; in fact, some people
     might describe it as one giant eccentricity, and an explanation is,
     perhaps, in order.  One of the authors of this manual, Hue, Jr., is also
     the principal porter and caretaker of Citadel-86.  Citadel-86 derives
     directly from the version 2.10 of Citadel written by Cynbe ru Taren for
     CP/M, and contains a number of the apparent oddities that originally
     appeared in Cynbe's code.  Hue, Jr., feeling that there may have been
     certain reasons in Cynbe's mind for what he did, has been somewhat loathe
     to change how certain things worked.  This may indicate a certain lack of
     ambition on his part; if so, so be it.  Whatever the case, he has chosen
     to leave them in, due to his faith that Cynbe knew what he was doing.
 
     I.2 Introduction
        Citadel-86 is part of a growing family of BBSes that are termed
     "room-based" systems.  These systems are characterized as excellent
     messaging systems in which the message base is partitioned into various
     'areas' that enhance the focus of the topics on that particular system
     (if well-managed); the areas are usually termed 'rooms' in order to
     provide a highly familiar metaphor for the common user.
 
        Some room-based systems have an additional structure added on to them,
     known sometimes as 'hallways' or 'floors', which give addition focus.
     Citadel-86 has a 'floor' capability, which is optionally available to the
     users.  Floors allow the sysop and aides to partition the collection of
     rooms into 'subject floors' (or 'topical floors'), so that rooms may be
     grouped as needed.
 
        Room-based systems normally feature an extremely streamlined set of
     commands, in which those used the most often are mnemonic 'single-stroke'
     commands whereby the user supplies the first letter of the command to
     execute and the system provides the rest of the command.  The speed
     and ease-of-use of such a command set, in conjunction with the room
     concept, has combined to make room based systems extremely popular and
     heavily used in several sections of the United States.
 
        Citadel-86 also has file upload and download abilities, integrated
     with the room metaphor, and a network capability.
 






                                    -2-






     I.3 Requirements
        There are a number of requirements connected with running a Citadel-86
     system. The most important one, though, is perhaps the most ignored, and 
     that is experience with Citadel-86 or similar BBS software from a user
     standpoint.  It can't be stressed enough that you should have at least a
     month of day-to-day experience with Citadel-86 as a normal user, learning
     the various commands relating to messages and files, and in general
     becoming not only familiar, but comfortable with the Citadel-86 style of
     bbsing before aspiring to sysopdom.

        More formally, Citadel-86 is capable of running on two classes of
     machines using the same executable code.  The first is the Zenith Z-100,
     an 8085/8088 machine.  The second category contains the IBM PCs, ATs, and
     close clones (note that a Z-100 does NOT constitute a close clone,
     although it is supported).  These two classes are similar enough that we
     do not need to discuss the requirements for each class separately.
 
      o Operating System: PC- or MS- DOS 2.x or 3.x is required.  While not
        every single version of DOS that falls in the 2.x to 3.x range has been
        tested with Citadel-86, we have not had any reports of problems with
        those versions of DOS.  Version 1.x of MSDOS is a NO NO!
 
      o RAM: We suggest that at least 256K RAM be made available to Citadel-86.
        This is in addition to RAM for MS-DOS, TSR programs, etc.
 
      o Disk storage: A hard disk is, naturally, highly desirable.  However,
        you can run Citadel-86 on a two floppy system, but if you must do so,
        you should also try to make sure that you can have a relatively large
        RAM disk available; due to Citadel-86's structure, disk access is
        quite frequent.  While hard drives (and RAM drives!) do not mind
        frequent disk accesses, floppy drives have been known to burn out
        under constant usage unless certain options concerning RAM drives
        are taken advantage of within Citadel-86.
 
      o An auto-answer modem and the hardware (cables, etc.) requisite to hook
        it up to your computer:  While a Hayes or compatible is by far the most
        popular modem in usage, Citadel-86 can be configured to use several
        other types of modems.
 
      o A copy of the Citadel-86 software:  Typically, Citadel-86 comes in the
        form of three archives.  The first is called RUNTIME.ARC, and is
        absolutely necessary.  It contains the required executables to bring
        Citadel-86 up, various help files, and a configuration file.  The
        second is called SUPPORT.ARC, and contains what little documentation is
        available for Citadel-86.  It is not strictly necessary, but
        useful (or at least comforting).  The third is called UTILEXE.ARC, and
        contain the utilities available for Citadel-86.  (If you don't have
        these, they may possibly be on Test System in a room called
        Necessities].)
 
      o Some patience!








                                    -3-






     II. INSTALLATION
        In this section we explore the installation procedure for Citadel-86,
     investigating territory ranging from a general overview of the operating
     procedures of Citadel-86 to the details of setting up a system.
 
        We'll begin with a very short section on DOS and modem configuration. 
     Then we get to the red, raw meat of Citadel-86: a description of how to
     prepare and operate Citadel-86, and a discussion of the data files that
     Citadel-86 needs or generates.  Following that will be a walk-through of
     actually setting up a basic Citadel-86 installation, at the end of which
     you should have a working Citadel-86 system.
 
        Easy, right?
 
     II.1 Tickling DOS configurations
        First comes the only required DOS configuration that must be performed,
     and that is to place the line "FILES=20" in your CONFIG.SYS file on your
     boot disk.  If such a line already exists (or more than 20 is specified),
     then you don't need to worry about anything.  If such a line doesn't
     exist, then please put it into CONFIG.SYS, save the file, and reboot your
     system so that it'll take effect.  IF YOU DON'T, CITADEL WILL BE VERY
     PEEVISH!
 
        If you don't understand what we're gabbing about, then please consult
     your DOS manuals.  CONFIG.SYS is an important part of the DOS system; it
     will do you good to learn what it's about.
 
        We AREN'T going to discuss DOS batch files in here.  We'll leave that
     for a later advanced section, because Citadel-86 exits with different
     ERRORLEVELs; the exact levels vary with the reason that Citadel-86 exited.
     We feel that it would be better not to cause excess confusion now, because
     you'll be confused soon enough as it is.
 
        We AREN'T going to discuss Citadel-86 command line parameters here,
     either.  While such things exist, we deem these to be the subject of an
     advanced section, and so we leave them for later attention in this manual.
 
     II.2  Making your modem do the right thing
        The Citadel-86 basic requirements in the area of modems are:
      o Modem can be hooked up to the computer
      o Modem can auto-answer the phone
      o Modem supports true carrier detect (very preferably on pin 8)
      o Modem can be hung up
 
        That sounds pretty darn basic, and it is.  However, if you want to take
     advantage of some of the default configurations of Citadel-86 for the
     modem, here's what we suggest for your modem in terms of characteristics:
      o Hayes or (semi) compatible
     or
      o Carrier detect on pin 8 (normal for most modems)
      o Carrier hangs up modem when DTR is dropped








                                    -4-






        Like we said, Citadel-86 is not restricted to Hayes/compatible
     modems, although they are of course the most popular modem used.  But
     other modems, such as TransModems, have been used successfully with 
     Citadel-86. This makes our job, as the manual writers, substantially 
     more difficult. Due to the overwhelming popularity of the Hayes compatible
     modems, we're going to confine most of our advice on modem configuration
     to Hayes and compatibles.
 
        The first thing to bear in mind is that "compatible" is often a
     slippery term.  Our advice is based on our own experience with our Hayes 
     compatible modems; if what we say doesn't seem to jibe with your modem's
     documentation, then use a little imagination and search.
 
        Hayes modems are not normally correctly configured fresh from the
     factory, so you must configure yours.  Usually, a combination of two
     methods are used to achieve the correct configuration.  First, DIP
     switches on the modem usually control several different functions,
     including auto-answer mode.  However, on some Hayes compatibles they
     don't exist; the functions they usually serve are then either accessed
     via software, or not at all. Second, (as you might have guessed), software
     can be used to configure the modem, through the use of AT commands.
 
        We strongly suggest that you have your modem manual available at this
     point.
 
        First, you want to make sure that your modem will drop carrier when DTR
     is dropped; the opposite of this is sometimes called the "forced DTR"
     function, and can be found in the DIP switches.  Make sure that the modem
     does not have "forced DTR" on.
 
        Next, you need to ensure that the modem is not "forcing carrier
     detect". Instead, it should only have carrier detect true when there is
     actually a caller online; otherwise your Citadel-86 will not work
     correctly.
 
        Finally, you want to make sure that the modem will auto-answer when
     Citadel-86 is up.  This can be selected either by DIP switch or through
     software.  Even if you have a modem that has a DIP switch that controls
     this function, you may want to use software instead, for finer control of
     how your modem acts.  You'll find later in this manual that you can
     specify a string of commands to be sent to the modem when Citadel-86 first
     comes up, which you can use to activate auto-answer mode.
 
        The above comments apply equally well to non-Hayes compatible modems,
     although the details of how to initialize the modem will differ greatly.
 
        More detail on initialization of the modem will appear later in this
     manual in Section II.5.b: Part 6 of Section 1: MODEM HANDLING.

     II.3 Citadel-86 Operating Procedures (and other epic fantasies)
        Citadel-86 comes with a whole mess of files.  However, only three of
     these files are important, because they constitute the beginnings and
     necessities of Citadel-86.  They are:






                                    -5-








      o CTDLCNFG.SYS.  This file will contain your description of how you want
        your system set up.  Decisions concerning the location of important
        data files, system policies, and other semi-arcane things are described
        for Citadel-86's use.  The CTDLCNFG.SYS that should have accompanied
        your system is a template of a very generic system, and we plan to
        guide you through it later in this manual.
 
      o CONFG.EXE.  This executable program digests CTDLCNFG.SYS, converting
        the information contained therein into a form that is far easier to
        digest by computer programs.  It is also responsible for generating new
        data files when necessary (typically only when a new system is first
        built!) and analyzing old data files.  It produces a highly temporary
        yet necessary file called CTDLTABL.SYS.

      o CTDL.EXE.  This is the main executable program of Citadel-86.  It
        expects to find CTDLTABL.SYS (remember that name?).  If it finds it, it
        reads it, erases it, and then continues to try to bring up the rest of
        the system, using the information that it found in CTDLTABL.SYS.  If
        there are no severe abnormalities during CTDL.EXE's use, it will write
        a new version of CTDLTABL.SYS for use the next time you bring up
        CTDL.EXE.
 
     II.3.a Who's this masked Temporary file, anyways?
        CTDLTABL.SYS has been passed off so far as a temporary file, generated
     by CONFG.EXE from digesting CTDLCNFG.SYS, and required by CTDL.EXE.
     However, for a mere temporary file, it merits more discussion.  We said
     that CTDL.EXE expects to find it; you may have figured out that if it's
     not there, then CTDL.EXE won't function properly.  This is correct, and
     the proper corrective action is to run CONFG.EXE.  DON'T TRY TO USE AN OLD
     VERSION OF CTDLTABL.SYS THAT YOU MAY HAVE SAVED IN CASE OF A CRASH!  Yes,
     we know that running CONFG.EXE to generate a new CTDLTABL.SYS can take a
     while if you're running a big system.  We mentioned that CONFG.EXE
     analyzes old data files; as it happens, the results of this analysis is
     also placed in CTDLTABL.SYS, and used to enhance access to various parts
     of Citadel-86, such as the log.
 
        If you use an old version of CTDLTABL.SYS, the older information can
     cause Citadel-86 to look for messages that no longer exist, lose track of
     new rooms and log accounts, and other behaviors that a sysop generally
     finds disruptive to domestic tranquility.  So, really, "Just say no."  Run
     CONFG.EXE if you lose your current CTDLTABL.SYS through a crash or power
     loss.  (This can be automated.  See section II.9 for advice on
     batch files.)
 
 
     II.3 (con't)
         Back to the subject.  We now know the purposes of the three primary
     files of Citadel-86.  CTDLCNFG.SYS contains information that only the
     sysop can supply; CONFG.EXE processes CTDLCNFG.SYS and other data files,
     producing CTDLTABL.SYS; CTDL.EXE requires CTDLTABL.SYS, and constitutes
     the main executable of Citadel-86.
 





                                    -6-






         So, in short form, here's how you run Citadel-86:
      o Modify CTDLCNFG.SYS to taste.
      o Run CONFG.EXE.
      o Run CTDL.EXE as many times as desired, as long as each run is
        terminated normally.

        If you crash, either from a fatal bug or power loss or whatever, just
     run CONFG.EXE again.
 
     II.4 Other Data Files
        When you run CONFG.EXE for the first time, a number of data files are
     created, and they're what we're going to talk about in this section. 
     These files contain the information -- accounts, rooms, messages, and
     other things -- that make up any BBS.  The capacities of these files are
     selectable by the sysop, and once selected they remain the same size as
     CTDL.EXE runs (don't panic, though -- they can be changed through the use
     of Citadel-86 utilities!).  And with no more delay....
 
      o CTDLMSG.SYS.   This file contains all the messages in the system.
      o CTDLROOM.SYS.  This file contains information about the rooms in your
                       system.  The size of this file is given later in this
                       manual.
      o CTDLLOG.SYS.   This file contains all the accounts for users on your
                       system.  The size of this file is given later in this
                       manual.
      o CTDLNET.SYS.   This file, if it exists, will be 0 bytes long when
                       initially generated by CONFG.EXE.
      o CTDLFLR.SYS.   This file contains information about the floors in your
                       system.  This is the only file of this group is not
                       static; it grows as you add floors to your system.
                       Don't panic, though.  Each floor only takes 21 bytes.
 
        These, however, are not the only data files that are associated with
     Citadel-86.  CTDL.EXE may, on occasion, generate data files also.  These
     files, unlike those generated by CONFG.EXE, are not static; however, they
     are almost always very small.
 
      o CTDLARCH.SYS.  This file contains data about auto-archiving of rooms
                       (an advanced topic to be covered under day-to-day 
                       operations).
      o CTDLNET.SYS.   This file, created by CONFG.EXE, will be expanded by
                       CTDL.EXE if you are participating in a network.
      o CALLLOG.SYS.   This file, an optional text file, is updated as each
                       caller hangs up.
      o CTDLDIR.SYS.   This file contains data about the directory rooms on
                       your system, specifically the name of the DOS directory
                       associated with each directory room on your system.
 
        There are also the collection of help files that came with
     Citadel-86, which we talk about in Section X.
 








                                    -7-






     II.5 The ole' configuration file
        So... we're done with that dull, but necessary, overview.  Now we get
     down to that fun stuff, the screechy details of deciding those system
     policies that can be enforced through the Citadel-86 software, where
     certain data files or groups of data files will be kept on your system,
     and some other details.  We do this by editing the file CTDLCNFG.SYS
     mentioned earlier in this manual, so you may want to haul out your editor.
 
        Or you may not.  Instead, it might be better to first read through this
     section along with a printout of CTDLCNFG.SYS, (we've included a copy of 
     it in this file as well; see pages 35-42) comparing, taking notes,
     understanding what is required and what questions you will have to answer
     in order to set up your Citadel-86.
 
        We've decided to divide the CTDLCNFG.SYS file into four sections in
     this manual.  The first section covers the utter necessities that must be
     set correctly for Citadel-86 to come up, options that cannot be shut off,
     and some miscellaneous doodads that aren't strictly required for a basic
     system, but that we'd like you to set anyway.  This first section makes up
     the bulk of the CTDLCNFG.SYS parameters, and is the only one that you must
     fill out in order to bring up Citadel-86; the rest of the sections
     constitute options that are not necessary for a basic Citadel-86
     (although, of course, they ARE useful!).  If you're using a 'virgin' copy
     of CTDLCNFG.SYS, the options in the rest of the sections have been set to
     what we feel are harmless values.
 
         The second section is made up of options that are useful, but not
     necessary, for the operation of Citadel-86.
 
        The third section is made up of options related to Citadel-86's
     networker.
 
        The fourth section covers extremely optional parameters designed to
     make modem handling very flexible when necessary.  (Don't read this
     unless you have a captive, well-fed assembly-language programmer nearby.)
 
     II.5.a But first, a word on moral values ...
        There are two methods that values are set in CTDLCNFG.SYS.  One method
     is related to our reference to the fourth section, above, and will
     thus be covered in that advanced section.  The other method for setting
     parameter values, used with the rest of CTDLCNFG.SYS, looks like this:

     #<parameter name> <parameter value>
 
        The '#' MUST be in the left-most column of the file in order for
     CONFG.EXE to recognize it as a parameter. Indenting this line a space
     provides an easy way to disable or save an old value when experimenting
     and causes CONFG.EXE to ignore the line.

        A parameter value will usually either be a numerical value or a string
     value, and we'll tell you for each parameter whether your selection should
     be numerical or a string.  When it is numerical, always use decimal (with
     the exception of the fourth section).






                                    -8-






        String values are always enclosed in quotes.  Most string values are
     used to indicate where to find certain files, but some string values are
     special in that certain hard-to-express codes may need to be used in order
     to accomplish something; this occurs almost exclusively when communicating
     with odd modems (such as TransModems).  Therefore, certain parameter
     string values in CTDLCNFG.SYS will allow formatting "directives" to be
     placed within them, which will be interpreted during the execution of
     CTDL.EXE to do special things.  The general format of a directive is a
     backslash ('\') followed by a either a character that indicates a specific
     action, or a sequence of three digits that represent an OCTAL value that
     you need to be in this particular position to accomplish what you wish to
     accomplish. Here is the list of characters that perform special actions
     when following a backslash:
 
            n: CR-LF
            t: Tab character
            b: Non-destructive Backspace
            r: CR
            f: Formfeed
            ": Put out a quote (allows quotes to appear in your strings)
            \: Backslash
 
     So, if you wanted to insert a CR/LF into a string value, you would type
 
             "...\n..."
 
     If you needed to have the binary value of 6 in a string value, you would 
     type
 
             "....\006...."
 
        Not all parameter string values accept these formatting directives;
     those that don't will simply ignore them.  We have marked those parameters
     that do accept them both in this manual and in CTDLCNFG.SYS.  (OCTAL
     values, you say! Well.... the gentleman who donated the code to do the
     formatting directives, a certain Dalnefre' of SynTel, is a C hacker, and
     did it that way.  We feel that it might be worth changing sometime in
     the future, too.)
 
        One more note.  Certain of the string values in CTDLCNFG.SYS end up
     being printed to the users via Citadel-86's formatter.  In these cases,
     when you use the CR/LF formatting directive ("\n"), remember to have a
     space follow it -- otherwise, Citadel-86's formatter probably won't send
     a CR/LF to the caller's terminal!

     II.5.b Section 1 of CTDLCNFG.SYS
        We're finally looking at CTDLCNFG.SYS.  The file starts (or at least
     our virgin copy does) with a short introduction to itself, which basically
     tells you to consult this manual if you find it too terse.  A short list
     of supported formatting directives is also included.









                                    -9-
 





     Part 1 of Section 1: MEANINGLESS MISCELLANEA

        We're going to start Section 1 with some miscellaneous parameters.

     ------
     #nodeTitle
        The first parameter you should find is called nodeTitle. It is a string
     value that obeys formatting directives, and is subject to formatting
     considerations.  nodeTitle is the title of your installation that is
     printed when carrier is detected on your system.  More precisely,
     nodeTitle will show up in the following place on your system:
 
      Welcome to <#nodeTitle>
       Running ...
 
     However, nodeTitle may not necessarily be printed at this point,
     because if a file named BANNER.BLB exists on your system in the right
     place, it will be printed in place of the "Welcome to <nodeTitle>" part.
     For more details, refer to Part 3 of this manual, on day to day operations
     (when it comes into existence).  EXAMPLE:
 
     #nodeTitle "Test System\n Truly a Heaven in Reverse"
 
     The #nodeTitle is printed out on .Read Status commands, also.  There is no
     formal limit on the length of this parameter, but you should definitely
     use BANNER.BLB for long #nodeTitles, or to vary it easily.

     ------
     #nodeName
        nodeName is, in reality, purely a network parameter, and if you have no
     plans to ever join a C86net, then there is no need to fill in this
     parameter.  However, it has always been traditional, even before there was
     a net for any Citadel system anywhere, to fill in this and the next
     parameter (and, so, sentimentally we feel this belongs in this
     Miscellaneous section).   nodeName is a string value which does NOT accept
     formatting directives (i.e., formatting directives will be ignored).  It 
     can be no longer than 19 letters long.  It should be a short, mnemonic
     name for your system.  An EXAMPLE of a reasonable value:
 
     #nodeName "ODD-DATA"            -- The original Citadel
 
     If you ever do join a C86net, messages from your system appearing on
     another Citadel-86 node of that net will look something like this
 
        82Nov23 from Cynbe ru Taren @ODD-DATA
 
     except that ODD-DATA would be replaced with your value for #nodeName.
 











                                    -10-






     ------
     #nodeId
        As mentioned, this parameter is a network parameter that has
     traditionally always been set, even for non-network Citadels.  If you have
     no plans to ever be on a C86net, then you don't have to set this string
     value parameter to anything important.  If you do plan to join one,
     though, (we'll go over this in more detail in the section on the network),
     then you do have to set this parameter correctly.  The format of this
     parameter is
 
          "<Country code><Area Code><Phone number>"
 
     all of which applies to the phone that your system resides on.  Country
     code is a two letter sequence indicating what country you live in (US is
     the United States, CA is Canada.  Other country codes may be found in
     COUNTRY.DOC. see page xx). Area code is the area code of your system (yes,
     we are aware that there is a clear bias towards US-style telephony).  And
     Phone number is, of course, the phone number that your system is on.  You
     can put punctuation (such as parenthesis and dashes), but please be
     conservative with them.  This string value does not obey formatting
     directives.  Here's a fairly generic example:
 
     #nodeId "US (612) 866 1804"          -- Some system somewhere
 
     Part 2 of Section 1: REQUIRED ODD STUFF

     ------
     #baseRoom
        OK, now we're out of the miscellanea and into parameters that you have
     to set, starting with baseRoom.  Citadel-86 always has a minimum of three
     rooms, the Aide> room for housekeeping, the Mail> room for private
     correspondence, and the <baseRoom>, which is the room that a caller is
     always initially placed in.  (Historical note: the old CP/M Citadel called
     this room the Lobby>; we've only made the name of the Lobby> selectable by
     the sysop.)  This parameter is a string value that obeys formatting
     directives and goes through the Citadel-86 formatter, and you must limit
     yourself to 19 characters or less for this value. And one more note --
     Citadel-86 will append the '>' to this name when it prints the room prompt
     for this room, you don't have to put it in yourself. If you wished to
     emulate the old CP/M Citadel, you'd set baseRoom thus:
 
     #baseRoom "Lobby"
 
     There is no default for this parameter.

     ------
     #MainFloor
        MainFloor is analogous to #baseRoom.  Any Citadel-86 V3 has a base
     floor, just as it has an Aide> room, etc.  This parameter allows you to
     name this base floor.  This parameter is a string value which cannot be
     longer than 19 characters, and specifies the name of your base floor.  So,
     if you want to name your base floor MAIN FLOOR, you'd have

     #MainFloor "MAIN FLOOR"

     There is no default value for this parameter.



                                    -11-






     ------
     #CRYPTSEED
        Citadel-86 automatically encrypts all sensitive data files.  While the
     algorithm used can, of course, be broken by the determined, particularly
     since the code is available for perusal, the encryption does provide
     protection against casual eyes, mistakes, and amateur system breakers.  We
     do encourage you to take precautions of your own, such as not opening
     directory rooms that look at sensitive data.

        CRYPTSEED is an encryption seed that Citadel-86 uses to encrypt your
     data; if someone should acquire of all of your data files but for
     CTDLCNFG.SYS, then they still won't have access to your system until they
     figure out what your CRYPTSEED is.  DON'T EVER CHANGE THIS VALUE WHILE
     RUNNING A CITADEL-86, OR EVERYTHING WILL BECOME MESSED UP!
 
        We do not know of any value that you can select that will "deactivate"
     the encryption process (to be frank, we don't understand the encryption
     algorithm ourselves).  Pick a value at random; the value should be a
     value less than 65536.  Here's an example:
 
     #CRYPTSEED    69            -- a little hubris for the shy

     Part 3 of Section 1: DATA FILE SIZES

     ------
     #MESSAGEK
        MESSAGEK defines how much disk space you wish to allocate for messages
     on your installation.  There is no way to define how many messages you
     want in your system, or how fast they turnover.  All the messages in your
     system will reside in CTDLMSG.SYS, and thus the number of messages in your
     system at any given moment will depend on the length of the messages being
     entered into the system by your users.  The turnover rate of your messages
     will depend on how busy your system is.  As an example, Test System has a
     611K message base, which holds 2100 messages +/- 300, of which some are of
     fairly good length.  Turnover seems to between 3 weeks and a month, since
     80-160 messages are entered a day.  However, Test System is also a busy
     system.

        The sysop of an installation should also keep in mind that very large
     systems, with many new messages, can be intimidating to new users, so
     large message spaces should be approached with caution.  Remember, there
     is a utility for expanding the message base, but not for shrinking it.
 
        This is a numerical value which you specify in 'K', which is actually
     1024 bytes/K.  So, for example, to specify a 250K message file
 
     #MESSAGEK 250               -- 250K message base
 
     ------
     #MSG-SLOTS
        This numerical parameter specifies how many messages per room will
     be used on this system (the lone exception is the Mail>, which is covered
     by the following parameter).  If you wanted to use Citadel-86's
     traditional number of messages per room, you'd have

     #MSG-SLOTS 58



                                    -12-






     ------
     #MAIL-SLOTS
        This is a numerical parameter specifying how many messages per log
     record that you wish to reserve for Mail.  The Mail> room is the only
     room in the system whose data is not kept in CTDLROOM.SYS.  Instead, the
     file CTDLLOG.SYS contains the "Mail>" room, reserving for each account
     enough room for MAIL-SLOTS Mail messages.  Therefore, this parameter gives
     you the ability to decide the maximum number of Mail> messages per user 
     that they can access.  Please remember that if a user gets more messages
     in Mail> than there are MAIL-SLOTS between two successive logins, then
     they will lose the earlier messages sent to them.  Another consideration
     is that many users like to review old Mail when engaged in an in-depth
     private conversation.  Therefore, setting MAIL-SLOTS to a low value may
     not be the attractive alternative that it first seems.  However, it should
     go without saying a high MAIL-SLOTS value may eat up more room than
     necessary on your drives.  The section on LOGSIZE will give an exact
     formula for how much space your log will take up.  If you wanted to use
     what Citadel-86 used before V3, you'd have

     #MAIL-SLOTS 58

     ------
     #MAXROOMS
        This numerical parameter specifies the maximum number of rooms your
     system will support.  Since the baseRoom, Aide>, and Mail> room are
     necessary, the smallest value you can give is 3.  The largest number is
     65536 (probably).  If you wanted to have a 64 room system, you'd have

     #MAXROOMS 64

        You can use the following formula to estimate the number of bytes a 
     room file will take up on your system:

          # of bytes = MAXROOMS * (50 + (6 * MSG-SLOTS))

     ------
     #LOGSIZE
        This numerical parameter gives you, the sysop, the ability to decide
     how many accounts will be available on your system.  If you run a system
     in which more accounts are used than there are accounts reserved, then new
     accounts are generated by killing old accounts.  The account that will be
     replaced with the new account is that account which has not been used in 
     the longest time (in other words, accounts that are not used will be the
     first to be killed).
 
        All space is reserved immediately for these accounts.  The size of
     this file can be estimated from the formula
     
          # of bytes = LOGSIZE * (82 + MAXROOMS + (6 * MAIL-SLOTS))

     so if you are operating in a restricted environment, plan accordingly.
 
        If you need to, you can expand the size of the log through the use of
     the DATACHNG utility, but the log cannot be shrunk.  This is a numerical
     value.  Here is an example:
 
     #LOGSIZE 180                -- Usually adequate.
 

                                    -13-






     Part 4 of Section 1: DATA FILE LOCATIONS

        Now we discuss where you want the data files to be located on your
     system.  These parameters are all specified in the same way, as a string
     value (which does not obey formatting directives, naturally) that tells
     Citadel where on your system the given data file or files associated with
     the given parameter is located.

        Simply use the MSDOS relative directory specification.  You can
     ONLY specify a directory that is a subdirectory of the current directory
     on the disk that you specify (if you don't specify a disk, then the
     current disk will be assumed).  So, some sample valid specifications would
     be "c:", "a:system", "b:msgs", and "i:bark".  Some sample INVALID
     specifications include "c:\citadel\msgs" (that is an absolute
     specification, rather than relative), "a:\audit" (ditto), and "i:.."
     (".." is technically not a subdirectory, but a parent directory).
 
        If CONFG.EXE cannot find the directory that you specify, it will
     attempt to create that directory, after asking permission.

     ------
     HELPAREA
        This parameter specifies where all of your Help files will be located.
     These files are *.HLP, *.BLB, and *.MNU.  Normally, you should create this
     directory and place the help files in the directory before bringing up
     Citadel-86, since help files are usually online at all times.
 
     #HELPAREA "c:helps"         -- helps subdirectory on drive C:
 
     ------
     LOGAREA
        This parameter specifies the location of your CTDLLOG.SYS file (this 
     file is sized by your LOGSIZE parameter).
 
     #LOGAREA "c:system"         -- put it in a general system dir
 
     ------
     ROOMAREA
        This parameter specifies the location of CTDLROOM.SYS, CTDLARCH.SYS,
     and CTDLDIR.SYS.

     #ROOMAREA "system"          -- another general system dir
 
     ------
     MSGAREA
        This parameter specifies the location of CTDLMSG.SYS.

     #MSGAREA "c:msg"            -- give msgs there own place in the sun

     ------
     FLOORAREA
        This parameter specifies the location of CTDLFLR.SYS.

     #FLOORAREA "floors"





                                    -14-






     Part 5 of Section 1: POLICY OPTIONS

        Now we enter the POLICY part of the CTDLCNFG.SYS file.  The parameters
     discussed here represent the parts of your policy that can be enforced via
     the Citadel-86 software.
 
     ------
     #AIDESEEALL
        This parameter is a toggle that gives you some power over the scope of
     your aides' "vision".  If you set this parameter to 1, then your aides
     have access to all public AND private rooms (but not invite rooms, unless
     the have been invited).  If this parameter is set to 0, then aides only
     have access to public rooms, plus those private and invite rooms that
     they've been invited to.  So, if you want your aides to see all public and
     private rooms, you would have
 
     #AIDESEEALL 1               -- See all but invite rooms
 
     if you don't want your aides to be so nosy, then you'd have
 
     #AIDESEEALL 0               -- See only public rooms.
 
     ------
     #LOGINOK
        The LOGINOK parameter controls whether your system is an "open" or
     "closed" system.  If you set LOGINOK to 1, the system will allow anyone to
     log in as a "new" user; that is, it will ask a caller who uses an
     unrecognized password if they wish to login as a new user.  If LOGINOK is
     set to 0, the system will simply tell the caller without a valid password
     that there is no record of that password, and that they should leave
     Mail> to the sysop; the only way to enter new users into the system is
     from the system console. If you want an open system, for example, you
     would have
 
     #LOGINOK 1                  -- let the riff-raff in!
 
     ------
     #ENTEROK
        ENTEROK controls whether a caller who is not logged in can enter
     messages or not.  If ENTEROK is 1, then a caller who has not logged in
     can enter messages; if it is 0, then they must log in first, except for
     Mail to the sysop.  Setting ENTEROK to 0 can reduce vandalism; setting
     it to 1 gives your callers the privilege of anonymity.
 
     #ENTEROK  0                 -- log in first, folks!
 
     ------
     #READOK
        READOK controls whether an unlogged caller can read messages.  If
     READOK is 1, then they may.  If READOK is 0, then an unlogged caller can
     only read the policy statement available in the Mail> room (POLICY.HLP),
     and the help files.  Setting READOK to 0 can discourage unwelcome callers
     from using scarce system time.
 
     #READOK 0                   -- gotta login to read these gems...




                                    -15-






     ------
     #ROOMOK
        ROOMOK controls who can create new rooms on your system.  If ROOMOK is
     1, then any logged in user of the system may create new rooms.  If ROOMOK
     is 0, then only aides may create new rooms on your system.
 
     #ROOMOK 1                   -- a liberal policy
 
     ------
     #ALLMAIL
        ALLMAIL controls who can use the Mail> room.  If ALLMAIL is 1, then
     any user may use Mail> to send private messages to any other user on the
     system.  If ALLMAIL is 0, then only Aides may use the Mail> room in a
     general manner; regular folk can only use Mail> for messages to Sysop.
     Setting ALLMAIL to 0 may be appropriate on tightly focused systems
     operating in a small environment.
 
     #ALLMAIL 1                  -- the normal policy
 

     Part 6 of Section 1: MODEM HANDLING
        We now enter into defining the essential details of your communications
     hardware.

     ------
     #IBM
        You use this parameter to tell your Citadel-86 if your system is
     running on an IBM PC/XT/AT or compatible, or if it is running on a Zenith
     Z-100 (set it at 0). If you have an IBM, you'd have
 
     #IBM 1                      -- Big Boo
 
     ------
     #COM
        This parameter is meaningful only for IBMs, and selects which COM port
     the modem is attached to (on Z-100s only J2 ports are supported).  For
     IBMs, only COM ports 1 and 2 are supported.
 
     #COM 1                      -- If you are using COM1.
 
     ------
     #SYSBAUD
        The SYSBAUD parameter is used to tell Citadel-86 what baud rates your
     hardware will support.  Citadel-86 cannot normally be configured to run
     high baud rates while excluding lower baud rates (i.e., operate
     correctly at 1200 baud but not at 300 baud).  A value of 0 indicates that
     the system is a 300 baud system, 1 indicates 300/1200, 2 indicates
     300/1200/2400, 3 indicates 3/12/24/48, and 4 indicates 3/12/24/48/96.
 
     #SYSBAUD 1                  -- A 3/12 system.
 
     ------
     #SEARCHBAUD
        IF YOU ARE A NOVICE, WE SUGGEST SETTING THIS PARAMETER TO 1, EVEN IF
     YOU DO HAVE AN INTERNAL HAYES MODEM.  ONLY PLAY WITH THE SEARCHBAUD
     PARAMETER AFTER YOU HAVE A CITADEL-86 INSTALLATION THAT WORKS CORRECTLY.



                                    -16-






        The SEARCHBAUD parameter is used to tell Citadel-86 how to find the
     baud rate of the caller.  If the value of this parameter is 1, then
     Citadel-86 will search for the correct baud rate by switching through each
     of the valid baud rates for this installation, searching for a half second
     at each baud rate for a carriage return from the caller.  If the value
     of this parameter is 0, then Citadel-86 assumes that you have a
     failure-proof method of detecting the baud rate of the caller, and will
     execute the interpreter routine CHECKBAUD to find it.  If you check the
     advanced section on interpreter routines, you'll notice that CHECKBAUD is
     set up to handle a Hayes/compatible 1200 baud internal modem on an IBM,
     by checking the modem's high speed pin. This is the only way which we are
     aware of for infallibly detecting the baud rate of the modem; Hayes result
     codes are NOT a guaranteed method, although we detail support for Hayes
     result codes later in this manual.
 
     #SEARCHBAUD 1               -- Normal setting
 
     ------
     #modemSetup
        This parameter is used to initialize your modem.  It is a string value
     parameter that obeys the formatting directives; however, you should be
     warned that Citadel-86 automatically appends a "\r" to the end of this
     string before sending it to the modem.
                                                            
        And when is modemSetup sent to the modem?  It is automatically sent
     twice while Citadel-86 is initializing, and it will also be automatically
     sent to the modem whenever the <R>einitialize command is selected from the
     Sysop Menu (i.e. privileged function:).

        The value that you use for this string should cause the modem to be
     put into a mode where it will function suitably with Citadel-86.  This
     includes auto-answer and response to DTR, at the very least.  Other
     options that you may wish to consider include turning the modem speaker
     off (if you have one); consult your modem manual for details.  The example
     we have here is biased towards Hayes/compatible modems.  You may have to
     do some research if you're using an odd modem.  Our example turns
     auto-answer on and turns off the speaker on a Hayes modem; note the lack
     of "\r".
 
     #modemSetup "AT S0=1 M0"           -- Surely an exercise in aesthetics...
 
     ------
        If you are a novice setting up Citadel-86 for the first time, please 
     SKIP to Section II.6.  This is the end of Section 1 of CTDLCNFG.SYS,
     parameters that must be set for Citadel-86 to run correctly.  The other
     three sections of a virgin copy of CTDLCNFG.SYS (which we assume you are
     working with) have been given default values that shouldn't cause any
     problems with running a Citadel-86.
 
        If, on the other hand, you're just exploring what's available, continue
     on your merry way!
 
 






                                    -17-






     II.5.c Section 2 of CTDLCNFG.SYS

        Now we enter into the realm of options that may prove useful to you in
     your particular environment, but which are not necessary for the correct
     operation of a Citadel-86.  We're going to begin by discussing a general
     time-driven event-handler facility.  Then we'll talk about some other
     miscellaneous parameters.
 
     ------
     #event ...
        This is what we're calling a "time-driven event-handler", which we're
     going to define as the ability to cause Citadel-86 to do certain things
     at times that you specify.  So, for instance, you can have the system
     come down at certain times of the day to back itself up, or have it go
     into networking mode several times a week -- or several times a day.  Or
     do whatever your imagination suggests.  Any number of these #event
     parameters may appear in your CTDLCNFG.SYS file.

        This is the generic format of these parameters.

     #event <days> <time> <class> <type> <duration> <warning string> <depends>

        Here is an explanation of each parameter field in the above.

     <days> can be any of the values "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
     "Sun", or "All", or any combination of the first seven.  If used in
     combination, separate each with a ',', but NO spaces are allowed.  This
     part of #event is used to specify on what days this event is to take
     place.  So, if you want something to happen only on Wednesdays and
     Saturdays, then you'd have

     #event Wed,Sat ....

     The 'All' value means, of course, all days of the week.

     <time> is the military specification of what time of day this event is
     supposed to happen (unless the class of this event is 'relative' -- see
     below).  For instance, 11 AM would be

     #event .... 11:00 ....

     while 11 PM would be

     #event .... 23:00 ....

     and 12:30 AM would be

     #event .... 00:30 ....

     Only one time can be specified in this field.  If you need the same event
     to happen at multiple times, then use separate #event entries.

     <class> indicates the class of the event, which is roughly what kind of
     event it will be.  C-86 supports four classes of events at this time:





                                    -18-






     'network' -- this indicates that Citadel-86 should drop into networking
     mode on the day(s) at the time indicated by the <days> and <time> fields.

     'external' -- this indicates that Citadel-86 should come down on the
     day(s) at the time specified by the <days> and <time> fields.  The
     ERRORLEVEL that Citadel-86 should generate when it comes down will be
     discussed later in the subsection on the <depends> field.  This class
     should be used in conjunction with a carefully written batch file.

     'relative' -- this indicates that Citadel-86 should come down X minutes
     after it has come up (this is used to replace the TIMEOUT and HOUROUT
     parameters).

     The number of minutes should be expressed in the <time> field; the <days>
     field has no meaning (although it should be filled in) when class is
     'relative'.  The ERRORLEVEL to be generated by Citadel-86 when it comes
     down will be discussed later, but for now we'll state that it occupies the
     <depends> field.  For instance, if you want your system to come down 6
     hours after it comes up, do something, and then come back up (at which
     point you should realize it'll come back down again 6 hours after that,
     unless another event comes first), you would have an event like:

     #event Sat 6:00 relative .... 7

     in your CTDLCNFG.SYS (note that Sat is meaningless, but some valid field
     has to be there), and your batch file would have something like this:

     :loop
     ctdl
     ...
     if ERRORLEVEL 7 goto doseven
     ...
     :doseven
     REM this is a generic program call, fill in with what you'd really do
     generic
     REM other things..
     ....
     REM now bring Citadel-86 back up
     goto loop
     ....

     'dl-time' -- This indicates that a "download time limit" should be
     activated.  This was a recent addition to the #event handler, and is thus
     a patch rather than a full-scale addition; to truly implement a download
     time limit would probably require a Major Release.  When this class of
     event is active, the total amount of time a user may use in downloads
     during a session is limited by the value in the <depends> field, which
     is designated in MINUTES.  This class value should only be used with the
     'quiet' type (see below).  When this event ends, download time limits
     return to an unlimited status automatically.

     <type> defines what type of event this will be, which essentially means
     how Citadel-86 reacts when the event time comes around.  There are two
     types of events supported at this time:





                                    -19-






     'preempt' -- this indicates that when it's time for this event to occur,
     the current user (if one is on) will be kicked off the system.  A warning
     will be issued to the user 5 minutes before the event is to occur (or if
     they call in after the 5 minute mark has passed, they will get the warning
     immediately). This type should be used for events that MUST occur at a
     given time, such as networking.

     'non-preempt' -- this indicates that the system is willing to wait until
     the current user is off the system before executing the current event.  If
     the time of the event is passed by, the event will still be executed when
     the caller logs off.

     'quiet' -- this indicates that the event should occur with no notice given
     to the user.  Currently, this only makes sense with the 'dl-time' 
     parameter, since there is no need to bring the system down or drop into
     network mode to change the dl-time limit.



     <duration> defines how long the event will last, in minutes.  If duration
     is 0, then if you happen to bring the system up at the exact time that the
     event is to take place, the event WON'T take place; for all other values
     of duration, the event will take place. Duration should probably be 0 for
     external events that you only want to happen once, happen quickly, and
     bring the system right back up, such as a backup event in which your BAT
     file backs up the system and then brings it back up.  This can go so fast
     that your system will be back up in less than 1 minute, so you don't* want
     duration set to 1 -- you want it at 0, otherwise the event could be
     executed more than once.  However, for network events you certainly want
     it set correctly.  A 45 minute network event would look like this:

     #event ... ... network preempt 45 ....

     <warning string> is only valid for 'preempt' events.  It is sent to the
     user for the warning and for the "you've been kicked off" messages.  It
     should be enclosed in quotes.  Here's what the messages look like:

     "<beep>WARNING: System going down at <time> for <warning string>."

     "<beep>Going to <warning string>, bye!"

     So, for networking,

     #event .... "networking" ...

     works just fine.













                                    -20-






     <depends> is a parameter whose meaning depends on the class of the event.
     If the class of the event is 'external' or 'relative', then this value is
     the ERRORLEVEL that Citadel-86 is supposed to generate as it comes down,
     and should be used in BAT files for further processing.  The upper
     effective limit on this parameter is whatever MSDOS allows in BAT files,
     we think.  Before leaping into this, however, please review the section
     on BAT files in this Installation Manual, paying particular attention to
     already-reserved ERRORLEVELS.

     If the class of this event is 'network', then <depends> specifies what
     net(s) this network event is going to participate in.  While we are not
     going to discuss in detail what Citadel-86's "multinet" capability is,
     here is a summary: Citadel-86 supports handling multiple C86nets.  Each
     network is identified by a number; all of the nodes in your system can
     be associated with 0 or more of these nets.  Thus, using the <depends>
     field can allow you to network with certain systems at one time and/or
     day, and other systems on other times and/or days. The <depends> field
     must have at least one of the nets identified here, and may have more
     if a particular network session is servicing more than one network at
     a time.  If more than one net is to be serviced, place a comma, and ONLY
     a comma, between each net identifier. So, if you wanted to specify
     nets 1, 6, and 14, you'd have

     #event .... 1,6,14

     If the class of the event is 'dl-time', then the depends field specifies
     the maximum number of minutes that may be spent in downloading during
     a single login while this event is in effect.

         And that's it for the #event parameter(s).  We hope our explanation
     is understandable; we sure had a hard enough time writing it!

     ------
     #sysPassword
        This parameter gives you access to the Remote Sysop capabilities of
     Citadel-86.
 
        A "Remote Sysop" is an Aide, not at the System Console, who knows
     the Remote Sysop Password.  A Remote Sysop's capabilities include complete
     access to the Sysop Menu (yes, including such silly things as changing
     the Baud Rate -- See Section X) and when editing rooms the Remote Sysop
     can do what a normal Sysop can do.  A Remote Sysop gains access to the
     Sysop capabilities in exactly the same way as a normal Sysop does, by
     sending a ^L to the system -- but a Remote Sysop has to supply a password.
 
        This parameter, a string value that does not obey formatting
     directives, does NOT (repeat NOT!) specify the Remote Sysop Password.
     Rather, it specifies the NAME of a file that contains, on one line, the
     Remote Sysop Password (this allows you to hide your Remote Sysop Password
     somewhere on your system).  This filename may specify any file anywhere
     on your system, including different drives and subdirectories.
 
        The password itself must be at least 15 letters long, and is, unlike
     most passwords, case-sensitive.  WARNING: If you change the password
     in the file, you must run CONFG again (CONFG ONLYPARAMS -- see the Section
     on Command Line parameters).



                                    -21-






        If this parameter is not specified, or the file is not found, then the
     Remote Sysop facility is not active.

        We really don't recommend you use this facility, due to the abuse
     possible if some juvenile delinquent breaks two passwords.  However, if
     you insist on using this facility, and placed your password in a file in
     a directory on drive G, in a file named PWD in a directory on the root
     called HIDING, you'd have the following in your CTDLCNFG.SYS file.
 
     #sysPassword "g:\hiding\pwd"       -- Note the lack of '\\' sequences
 
 
     ------
     #CALLAREA
        This parameter is just like the MSGAREA, et al.  It is a string value
     parameter that specifies a drive and directory which will hold an audit
     file.  If this parameter is not present in your CTDLCNFG.SYS file, then
     the audit file will not be created or updated by Citadel-86.
 
        The audit file is known as CALLLOG.SYS.  It is a simple ASCII text file
     that contains notes regarding system usage.  There are only two types of
     notes.  The first lists when the system has come up and down.
 
        The second type records who has called, listing login and logout times,
     one line per person, in the following format:
 
     <person>   :   <login time> - <logout time> <baud rate>

        Occasionally such a line will have an extra character appended onto it,
     and they have the following significance.
 
        '+'  Means that this user logged in as new.
        '-'  Means that this user used .TS to logout.
        'T'  Means that this user timed out on the system.
        'E'  Means that this user hit the error limit on the system and was
             kicked off.
 
        If you want to have a call log, you would have something like this in
     your CTDLCNFG.SYS file:
 
     #CALLAREA "c:audit"         -- This can only be a subdirectory

     ------
     #MIRRORMSG
        The structure of Citadel-86's message base causes frequent disk access.
     While this is not particularly deleterious for a hard disk, this kind of
     activity has been known to actually destroy floppy drives. Therefore, it
     makes sense to put the message base into a RAM drive. However, this leaves
     systems vulnerable to message base loss due to power failure. Because of
     this, Citadel-86 has the ability to support two identical message bases at
     once.








                                    -22-






        The first message base functions as the primary; messages are written
     to and read from this base. This message base is specified by the MSGAREA
     parameter.  The second message base, however, is subject only to writing,
     thus saving wear and tear on the media involved.  Since the primary
     message base (the one that is both written to and read from) is subject
     to a lot of wear and tear, this message base should be placed in a RAM
     disk. The MSGAREA parameter mentioned earlier specifies the area for the
     primary message base.  It is your responsibility to make sure that a copy
     of CTDLMSG.SYS is in the RAM disk when you bring Citadel-86 up; Citadel-86
     will not do that for you.
 
        The secondary message base, since it is only written to, should reside
     on permanent media, such as a floppy.  The parameter MSG2AREA, a string
     value that does not respond to formatting directives, specifies the area
     where the secondary message base should reside.  Since both message bases
     are written to simultaneously, they should remain identical.
 
        If you wish to use this option, MIRRORMSG should be set to 1;
     otherwise, it should be set to 0.  If MIRRORMSG is set to 1, then MSG2AREA
     should specify where the secondary message base should reside.  For
     instance
 
     #MIRRORMSG 1                -- yeah, why not?
     #MSG2AREA "b:msg"           -- on floppy, of course

     ------
     #RESULT-300
     #RESULT-1200
     #RESULT-2400
     #RESULT-4800
     #RESULT-9600
     #RING

        Citadel-86 has the ability to read the result codes from Hayes modems
     and determine the baud connection of the modem from them.  This currently
     only works with the PCompatibles; the Zenith Z-100s are not yet capable
     of this.

        The #RESULT-xxxx parameters and the #RING parameter are string values
     which should contain the result codes your modem will return for the 
     respective connections, while #RING is the result code for a RING.
     Consult your modem for the exact values, since they vary from modem to
     modem.  You are also responsible for using the #modemSetup parameter to
     initialize your modem correctly for returning result codes.

        When Citadel-86 is trying to use result codes to detect the baud rate
     of a caller, it proceeds by scanning the input for a C/R.  Once one is
     found, then the characters accumulated before the C/R are compared to your
     #RING value.  If they are identical, then all the characters are thrown
     away and Citadel-86 looks for more result codes.  If #RING did not match,
     then the system will scan the various #RESULT-xxxx values that you 
     specified, again looking for a match.  If one is found, then the
     respective baud rate is set and the system proceeds with login.  If a
     match is not found, then the system begins scanning for user-sent C/Rs in
     an attempt to find the baud rate.




                                    -23-






        You do not need to specify values for baud rates your modem doesn't
     support, and we recommend that you do not.

        If you have your SEARCHBAUD parameter set to 0, then you should NOT use
     this option.

        Here is an example for a MultiTech MT224.

     #RESULT-300 "1"
     #RESULT-1200 "5"
     #RESULT-2400 "9"
     #RING "2"

     ------
     #HOLDAREA
        Citadel-86 has the optional capability to save messages that are
     inadvertently interrupted during composition by users for later
     completion.  The reason we say "optional" is that the method used to
     save such messages is to save them as files on disk, and in a restricted
     environment such an ability may not be desirable. Thus, this feature is
     only available on systems in which #HOLDAREA is defined.  #HOLDAREA is
     another directory specification, exactly like those of Section 1 of
     CTDLCNFG.SYS.  All messages that are interrupted will be stored there
     until the next time the user logs in.  These files are currently 7706
     bytes long.

     #HOLDAREA "hold"

     ------
     #sysopName
        This parameter is used to tell your system who the sysop is.  The only
     real effect of this parameter is that all Mail> to sysop is automatically
     routed to the account that you specify in this parameter's string value.
     (This will also affect net Mail> to sysop.)  If you're not using this
     parameter, or the account does not exist, then Mail> to sysop will end up
     in the Aide> room.

     #sysopName "Me!"

     ------
 
     II.5.d Section 3 of CTDLCNFG.SYS

        This section covers the parameters of CTDLCNFG.SYS that are concerned
     with the Citadel-86 networker.  We have no intention of covering the
     network itself with this section; we tried to cover that in NETWORK.DOC.
 
     ------
     #NETWORK
        This parameter controls whether or not you're in the network at all.
     Set it to 1, and you are.  If it is set to 0, then you are not (initial
     setting for our virgin copy).  If you are planning to participate in the
     network, then please be sure that you understand the section on the
     #event parameter, because that is what you use to tell your system when
     to communicate with other systems on the networks.
 
     #NETWORK 1                  -- This system participates.


                                    -24-






     ------
     #LONG-HAUL
        This parameter controls whether or not you'll ever call any systems
     that are long distance from you.  If 1, then you will (if you have any on
     your list, natch); if 0, then you won't.  Naturally, if you never have
     any systems that are long distance from you in your node list, your system
     will never call long distance.
 
     #LONG-HAUL 1                -- Sure, what da heck
 
     ------
     #NewNetPrivs
        This numerical parameter let's you decide if new users should 
     automatically have net privileges or not.  If 1, then they do; 0, they
     don't.

     #NewNetPrivs 0                     -- let's be paranoid!

     ------
     #NETAREA
        This string parameter specifies where all the net files will be located
     on your system.  The "net files" are CTDLNET.SYS and various temporary
     files that have the suffixes ML, RFL, and SFL.  NETAREA is just like
     LOGAREA, MSGAREA, etc., specifying drivename, if necessary, and only a
     subdirectory of the current directory of the relevant drive.
 
     #NETAREA "netstuff"         -- let's put it in a directory called
                                 -- netstuff.

     ------
     #SHARED-ROOMS
        This numeric parameter reserves room in each node record for the number
     of shared rooms you think you'd like to share.  Each takes up 6 bytes, so
     plan according in view of the number of nodes you'll have on your node
     list and the number of rooms you might want to share with other systems.

     #SHARED-ROOMS 4            -- conservative
 
     ------
     #NET-ARCH-ROOMS
        This numeric parameter reserves room in each node record for the number
     rooms that you think you'd like to archive via the network.  Each takes up
     6 bytes, so once again plan accordingly.

     #NET-ARCH-ROOMS 2          -- it's an odd capability














                                    -25-






     ------
     #NET_RECEPT_AREA
        This parameter specifies a directory on your system that will contain
     all files that are sent to your system by some other system during
     networking, using the Send File facility (this is not the same as
     requesting files over the network).  NET_RECEPT_AREA is a string value
     that does not obey string formatting directives, of course, and it may
     specify any directory on your system, not just a subdirectory to your
     current directory.  So, supposing you wanted to specify
     C:\CITADEL\HOLDING as the directory for incoming files from the net,
     you'd have in your CTDLCNFG.SYS
 
     #NET_RECEPT_AREA "c:\CITADEL\HOLDING" -- that directory
 
     ------
     #NET_AREA_SIZE
     #MAX_NET_FILE
        These two parameters allow you to control how much space you wish to
     devote to files coming into your system from the net via the Send File
     command (i.e., other systems sending you files without you asking).
 
        NET_AREA_SIZE allows you to tell Citadel-86 how much space to devote to
     the directory specified in NET_RECEPT_AREA.  When a system attempts to
     send you a file, Citadel-86 will get the size of the file, and then check 
     to see how much space is already being taken up by files in
     NET_RECEPT_AREA.  If the difference of NET_AREA_SIZE and the files already
     in NET_RECEPT_AREA is less than the size of the incoming file, then your
     system will not accept the file that is being sent to you.
 
        MAX_NET_FILE allows you to control how big a file you will ever accept.
     If the size of the file being sent to you exceeds the value you specify
     here, then your system will not accept the file being sent.
 
        Both of these values are in terms of K.  So, for instance, if you only
     wanted to allow files of up 24K into your system, and only wished to
     devote up to 44K to NET_RECEPT_AREA, you'd have:
 
     #NET_AREA_SIZE 24
     #MAX_NET_FILE  44

     ------
     #callOutPrefix
     #callOutSuffix
        These two parameters control modem dialing during networking.  These
     are both string value parameters that will obey formatting directives, and
     should be used to convey commands to the modem.  When dialing, Citadel-86
     constructs a phone number to send to the phone company, and sends the
     following to your modem:
 
      <callOutPrefix><phone#><callOutSuffix>
 
     callOutPrefix should alert the modem to dial, while callOutSuffix should
     do anything necessary to finish the dialing sequence (usually, just send
     a C/R to the modem).





                                    -26-






        If you have a Hayes modem, we recommend you use the following values
     for these two parameters.
 
     #callOutPrefix "ATDT"            -- Tells a Hayes modem to dial out using
                                      -- touch tones
     #callOutSuffix "\r"              -- puts a carriage return at the end


     II.6 The Big Step -- Your first experience with CONFG
        You should have a complete, if only minimally, CTDLCNFG.SYS on your
     disk now (you DID save that file to disk when you were finished, didn't
     you?), so now it's time to process it into something that CTDL.EXE finds
     palatable.

        You do this with CONFG.EXE.  First, make sure that CTDLCNFG.SYS is
     located on your default disk; if you are running on a floppy-only system
     make sure that you have the correct floppies in the drives.

        Run CONFG.  It will come up with some sort of identification banner,
     and then begin processing your CTDLCNFG.SYS.  Normally, it will echo each
     parameter as it processes it.  If it runs into a parameter that it doesn't
     recognize, or a parameter value that may be out of range, it will come to
     a stop and tell you about it (or at least it should).  Make note of the 
     problem and edit your CTDLCNFG.SYS accordingly.  If it seems critical, or
     you don't understand what's wrong, review this manual, and if that
     doesn't help, some active research (local Citadel-86 sysops, etc.) may
     be called for.  (Good luck.)

        Once you get past this step, CONFG will grumble with the disk for a
     moment (or two on a floppy system), and then ask you some questions.
     This first set of questions depends on whether you created the system
     directories (assuming that you specified that at least some of the
     system files belong in their own directories) or not.  If you didn't,
     CONFG will ask you if it may create the directories needed for the
     system files; this gives you a chance to make sure you didn't screw
     something up.  If you didn't, then answer 'Y' (or 'y') for each question
     regarding directories.

        Once CONFG has decided that the directories are setup correctly, it
     will try to open your system files (i.e., the message file, the log file,
     etc.), and since this is the first time you've run CONFG, it won't find
     them, and therefore it will complain about this, and tell you that it is
     creating each of them.

        This is the first and last time you should ever have to see the
     questions about the directories, or the messages about missing system
     files.  If you do ever see them again, and don't know why, you may have
     problems.

        Next, CONFG will ask if you wish to initialize your system files.
     Since this is the first time, answer 'Y'.  NEVER answer 'Y' again unless
     you know what you're doing, because answering 'Y' tells CONFG to ERASE all
     the data in your data files.






                                    -27-






        Since you answered 'Y' (this doesn't happen when you answer 'N'),
     CONFG will ask if you wish to erase and initialize your message file
     (in case you didn't mean to say yes before).  Type 'Y', and then sit back
     and watch as CONFG creates the message base.  CONFG displays the number of
     'sectors' (128 byte chunks) to clear, and then counts them off as they are
     cleared.  If you are going to have a large (300K or more) message base 
     and have fairly slow disk drive(s), this is probably the time to get that
     cup of coffee.

        Once it is finished with the message base, it'll ask if you wish to
     erase and initialize the room file, and then the log file.  Since you are
     still creating your system, answer 'Y' to them and watch as CONFG clears
     each file.

        If CONFG encounters any problems during this process, it will tell you
     about it and exit without finishing.  It's up to you to figure out what's
     wrong at this juncture.

        Once it finishes with these files, it tells you that it is creating
     CTDLTABL.SYS (remember that file?), and exits after a few more seconds.

        You should now have a CTDLTABL.SYS on your current default disk, which
     also happens to be the disk that your Helps reside on.


     II.7 CTDL -- That Childhood Experience
        And now we get to that long awaited moment.  DO IT.  Run CTDL, however
     you have to do it.  (Is your modem on?)

        If everything is put together right, you have enough memory, and
     everything is configured right, CTDL will be read in, grumble at your disk
     or disks for a moment, initialize your modem, rumble a little more,
     initialize the modem a second time, and then come up with YOUR welcome
     banner.

        If that's what happened, sit back!  Didn't that feel good?  Feel the
     warm, golden glow?  (Quick, knock on some wood.)  And now you should
     probably turn to OPER3.MAN, the everyday care and feeding of Citadel-86.
     (Since we don't have that section written yet, just pretend you did.)
     The remainder of Section II covers advanced installation topics which you
     shouldn't concern yourself with right now, with the exception of Section
     II.8 which covers what to do in case of unexpected power losses and
     crashes. You should certainly read the advanced topics of Section II at
     some time in the future, because we talk about automating your
     installation with batch files, command line arguments, and other beasties;
     however, right now you're just getting used to being a Citadel-86 sysop.

     Delving into other topics when you're not familiar with the basic features
     of the sysop side of Citadel-86 could turn into a messy disaster that
     neither you, nor we, would wish to deal with.  So turn to OPER3.MAN.









                                    -28-






        If CTDL DIDN'T come up, there are a large variety of reasons for the
     failure.  If your system seemed to make it up but came down relatively
     gracefully (i.e., left you at the system prompt), check your disks for a
     file named CRASH. It may give you (or the person you turn to for help!)
     a hint on what might be wrong. If it seems to think there's an error with
     a file, perhaps you forgot to configure MS-DOS correctly.  If CTDL itself
     complains about "no ctdltabl.sys!", then either that file isn't on your
     default disk when you called CTDL, or CONFG didn't successfully finish.

        However, we should mention that on certain computers Citadel-86 simply
     won't run, even though the computers claim to be a PCompatible.  We don't
     know why, although we attribute the problem to a new compiler.  If this
     happens, well, we don't know what to say.  Certainly you should try to 
     find someone with more knowledge about Citadel-86 to discuss your problems
     with; it may be a problem with your CTDLCNFG.SYS, rather than this dreaded
     problem.


     II.8 When the inevitable happens
        Citadel-86, just like any other software, is not immune to such things
     as crashes, power failures, hardware failures, and the like.  When this
     happens, you must take corrective actions, because normally such
     occurrences will leave your system missing (or with a mangled version
     of) the valid version of CTDLTABL.SYS.

        In order to rebuild this vital file, you must run CONFG again.  CONFG
     will digest your CTDLCNFG.SYS, and then survey and summarize for CTDL the
     current contents of your data files.  Once it is finished, you may
     (usually) run CDTL.

        Let's go over exactly what will happen.  When you run CONFG, it should
     go through CTDLCNFG.SYS, just as it did in Section II.6, echoing each
     parameter as it encounters it.  Once finished, however, it's behavior will
     differ. It should not ask you if it may create the appropriate directories
     (since they should already exist), and it should not complain about not
     being able to find any of your system files (these should still exist,
     too!).  However, it WILL ask you if you wish to erase and initialize your
     system files.  This time reply N (with vigor!).  CONFG will immediately
     begin analyzing your data files, and after several minutes, depending on
     the size of your system, it will produce a CTDLTABL.SYS; your system will
     be fit to run again.

        Obviously, there are benefits to automating this process, particularly
     for handling power outages.  Consult the section on batch files and the
     section on command line options for details on effectively automating your
     system in such cases.

     II.9 Installation -- Advanced Topics
        By now you should have a pretty good feel for Citadel-86 procedures,
     but may wish to look into automating Citadel-86.  The first two
     subsections discuss subjects pertaining to that minor miracle; the third
     section will try to bring the first two together, with some representative
     examples of DOS BAT files.






                                    -29-






     II.9.a Command Line options
        A 'command line option' is a string of letters that you type
     directly following the program name.  Each command line option should be
     separated from the program name and any other command line option by at
     least one space.  Command line options are used to tell a program to do
     something that it might not do if the option wasn't there.  In abstract,
     from drive C: of MS-DOS:

     C><program name> <command line option 1> <c.l.o. 2> ...

        Both CONFG and CTDL have a set of command line options which you can
     use to make them do special things.  We'll treat each program separately.

     CONFG
        The CONFG program will respond to two options, which may appear
     together or individually on the command line.

        The first parameter is called ONLYPARAMS.  When CONFG finds this
     parameter on the command line, CONFG will NOT try to process your data
     files.  Instead, it will limit itself to reading and processing your
     CTDLCNFG.SYS file.  This ability is useful when you wish to change one of 
     the CTDLCNFG.SYS parameter values without going through the entire
     process of reading your data files. You MUST have a completely valid
     CTDLTABL.SYS available for CONFG to read; otherwise, this option will be
     ignored and your data files will be processed.

        The second parameter is any string of letters that do not match any
     other command line option for CONFG.  If this 'option' (you can just use
     some random string of characters) is on the command line, then CONFG will
     not ask whether or not you wish to erase and initialize your data files.
     Instead, CONFG will assume that your answer was 'N' (i.e., you simply wish
     to perform a reconstruction).  Thus, CONFG will never query the keyboard 
     for attention, and can run unattended, so long as all the data files are
     in their places.

     CTDL
        The CTDL program officially supports several options, and unofficially
     several more which will not be detailed here.  An 'official' option is an
     option that we anticipate supporting for a while; an 'unofficial' option
     is an option that is used for experimentation, and will someday be moved
     into the CTDLCNFG.SYS parameter file (or just thrown away).

        The first command line option is called +netlog.  This option applies
     only to networking systems.  When employed, it will cause a log of all
     network sessions to be written to the file NETLOG.SYS in your NETAREA
     directory.

        +nochat completely shuts the Chat option off.  Normally, an aide can
     force a chat when Chat is turned off.  This command line option prohibits
     aides from forcing Chat when Chat is turned off.  This option does nothing
     when Chat mode is on.








                                    -30-






        +newvideo will ask Citadel-86 to use a new style of video interface
     for the Sysop on the System Console.  The reason that this feature is
     accessed via a command line switch is that there is some sort of bug
     that won't allow some systems to use this feature.  Please check to
     see if you have a VIDTEST.EXE file in one of your archive files.  If
     so, it will test your system to see if Citadel-86 will blow up your
     system or not (you'll be able to tell by whether or not you have to
     reboot your system after running the test program).

        If +inv is on your command line, then your status bar will appear
     in inverse video.

        A command line option that does not match any of those listed so far
     is known as the 'crash' option.  It will cause CTDL to leave a message in
     your Aide> room informing you that Citadel-86 apparently came up from a
     crash at the time of the message.  This is useful for batch files.

     II.9.b BAT files and program termination ERRORLEVELS
        MS-DOS BAT files depend heavily on the concept of ERRORLEVELs, and we
     encourage you to read the MS-DOS manuals for a full explanation of BAT
     files. The CTDL program, on termination, will set the MS-DOS ERRORLEVEL
     level to a value that you can use to write useful BAT files; you may also
     cause other ERRORLEVELS to be set, as explained earlier in this manual.  
     The values indicate the reason that Citadel-86 terminated, and the ones
     reserved by Citadel-86 are discussed here.  Feel free to use other
     ERRORLEVELS at your discretion.

     0 -- A normal exit.  This indicates that the sysop took the system down
          via e<X>it on the Sysop's menu (see Section III.? for an explanation
          of the sysop menu).
     1 -- Not used.  You may use, if you wish, in conjunction with the #event
          parameters.
     2 -- This was a crash exit.  Citadel-86 is capable of recognizing a number
          of fatal internal errors; when any of them are encountered,
          Citadel-86 will hangup the current caller and immediately terminate
          with this value.  If a crash of this sort occurs, CONFG should be
          run before attempting to run CTDL again.  Some (not all) of these
          fatal errors include non-existence of CTDLTABL.SYS (very, very
          common, due to power failures), missing system files (such as the
          message file, etc.), and corrupted internal data, which indicates 
          the possibility of a bug in CTDL.  Some of these crashes will leave
          the files CRASH and AUDIT behind, which can give hints on what's
          wrong (particularly CRASH).
     3 -- A remote sysop exit.  Since an Aide can be given access to the sysop
          menu from remote (see Section II.5.c on the parameter #sysPassword), 
          s/he is capable of taking your system down from remote.  A number of
          sysops indicated that it might be useful to distinguish between a
          sysop exit and a remote sysop exit, so this ERRORLEVEL is supported.

        One more note.  When you write a BAT file, make sure that you handle
     the ERRORLEVELS in a "top to bottom" manner.  DOS will not process the
     ERRORLEVELS correctly otherwise.

     II.9.c Making BAT files and command line options work for you.
        No program is ever bug-free.  However, it is nice to pretend that one
     is, and an effective way to pretend that a particular program has achieved
     such a goal is by never having it require your attention when you are
     attending to other things.

                                    -31-






        Citadel-86 tries to emulate this sort of utopian software by returning
     a value to MS-DOS when it terminates gracefully, as we described above,
     which allows you to construct BAT files that will handle most
     contingencies.

        Basically, we have to handle 'emergency' situations, which consist of
     coming up from a reboot and handling a graceful crash, and handling
     non-emergencies, which are coming out of C-86 in response to timeouts,
     sysop exits, and remote sysop exits.

        First, let's look at the emergencies.  Typically, an emergency never
     happens at a convenient time; instead, you're off on vacation, at work,
     or feeding the cat.  Therefore, the software has to handle the emergencies
     on its own, within limits.

       In both of our emergency situations, the system must go through a CONFG
     call. When we looked at the command line options of CONFG, we saw that a
     nonsensical argument on CONFG's command line tells it not to ask for
     operator input regarding whether the system should be erased, but rather
     to simply re-analyze the data in preparation for a CTDL call.  Therefore,
     part of our BAT file strategy will contain the line

     CONFG gleeeeepy

     which we may end up placing in its own BAT file.

        Looking into the section on ERRORLEVELs, we should have also noticed 
     that one of the events that will cause a graceful crash is the absence of
     a CTDLTABL.SYS file.  Thus, we can classify a power down as simply another
     graceful crash -- after we make some modifications to your boot disks
     AUTOEXEC.BAT.  But first let's look at just how we should handle these
     'graceful crashes'.

        We said that a graceful crash produces an ERRORLEVEL of 2.  With this
     in mind, we can put in one of our BAT files some lines that look roughly
     like this:

     CTDL
     ...
     if ERRORLEVEL 2 Fixit

     Fixit, in this case, is another BAT file which will fix the system for us.
     I.e., it runs CONFG and gets the system back up on its feet.  What should
     it look like?  Well, first we want to start the file as mentioned above:

     CONFG Gleeepy

     Once CONFG finishes, we need to restart CTDL.  As it happens, MSDOS BAT
     files do not 'stack' up; if A.BAT calls B.BAT, when B finishes it does
     NOT return to A, but instead falls out to MS-DOS.  This makes it easy to
     write BAT files to accomplish our purposes.  Suppose we call our main BAT
     file RUNIT.BAT (the file that contains the 'if ERRRORLEVEL 2 Fixit' line
     in it).  Then we can simply finish the FIXIT.BAT file with






                                    -32-






     RUNIT CRASH

     We'll explain the CRASH command line option later.

        What about the rest of those ERRORLEVELs?  Well, let's solidify your
     RUNIT.BAT a little more.

     CTDL
     if ERRORLEVEL 3 goto remote
     if ERRORLEVEL 2 Fixit
     if ERRORLEVEL 1 goto timeout
     if ERRORLEVEL 2 goto alldone

        (Note the descending order we use here.  This is necessary due to the
     method MS-DOS uses to handle 'if' statements.)  This was simple -- we just
     put off all the work.  However, most of the work is yours, because it is
     really up to you to figure out what you wish to do when your system
     times out (CTDLCNFG.SYS's #event parameter -- we simply assumed that you
     used a 1 in the <depends> field of an external #event parameter) and when
     your remote sysops bring your system down.

        So let's flesh out the rest of this sample RUNIT.BAT.

     :loop
     CTDL %1 ...
     shift
     if ERRORLEVEL 3 goto remote
     if ERRORLEVEL 2 Fixit
     if ERRORLEVEL 1 goto timeout
     if ERRORLEVEL 2 goto alldone
     :remote
     REM put here what you want remote terminations to cause to happen.  If you
     REM want to rerun CTDL, you'd have 'goto loop'.
     ...
     :timeout
     REM put here what you want timeouts to do (backups or whatever)
     ...
     REM we assume that you'd want to restart Citadel-86 afterwards.
     goto loop
     :alldone
     REM And now the sysop at the console took us down, so we'll die.

        Most of this should be pretty easy to understand.  The '...' on the
     CTDL command line simply means whatever options you choose to put on that
     line. However, the '%1' may be puzzling.  As the MS-DOS manual indicates,
     %1 is the first argument on the command line of this BAT file.  Now,
     let's look back at the FIXIT batch file, where we put RUNIT CRASH.  This
     will force the parameter CRASH to appear on your CTDL command line, which 
     CTDL will interpret as a 'nonsense' argument, therefore causing a 'crash'
     message to appear in your Aide> room.  Since it was the FIXIT batch file
     that ultimately causes this message to appear, this is good behavior.








                                    -33-






        But what of that SHIFT following the CTDL command line?  This causes
     the RUNIT command line arguments to shift 1 to the left.  Since there were
     no more arguments to RUNIT, any executions of CTDL subsequent to the SHIFT
     call, while within this BAT file, will not result in messages in the Aide>
     room.  And why might there be any more calls to CTDL after the first one?
     Look at the commands following the timeout label.

        This is just an example.  Have fun.

     II.9.d Extreme options in CTDLCNFG.SYS
        Some of the modem I/O routines in Citadel-86 can be changed by the
     adventurous sysop via the CTDLCNFG.SYS file.  Normally, Citadel-86 uses
     built-in modem routines designed to handle the normal situations of Z-100s
     and the two COM ports of PClones.  However, they can be replaced through
     manipulation of CTDLCNFG.SYS.

        When do you want to use these options?  NEVER, really.  But you
     probably do when you have an unusual, but not unique, modem setup.  If you
     feel your modem connection is really, really odd, you may wish to acquire
     the source code for Citadel-86 and perform some hideous hacks of your own.
     These options are useful when you wish to do something unusual with your
     installation.

        All right, what ARE these 'routines,' anyways?  They came from the CP/M
     version of Citadel, where they were the entirety of Citadel's modem I/O.
     To quote the old documentation that accompanied them, they "...implemented
     a virtual machine with a single accumulator", which is another way of
     saying that a primitive psuedo-assembly language was made available to
     the sysop for designing their own modem I/O.  The reason that they
     exist in Citadel-86 is partly inertia and partly their flexibility: the 
     two types of machines that Citadel-86 supports, Zenith Z-100s and most
     PClones, have radically different serial interfaces.  Using the
     appropriate routines saves some (probably only a trivial amount of) code
     room.

        OK, let's get concrete.  Each routine available to you is composed
     of two parts, the name of the routine and the code which implements it.
     Abstractly, it looks like this:

     #start <routine name>
     #code <instruction> <optional instruction data>
     #code <instruction> <optional instruction data>
     ...

        Usually, the last #code instruction will specify a RET.














                                    -34-







        Here is the list of routines currently supported:

     HANGUP     -- This routine MUST force your modem to hangup.
     INITPORT   -- This routine should initialize your port AND your modem.
                   (NOTE: If INITPORT exists, #modemSetup should NOT exist.)
     CARRDETECT -- This routine MUST return (see the RET instruction) a 0 when
                   there is no carrier, and a non-0 value when there is
                   carrier.
     SET300     -- This routine should set your modem's port to 300 baud.
     SET1200    -- This routine should set your modem's port to 1200 baud.
     SET2400    -- This routine should set your modem's port to 2400 baud.
     SET4800    -- This routine should set your modem's port to 4800 baud.
     SET9600    -- This routine should set your modem's port to 9600 baud.
     SET_HIGHER -- This routine should set your modem's port to your choosing
                   (this option may not be supported in the future).
     CHECKBAUD  -- This routine is only used when SEARCHBAUD is 0.
                   CHECKBAUD must return (see RET) 0 if the modem is at
                   300 baud, 1 if 1200 baud, 2 if 2400 baud, 3 if 4800 baud,
                   and 4 if 9600 baud.
     ENABLE     -- This routine must ENABLE your modem for answering the phone.
     DISABLE    -- This routine must DISABLE your modem from answering the
                   phone.

        The instructions available to you simulate a very simple machine with
     one accumulator and a scratch array.  You'll find the instructions crude,
     primitive, and limiting.  The scratch array is addressed from 0, and has
     40 elements.  Here they are:

     LOAD x   -- This instruction loads the accumulator with the value in
                 location x of memory (!).
     ANDI x   -- This instruction performs a logical AND of the accumulator
                 with x and places the result in the accumulator.
     ORI x    -- This instruction performs a logical OR of the accumulator with
                 x and places the result in the accumulator.
     XORI x   -- This instruction performs a logical XOR of the accumulator
                 with x and places the result in the accumulator.
     STORE x  -- This instruction stores the accumulator in the specified 
                 address of memory(!).
     LOADI x  -- This instruction loads the accumulator with the value of x.
     RET   x  -- This instruction forces the routine to return to the caller
                 with the value of the accumulator (in this case, 'x' is just
                 a dummy value).
     INP x    -- This instruction causes the accumulator to be loaded with the
                 value currently present at port x.
     OUTP x   -- This instruction causes the accumulator to be sent to port x.
     PAUSEI x -- This instruction causes the Citadel-86 installation to pause
                 for x/10s of a second.
     ARRAY[]= x -- This instruction stores the accumulators value in the
                   specified location of the scratch array.
     ARRAY[] x  -- This instruction loads the accumulator with the value in the
                   specified location of the scratch array.
     OUTSTRING "x" -- This instruction causes the string "x" to be sent to the
                      modem.





                                    -35-






     OPR# "x" low high -- This instruction causes the string "x" to be
                          displayed, followed by a request for a number.  Low
                          and high specify the lowest and highest acceptable
                          values that will be accepted.  The accumulator
                          receives the value specified by the user.

        In SUPPORT.ARC there should be a file named PSUEDO.DOC.  It contains a
     listing of all the default routines used by Citadel-86.  If you have ANY
     plans at all for using your own routines, first examine those in
     PSUEDO.DOC, both to understand what is used for a default, and for working
     examples of how to write valid routines.

        And, lastly, REALLY WE HOPE YOU DON'T HAVE TO ENGAGE IN THIS SILLINESS.



                                ctdlCnfg.sys


        This is the configuration file for the Citadel-86 bulletin board
     system. It is read in by confg.exe which sets up a "ctdlTabl.sys" file
     recording the configuration parameters.  (CtdlTabl.sys is read by the
     other Citadel programs.) This file must be edited to be appropriate to
     the local environment. Lines not beginning with "#" are ignored by CONFG
     and may be deleted once the file is successfully configured -- they are
     purely documentary.  For more detail, consult the CITADEL-86 SYSOP MANUAL.
 
     GENERAL STRING FORMATTING CONTROLS:
     The following are supported:
             "\n": CR-LF
             "\t": Tab character
             "\b": Non-destructive Backspace
             "\r": CR
             "\f": Formfeed
             "\"": '"'
             "\\": Backslash
             "\<xxx>": The octal* ASCII value is output

        SECTION 1: NECESSITIES AND MISCELLANEA
 
     SYSTEM TITLE
        nodeTitle is printed after the "Welcome to" and before the "Running..."
     lines of the banner that pops up on carrier detect, UNLESS BANNER.BLB
     exists, in which case the entire "Welcome to <nodeTitle>" line is
     replaced with the contents of BANNER.BLB.  nodeTitle is a string value
     that accepts formatting directives and goes through the Citadel
     formatter.


#nodeTitle "Our Name"         -- An obvious imposter









                                    -36-






     SYSTEM NAME
        nodeName is purely for networking purposes.  Messages which
     originated on your system will have headers looking like:

           82Nov23 From Cynbe ru Taren @ODD-DATA

     This should be a short (for the sake of the reader!) mnemonic
     identifying your node for humans.  It does not use formatting directives.
 
#nodeName "ODD-DATA"          -- The original Citadel (kow-tow, everyone)
 
     SYSTEM ID
        nodeId is also purely for networking purposes.  Messages which
     originate on your system will be marked with the nodeId, but it will
     not normally be printed out.  It is primarily for the use of the
     networking support software, and forms a globally unique name and
     address for your system.  It consists of a country abbreviation
     followed by area code and system phone number.  This string value does not
     use formatting directives. Country abbreviation for the US is "US", for
     Canada is "CA".  (For others, see COUNTRY.DOC.)


#nodeId "US 612 866 1804"


     SYSTEM BASEROOM
        baseRoom is the homeroom of the Citadel in operation, the place you
     go when there are no more rooms with unread messages left.  This is
     usually known as the Lobby> on most systems.  It's simply a nice,
     easy way to customize and give character to your system..
 
#baseRoom "Glops"
 
     SYSTEM BASE FLOOR
        MainFloor is the home floor of the Citadel in operation, the floor
     where baseRoom, Aide, and Mail are located.  It's another nice, easy
     way to customize your system

#MainFloor "Da Basement"

     SYSTEM ENCRYPTION SEED
        CRYPTSEED is a number used in encrypting the data files.  Change
     it once when you install the system, but not thereafter -- or you
     won't be able to read the existing files any more.

#CRYPTSEED 333                --













                                    -37






     DATA FILES SIZE: MESSAGE BASE
        MESSAGEK sizes "ctdlmsg.sys", the file message text is stored in. The
     size of this parameter together with the rate at which message text is
     entered determines message lifetime.

#MESSAGEK 300                 -- 300Kbyte ctdlmsg.sys

     DATA FILES SIZE: MESSAGES PER ROOM
        MSG-SLOTS defines the maximum number of displayable messages per room
     on your room, except for the Mail> room.

#MSG-SLOTS 58                 -- 58 is kind of traditional

     DATA FILES SIZE: MESSAGES PER MAIL ROOM
        MAIL-SLOTS defines the maximum number of displayable messages for each
     user's Mail> room.

#MAIL-SLOTS 58                -- Yet another tradition...

     DATA FILES SIZE: ROOM FILE
        MAXROOMS defines the maximum number of rooms on your system.

#MAXROOMS 64                  -- This is usually enough
 
     DATA FILES SIZE: LOG FILE
        LOGSIZE is the number of entries that you want in your log. Once
     you've selected a log size and have configured, you may NOT shrink
     the log except by destroying the log totally. There is a utility
     available for expanding the log, called DATACHNG.

#LOGSIZE 180                  --

     **DATA FILE LOCATIONS**
        The next several parameters allow you to specify where certain system
     files are to appear on your system.  Please note that only subdirectories
     of the disk you specified are legal.  Disk specifications are legal.
 
        This parameter specifies where you want your help files located in your
     system.

#HELPAREA "helps"             -- All help files located in subdir
                              -- "helps"
 
        This applies to the CTDLLOG.SYS file.

#LOGAREA "a:log"              -- in subdir "log" on drive a:
 
        This applies to the CTDLROOM.SYS, CTDLBAD.SYS, and CTDLARCH.SYS files.

#ROOMAREA "system"            -- in subdir "system"
 
        This applies to the CTDLMSG.SYS file.

#MSGAREA ""                   -- current directory of default disk





                                    -38-






        This applies to the CTDLFLR.SYS file.

#FLOORAREA "floors"           -- its own subdirectory for no particular reason.

     AIDE SCOPE:
        The AIDESEEALL parameter controls the scope that Aides have on the
     installation.  If this parameter is set to 0, then Aides are only allowed
     to see public rooms and private rooms that they are told about;
     private room creation will leave an entry in the Aide> room indicating
     that a room was created, but not the name.  An Aide at the SysConsole
     will, however, see all rooms.  If this parameter is set to 1, then all
     Aides will see all rooms on the system, public or private.
 
#AIDESEEALL 0                 -- Aides see nothing
 
     NEW USER CONTROL:
        LOGINOK controls whether users without a password can login from
     remote. If LOGINOK is 1, they may; if LOGINOK is 0, then the only place
     that new accounts may be entered is from the system console.
 
#LOGINOK 1                    -- user-established accounts
 
     MESSAGE ENTRY CONTROL:
        If ENTEROK is 1, callers that are not logged in may enter messages.  If
     0, then they must login first before they can enter messages (except for
     Mail> to the Sysop.  Note that Anonymous rooms are not an exception.

#ENTEROK 0                    -- login first

     READING CONTROL:
        If READOK is 1, then unlogged callers can read messages.  If READOK is
     0, then users must login before reading messages.
 
#READOK 0                     -- login first
 
     ROOM CREATION CONTROL:
        If ROOMOK is 1 then regular folks can create new rooms, else only those
     with aide privilege can do so.
 
#ROOMOK 1                     -- general room-creation privileges
 
     MAIL CONTROL:
        If ALLMAIL is 1, all get privileges; 0 means only aides have the
     privilege.
 
#ALLMAIL 1                    -- Everybody can send mail
 

     COMPUTER HARDWARE TYPE:
        Setting IBM to 1 implies the system is a PClone, and to use some
     internal routines for accessing modem.  If IBM is 0, then substitute
     other special routines specific to the Z100 for accessing modem.
 
#IBM 1                        -- IBM clone





                                    -39-
 





     COM PORT:
        The COM parameter allows the sysop who is using an IBM to select
     either COM1 or COM2 as the communications port. This parameter is
     meaningless for Z-100s.

#COM 1                        -- COM1 is the selection
 
     SYSTEM BAUD RATES:
        SYSBAUD defines the baud rates supported by this installation.  0
     indicates 300 only, 1 indicates 300/1200, 2 indicates 300/1200/2400,
     and 3 indicates 300/1200/2400/your own selection.
 
#SYSBAUD 1                    -- A 3/12 system.
 
 
     CALLER BAUD DETECTION:
        If SEARCHBAUD is 1, then a "search for carriage returns" commences
     amongst the valid baud rates defined by SYSBAUD.  If SEARCHBAUD is 0,
     then the interpreter routine CHECKBAUD is executed to find the correct
     baud.
 
#SEARCHBAUD 1                 -- Yes, autosearch
 
 
     MODEM INITIALIZATION:
        modemSetup specifies what should be sent to the modem after
     initializing the port. While Hayes/compatibles are recommended, other
     types of modes have been successfully used with Citadel-86, such as
     TransModems.

#modemSetup "AT S0=1 M1"


        SECTION 2: INTERESTING OPTIONS
 
     TIMED EVENT HANDLER:
        See the manual for this one.  Here is the generic format:

-#event <days> <time> <class> <type> <duration> <warning string> <depends>

     REMOTE SYSOP FACILITY:
        #sysPassword specifies the file that contains a string that will act
     as the password to the remote sysop abilities.  If this parameter is not
     specified, or if the file is not found, or is unreadable, then remote
     sysop abilities are disabled.  Only Aides can access remote sysop
     abilities, and they must* know the exact password, including the case
     of the individual letters.
 
-#sysPassword "c:\pwd"        -- Inactive (note the leading hyphen)










                                    -40-






     AUDIT:
        This parameter specifies where the CALLLOG.SYS file ends up on your
     system.  Note that the directory specified has to be a subdirectory of
     a current directory.


-#CALLAREA ""                 -- put CALLLOG.SYS in the current directory
                              -- (inactive -- note leading hyphen)
     RAM DRIVE HANDLING:
        These two parameters control whether or not and where a secondary
     message file will reside.  If you use this parameter, it should
     reference a permanent media file, and the MSGAREA parameter should
     reference a RAM drive.  MSGAREA will always be both read and written to,
     while this one will only be written to; thus, this parameter should
     reference the media more sensitive to wear and tear.  MIRRORMSG should
     be 1 if you wish to use this ability; MSG2AREA then referrnces the
     location of the secondary message base.
 
#MIRRORMSG 0                  -- Turn it off for novices
#MSG2AREA ""                  -- so this is irrelevant while MIRRORMSG
                              -- is 0

     RESULT CODES FOR BAUD DETECT:
        These parameters allow you to try to detect baud rate via result codes.
     Do not use these parameters if you SEARCHBAUD is 0.  The following is
     only an example for a MultiTech 224.

-#RESULT-300  "1"             -- all are deactivated
-#RESULT-1200 "5"
-#RESULT-2400 "9"
-#RESULT-4800
-#RESULT-9600
-#RING        "2"
 
     INTERRUPTED MESSAGE AREA:
        This parameter specifies where to save interrupted messages for
     later completion.

-#HOLDAREA "held"             -- inactive

     SYSOP MAIL ROUTING:
        This parameter specifies the account that Mail> to sysop should be
     routed to.

 -#sysopName "Me!"            -- inactive

        SECTION 3: NETWORK PARAMETERS

     NETWORK SELECT:
        You use this parameter to decide whether or not you are a networking
     system.  If you set this parameter to 0, then the rest of the parameters
     in this section are meaningless, because you are not a networking
     system.

#NETWORK 0                    -- Disable for novices




                                    -41-






     LONG DISTANCE NET:
        This parameter decides whether you'll call LD systems or not.  If 1,
     then you will; if not, you won't.  This parameter may be unneeded in
     the future.

#LONG-HAUL 0                  -- Off for now


     NEW USER NET PRIVILEGES:
        #NewNetPrivs specifies whether or not new users automatically have
     net privileges.

#NewNetPrivs 0                -- Nope.

     NET FILES LOCATION:
        You use this parameter to specify where the various network-related
     files will be located.  It is a string parameter that you use to specify
     the drive and directory to put these files.

#NETAREA "c:net"              -- an example ONLY

     MAXIMUM SHARED ROOMS:
        This parameter selects the maximum number of shared rooms per system.

#SHARED-ROOMS 1


     ARCHIVING ACROSS THE NETWORK:
        This parameter selects the maximum number of rooms that you think
     you'll ever want to simultaneously archive to another system.

#NET-ARCH-ROOMS 1


     RECEPTION AREA FOR FILES:
 
        The NET_RECEPT_AREA parameter specifies the directory that files sent
     to this installation Via the Send File feature of the net will be placed
     in.  Do NOT end it with a '\'!

#NET_RECEPT_AREA "C:\citadel\recept" -- Just an example


     RECEPTION DIRECTORY SIZE:
        The parameter NET_AREA_SIZE allows the sysop to specify how much room
     should be allocated for the NET_RECEPT_AREA parameter.  This allows the
     sysop to ensure that his system isn't swamped by files sent by other
     systems. The NET_AREA_SIZE parameter should be in K. (Remember, this
     should be in hex.)

#NET_AREA_SIZE 500








                                    -42-






     INCOMING FILES SIZES:
        The MAX_NET_FILE parameter allows the sysop to decide how large of a
     file the system will accept from another system when the file is sent
     by the other system (this does NOT apply to Requesting a file, only to
     accepting a file Sent with the Send Net feature). This parameter is
     also in K.

#MAX_NET_FILE 300

     MODEM DIALOUT:
        callOutPrefix determines what is output to the modem prior to
     the phone number to be dialed.  It must send all commands necessary
     to put the modem into dial out mode.  Additionally, it must contain
     what is neceessary in the way of special commands dealing with PBX's,
     etc.

        #callOutSuffix determines what is output to the modem after
     #callOutPrefix and the phone number has been output.  Graphically,

            <#callOutPrefix><phone#><#callOutSuffix>

     is the sequence in which data is out when the networker tries
     to dial out.  Since nothing is automatically appended to the
     number when it is being output to the modem during networking,
     the typical value for an installation using a Hayes/compatible is

            #callOutSuffix "\r"

     since Hayes/compatibles require a C/R to end a command string.

     This may not hold true for other brands of modems.

#callOutPrefix "ATDT"         -- Normal Hayes installation w/ TT.
#callOutSuffix "\r"           -- Typical Hayes suffix
 
        SECTION 4: SPECIAL REQUIREMENT HANDLING

        NOTE: If you think you have an odd modem setup, such as a
     non-standard cable for allowing direct access to a high-speed pin, then
     consult the Citadel-86 SYSOP MANUAL, Section II.5.d, which details what
     abilities are available in this section of CTDLCNFG.SYS.  If that
     section is not clear, or doesn't seem to handle your particular problem,
     try to contact Hue, Jr. on the C-86 Test System (612) 866-1804 for help,
     or his successors.
 
#alldone x x                  -- end of file













                                    -43-





