














                                NETHACK MANUAL

                              Citadel-86: V3.03

                                  by Hue, Jr.

                            C-86 Test System Sysop

                                    88Mar01














































     Table of Contents


     I. Introduction . . . . . . . . . . . . . . . . . . . . . . .  2
        I.1 History  . . . . . . . . . . . . . . . . . . . . . . .  2
        I.2 Purpose  . . . . . . . . . . . . . . . . . . . . . . .  2

     II. Overview  . . . . . . . . . . . . . . . . . . . . . . . .  3

     III. Information Transfer Layer . . . . . . . . . . . . . . .  3
        III.1 Call Stabilization . . . . . . . . . . . . . . . . .  4
        III.2 Transfer Medium  . . . . . . . . . . . . . . . . . .  5

     IV. Application Layer . . . . . . . . . . . . . . . . . . . .  6
        IV.1 Overview  . . . . . . . . . . . . . . . . . . . . . .  7
        IV.2 ID & Name . . . . . . . . . . . . . . . . . . . . . .  7
        IV.3 Facility Requests . . . . . . . . . . . . . . . . . .  8
        IV.4 Message & File Transfer . . . . . . . . . . . . . . .  9
        IV.5 Network Session Control Facilities  . . . . . . . . .  9
           IV.5.a Hangup command . . . . . . . . . . . . . . . . .  9
           IV.5.b Error Code Support . . . . . . . . . . . . . . . 10
           IV.5.c Role Reversal  . . . . . . . . . . . . . . . . . 10
        IV.6 Data Transfer Facilities  . . . . . . . . . . . . . . 10
           IV.6.a Normal Mail  . . . . . . . . . . . . . . . . . . 10
           IV.6.b Room File Requests . . . . . . . . . . . . . . . 10
           IV.6.c Ambiguous Room File Requests . . . . . . . . . . 11
           IV.6.d Ambiguous Room File Requests With Approval . . . 11
           IV.6.e Network Room . . . . . . . . . . . . . . . . . . 12
           IV.6.f Check Mail . . . . . . . . . . . . . . . . . . . 12
           IV.6.g Send File  . . . . . . . . . . . . . . . . . . . 13
           IV.6.h Alternate Room Sharing . . . . . . . . . . . . . 13
        IV.7 ITL Alternate Realities . . . . . . . . . . . . . . . 13
        IV.8 Security  . . . . . . . . . . . . . . . . . . . . . . 13
           IV.8.a System Net Password  . . . . . . . . . . . . . . 14
        IV.9 Other Reserved Facility Byte Values . . . . . . . . . 15
        IV.10 Facilities -- Short List . . . . . . . . . . . . . . 15

     V. Minimal Compatability Requirements . . . . . . . . . . . . 15

     Appendix A.  Message Transfer Format  . . . . . . . . . . . . 15

     Appendix B.  Examples!  . . . . . . . . . . . . . . . . . . . 16
       B.1 Call Stabilization  . . . . . . . . . . . . . . . . . . 16
       B.2 ID & Name . . . . . . . . . . . . . . . . . . . . . . . 17
       B.3 Normal Mail . . . . . . . . . . . . . . . . . . . . . . 17
       B.4 Ambiguous Room File Requests  . . . . . . . . . . . . . 17
       B.5 Network Room  . . . . . . . . . . . . . . . . . . . . . 18
       B.6 Check Mail  . . . . . . . . . . . . . . . . . . . . . . 18
       B.7 Send File . . . . . . . . . . . . . . . . . . . . . . . 19
       B.8 Alternate Room Sharing  . . . . . . . . . . . . . . . . 19

     Appendix C.  BBS Software compatible with C86Net  . . . . . . 19

     Appendix D. Main C86Net . . . . . . . . . . . . . . . . . . . 19





                                    -1-






     I. Introduction
        This document attempts to detail, in a haphazard manner, the network
     known as C86Net.  C86Net is a BBS network protocol which is currently
     used by Citadel-86 (for Z100s and PClones), NeoCitadel (PClones), STadel
     (Atari STs), and Amiga Citadel-68K (Amigas).

     I.1 History
        The original motivations for C86Net were two-fold: to provide an
     interesting project exploring a topic that the author had never studied
     before, and to (ultimately) allow the sysops of Citadel-86s in the Twin
     Cities area of Minnesota (aka Minneapolis/St. Paul) to communicate with
     each other without having to call each other's boards; the number of
     Citadels in the area was beginning to escalate, making it impossible
     for gainfully employed sysops to talk conveniently.

        The first version of C86Net came into being in June of 1985, and is
     better left unmentioned.  After learning from his mistakes and discussing
     the entire project with John Stanley, a second version was attempted and
     installed in all local Citadel-86s.  This, too, was a ghastly mistake,
     but enough lessons were learned so that the third version of C86Net could
     be constructed in an expandable fashion that would allow easy backward
     compatability as the network facilities were expanded.  The installation
     of the second and third versions mandated this ability: updating an
     entire set of systems simultaneously is a nightmarish situation.

        The history of C86Net since then has consisted of two events: the
     addition of new facilities as new needs were identified, and the
     integration of non-Citadel-86 systems to C86Net networks.

        The history of adding facilities is not going to be detailed here; it
     would be both tedious and useless.  However, the astute reader will
     note several anomolies and redundancies in the facilities.  Be advised
     that this is what happens when the author is programming for both
     learning and fun; another term is "programming by accretion."

        The first non-Citadel-86 system to join a C86Net was NeoCitadel, by
     Hue, Sr., which started by supporting Net Mail.  Then a valiant, notable
     effort was made by Lum the Mad, author of Lumadel, a very good Citadel
     clone for the Apple II series of computers.  His networker, written in
     Apple Basic, actually managed to communicate during several manual tests
     with a Citadel-86.  However, an automated networker was never completed,
     and Lumadel languished after Lum bought an IBM clone.

        The final two types of BBS software that are compatible with C86Net
     are derived from Citadel-86: Amiga Citadel-68K as ported by Stallion aka
     Jay Johnson, and STadel as ported by orc.

        No other BBS software is known to be compatible with C86Net.

     I.2 Purpose
        The purpose of this document is to detail C86Net at the byte level.
     We will only talk about how the protocol should react to each condition.
     We are not going to discuss what each facility "should" be used for,
     although suggestions may be advanced.





                                    -2-






        If you only have a headache when you're done reading this, count
     yourself lucky.  The author will probably know what a year's worth of PMS
     is like.

     II. Overview
        Just about any networking textbook will tell you that most networks
     can be divided into some set of layers (an example, the ISO Standard, is
     fairly well explained in Computer Networks by Tannenbaum), and the
     Citadel-86 Networking protocol is not an exception, in concept.  (NOTE:
     no attempt is going to be made to use network terminology currently in
     use by network experts.  Instead, the terminology I'll use will be what
     I think best describes the subject matter.  As such, this document's
     terminology may change from revision to revision as people discuss and
     argue with me about it.)  Familiarity with such a textbook (or, better
     yet, a real network implementation) is certainly suggested (unless you
     have masochistic tendencies, like I did).

        The protocol seems to break down into just two layers.  The first can
     be termed the "information transfer" layer, or the "link" layer; the
     second can be described as the "application" layer.

                            ---------------------
                            | Application Layer | -  -  -  -  -  -  -  -  -
                            ---------------------
                                     |  |\                      Another _____\
             This node              \|  |                         node       /
                           ------------------------
                           | Information Transfer |  _  _  _  _  _  _  _  _
                           |        Layer         |
                           ------------------------

        The purpose of the Information Transfer Layer is to ensure (to the
     extent possible) that all information that is to be conveyed from and to
     this system's Application Layer from another system's Application Layer
     actually succeeds in transmission.

        The purpose of the Application Layer is to accomplish useful work
     during a networking session with another node.

        It should be apparent that the Application Layer is dependent on the
     Information Transfer Layer.  Despite this dependency, most of this
     document is dedicated to the Application Layer, detailing its facilities,
     due to the fact that the Information Transfer Layer is very simple (not
     necessarily a good sign).

        Whenever the acronym "ITL" is used, assume that it means Information
     Transfer Layer; similarly, the "AL" refers to the Application Layer.

     III. Information Transfer Layer
        As mentioned, the ITL's purpose is to provide a stable communications
     medium.








                                    -3-






        The keyword here is "stable".  In order to achieve this, several goals
     must be accomplished during any given networking session in order for
     overall success to be achieved, and these can be broken into two parts.

        The first part is called "Call Stabilization."  This part of the ITL
     has the goal of establishing the first step of stabilization.  The section
     on Call Stabilization will detail some of the problems associated with
     Call Stabilization.

        The second part is the provision of a transfer medium.  In this
     section, it is best to remember that looking at C86Net from a layer
     viewpoint does not mean that the C86Net was built as a reflection of some
     layer model.  This should lessen confusion.

     III.1 Call Stabilization
        The purpose of this process is to establish quickly and efficiently
     that the caller is another system on the net that wishes to engage in a
     networking session.  The design of call stabilization was driven by whim,
     a wish for efficiency, and experience with earlier versions of C86Net.

        The problems consist of, first, users calling in during networking.
     Call Stabilization is designed to stave off the fumblings of an honest
     user who simply doesn't realize that the networker is in effect by
     forcing a "recognition code" to be given that would be difficult for a
     casual user to generate.

        The second (and last) problem comes from the machines that the network
     was originally implemented on, which are Z-100s and IBMs using MS-DOS.
     During the last few years the marketplace has literally been bombarded by
     modems that can accomodate multiple baud rates (300, 1200, 2400, and now
     9600 looms on the scene), and can signal to the host system what the
     connect baud rate is.

        The modems can typically have two methods of signaling the connect
     baud rate: by sending a unique text string to the host at the serial port
     baud rate, and via signals on the RS232 interface.

        Unfortunately, within my experience the use of the text strings for
     divining baud rate is not completely reliable; and, ridiculously, both
     IBM and Zenith completely neglected to make available the RS232 signals
     on their serial ports that would have allowed the programmer to discover
     the connect baud rate, with the exception of some internal modems on the
     IBM.

        Therefore, Call Stabilization must allow some way for effective baud
     rate connect detection to occur.  The Call Stabilization technique
     currently in use does not seem to be too bad in achieving the objectives.












                                    -4-






        Here is the process (sort of) graphically, right after carrier detect:

               Caller                |                     Receiver
               ------                |                     --------
                           Systems detect carrier
      Wait for full second           |                Wait for full second
      Send following 3 bytes:        |                Begin waiting for the
               7                     |                following three bytes:
               13                    |                        7
               69                    |                        13
      and wait 4 seconds.            |                        69
      If have not received a         |                 After the 4 second
      correct response (see          |                 response wait, the
      Receiver column), then         |                 Receiver can switch
      resend the above 3 bytes.      |                 bauds if necessary.
      This looping process should    |                 If get the above 3
      only be repeated 20 times.     |                 bytes, then respond
      If, on the 20th try, still     |                 instantly with:
      have not received a correct    |                        ~7
      response, HANGUP.              |                        ~13
      If have received a correct     |                        ~69
      response, send an ACK.         |                 and then wait for an
                                     |                 ACK. This should end
                                                       Call Stabilization.

        So, essentially, the caller waits a second, and then sends a 3 byte
     sequence to the receiver.  When the receiver receives those 3 bytes
     successfully, it replies with the logical negation of those 3 bytes.  The
     caller then sends an ACK back, indicating that the call is stabilized.
     If the protocol fails 20 times, then the caller hangs up, assuming
     something was wrong.

        The 7-13-69 sequence only has significance in that a casual user
     probably won't generate it accidentally.

     III.2 Transfer Medium
        The purpose of this part of the ITL is to provide a stable means of
     transporting information to and from the other node that the networking
     session is concerned with.

        Take it as a caveat that this is neither "clean" or "elegant" by
     any stretch of the imagination.  Just take a deep breath and start
     reading (particularly if you're a networking professional!).  Also, this
     is going to be difficult, seeing that I have troubles explaining it
     coherently myself.  However, considering the fact that adding new
     facilities to the Applications Layer has been simple as of late, I must
     assume that SOMETHING is being done right here.












                                    -5-






        The Transfer Medium takes some stream of information and attempts to
     transfer it to another system.  As such, it is under strategic control of
     the Application Layer in terms of when to start and when to stop; another
     way to explain it is that the Application Layer will tell it to start
     sending some stream of data, will tell it to stop sending, will tell it
     to receive information from the other system, etc.  Details of when to
     send, when to receive, etc., are contained in the sections on the
     Application Layer, and will not be treated further in this section.

        One of the responsibilities of the Transfer Medium is to place no
     interpretation on the data that is being received from, or sent to, the
     other system involved in networking; the Transfer Medium only takes the
     data and sends it to the other system's Transfer Medium, or receives the
     data and sends it "up" to the Application Layer of the host system.  The
     Application Layers involved make decisions as to what is to be done with
     the data.

        So, what is the structure of the ITL Transfer Medium?  C86Net
     currently uses Ward Christiansen's XMODEM protocol to transfer data.
     Each time the system wishes to transfer or receive some data, it uses
     XMODEM, telling it to expect or send a 'file'.

        At the risk of confusing the readers, let's hop ahead and state that 
     the AL uses the ITL to Facility Requests to and from nodes, sending each
     Facility Request when needed.  Each Request is, or should be, treated by
     the ITL as a separate file.  Therefore, the ITL should send, or receive,
     each Request as a new file (where it stores it is an implementation
     detail), with a new block 1, etc.  We'll try to provide details at the
     end of this document.

        XMODEM-Checksum is used in ITL, not CRC.  However, CRC should function
     with no problems.

        At this time, there are no alternative ITL transfer formats.  However,
     consideration is being given to making SEA's SEAlink protocol an
     alternative.  Any use of SEAlink in C86Net will not make those nodes
     incompatible with older nodes on a C86Net; the change can and will be
     made to be backward compatible.  So if you are trying to implement C86Net
     on your system and don't want to try to implement SEAlink, don't panic.

     IV. Application Layer
        The Application Layer (AL), via the ITL, manages all of the work that
     is to take place during a network session.
















                                    -6-






     IV.1 Overview
        The following diagram graphically demonstrates the flow of control
     during a C86Net network session.  Assume, of course, that this is a
     minimal diagram. The references to the ITL are provided for completeness'
     sake and context.

       -----------------
       |     CALL      |                ITL Territory
       | STABILIZATION |       _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
       -----------------      /
               |             /          AL Territory
       _ _ _ _ | _ _ _ _ _ _/
               |                RECEIVER TELLS CALLER CAN'T HANDLE COMMAND
               |                    ____________________<___________
               |                    |                              |
       ----------------     ----------------     ------------      ^
       | CALLER SENDS |_>___| CALLER SENDS |___>_| RECEIVER |___>__|
       | ID & NAME    |     |   COMMAND    |     | RESPONDS |      |
       ----------------     ----------------     ------------     \|/
                                   |                               |
                                   |                               |
                                   |                        --------------
                                   |                        |  RECEIVER  |
                                   |                        |  TELLS     |
                                   ^                        |  CALLER    |
                                   |                        | CAN HANDLE |
                                   |                        |   COMMAND  |
                                   |                        --------------
                                   |                               |
                                   |                               |
                                   |  UNLESS COMMAND IS    ----------------
                                   _____________<__________| DO SPECIFIED |
                                         'HANGUP'          | ACTION       |
                                                           ----------------

        Call Stabilization has already been covered (III.1), so we shan't
     speak of it further.  The diagram can be summarized as: caller identifies
     itself, and then begins sending a sequence of Facility Requests.  Each
     Request is dealt with by the receiver as received, and implies some set
     of actions that both systems are aware of.  Each Request's actions are
     documented in this document.

     IV.2 ID & Name
        After receiving the ACK indicating end of Call Stabilization, the
     calling system must identify itself to the receiver.  The caller sends,
     in this order, nodeId & nodeName to the Transfer Medium, telling it to
     send them to the receiver.

        nodeId, nodeName: Are normal null-terminated C strings.

        Neither the nodeId nor nodeName may exceed 20 bytes in length
     (including the null byte terminating each string); therefore, the total
     bytes of significant data that the AL must deal with should not exceed 40.
     This also implies that the ITL should not send more than a sector
     (128 bytes) worth of data.




                                    -7-






        So, for example, let's say that a system using the nodeName "Buffalo"
     and with a nodeId of "US 612 477 0927" called some other system. After
     the WC session was over, the receiver's buffer or temporary file would
     look like this

          Id            name
     US 612 477 0927<0>Buffalo<0> <-balance of the sector is trash->

     IV.3 Facility Requests
        After the caller identifies itself, the two systems go into a loop.
     Each loop starts with the Caller sending a Facility Request.  A Facility
     Request at the AL layer consists of at least one byte, which contains a
     code indicating the Facility requested, and up to four optional
     parameters which are used to convey other data required for the Facility.
     Each of these parameters are normal C null-terminated strings, and none
     may exceed more than 20 bytes in length, including the ending null byte;
     they may be smaller if the entire 20 bytes is not needed.  The last of
     the optional parameters, be there 0 or 4 of them, is always followed by a
     0 byte.  A Facility Request that does not require any parameters would
     look like this at the Application Layer:

       <facility-byte><0>

     and a Facility Request that needs two parameters would look like this:

       <facility-byte><string1><string2><0>

        At the ITL level, the Facility Request byte comes first, followed by
     each parameter; the rest of the sector is trash.

        The receiver, on receipt of the facility request, must decide if it
     can execute the facility requested by the caller.  If so, the receiver
     just sends back one byte, called GOOD, and then the network session
     proceeds along the lines implied by the facility.  If the receiver cannot
     executethe facility requested, it sends back a byte called BAD followed
     by a null-terminated string < 126 characters which explains why the
     facility cannot be executed.

       <Good>

       <Bad><error string>

        The actual values of GOOD and BAD are

      BAD:  0
      GOOD: 1

        Section IV.5 through IV.9 detail all facilities currently supported by
     Citadel-86 in C86Net, plus some proposed facilities.










                                    -8-






     IV.4 Message & File Transfer
        When "transfer of messages" is mentioned below, the meaning is that a
     series of 0 or more messages are to be sent from one system to the other.
     When the number of messages is 0, then it is not necessary to do more
     than start and stop the ITL, which should be interpreted by the system
     receiving the 0 messages to mean that 0 messages were received.

        When one or more messages are being sent, each should be in the format
     detailed in Appendix A.

        When more than one message is being sent, there should be no separator
     between messages, due to the format that messages are sent in.  Due to
     the current character of the ITL, the reality of networking leaves us with
     last sectors of which zero or more bytes will be trash.  Therefore, when
     transferring messages, the balance of the last sector which has no meaning
     can either be ^Z filled (vis a vis XMODEM rules) or space-filled.

        A file transfer implies that one or more files are being sent.  There
     is no data transformations applied to files at the AL layer, i.e., they
     are sent (conceptually) byte by byte to the ITL for transfer.  The ITL,
     being what it is, does not currently perform any transformations.  In the
     future, it may, but the ITL has the responsibility of ensuring that
     transformations inserted by the ITL are taken out before termination of
     the ITL.

        Really, that may sound bad, but it's very easy.  "Clean up after
     yourself."

     IV.5 Network Session Control Facilities
        These facilities are used to control the overall behavior of a network
     session.

     IV.5.a Hangup command
        This facility is a simple 1-byte command that tells the receiver to
     hang up.  Unfortunately, the behavior of the receiver for this facility
     depends on the state of the network session.  If this facility is used
     during usage of Role Reversal, then it signals the end of the Role
     Reversal facility, and the receiver should send back a GOOD byte (see
     Section IV.5.c).

        If this facility is not used during usage of Role Reversal, then the
     receiver does NOT send back either a GOOD or BAD byte.  Instead, it just
     hangs up (i.e., terminates the Network session).

        The value of the Hangup byte is 0.














                                    -9-






     IV.5.b Error Code Support
        This Request asks the receiver if his system can transmit Error Code
     responses to Requests. This Request must be exercised and accepted as
     GOOD before the receiver can use the Error Code response instead of the
     BAD response when reporting his ability to support a particular facility
     requested.

        The value of the Error Code Support byte is 200.

        Citadel-86 does not currently support this facility.

     IV.5.c Role Reversal
        In order to make networking more efficient in nets that are using room
     sharing concepts, it has become a necessity to allow "role reversal"
     during the networking period.  The term "role reversal" means that during
     the period of a call, two systems, supposing they are adequately
     equipped, may exchange their roles of "caller" and "receiver", and then
     continue to network, with the real receiver now becoming the "caller",
     and vice versa.  All services should be supported under role reversal.

         When role reversal is agreed upon by the two systems (this is defined
     to be the point at which the receiver has replied GOOD to the caller),
     the two systems now switch roles.  The caller, who has now become the
     receiver, now starts waiting for the first facility request from the
     receiver, who has now become the caller.

        The caller and receiver should, of course, be aware of who is who;
     this is why the stage of CALLER SENDS NAME & ID is skipped during role
     reversal.

        The end of role reversal is signaled by the original receiver (now the
     caller) by sending the HANGUP command.  The original caller (now the
     receiver) acknowledges this (reply GOOD), and at this point, the two
     again reverse roles. Note that the HANGUP command has been modified in
     this one contextual instance to act different from its normal behavior.

        The value of the Role Reveral byte is 201.

     IV.6 Data Transfer Facilities
        These facilities support transfer of various sorts of data between
     nodes.

     IV.6.a Normal Mail
        This facility is a parameterless facility which is designed to allow
     transfer of Mail> from the transmitter to the receiver.  If the receiver
     signals that it can receive Mail>, then the transmitter should begin
     transmitting all Mail messages destined for the receiver via the ITL.

        The value of the Normal Mail byte is 1.

     IV.6.b Room File Requests
        This facility is used to request one file from the receiver.  It has
     two parameters, the name of the room that the file is located in
     (parameter 1), and the name of the file to be transferred (parameter 2).





                                    -10-






        If the receiver is willing to transfer the specified file to the
     transmitter, it should send back a GOOD byte, and then tell the ITL to
     send the file to the transmitter, which should be ready to receive the
     file.

        If the receiver will not or can not satisfy the request, then it should
     return a BAD byte.  The reasons for not satisfying this request are, of
     course, implementation dependent, but they can include such reasons as
     non-existence of room, non-existence of file, sheer peevishness, etc.

        This facility is an anachronism, retained for backward compatability.
     The facility Ambiguous Room File Requests is a better choice.

        The value of the Room File Request byte is 2.

     IV.6.c Ambiguous Room File Requests
        This facility is an expansion of IV.6.b, and very similar to it.  It,
     too, has two parameters, the first the name of the room and the second
     the name of the file requested.  However, the second parameter can safely
     be used to specify an ambiguous set of files if the user so chooses.

        If the receiver consents to send the requested files to the
     transmitter, then it should send back a GOOD byte.  At this point, the
     procedure diverges from that used in IV.6.b.  For each file to be sent to
     the transmitter by the receiver, it first sends via the ITL two strings
     (null-terminated), which, in order, are the name of the file, and the
     size of the file in 128 byte sectors.  If the file SEX.ED was 12877 bytes
     long, the receiver would send

                    SEX.ED<0>101<0>

        These two strings constitute in themselves a separate transfer; in ITL
     terms this means a separate XMODEM transfer, as if we were sending a
     single file just ahead of the real file.

        The transmitter does nothing but receive these pairs for each file that
     it will receive.  When the receiver has no more files to send that would
     satisfy the request for files, it sends one more of the pre-file headers,
     in which the length of the file name is 0.  This indicates the end of this
     facility.

        The value of the Ambiguous Room File Request byte is 3.


     IV.6.d Ambiguous Room File Requests With Approval
        This is a non-implemented facility, which is not yet completely
     defined.
        The value of the Ambiguous Room File Request With Approval byte is 4.











                                    -11-






     IV.6.e Network Room
        This facility is used to send 0 or more messages from one system to
     another for a specified room.  The room that these messages are coming
     from is the sole parameter of this facility. If the receiver is willing
     to accept the messages for delivery to the room on the receiver's system,
     it replies GOOD to the caller, and then begins data transfer of the
     messages in the same manner as it would for Mail transfer.  It it does
     not wish to accept the messages (for whatever reason) from the caller, it
     then replies BAD.

        The value of the Network Room byte is 5.

     IV.6.f Check Mail
        The Normal Mail facility does not contain any provisions for checking
     to see if Mail messages that were sent can be delivered to the designated
     recipients. This command provides that facility.  If the receiver chooses
     to accept this command, it should send a GOOD byte, and then cycle
     through the Mail messages received from the caller.  For each message
     that can not be delivered, the receiver should send back a byte and three
     strings which describe the reason that the Mail cannot be delivered.  The
     three strings, in the order that they should be sent, should contain the
     following information:

             String 1: Author of the Mail> message.
             String 2: Recipient of the Mail> message.
             String 3: Error "context."  This field should contain a message
                       that describes (in English) something useful about the
                       error.  Citadel-86 currently fills this with the date
                       and time of the message, suitable for sending to the
                       author of the failed message.

        All three of these strings must be present.  Any or all of the three,
     however, may be of 0 length.  None may exceed 20 characters in length
     (including the 0 byte).

        The values of the byte are:

      NO_RECIPIENT    1  -- This reason indicates that there is no such
                            recipient on the Receiver system. Note that the
                            second string following this reason byte normally
                            contains the name of the recipient that could not
                            be found.
      BAD_FORM        2  -- This reason indicates that there was no "To" field
                            in the message.  Usually is a symptom of
                            programming error.
      UNKNOWN         99 -- Something really* odd happened.  The context
                            string (#3) should perhaps contain the number (on
                            the Caller system) of that message, so that it may
                            be investigated later.

        After all of the negative acknowledgements of Mail> have been sent
     back, the receiver sends one more byte, which is called the NO_ERROR
     byte. It indicates that there are no more errors to be sent to the
     transmitter.  If there were no bad Mail messages in the first place, then
     the only real data that the receiver would return to the transmitter
     would be the NO_ERROR byte.  The value of the NO_ERROR byte is 0.



                                    -12-






        All negative acknowledgements, plus the NO_ERROR byte, are sent as a
     single stream of data, not as separate ITL transfers!

        The value of the Check Mail byte is 6.

     IV.6.g Send File
        This facility allows the sysop to send a file to another system.
     There are three parameters associated with this request: The name of the
     file that the sender wishes to send to the receiver, and the size of the
     file, first in terms of sectors (CP/M compatibility, if ever any CP/M
     Citadels wish to join the net), and then in just bytes. (Remember, these
     are really just ASCII strings.)

        The file is sent only upon positive acknowledgement of this request.
     However, it should not be assumed that a negative response implies that
     the facility is not supported.  Since the size of the file is sent along
     with the request, the receiver may decline to receive the file due to
     space considerations, but could receive a smaller file.

        The value of the Send File byte is 7.

     IV.6.h Alternate Room Sharing
        This facility was motivated by the LD room sharing network, due to the
     fact that a system that is willing to absorb the expense of sharing rooms
     at LD may not be willing to support the additional costs that could occur
     from the role reversal command (for instance, very large files being sent
     or requested by the receiving system).

        This facility solves the above problem.  Succinctly, it notifies the
     receiving system that the caller wishes to share the specified room.  Upon
     receiving a positive acknowledgement, the caller proceeds to send all
     net messages that should be sent to the receiver.  When finished, the
     receiver sends all net messages meant for the caller for the specified
     room.  This is most commonly used for C86Net routing.

        Usually, messages from systems other than the two involved in the
     network session will be passed to other systems using this Facility.

     The value of the Alternate Room Sharing byte is 8.

     IV.7 ITL Alternate Realities
        These commands will be used to attempt to change to different
     communication protocols at the ITL level.  Since only the basic XMODEM
     style of ITL is currently supported, there are no entries in this
     section. However, byte value 100 is reserved for future use in connection
     with facilities of this type.

     IV.8 Security
        These facilities address security concerns on the network.










                                    -13-






     IV.8.a System Net Password
        This facility provides a rough security system by allowing a string
     designated to be a password to be sent by the caller to the receiver.
     The protocol itself does not designate what a bad (or good) password
     should mean to the receiving system; this is up to the implementors.  As
     an example, the implementor of Citadel-86 has made the following
     decisions (this is [or should be] detailed in NETWORK.DOC):

      o If there is no password listed for this system, and none is sent, or a
        zero-length password is sent, then the caller is assumed to be
        validated, and all commands will be whole-heartedly executed.
      o If the caller sends a password that matches (non case-sensitive) with
        the password that the receiver has recorded for the caller, then the
        caller is validated and all commands will be executed.
      o If the caller sends a password that does not match, then the receiver
        will do nothing useful during role reversal, and will not respond
        positively to role reversal requests.

        Technically, this command is very simple.  The caller sends the
     command byte to the receiver, and the first parameter of the command byte
     contains the password (<= 20 including terminating NULL).  The receiver
     ALWAYS responds positively, whether or not the password matches.

        The value of the System Net Password byte is 202.

     IV.9 Other Reserved Facility Byte Values.
        Byte values 20 - 30 are reserved for STadel routing.

        Before using any other byte values, please try to coordinate with
     whomever else is implementing C86Net.

     IV.10 Facilities -- Short List
            Name    |     Byte Value  |   Description
            ----    |     ----------  |   -----------
     Hangup         |         0       |   End a network session or role
                    |                 |           reversal.
     Error Code     |       200       |   Alternate error reporting (not
                    |                 |           implemented on Citadel-86).
     Role Reversal  |       201       |   Allow reveral of roles during call.
     Normal Mail    |         1       |   Send Mail.
     File Request   |         2       |   Request a File.
     Ambiguous FR   |         3       |   Ambiguous File Request.
     AFR w/ approval|         4       |   Ambiguous File Request With Approval
                    |                 |           (not implemented).
     Network Room   |         5       |   Send messages from room to system.
     Check Mail     |         6       |   Check Mail previously sent.
     Send File      |         7       |   Send File to system.
     Alt Room Net   |         8       |   Share room alternate system (routing).
     System pwd     |       202       |   System password.
     STadel         |       20-30     |   orc's evil purposes.
        reserved








                                    -14-






     V. Minimal Compatability Requirements
        In order for a system to be compatible with C86Net at a minimal level,
     it must satisfy requirements at the ITL and AL levels.

        At the ITL level, it must be able to call stabilize and use the XMODEM
     style of transfer for all facilities supported at the AL level.  This
     includes the SYSTEM ID that follows call stabilization.

        At the AL level, technically the minimum facility support that you
     need is only the Hangup facility (Section IV.5.a).  However, that's
     hardly useful, so a practical minimum would be the Hangup and Mail
     commands.


     Appendix A.  Message Transfer Format
         The format for all C86Net messages on the net
     consists of a collection of C strings (text followed by a null) that
     represents all the data associated each message.  Each field is
     identified by the first character of text in that field, and each
     identifier is unique. The fields may come in any order, with the
     exception that the Message text field is the last field. Any data
     following the null byte that ends the Message field is assumed to be
     part of the next message.

        All data is straight ASCII, ended with a null byte, including those
     fields that could be encoded in binary.

        The following fields and identifiers are currently supported.

      Identifier        Data                                 Max Length
      ----------        ----                                 ----------
      'A'          Author of current message.                20
      'D'          Date on which message was written.        20
      'N'          Name of system which message was          20
                    written on.
      'O'          ID of system which message was written    20
                    on (i.e., "US 612 866 1804").
      'R'          Room which message was originally         20
                    written in.
      'S'          Message ID on source system, in old       20
                    CP/M Citadel 8-bit style (i.e., 32 bit
                    number split into two 16 bitters.  See
                    below in the example).
      'T'          Recipient of message (normally for        20
                    private Mail).
      'C'          Time message was written.                 20
      'M'          Message text, all CRs changed to Line     7499, should not
                    Feeds.                                         be limited,
                                                                   though.
      'Z'          STadel reserved                           ??

        In the above table, the MAX LENGTHS include the NULL byte.







                                    -15-






        So, a message on Test System (nodeId US 612 866 1804, nodeName 'C86
     Test System') that looks like this:

        86Feb01 @ 10:01 from John Flash in Other Citadels>
        This is a test.


      with a message ID of 5644 might look like this during transmission on
      the net:

      D86Feb01<0>C10:01<0>S0 5644<0>NC-86 Test System<0>OUS 612 866
      1804<0>AJohn<space>Flash<0>ROther Citadels<0>MThis is a test.<LF><0>

        Clear as mud, right?

     Appendix B.  Examples!
        The following are examples for selected facilities, in order to
     illuminate what may be otherwise very bewildering examples.  Not all
     of the facilities are covered.

        Many of the facilities will show examples at two levels:  a high level
     displaying the "file" flow used, and a low level view examining the
     contents of certain data and control packets.  Throughout the examples,
     the term "file" means an XMODEM session is completed, starting with block
     #1 and ending with block N and an EOT.  This may be an actual file being
     transferred, as will happen with File Requests, or it may mean a series
     of messages being transmitted, which may or may not be stored as a file,
     depending on the implementation, or it may refer to control information
     (such as a Facility Request), which again could be stored as a file on
     disk, or stored in a temporary RAM buffer.

        The abbreviation FR stands for Facility Request below.  In all cases
     below, unless otherwise noted, it assumes that all Facility Requests are
     positively acknowledged.

     B.1 Call Stabilization
        The following illustrates a call in which the first attempt at call
     stabilization fails because the receiver, a 300/1200 system which cannot
     directly detect the baud of the caller, started looking at 300 baud, while
     the caller is at 1200.

          CALLER                    RECEIVER
               <The systems connect!>
        <7><13>69> -->              receives garbage, switches to 1200 after
                                    4 seconds
         Times out at 4
         seconds
        <7><13>69> -->              Receives sequence
         Gets confirmation     <--  <~7><~13><~69>
          <ACK> -->                 Receives ACK

             CALL STABILIZATION COMPLETED







                                    -16-






     B.2. ID & Name
        From a high level, caller identification flow control is very simple.

        CALLER           RECEIVER
             == <file> ==>

        The length of file in this case should never exceed a single XMODEM
     sector.  The contents should look like this:

         <C-string: nodeId><C-string: node name><trash>

        Suppose the node name of a system was Dandelion Wine, and the node id
     was US 612 732 4419.  Then the ID & Name "file" would contain

         US 612 732 4419<0>Dandelion Wine<0><irrelevant trash>

     B.3. Normal Mail
        At a high level, here is the sequence of file transfers.

           CALLER           RECEIVER
         == file: FR == >
                      <== file: GOOD ==
         == file: Mail> messages == >

        At a low level, the file: FR should only have a length of one sector
     (as should all FRs), containing:

        <1><0><126 bytes of irrelevant trash>

        The file: GOOD should contain the following:

        <1><127 bytes of trash>

        Since that's all that a GOOD reply should ever contain, we shall not
     explain that again.  Refer to Appendix A for an explanation of the
     appearance of file: Mail> messages.

     B.4. Ambiguous Room File Requests
        Here is the high level view of this facility:

           CALLER           RECEIVER
         == file: FR == >
                      <== file: GOOD ==
                      <== file: File #1 header ==
                      <== file: File #1 ==
                            ...
                      <== file: File #n header ==
                      <== file: File #n ==
                      <== file: File header with empty string ==

        For a low level examination, let's assume that the Caller asked for
     *.doc in a room called Whatever>.   The file: FR would then contain

        <3>Whatever<0>*.doc<0><0><irrelevant trash>





                                    -17-






        Now let's suppose that the RECEIVER has decided that the files SEX.DOC
     and GARBAGE.DOC match with *.doc in Whatever>, with sizes of 100,909 and
     32,555 bytes. File #1 header would contain

        SEX.DOC<0>789<0><irrelevant trash>

     while File #1 itself would be the contents of SEX.DOC.  File #2 header
     would contain

        GARBAGE.DOC<0>255<0><irrelevant trash>

     while File #2 would be the contents of GARBAGE.DOC.  File #3 header,
     since no more files need to be sent, would contain

        <0><irrelevant trash>

     and that would constitute the end of this Facility.

     B.5 Network Room
        From a high level viewpoint, this Facility looks like this:

           CALLER           RECEIVER
         == file: FR == >
                      <== file: GOOD ==
         == file: messages == >

        The contents of the FR for a room named Philosophy would be

         <5>Philosophy<0><0><irrelevant trash>

     B.6 Check Mail
        From a high level viewpoint, this Facility looks like this:

           CALLER           RECEIVER
         == file: FR ==>
                      <== file: GOOD ==
                      <== file: acknowledgements ==

        The content of the FR would simply be

           <6><0><irrelevant trash>

        Let's look at the example that all the Mail messages transferred
     earlier could be delivered.  The content of file: acknowledgements
     would then be

            <0><irrelevant trash>

     which would result in a single sector being returned to the transmitter.
     Now let's suppose that two Mail messages could not be delivered.  One was
     addressed to Curly, while the other was addressed to Moe, both from
     Mikey.  Then the file: acknowledgements would contain

       <1>Mikey<0>Moe<0>87Oct08 @ 4:04<0><1>Mikey<0>Curly<0>87Oct07
       @ 23:13<0><0><irrelevant trash>




                                    -18-






     B.7 Send File

        From a high level viewpoint, this Facility looks like this:

           CALLER           RECEIVER
         == file: FR ==>
                      <== file: GOOD ==
         == file: file ==>

        The contents of the FR for a file named GURGLE.NOT, size 13,934 bytes,
     would be

          <7>GURGLE.NOT<0>109<0>13934<0><0><irrelevant trash>

     B.8 Alternate Room Sharing
        From a high level viewpoint, this Facility looks like this:

           CALLER           RECEIVER
         == file: FR ==>
                      <== file: GOOD ==
         == file: messages ==>
                      <== file: messages ==

        For a room named Horse Trading, the FR would look like

          <8>Horse Trading<0><0><irrelevant trash>

        The file: messages would be the messages to be sent from the
     transmitter to the receiver, first, and then from the receiver to the
     transmitter.

     Appendix C.  BBS Software compatible with C86Net
        The following BBS packages are known to be at least minimally
     compatible with C86Net.  Consult their documentation to find out how
     many facilities each supports.

      Name                 Home base          Number           Baud rates
      ----                 ---------          ------           ----------
      Citadel-86           C-86 Test System   (612) 866-1804   3/12/24
      NeoCitadel           SuperComp II       (612) 431-1107   3/12/24
      Amiga Citadel-68K    The Phoenix        (612) 459-8095   3/12/24
      STadel               Pell               (612) 377-9239   3/12

     Appendix D. Main C86Net
        All four of the homebase systems listed in Appendix C participate in
     what may best be termed the main C86Net, to which all systems are invited
     to participate in.  This net runs from 3:00 AM to 3:45 AM Twin Cities
     time, 7 days a week.  Most of the systems participating in that network
     are located in the Twin Cities network, and share a number of rooms for
     various purposes, but there are several other systems networking with the
     Twin Cities, some of which also share rooms.

        There is also a small adjunct net which networks from 3:45 AM to
     4:00 AM, every night, for the purpose of LD room sharing routing.





                                    -19-



