#! /usr/local/bin/perl 
# 
#   simx - search SIMTEL index
#
#   ejk 12/93   1.0 version
#   msz 4/94  added     Local vs. Primary Mirror Directory label
#		1.1	Fixed bug - on test to die if simibm.idx not found
#			Added IDX env. var. & changed code to use 1st idx file
#		1.2	Fixed bug - usage didn't print if simibm.idx not found
#		1.3	Added -m option for perl pattern match expressions

#---Configuration variables----------------------------------------------------
#
#   @IndexFiles - possible paths for SIMTEL index files
#
#   %NFSPath - possible NFS mount points and directory paths for SIMTEL. 
#              If a mount point exists, the corresponding directory path
#              will be included in the printout. 

@IndexFiles = split(/[\s\n]+/, <<'-30-'); #insert paths between here and -30-
./simibm.idx   /pub/pc/simtel/simibm.idx 
/micro/lists/simibm.idx /tmp/simibm.idx
/nfs/ftp/pub/pc/simtel/simibm.idx
-30-

$NFSPath{'/nfs/wuarchive'} = '/nfs/wuarchive/systems/ibmpc';
#---End Configuration variables------------------------------------------------

sub usage { die <<'-30-';
simx (Version 1.3) - search SIMTEL index by keywords and/or date
----------------------------------------------------------------
simx [-c] [<keywords>] [since yymmdd] [ | more ]
simx -m '<perl pattern match expression>'

-c            Make keyword search upper/lower case sensitive

<keywords>    One or more keywords or word fragments, optionally preceded
              by 'not', linked by 'and' or 'or' if more than one

since yymmdd  Report only items dated on or after the specified date
   
Examples:
simx norton                #items matching 'norton', 'Norton', etc
simx since 931201          #all items dated after Dec 1 1993
simx virus since 930101    #virus items dated after Jan 1 1993
simx object or c++ or OOP  #object-oriented items
simx -c OOP                #items matching 'OOP' (but not 'snoop', 'loop', etc)
simx -m '/editor/i && /vi[ -]/i' # Vi or VI editors (not 'video', 'view' etc)
simx norton and not guide since 920601 #Norton but not guides since June 1 1992
-------------------------------------------------------------------------------
-30-
}

#---Generate usage information if no arguments
&usage unless $ARGV[0];

#-Add contents of IDX environment variable to the front of the list if it exits
if ($_=$ENV{'IDX'}) {splice(@IndexFiles,0,0,$_);} 

#---Search for and open SIMTEL index file
for $f(@IndexFiles) { 
	if ( -r $f )  {
	     $SimX = $f ;
             print "Using index file $f.\n" if $ENV{'SIMX_DEBUG'};
             last; 
             } # Use first readable index
	  else   {
	     print "Index file $f not found.\n" if $ENV{'SIMX_DEBUG'};
	  }
	}
        print "\n" if $ENV{'SIMX_DEBUG'};
die "The SimTel index could not be found in any of the directories specified\n" 
 . "in simx.  This could mean a remote filesystem is temporarily unavailable.\n"
 . "Try specifying the location of a simibm.idx file using the IDX\n"
 . "environment variable.  e.g. setenv IDX /directory/of/your/simibm.idx\n"
    unless $SimX  ;
#open(SimX, $SimX) || die "$SimX: $!\n";
if (!open(SimX, $SimX) ) { die "$SimX: $!\n"; }


#---Set for case insensitive or sensitive searching
$case = 'i'; if ($ARGV[0] eq '-c') { $case = ''; shift; }

if ($ARGV[0] ne '-m') {

#---Form match argument string, check for and remove 'since yymmdd' clause
$match = join(' ', @ARGV);
while($match =~ /since (\d+)/) { $Date=$1; $match =~ s:since $Date::; }

#---Change every word to Perl match phrase
$match =~ s:((\w|[-\./+])+):m~$1~$case:g;

#---Escape regular expression metachracters in keyword
$match =~ s:([+.]):\\$1:g;

#---Convert 'and', 'or', 'not' to Perl operators
$match =~ s:m~and~$case:&&:g;
$match =~ s:m~not~$case:!:g;  
$match =~ s:m~or~$case:||:g;

#---Add Perl equivalent of 'since yymmdd' if present
$match = '1' unless $match;
$match = qq|($match) && /,(\\d\\d\\d\\d\\d\\d),"/ && \$1 ge $Date| if $Date;

}
else {
$match = $ARGV[1];
}
#---for debugging or user curiosity
print "Perl pattern match regular expression:\n$match\n" if $ENV{'SIMX_DEBUG'};

#---Check for NFS-mounted SIMTEL
for $d(keys(%NFSPath)) {
   $time0 = time; 
   $SimDir = $NFSPath{$d} if -d $d;
   warn "$d NFS timed out\n" if (time - $time0) > 30; 
   }

#---execute search/print loop 
#
#  (Note: eval of entire loop is faster than eval of $match within a loop.)
#
eval("while(<SimX>) { &print(\$_) if $match; }");

sub print {
   chop; s/["\r]//g; 
   ($dev,$dir,$file,$dummy,$size,$type,$date,$comment) = split(/,/,$_,8);
   $dev = "$SimDir/" if $SimDir;
   $devdir = qq|$dev$dir|;
   $at = ($type == 8) ? 'B' : 'A';
   if ($devdir ne $ldevdir) {
     if ($SimDir) { print "\nLocal "; } else { print "\nPrimary Mirror "; };
     print "Directory $devdir\nFilename    Type Length  Date    Description\n"
           . ('=' x 79) . "\n" ;
     }
   printf("%-12s %s  %7d  %s  %s\n", $file, $at, $size, $date, $comment);
   $ldevdir = $devdir;
   }
