/*************************************************************************
* Global definitions of	GraphGen.c for all the world...			 *
*************************************************************************/

#ifndef	GRAPH_GEN_H	/* Define only once */
#define	GRAPH_GEN_H

/* The following conditional compilation flags are also in GraphGen.c!       */
/* #define NOGRAPHICS	   /* If no graphics to perform (only routine calls) */
/* #define NOWINDOWS		    /* If no windows routines to be included */
/* #define NOMENUS		      /* If no menus routines to be included */
/* #define NOHELP		 /* If no print help routines to be included */
/* #define DEBUG		   /* Print graphics driver info and dies... */
/* #define SINGLEPAGE	       /* If more than one pages should be supported */

#define	MENU_MAX_ITEMS 14		  /* Maximum number of items in menu */
#define	MENU_MAX_LEN   20		   /* Maximum length of string entry */

typedef struct MenuItem	{
   int color;
   char	string[MENU_MAX_LEN];
} MenuItem;

extern	int    GGGraphMode;			  /* The Graphics mode value */
extern	double GGAspectRatio;	    /* Aspect ratio of a pixel in the screen */
extern	int    GGScreenMaxX, GGScreenMaxY; /* The maximum res. of the screen */
extern	int    GGScreenMaxColors;	/* The maximum # of colors available */
extern	int    GGScreenMaxPages;	 /* The maximum # of pages available */
extern	int    GGScreenErrorCode;	      /* Reports any graphics errors */
extern	struct palettetype palette;	        /* Used to read palette info */
extern	int    GGCurrentCursorX, GGCurrentCursorY;/* Cursor current position */
extern	int    GGScreenGraphicMode;	  /* TRUE if current mode is graphic */

#ifndef	TRUE
#define	TRUE	-1
#define	FALSE	0
#endif

#define	MSG_AREA_X      1.25		    /* General notes goes to here... */
#define	MSG_AREA_Y     -0.9
#define	MSG_AREA_WIDTH  0.7

#define MAX_HELP_MENU_CHAR 20		   /* Maximum of chars per help line */

#define MENU_FRAME_COLOR	RED
#define HELP_COLOR		CYAN
#define HELP_COLOR_HEADER	YELLOW

#ifndef	NOWINDOWS

#define SW_MIN_X	1.2				/* The STATUS window */
#define SW_MAX_X	2.0
#define SW_MIN_Y	-0.97
#define	SW_MAX_Y	0.97
#define SW_FRAME_COLOR	LIGHTRED
#define SW_LINE_COLOR	MAGENTA


#define VW_MIN_X	-0.97				  /* The VIEW window */
#define VW_MAX_X	1.1
#define VW_MIN_Y	-0.97
#define	VW_MAX_Y	0.97
#define VW_FRAME_COLOR	LIGHTGREEN
#define VW_LINE_COLOR	GREEN

#endif	NOWINDOWS

/* And finally the external routine prototypes: */

void GGMyMove(double x, double y);
void GGMyDraw(double x, double y);
void GGMySetColor(int color);
void GGInitGraph(void);
void GGCloseGraph(void);
void GGGetPoint(double *x, double *y);
void GGDrawPoint(double p[], char title[], int PointColor);

#ifndef NOMENUS
int GGMenuDraw(int n, struct MenuItem m[], int erase);
int GGMenuPick(void);
int GGConfirm(char *s);
#endif	NOMENUS

#ifndef NOHELP
void GGPrintHelpMenu(char *FileName, char *MenuName);
#endif	NOHELP

void GGClearMenuArea(void);
void GGClearViewArea(void);
void GGClearAllScreen(void);
void GGViewPortMenuArea(void);
void GGViewPortViewArea(void);
void GGViewPortAllScreen(void);
void GGPutErrorMsg(char *s);
void GGPutMsgXY(char *s, double x, double y);
void GGGetGraphicLine(double x, double y, char s[], int color);
void GGTone(int Frequency, int Time);

#define GGXYPutStr(x, y, s) GGPutMsgXY(s, x, y)/* Same duty - different name */

#endif	GRAPH_GEN_H
