/*****************************************************************************
*   definitions for program to draw a function given as Y = f(X) or          *
* X = f(t), Y = f(t) .                                                       *
*                                                                            *
*   Written be :  Gershon Elber                          Ver 0.1, Mar. 1988  *
*****************************************************************************/

#ifndef DRAW_FUNC_H
#define DRAW_FUNC_H

#include "Expr2Trg.h"

#ifndef	NULL
#define	NULL	0
#endif

#ifndef	TRUE
#define	TRUE	-1
#define	FALSE	0
#endif

#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define MIN(x, y)	((x) > (y) ? (y) : (x))
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max) (MIN(MAX((x), (Min)), (Max)))

#define INFINITY	1e6
#define EPSILON		1e-6

#define DEG2RAD(Deg)	((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)	((Rad) * 180.0 / M_PI)

#define BSPACE	8
#define TAB	9
#define LF	10
#define CR	13
#define ESC	27

#define XY_FUNC_T	1	       /* Input Kind is X = F(T) ,  Y = F(T) */
#define Y_FUNC_X	2			   /* Input Kind is Y = F(X) */

#define LINE_LEN	80			      /* Maximum line length */
#define LINE_LEN_LONG 1024 /* Used to save derivatives (might be loonnngggg) */
#define FILE_NAME_LEN	80

#define ERROR_COLOR	RED			  /* Color of error messages */
#define READ_COLOR	CYAN		      /* Color from requesting input */

#define AXES_COLOR	BLUE

#define FUNC_COLOR	MAGENTA				/* Color of function */
#define FUNC_DER1	RED			/* Color of first derivative */
#define FUNC_DER2	GREEN		       /* Color of second derivative */
#define FUNC_DER3	YELLOW			/* Color of third derivative */

#define FUNC_POS_X	-0.6		      /* Function as string position */
#define FUNC_POS_Y	-0.1
#define FUNC_DIF_Y	0.12		     /* Difference between two lines */

#define MAIN_SCALE	1.9		/* Should be 2 but for the safety... */

extern int MouseExists,   /* Set according to autotest and config enforcment */
	   GraphDriver;							/* " */

/* Global prototypes of DrawFunc.c module: */
void RedrawScreen(ExprNode *PFuncX[], ExprNode *PFuncY[],
	char SFuncX[][LINE_LEN_LONG], char SFuncY[][LINE_LEN_LONG],
	double *Xmin, double *Xmax, double *Ymax,
	double Tmin, double Tmax, int InputKind);
void PrintMathError(void);
void MyExit(int ExitCode);

/* Global prototypes of GetFunc.c module: */
void DoGetFunc(ExprNode **PFuncX, ExprNode **PFuncY,
	char SFuncX[][LINE_LEN_LONG], char SFuncY[][LINE_LEN_LONG],
	int *InputKind,
	double *Xmin, double *Xmax, double *Ymax, double *Tmin, double *Tmax);
void GetLine(char *Header, char *s);

/* Global prototypes of SetScale.c module: */
void DoSetScale(double *Xmin, double *Xmax, double *Ymax, int *NumOfSamples,
	int *AutoScaleFlag, double *DomainMin, double *DomainMax);

#endif  DRAW_FUNC_H
