;*************************************************************************
;* RTABLE.ASP  (C) 1987 DATASTORM TECHNOLOGIES, INC.                     *
;*                                                                       *
;* A sample ASPECT script file for logging onto the DATASTORM            *
;* roundtable on GEnie.                                                  *
;*                                                                       *
;*************************************************************************

  ASSIGN S9 "xxxnnnnn,ppppp^M"         ;store your User Number,PASSWORD
  ASSIGN S8 "2"                        ;Dial dir entry for GEnie

  CLEAR                                ;clear the screen
  BOX 0 0 2 51 14
  ATSAY 1 5 14 "Calling GEnie for the DATASTORM Roundtable"
  LOCATE 3 0
  EMULATE ANSI                         ;ANSI-BBS terminal emulation
  IF NOT LINKED
     DIAL S8
  ENDIF
  SET DUPLEX HALF                      ;turn echo on
  PAUSE 1                              ;network settling time
  TRANSMIT "H"                         ;send characters for synchronization
  PAUSE 1
  TRANSMIT "H"
  PAUSE 1
  TRANSMIT "H"
  PAUSE 1
  TRANSMIT "^M"                        ;send it all
  WAITFOR "U# " 35                     ;wait for Genie prompt
  RFLUSH                               ;make sure no noise came in
SENDID:                                ;loop for resending ID
  TRANSMIT S9                          ;transmit your User Number,PASSWORD
  WAITFOR "^M"                         ;wait for carriage return
  RGET S0                              ;get rest of prompt
  FIND S0 "U#"                         ;check for VALIDATION FAULT
  IF FOUND                             ;if it is
    GOTO SENDID                        ;try again
  ENDIF                                ;end of test
  WAITFOR "or <H>elp?" 180             ;wait for Genie Main menu prompt
  IF NOT WAITFOR                       ;no response from the system
    GOTO UNAVAILABLE                   ;hang up and try again?
  ENDIF                                ;continue
TRYAGAIN:                              ;loop for resending page number
  TRANSMIT "M725^M"                    ;goto Datastorm Roundtable
  WAITFOR "Page 725" 180               ;did we make it
  IF WAITFOR                           ;test to make sure
    WAITFOR "or <H>elp?"               ;wait for the Roundtable prompt
    ALARM 2                            ;make some noise
    EXIT                               ;we made it!
  ENDIF                                ;end of test
  SOUND 440 50                         ;signal attention
  KFLUSH                               ;make sure no keys pressed
  MESSAGE "^MDidn't make it to the Roundtable.  Want to try again? (Y/N)"
  GET S0 1                             ;get the keyboard input
  FIND S0 "Y"                          ;did we get a Y?
  IF FOUND                             ;test it
    GOTO TRYAGAIN                      ;send the page number again
  ENDIF                                ;continue
  EXIT                                 ;end it

UNAVAILABLE:                           ;system is unavailable
  HANGUP                               ;hangup phone
  CLEAR                                ;clear screen
  SOUND 440 50                         ;make some noise
  KFLUSH                               ;clear the keyboard
  MESSAGE "^M^JSorry! Genie is not responding!^M^J"

  EXIT                                 ;quit command file
