unit rusnio;

{

rusnio.pas - nonconsole input/output routines

assumes a fossil (if the nonconsole routines will ever be used)

requires:

uses dos,crt,rusnglob,rusnmous ( , and possibly mouse and rusntime ) ;

shortcomings:

minimal ansi/vt100 hard-coded in

}

{$I rusn-def.pas}

interface

uses dos,crt,rusnglob,rusnmous

{$ifdef timeout}

,rusntime

{$endif}

{$ifdef mouse}

,mouse

{$endif}

;

procedure xwrites(s: string);
procedure xwritei(i: integer);
procedure xwriteiw(i,w: integer);
procedure xwritess(s1,s2: string);
procedure xwritesss(s1,s2,s3: string);
procedure xwritessss(s1,s2,s3,s4: string);
procedure xwritesis(s1: string; i2: integer; s3: string);
procedure xwritessis(s1,s2: string; i3: integer; s4: string);
procedure xwriteln;
procedure xwritelns(s: string);
procedure xwritelnss(s1,s2: string);
procedure xwritelnsss(s1,s2,s3: string);
procedure xwritelnssss(s1,s2,s3,s4: string);
procedure xwritelnsi(s1: string; i2: integer);
procedure xwritelnsssisis(s1,s2,s3: string; i4: integer; s5: string;
 i6: integer; s7: string);
procedure xgotoxy(x,y: integer);
procedure writexy(x,y: integer; s: string);
procedure xclreol;
procedure xclreolxy(x,y: integer);
procedure xclrscr;
function xkeypressed: boolean;
function xreadkey: char;
procedure xreadlns(var s: string; maxlen: integer; keepcurrent: boolean);
procedure xreadlnsp(var s: string; maxlen: integer; keepcurrent: boolean);
procedure xhighvideo;
procedure xlowvideo;

implementation

procedure noncwritec(c: char);

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 1;
  regs.al := ord(c);
  intr($14,regs);
end;

function noncreadc: char;

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 2;
  intr($14,regs);
  noncreadc := chr(regs.al);
end;

function noncinready: boolean;

var
  regs: registers;

begin
  regs.dx := port;
  regs.ah := 3;
  intr($14,regs);
  noncinready := odd(regs.ah);
end;

procedure xwrites;

var
  i: integer;

begin
  if console then
    begin
      mousehide;
      write(s);
      mouseshow;
    end
  else
    begin
      for i := 1 to length(s) do
        noncwritec(s[i]);
      if shadow>0 then
        begin
          write(s);
          delay(shadow);
        end;
    end;
end;

procedure xwritei;

var
  s: string;

begin
  if console then
    begin
      mousehide;
      write(i);
      mouseshow;
    end
  else
    begin
      str(i,s);
      xwrites(s);
    end;
end;

procedure xwriteiw;

var
  s: string;

begin
  if console then
    begin
      mousehide;
      write(i:w);
      mouseshow;
    end
  else
    begin
      str(i:w,s);
      xwrites(s);
    end;
end;

procedure xwritess;

begin
  xwrites(s1);
  xwrites(s2);
end;

procedure xwritesss;

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
end;

procedure xwritessss;

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwrites(s4);
end;

procedure xwritesis;

begin
  xwrites(s1);
  xwritei(i2);
  xwrites(s3);
end;

procedure xwritessis;

begin
  xwritess(s1,s2);
  xwritei(i3);
  xwrites(s4);
end;

procedure xwriteln;

begin
  if console then
    begin
      mousehide;
      writeln;
      mouseshow;
    end
  else
    xwritess(chr(13),chr(10));
end;

procedure xwritelns;

begin
  xwrites(s);
  xwriteln;
end;

procedure xwritelnss;

begin
  xwrites(s1);
  xwrites(s2);
  xwriteln;
end;

procedure xwritelnsss;

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwriteln;
end;

procedure xwritelnssss;

begin
  xwrites(s1);
  xwrites(s2);
  xwrites(s3);
  xwrites(s4);
  xwriteln;
end;

procedure xwritelnsi;

begin
  xwrites(s1);
  xwritei(i2);
  xwriteln;
end;

procedure xwritelnsssisis;

begin
  xwritesss(s1,s2,s3);
  xwritei(i4);
  xwrites(s5);
  xwritei(i6);
  xwritelns(s7);
end;

procedure xgotoxy;

begin
  if console then
    begin
      mousehide;
      gotoxy(x,y);
      mouseshow;
    end
  else
    begin
      xwritess(#27,'[');
      xwritei(y);
      xwrites(';');
      xwritei(x);
      xwrites('f');
    end;
end;

procedure writexy;

begin
  xgotoxy(x,y);
  xwrites(s);
end;

procedure xclreol;

begin
  if console then
    begin
      mousehide;
      clreol;
      mouseshow;
    end
  else
    xwritess(#27,'[0K');
end;

procedure xclreolxy;

begin
  xgotoxy(x,y);
  xclreol;
end;

procedure xclrscr;

begin
  if console then
    begin
      mousehide;
      clrscr;
      mouseshow;
    end
  else
    begin
      xwritess(#27,'[2J');
      xgotoxy(1,1);
    end;
end;

function xkeypressed;

var
  minnow: integer;

begin
  if console then
    begin
{$ifdef mouse}
      if hasmouse then
        xkeypressed := keypressed or (mousevent.event<>0)
      else
        xkeypressed := keypressed;
{$else}
      xkeypressed := keypressed;
{$endif}
    end
  else
    begin

{check for timeout _before_ checking if a key is ready - modems can spew}

{now also checks for trusted users!}

{$ifdef timeout}

      minnow := mitoday;
      if minnow<minstart then
        inc(minnow,24*60);
      if minnow-minstart>=minutes then
        begin
          xwriteln;
          xwritelns('time up');
          xwriteln;
          halt(2);
        end;

{$endif}

{$ifdef mouse}
      if hasmouse then
        xkeypressed := noncinready or keypressed or (mousevent.event<>0)
      else
        xkeypressed := noncinready or keypressed;
{$else}
      xkeypressed := noncinready or keypressed;
{$endif}

    end;
end;

function xreadkey;

var
  result: char;

{$ifdef mouse}
  regs: registers;
  wasx, wasy: byte;
{$endif}

begin
  if console then
    begin

{ ignore function keys, alt keys, numeric pad keys - translate to ' ' }

      repeat

{$ifdef mouse}

        repeat
        { nothing - we're on the console }
        until xkeypressed;

        if keypressed then
          begin
            result := readkey;
          end
        else
          begin
            wasx := wherex;
            wasy := wherey;
            gotoxy(1+(mousevent.horiz div 8),1+(mousevent.vert div 8));
            regs.ah := 8;
            regs.bh := 0;
            intr($10,regs);
            result := chr(regs.al);
            gotoxy(wasx,wasy);
            mousevent.event := 0;
          end;

{$else}

        result := readkey;

{$endif}

        if (result=#0) and keypressed then
          begin
            result := readkey;

{ change these extended keys: }

{    2nd Char key pressed    code returned }
{    -------- -----------    ------------- }
{    I  73    PgUp           <             }
{    Q  81    PgDn           space or >    }
{    G  71    Home           ^             }
{    O  79    End            $             }
{    ;  59    F1             ?             }
{    K  75    left arrow     backspace     }
{    $  36    alt-J          !             }

            if result='I' then
              result := '<'
{$ifdef pgdnbecomesgt}
            else if result='Q' then
              result := '>'
{$else}
            else if result='Q' then
              result := ' '
{$endif}
            else if result='G' then
              result := '^'
            else if result='O' then
              result := '$'
            else if result=';' then
              result := '?'
            else if result='K' then
              result := #8
            else if result='$' then
              result := '!'
            else

{ ignore other extended keys }

              result := #0;

          end;

      until result<>#0;
    end
  else
    begin
      while not xkeypressed do
        ;
      if keypressed then
        result := readkey
      else
        result := noncreadc;
    end;
  xreadkey := mainmap[result];
end;

procedure xreadlns;

var
  result: string;
  len: integer;
  c: char;

begin
  if keepcurrent then
    result := s
  else
    result := '';
  len := length(result);
  xwrites(result);
  repeat
    c := xreadkey;
    if (c=#127) or (c=#8) then
      begin
        if length(result)>0 then
          begin
            xwritesss(#8,' ',#8);
            dec(len);
            if len=0 then
              result := ''
            else
              result := copy(result,1,len);
          end;
      end
    else if (c=#13) then
      begin
{$ifdef xwritelnafterxreadln}
        xwriteln;
{$endif}
      end
    else if (c=#21) then   { control-U }
      begin
        while len>0 do
          begin
            xwritesss(#8,' ',#8);
            dec(len);
          end;
        result := '';
      end
    else if (ord(c)>=32) and (eightbitclean or (ord(c)<128))
     and (len<maxlen) then
      begin
        inc(len);
        result := result+c;
        if console then
          begin
            mousehide;
            write(c);
            mouseshow;
          end
        else
          noncwritec(c);
      end
  until c=#13;
  s := result;
end;

procedure xreadlnsp;  {readln, can end with SPACE or RETURN}

var
  result: string;
  len: integer;
  c: char;

begin
  if keepcurrent then
    result := s
  else
    result := '';
  len := length(result);
  xwrites(result);
  repeat
    c := xreadkey;
    if (c=#127) or (c=#8) then
      begin
        if length(result)>0 then
          begin
            xwritesss(#8,' ',#8);
            dec(len);
            if len=0 then
              result := ''
            else
              result := copy(result,1,len);
          end;
      end
    else if (c=#13) or (c=' ') then
      begin
{$ifdef xwritelnafterxreadln}
        xwriteln;
{$endif}
      end
    else if (c=#21) then   { control-U }
      begin
        while len>0 do
          begin
            xwritesss(#8,' ',#8);
            dec(len);
          end;
        result := '';
      end
    else if (ord(c)>=32) and (eightbitclean or (ord(c)<128))
     and (len<maxlen) then
      begin
        inc(len);
        result := result+c;
        if console then
          begin
            mousehide;
            write(c);
            mouseshow;
          end
        else
          noncwritec(c);
      end
  until (c=#13) or (c=' ');
  s := result;
end;

procedure xhighvideo;

{color is 0-15, background is 0-7}

begin
  if console then
    begin
      textcolor(highcolor and $f);
      textbackground(highcolor shr 4);
    end
  else
    xwritess(#27,'[7m');
end;

procedure xlowvideo;

{color is 0-15, background is 0-7}

begin
  if console then
    begin
      textcolor(lowcolor and $f);
      textbackground(lowcolor shr 4);
    end
  else
    xwritess(#27,'[m');
end;

end.
