unit rusnselb;

{

rusnselb.pas - rusnews selectandbrowse, viewarts, browseart and friends

}

{$I rusn-def.pas}

interface

uses dos,crt,rusnglob,genericf,rusnfunc,rusnio,rusnproc,rusnkill,
  rusnmous,rusnfile;

procedure selectandbrowse;

implementation

var
  moreselecting: boolean;
  skipsection: boolean;
  starbeside: integer;
  artfn: string;
  artf: text;
  arteof: boolean;
  artlinebuf: string;
  artwaslongline: boolean;
  artlineno: integer;
  artuheader: string;
  artopen: boolean;
  donebrowse: boolean;
  startofline: boolean;
  firstblankline: integer;
  showallheaders: boolean;

procedure getartl(var s: string; maxlen: integer; toscreen: boolean);

var
  gotaline: boolean;

begin
  inc(artlineno);
  startofline := false;
  if artlinebuf<>'' then
    begin
      s := copy(artlinebuf,1,maxlen);
      if maxlen=255 then
        artlinebuf := ''
      else
        artlinebuf := copy(artlinebuf,maxlen+1,255);

{ looks redundant with case below just like this, but isn't.  really.}

      if artlinebuf='' then
        arteof := eof(artf);

    end
  else if eof(artf) then
    begin
      arteof := true;
      s := '(internal error)'
    end
  else
    begin
      gotaline := false;
      while not gotaline and not arteof do
        begin

          startofline := not artwaslongline;
          artwaslongline := false;

          read(artf,s);

          if eoln(artf) then
            readln(artf)
          else
            artwaslongline := true;

          if s='' then
            if firstblankline>artlineno then
              firstblankline := artlineno;

          gotaline := true;

{ don't use isheaderline here.  if last header is hidden, first pass }
{ will set firstblankline to a small number, which will then cause }
{ artlineno=firstblankline before the first blank line is actually seen }

          if (artlineno<=firstblankline) then
            if startofline then
              if (s<>'') then
                if (s[1]<>' ') and (s[1]<>^I) then
                  artuheader := upper(getfirstw(s));

          if (artlineno<=firstblankline) and not showallheaders and
           toscreen and (s<>'') then
            if hideheaders<>'' then
              begin
                if pos(':'+artuheader,hideheaders)<>0 then
                  gotaline := false;
              end
            else if showheaders<>'' then
              if pos(':'+artuheader,showheaders)=0 then
                gotaline := false;

{will trim() break _anything_?  like, while reading in headers?  mail? etc.}

{using trim() is _not_ evil on headers - is it ever a problem?  what about}
{expanding tabs?  except for Makefiles and map entries...}

{trim() messes up signatures, which are added after getartl is used}

{trim() messes up old-style uuencoded postings!  taken out!}

{taken out trim() and expand() when not showing on screen (ie saving to disk) }

{}{}{} {unfortunately, this doesn't work when replying to long lines that}
{}{}{} {begin with a tab - the line overflows in the editor.  needs work}

          if gotaline then
            begin
              if toscreen then
                s := trim(expand(s));

{time-saver, probably, to skip over the copy/copy when possible}
              if length(s)>maxlen then
                begin
                  artlinebuf := copy(s,maxlen+1,255);
                  s := copy(s,1,maxlen);
                end;
            end;

{ in case of malformed articles - prevent infinite loop }

          if artlinebuf='' then
            arteof := eof(artf);

        end;

      if not gotaline then
        s := '(malformed article)';

    end;
end;

procedure artresetattempt;

{ don't bother with filemode here - tpascal doesn't use it on text files }

begin

{can't use safereset here, since we don't want to do a new assign each time}

{$I-}
  reset(artf);
{$I+}

  if ioresult=0 then
    begin
      arteof := eof(artf);
      artlinebuf := '';
      artwaslongline := false;
      artlineno := 0;
      artuheader := '';
      artopen := true;
    end;
end;

procedure artreset;

var
  givenup: boolean;
  yn: char;

begin
  givenup := false;
  artopen := false;
  while not artopen and not givenup do
    begin
      artresetattempt;
      if not artopen then
        begin
          yn := onekey('unable to open file.  try again?  y/n ','yn ');
          if yn=' ' then
            yn := 'y';
          if yn='n' then
            givenup := true;
        end;
    end;
  if not artopen then
    begin
      donebrowse := true;
      arteof := true;
    end;
end;

procedure delivermail(mailfn: string; toaddr,ccaddr: string);

var
  mailf: text;
  maillffn: string;
  maillff: text;
  cclffn: string;
  cclff: text;
  rereadblankfound: boolean;
  fromfound: boolean;
  sigfn: string;
  sigf: text;
  foundblank: boolean;
  s: string;
  sendeditvspellquit: char;
  outmailfn: string;
  outmailf: text;
  ccoutmailfn: string;
  ccoutmailf: text;
  basesite: string;
  ccbasesite: string;
  lineno: integer;
  doserr: integer;

  smarthostdir: string;
  seqstr: string;
  ccseqstr: string;

  builtin: boolean;

begin

  builtin := mailcmdline='(builtin)';

  if builtin then
    begin
      smarthostdir := smarthost;
      if pos('!',smarthostdir)<>0 then
        smarthostdir := copy(smarthost,1,pos('!',smarthostdir)-1);
      smarthostdir := spooldir+'\'+smarthostdir;

      seqstr := integertozstring(newseqnumber,4);
      maillffn := smarthostdir+'\'+seqstr+'.dat';

{}{}{} {should get toaddr and ccaddr using getheaderline() here}
{}{}{} {in case they were changed!}

      if ccaddr='' then
        begin
          cclffn := '';
        end
      else
        begin
          ccseqstr := integertozstring(newseqnumber,4);
          cclffn := smarthostdir+'\'+ccseqstr+'.dat';
        end;

      { here copy mailf to maillff, cclff - strip carriage returns }

      assign(maillff,maillffn);
      rewrite(maillff);

      if ccaddr<>'' then
        begin
          assign(cclff,cclffn);
          rewrite(cclff);
        end;
    end
  else
    begin
      maillffn := temporarydir+'\'+userid+'.nl';
      assign(maillff,maillffn);
      rewrite(maillff);
    end;

  basesite := copy(basesitename(toaddr),1,8);
  outmailfn := outboxdir+'\'+basesite;

  if ccaddr<>'' then
    begin
      ccbasesite := copy(basesitename(ccaddr),1,8);
      ccoutmailfn := outboxdir+'\'+ccbasesite;
    end;

{getuniqfext makes sure it's not a device}

  outmailfn := getuniqfext(outboxdir+'\'+basesite);

  assign(outmailf,outmailfn);
  rewrite(outmailf);

{ must create outmailf _before_ ccoutmailfn is chosen, in case of }
{ a conflict! }

  if ccaddr<>'' then
    begin
      ccoutmailfn := getuniqfext(outboxdir+'\'+ccbasesite);
      assign(ccoutmailf,ccoutmailfn);
      rewrite(ccoutmailf);
    end;

  assign(mailf,mailfn);
  reset(mailf);

  rereadblankfound := false;
  lineno := 1;
  while not eof(mailf) do
    begin
      readln(mailf,s);

      write(maillff,s,#10);
      if (ccaddr<>'') and builtin then
        write(cclff,s,#10);

      if lineno=1 then
        begin
          writeln(outmailf,
           copy(s,1,length(s)-length(' remote from '+uucpname)));
          if ccaddr<>'' then
            writeln(ccoutmailf,
             copy(s,1,length(s)-length(' remote from '+uucpname)));
        end
      else if lineno>3 then
        begin
          if not trusted then
            begin
              if s='' then
                rereadblankfound := true
              else if not rereadblankfound then
                if makesame(s,'From: ',mailfrom) then
                  ;
            end;
          writeln(outmailf,s);
          if ccaddr<>'' then
            writeln(ccoutmailf,s);
        end;
      inc(lineno);
    end;
  close(mailf);

  close(maillff);
  if (ccaddr<>'') and builtin then
    close(cclff);

  close(outmailf);
  if ccaddr<>'' then
    close(ccoutmailf);

  if builtin then
    begin

{once .DAT is written, create .XQT}

      maillffn := smarthostdir+'\'+seqstr+'.xqt';
      assign(maillff,maillffn);
      rewrite(maillff);
      write(maillff,'U ',userid,' ',uucpname,#10);
      write(maillff,'Z',#10);
      write(maillff,'F D.',uucpname,seqstr,#10);
      write(maillff,'I D.',uucpname,seqstr,#10);
      write(maillff,'C rmail ',toaddr,#10);
      close(maillff);

      if ccaddr<>'' then
        begin
          cclffn := smarthostdir+'\'+ccseqstr+'.xqt';
          assign(cclff,cclffn);
          rewrite(cclff);
          write(cclff,'U ',userid,' ',uucpname,#10);
          write(cclff,'Z',#10);
          write(cclff,'F D.',uucpname,ccseqstr,#10);
          write(cclff,'I D.',uucpname,ccseqstr,#10);
          write(cclff,'C rmail ',ccaddr,#10);
          close(cclff);
        end;

{once .DAT and .XQT are written, create .CMD}

      maillffn := smarthostdir+'\'+seqstr+'.cmd';
      assign(maillff,maillffn);
      rewrite(maillff);
      writeln(maillff,'S ',seqstr,'.DAT D.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.DAT 0666');
      writeln(maillff,'S ',seqstr,'.XQT X.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.XQT 0666');
      close(maillff);

      if ccaddr<>'' then
        begin
          maillffn := smarthostdir+'\'+ccseqstr+'.cmd';
          assign(maillff,maillffn);
          rewrite(maillff);
          writeln(maillff,'S ',ccseqstr,'.DAT D.',uucpname,ccseqstr,' ',
           userid,' - ',ccseqstr,'.DAT 0666');
          writeln(maillff,'S ',ccseqstr,'.XQT X.',uucpname,ccseqstr,' ',
           userid,' - ',ccseqstr,'.XQT 0666');
          close(maillff);
        end;
    end

  else

    begin

      if pos('%f',mailcmdline)=0 then
        execviacomspec(extwafexpand(mailcmdline,toaddr,'')+' < '+maillffn)
      else
        execviacomspec(extwafexpand(mailcmdline,toaddr,maillffn));

      doserr := doserror;
      if doserr<>0 then
        warnerr(mailcmdline,doserr);

      if ccaddr<>'' then
        begin
          if pos('%f',mailcmdline)=0 then
            execviacomspec(extwafexpand(mailcmdline,ccaddr,'')+' < '+maillffn)
          else
            execviacomspec(extwafexpand(mailcmdline,ccaddr,maillffn));

          doserr := doserror;
          if doserr<>0 then
            warnerr(mailcmdline,doserr);

        end;
    end;

end;

procedure sendnewsasmail(infn: string; addr: string);

var
  inf: text;
  tempfn: string;
  tempf: text;
  s: string;
  toccseen: boolean;

begin
  warn('mailing to '+addr);

  xwrites('mailing...');

  assign(inf,infn);
  reset(inf);

  tempfn := temporarydir+'\'+userid+'.n2m';
  assign(tempf,tempfn);
  rewrite(tempf);

  writeln(tempf,'From ',userid,'  ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone,' ',
   'remote from ',uucpname);
  writeln(tempf,'Received: by ',node,' ('+newsreadername+')');
  writeln(tempf,'       via ',newsreadername,'; ',copy(cdow,1,3),', ',
   dayofmonth,' ',copy(monthname,1,3),' ',year,' ',time,' ',timezone);

  toccseen := false;

  while not eof(inf) do
    begin
      readln(inf,s);

      if not toccseen then  {must write it before the blank line!}
        begin
          if lower(copy(ltrim(s),1,3))='to:' then
            toccseen := true;
          if lower(copy(ltrim(s),1,3))='cc:' then
            toccseen := true;
          if s='' then
            begin
              writeln(tempf,'To: ',addr);
              toccseen := true;
            end;
        end;

      writeln(tempf,s);
    end;

  close(inf);
  close(tempf);

  delivermail(tempfn,getfromaddr(addr),'');

end;

{}{} {should be a three-part process!}

procedure injnews(newartfn: string; newsgroups, originalnewsgroups: string);
  
var
  newartf: text;
  newartlffn: string;
  newartlff: text;
  foundblank: boolean;
  s: string;
  newnewsgroups: string;
  mungedgroups: string;
  firstnewsgroup: string;
  firstcommapos: integer;
  newfrom: string;
  newapproved: string;
  monitorgroup: string;
  monitordir: string;
  monitorfn: string;
  monitorf: text;
  fromfound: boolean;
  doserr: integer;
  moderatoraddr: string;
  onlylf: boolean;
  i: integer;

begin

  assign(newartf,newartfn);
  reset(newartf);

  newnewsgroups := getheaderline(newartfn,'newsgroups:');

  newfrom := getheaderline(newartfn,'from:');
  newapproved := getheaderline(newartfn,'approved:');

{copy to monitor directory if asked -- just pick the first one found}
     
  monitorfn := '';
  monitorgroup := '';

{first:  try to find a monitor for any group it was posted to}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newnewsgroups+',done';

  while (monitorgroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      monitorgroup := groupsattr(firstnewsgroup,'/spy=');
    end;

{second:  try to find a monitor group for any group before editing}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newsgroups+',done';

  while (monitorgroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      monitorgroup := groupsattr(firstnewsgroup,'/spy=');
    end;

{finally:  try to find a monitor group for any group before Followup-To: }

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := originalnewsgroups+',done';

  while (monitorgroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      monitorgroup := groupsattr(firstnewsgroup,'/spy=');
    end;

  if monitorgroup='' then
    begin
      if not quiet then
        warn('(there is no automatic monitor for this post)');
    end
  else
    begin
      monitordir := getgroupdir(monitorgroup);
      if monitordir='' then
        begin
          warn('no dir found for monitor group '+monitorgroup+' !');
        end
      else
        begin
          monitorfn := getuniqfile(monitordir);
        end;
    end;

{check if any group on the list is moderated}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newnewsgroups+',done';
  moderatoraddr := '';

  while (moderatoraddr='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      if groupbattr(firstnewsgroup,'/mod') then
        begin
          moderatoraddr := groupsattr(firstnewsgroup,'/mod=');
          if moderatoraddr='' then
            begin
              moderatoraddr := firstnewsgroup;
              for i := 1 to length(moderatoraddr) do
                if moderatoraddr[i]='.' then
                   moderatoraddr[i] := '-';
              moderatoraddr := moderatoraddr+'@'+backbone;
            end;
        end;
    end;

{ allow only trusted users to issue Control: messages, post to alt.hackers, }
{ be group moderators, etc. }

  if trusted then
    if newapproved<>'' then
      moderatoraddr := '';

{use LF for posts, CRLF for mail}

  onlylf := (moderatoraddr='');

  newartlffn := temporarydir+'\'+userid+'.nl';
  assign(newartlff,newartlffn);
  rewrite(newartlff);
  if monitorfn<>'' then
    begin
      assign(monitorf,monitorfn);
{$I-}
      rewrite(monitorf);
{$I+}
      if ioresult<>0 then
        begin
          mkhier(monitordir);
{$I-}
          rewrite(monitorf);
{$I+}
          if ioresult<>0 then
            begin
              warn('could not write to monitor file '+monitorfn);
              monitorfn := '';
            end;
        end;
    end;

  foundblank := false;
  reset(newartf);
  while not eof(newartf) do
    begin
      readln(newartf,s);

      if not foundblank then
        if copy(s,1,6)='From: ' then
          fromfound := true;

      if s='' then
        begin
          if not foundblank then
            begin
              if not fromfound then
                begin
                  if onlylf then
                    write(newartlff,'From: ',newsfrom,#10)
                  else
                    writeln(newartlff,'From: ',newsfrom);
                  if monitorfn<>'' then
                    writeln(monitorf,'From: ',newsfrom);
                  fromfound := true;
                end;
            end;
          foundblank := true;
        end;

      if onlylf then
        write(newartlff,s,#10)
      else
        writeln(newartlff,s);
      if monitorfn<>'' then
        writeln(monitorf,s);
    end;
  close(newartf);
  close(newartlff);
  if monitorfn<>'' then
    close(monitorf);

  if moderatoraddr='' then
    begin

{}{} {should use rnews in bin directory only?}

      mousehide;

      if pos('%f',newscmdline)=0 then
        execviacomspec(wafexpand(newscmdline)+' < '+newartlffn)
      else
        execviacomspec(extwafexpand(newscmdline,'',newartlffn));

      doserr := doserror;

      mouseshow;

{}{} {waffle's rnews sometimes displays random error message on low memory}

      delay(1000);

      if doserr<>0 then
        warnerr(newscmdline,doserr);

    end

  else

    begin
{mail to moderation address}
      sendnewsasmail(newartlffn,moderatoraddr);
    end;

end;

procedure createpostorcancel(iscancel: boolean;
 newsgroups, originalnewsgroups, followupto, subject,
 references, author, originalauthor: string);

{ if author<>'', opens then closes artf }

var
  newartfn: string;
  newartf: text;
  refline: string;
  wref: string;
  nextref: string;
  ref1,ref2: string;
  foundblank: boolean;
  sigfn: string;
  sigf: text;
  s: string;
  sendeditvspellquit: char;
  doserr: integer;
  ccaddr: string;

begin

{ don't propogate errors in the Newsgroups: line if you can help it }

  newsgroups := unspace(newsgroups);
  followupto := unspace(followupto);

  newartfn := temporarydir+'\'+userid+'.fol';
  assign(newartf,newartfn);
  rewrite(newartf);

{this done since waf164 didn't handle newsname like waf165 does}

  writeln(newartf,'Path: ',newsname,'!',pathuserid);

  writeln(newartf,'Newsgroups: ',newsgroups);
  if (originalnewsgroups<>'') and (originalnewsgroups<>newsgroups) then
    writeln(newartf,'X-Original-Newsgroups: ',originalnewsgroups);
  if followupto<>'' then
    writeln(newartf,'Followup-To: ',followupto);
  if originalauthor<>'' then
    writeln(newartf,'X-Original-Article-From: ',originalauthor);

  if iscancel then
    begin
      if newsfrom=originalauthor then
        begin
          writeln(newartf,'From: ',newsfrom);
          writeln(newartf,'Sender: ',newsfrom);
        end
      else
        begin
          writeln(newartf,'From: ',originalauthor);
          writeln(newartf,'Sender: ',newsfrom);
        end;
    end
  else
    begin
      writeln(newartf,'From: ',newsfrom);
    end;

  if replyto<>'' then
    writeln(newartf,'Reply-To: ',replyto);
  writeln(newartf,'Subject: ',subject);
  writeln(newartf,'Message-ID: ',newmessageid);
  writeln(newartf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);

  if references<>'' then
    begin

{$ifdef rnewscontbroken}
      writeln(newartf,'References: ',references);
{$else}

{ wref is the space-terminated string of references that are yet to be }
{ written out - it starts with two spaces if need be (other than line one) }

      wref := 'References: ';
      while references<>'' do
        begin
          references := ltrim(references);
          nextref := chopfirstw(references);
          if length(wref+nextref)>70 then
            begin
              writeln(newartf,wref);
              wref := '  '+nextref+' ';
            end
          else
            wref := wref+nextref+' ';
        end;
      if wref<>'' then
        writeln(newartf,trim(wref));
{$endif}

    end;

  if organ<>'' then
    writeln(newartf,'Organization: ',organ);

  if iscancel then
    writeln(newartf,'Control: ','cancel ',references);

  writeln(newartf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);
  writeln(newartf);

  if iscancel then
    writeln(newartf,'cancelled within ',newsreadername)
  else if author='' then
    writeln(newartf,'(begin your PUBLIC post at this line, but no sooner)')
  else
    begin
      writeln(newartf,author,' writes:');
      writeln(newartf);
      artreset;
      foundblank := false;
      while not arteof and not foundblank do
        begin
          getartl(s,255,false);
          if s='' then
            foundblank := true;
        end;
      while not arteof do
        begin

{don't use just cols here, to be polite}

          getartl(s,min(cols,80)-3,false);
          if copy(s,1,1)='>' then
            writeln(newartf,'>',expand(s))
          else
            writeln(newartf,'> ',expand(s))
        end;
      close(artf);
    end;

  sigfn := home+'\'+'sig';
  safereset(sigf,sigfn);
  if fileresult=0 then
    begin
      readln(sigf,s);
      if s<>'-- ' then
        writeln(newartf,'-- ');
      reset(sigf);
      while not eof(sigf) do
        begin
          readln(sigf,s);
          writeln(newartf,s);
        end;
      close(sigf);
    end;
  close(newartf);

end;

procedure createcancel(newsgroups, subject, references,
 originalauthor: string);

begin
  createpostorcancel(true,newsgroups,'','',subject,
   references,'',originalauthor);
end;

procedure createpost(newsgroups, originalnewsgroups, followupto, subject,
 references, author, originalauthor: string);

begin
  createpostorcancel(false,newsgroups,originalnewsgroups,followupto,
   subject,references,author,originalauthor);
end;

procedure editandinjnews(newsgroups, originalnewsgroups, author: string);
  
var
  newartfn: string;
  sendeditvspellquit: char;
  doserr: integer;
  ccaddr: string;

begin

{ don't propogate errors in the Newsgroups: line if you can help it }

  newsgroups := unspace(newsgroups);

  newartfn := temporarydir+'\'+userid+'.fol';

  sendeditvspellquit := 'e';
  while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
    begin
      if not trusted then
        if sendeditvspellquit='E' then
          sendeditvspellquit := 'e';
      if sendeditvspellquit='v' then
        begin
          mousehide;
          execp(vspeller,vspelleroptions+' '+newartfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(vspeller,doserr);
          if editaftervspell then
            sendeditvspellquit := 'e';
        end;
      if sendeditvspellquit='e' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+newartfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;
      if sendeditvspellquit='E' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+newartfn+' '+artfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;

      xclreolxy(1,lpp-1);
      if author='' then
        sendeditvspellquit :=
          onekey('Public: <s>end <e>dit <v>spell <q>uit','sevq')
      else
        sendeditvspellquit :=
         onekey('Public: <s>end <e>dit <E>dit-both <v>spell <q>uit','seEvq');

      if sendeditvspellquit='s' then
        xwrites('send')
      else if sendeditvspellquit='e' then
        xwrites('edit')
      else if sendeditvspellquit='E' then
        xwrites('edit followup and original')
      else if sendeditvspellquit='v' then
        xwrites('vspell')
      else if sendeditvspellquit='q' then
        xwrites('quit');

    end;

  if sendeditvspellquit='s' then
    begin

{}{} {check headers}
     {invalid format of Newsgroups: line (spaces, etc.)}
     {warn if any groups in Newsgroups: not in forum set}
     {delete any duplicates from Newsgroups: line}
     {check From:}
     {check for moderated groups}
     {check for /solo groups}
     {a Lines: header might be polite.  maybe not}
     {would be nice to check for content-free messages sent by mistake}

      injnews(newartfn,newsgroups,originalnewsgroups);
      ccaddr := getheaderline(newartfn,'cc:');
      if ccaddr<>'' then
        begin

{}{}

          if (ccaddr='poster') or (ccaddr='sender') then
            ccaddr := author;

          sendnewsasmail(newartfn,ccaddr);
        end;

    end;

{leave refresh and artf re-opening to the caller}

end;

procedure post;

var
  newsubj: string;

begin
  if trusted then
    begin
      if groupbattr(currgroup,'/mod') then
        warn('this group is moderated');
      xclreolxy(1,lpp);
      xwrites('Subject: ');
      xreadlns(newsubj,max(cols-10,70),false);
      createpost(currgroup,'','',newsubj,'','','');
      editandinjnews(currgroup,'','');
    end
  else
    warn('you do not have access to post this way');

{ caller must refresh }

end;

procedure editanddeliver(subject,inreplyto,replyaddr,replyname,ccaddr,
 originalfrom,author: string; defaultreply: boolean);

{ expects artf to be closed;  will open and close if author<>'' }

var
  mailfn: string;
  mailf: text;
  mailcheckedfn: string;
  mailcheckedf: text;
  rereadblankfound: boolean;
  fromfound: boolean;
  sigfn: string;
  sigf: text;
  foundblank: boolean;
  s: string;
  sendeditvspellquit: char;
  outmailfn: string;
  outmailf: text;
  basesite: string;
  lineno: integer;
  doserr: integer;

begin
  mailfn := temporarydir+'\'+userid+'.mai';
  assign(mailf,mailfn);
  rewrite(mailf);
  writeln(mailf,'From ',userid,'  ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone,' ',
   'remote from ',uucpname);
  writeln(mailf,'Received: by ',node,' ('+newsreadername+')');
  writeln(mailf,'       via ',newsreadername,'; ',copy(cdow,1,3),', ',
   dayofmonth,' ',copy(monthname,1,3),' ',year,' ',time,' ',timezone);

{ don't bother with this line anymore -- makes future expansion easier }

{
  writeln(mailf,'       for ',replyaddr);
}

  write(mailf,'To: ',replyaddr);
  if replyname='' then
    writeln(mailf)
  else
    writeln(mailf,' (',replyname,')');

  if ccaddr<>'' then
    writeln(mailf,'CC: ',ccaddr);

  if originalfrom<>'' then
    writeln(mailf,'X-Original-Article-From: ',originalfrom);

  writeln(mailf,'Subject: ',subject);
  writeln(mailf,'From: ',mailfrom);

  if replyto<>'' then
    writeln(mailf,'Reply-To: ',replyto);

  writeln(mailf,'Message-ID: ',newmessageid);
  writeln(mailf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);

  if inreplyto<>'' then
    writeln(mailf,'In-Reply-To: ',inreplyto);

  if organ<>'' then
    writeln(mailf,'Organization: ',organ);

  writeln(mailf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);
  writeln(mailf);

  if author='' then
    writeln(mailf,'(begin your PRIVATE mail at this line, but no sooner)')
  else
    begin
      if defaultreply and (ccaddr='') then
        writeln(mailf,'In ',currgroup,' you write:')
      else
        if length(currgroup)+length(author)<60 then
          writeln(mailf,'In ',currgroup,', ',author,' writes:')
        else
          writeln(mailf,'In ',currgroup,', ',
           copy(author,1,max(60-length(currgroup),20)),'... writes:');
      writeln(mailf);
      artreset;
      foundblank := false;
      while not arteof and not foundblank do
        begin
          getartl(s,255,false);
          if s='' then
            foundblank := true;
        end;
      while not arteof do
        begin

{don't use just cols here, to be polite}

          getartl(s,min(cols,80)-3,false);
          if copy(s,1,1)='>' then
            writeln(mailf,'>',expand(s))
          else
            writeln(mailf,'> ',expand(s))
        end;
      close(artf);
    end;

  sigfn := home+'\'+'mailsig';
  safereset(sigf,sigfn);
  if fileresult<>0 then
    begin
      sigfn := home+'\'+'sig';
      safereset(sigf,sigfn);
    end;
  if fileresult=0 then
    begin
      readln(sigf,s);
      if s<>'-- ' then
        writeln(mailf,'-- ');
      reset(sigf);
      while not eof(sigf) do
        begin
          readln(sigf,s);
          writeln(mailf,expand(s));
        end;
      close(sigf);
    end;
  close(mailf);

  sendeditvspellquit := 'e';
  while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
    begin
      if not trusted then
        if sendeditvspellquit='E' then
          sendeditvspellquit := 'e';
      if sendeditvspellquit='v' then
        begin
          mousehide;
          execp(vspeller,vspelleroptions+' '+mailfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(vspeller,doserr);
          if editaftervspell then
            sendeditvspellquit := 'e';
        end;
      if sendeditvspellquit='e' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+mailfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;
      if sendeditvspellquit='E' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+mailfn+' '+artfn);
          mouseshow;
          doserr := doserror;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;

      xclreolxy(1,lpp-1);
      sendeditvspellquit :=
       onekey('Private: <s>end <e>dit <E>dit-both <v>spell <q>uit','seEvq');

      if sendeditvspellquit='s' then
        xwrites('send')
      else if sendeditvspellquit='e' then
        xwrites('edit')
      else if sendeditvspellquit='E' then
        xwrites('edit reply and original')
      else if sendeditvspellquit='v' then
        xwrites('vspell')
      else if sendeditvspellquit='q' then
        xwrites('quit');

    end;

  if sendeditvspellquit='s' then
    begin

      mailcheckedfn := temporarydir+'\'+userid+'.chk';

{}{}{} {should get replyaddr using getheaderline() here}

      { here copy mailf to mailcheckedf }

      assign(mailcheckedf,mailcheckedfn);
      rewrite(mailcheckedf);

      assign(mailf,mailfn);
      reset(mailf);

{check for changed From: lines on non-trusted users and replace}

{must make sure a From: line is actually found!}

      rereadblankfound := false;
      fromfound := false;
      while not eof(mailf) do
        begin
          readln(mailf,s);
          if not trusted then
            begin
              if s='' then
                begin
                  rereadblankfound := true;
                  if not fromfound then
                    begin
                      fromfound := true;
                      writeln(mailcheckedf,'From: ',mailfrom);
                    end;
                end
              else if not rereadblankfound then
                begin
                  if getfirstw(s)='From:' then
                    fromfound := true;
                  if makesame(s,'From: ',mailfrom) then
                    begin
                      warn3('',
'From: line was changed to normal.  -t flag required to change From: line.',
'adding a Reply-To: is probably better.')
{
                      xclreolxy(1,1);
                      xclreolxy(1,2);
                      xclreolxy(1,3);
                      xclreolxy(1,4);
                      xclreolxy(1,5);
                      xclreolxy(1,6);
                      xclreolxy(1,7);
                      writexy(1,1,'From: line was changed from');
                      writexy(1,2,s+' to');
                      writexy(1,3,mailfrom);
                      writexy(1,4,'and has been changed back.  if you need');
                      writexy(1,5,'to change From:, run as a trusted user.');
                      writexy(1,6,'adding a Reply-To: is probably better');
}
                    end;
                end;
            end;
          writeln(mailcheckedf,s);
        end;
      close(mailf);
      close(mailcheckedf);

      delivermail(mailcheckedfn,getfromaddr(replyaddr),getfromaddr(ccaddr));

    end;

{leave refresh and re-opening of artf to caller}

end;

procedure mail;

var
  replyaddr: string;
  newsubj: string;
  ccaddr: string;

begin
  xclreolxy(1,lpp);
  xwrites('To: ');
  xreadlns(replyaddr,max(cols-5,75),false);
  replyaddr := expandmail(replyaddr);

  xclreolxy(1,lpp);
  xwrites('CC: ');
  xreadlns(ccaddr,max(cols-5,75),false);
  ccaddr := expandmail(ccaddr);

  xclreolxy(1,lpp);
  xwrites('Subject: ');
  xreadlns(newsubj,max(cols-10,70),false);

  if replyaddr<>'' then
    editanddeliver(newsubj,'',replyaddr,'',ccaddr,'','',false);

{ caller must refresh }

end;




procedure browseart(artnum: integer; numleft: integer;
 var willupdatej: boolean);

var
  rot13ing: boolean;
  nonactedleft: boolean;
  lastlineshown: integer;
  artfrom: string;
  artsubject: string;
  artmessageid: string;
  artnewsgroups: string;
  ff: boolean;
  numlefts: string[30];
  totlines: integer;
  asearchstring: boolean;
  uppersearchstring: string;

function isheaderline: boolean;  {valid only once getartl has returned it}

begin
  isheaderline := artlineno<firstblankline;
end;

procedure showartl(s: string);

var
  changeds: string;
  i: integer;

begin
  changeds := nobeep(s);
  if hideformfeeds then
    for i := 1 to length(changeds) do
      if changeds[i]=^L then
        changeds[i] := ' ';

  if isheaderline then
    begin
      if pos(':'+artuheader,highlightheaders)<>0 then
        begin
          if startofline then
            xwritess(chopfirstw(changeds),' ');
          xhighvideo;
          xwritelns(screenline(changeds));
          xlowvideo;
        end
      else
        xwritelns(screenline(changeds));
    end
  else if rot13ing then
    xwritelns(rot13(screenline(changeds)))
  else
    if not asearchstring then
      xwritelns(screenline(changeds))
    else if pos(uppersearchstring,upper(changeds))=0 then
      xwritelns(screenline(changeds))
    else

{}{} {highlight just the word?}

      begin xhighvideo;xwritelns(screenline(changeds));xlowvideo;end;
end;

procedure newbrowsescreen;

begin
  xclrscr;
end;

procedure morelines(linestoshow: integer);

var
  s: string;
  ff: boolean;
  brandnewlinesshown: integer;

begin
  if arteof then
    donebrowse := true
  else
    begin
      nonactedleft := true;
      ff := false;
      brandnewlinesshown := 0;
      while not arteof and (brandnewlinesshown<linestoshow) and not ff do
        begin
          getartl(s,cols-1,true);
          ff := (pos(^L,s)<>0);
          showartl(s);
          inc(brandnewlinesshown);
          inc(lastlineshown);
        end;
    end;
end;

procedure rewindtopline(newtopline: integer);

var
  s: string;
  skippedlines: integer;
{
  ff: boolean;
  brandnewlinesshown: integer;
}

begin
  newbrowsescreen;
  nonactedleft := true;
  artreset;
  lastlineshown := 0;
  skippedlines := min(0,newtopline);
  while skippedlines<newtopline do
    begin
      getartl(s,cols-1,true);
      inc(skippedlines);
      inc(lastlineshown);
    end;

  morelines(lpp-1);

{
  ff := false;
  brandnewlinesshown := 0;
  while (brandnewlinesshown<lpp) and not arteof and not ff do
    begin
      getartl(s,cols-1,true);
      ff := (pos(^L,s)<>0);
      showartl(s);
      inc(brandnewlinesshown);
      inc(lastlineshown);
    end;
}

end;

procedure browserefresh;

begin
  rewindtopline(lastlineshown-lpp+1);
end;

procedure showlastline;

var
  wastes: string;

begin
  if totlines<0 then
    begin
      xwrites('searching for bottom line...');
      totlines := 0;
      artreset;
      while not arteof do
        begin
          inc(totlines);
          getartl(wastes,cols-1,true);
        end;
    end;
  rewindtopline(totlines-lpp+1);
end;

procedure browsehelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (940524)');
  writexy(1,4,'space,d,CR - forward 1 page, 1/2 page, 1 line');
  writexy(1,5,'u - back 1 page             = back to selection screen');
  writexy(1,6,'^,$ - top, bottom line    TAB skip this Subject: group');
  writexy(1,7,'n,p - next, previous selected article (or next group)');
  writexy(1,8,'b,a - back,ahead through selected OR unselected');
  writexy(1,9,'r - reply to author (in mail)    / search   . search again');
  writexy(1,10,'f - followup (in netnews) (possibly not yet)');
  writexy(1,11,'k - kill by subject or author (will not display again)');
  writexy(1,12,'K - antikill by subject or author (for auto-selection)');
  writexy(1,13,'^R - reread kill and antikill files from disk');
  if trusted then
    writexy(1,14,'e - edit article on disk');
  writexy(1,15,'D - rot13-decode article  s w - save/write article to disk');
  writexy(1,16,'h - toggle full header display  ^L - refresh screen');
  writexy(1,17,'! - shell escape        N - next group (no update)');
  writexy(1,19,'? - help                Q - quit (no update)');
  writexy(1,21,'file:');
  writexy(7,21,artfn);
  writexy(1,23,'press any key to return ');
  ch := xreadkey;
  browserefresh;
end;

procedure browseback;

begin
  donebrowse := true;
  browsedir := -1;
  browseonlysel := false;
end;

procedure browseahead;

begin
  donebrowse := true;
  browseonlysel := false;
end;

procedure savewriteart(fullheaders: boolean);

var
  outfilen: string;
  outfile: text;
  illegal: boolean;
  doit: boolean;
  appending: boolean;
  s: string;
  appendoverwriteforgetit: char;

{for non-trusted users, make sure no : or \ in unslash(filename)}
{and try to make sure it's not a device driver (con, aux, lpt1, etc.)}
{then force it in the user's home directory}

begin
  xclreolxy(1,lpp);
  xwrites('file name (blank to abort): ');
  outfilen := lastfilen;
  xreadlns(outfilen,cols-30,true);

  outfilen := ltrim(trim(outfilen));

  if outfilen<>'' then
    lastfilen := outfilen;

  if tildehome then
    if copy(outfilen,1,2)='~/' then
      outfilen := home+copy(outfilen,2,255);

  outfilen := unslash(outfilen);

  illegal := false;
  doit := (outfilen<>'');

  if numoccur(':',outfilen)>1 then
    illegal := true;

  if doit and not trusted then
    begin
      if numoccur(':',outfilen)>0 then
        illegal := true;
      if numoccur('\',outfilen)>0 then
        illegal := true;
      if numoccur('.',outfilen)>1 then
        illegal := true;
      outfilen := upper(outfilen);

{known devices just in case isdev doesn't catch them}

      if (outfilen='CON') or (outfilen='PRN') or
       (outfilen='AUX') or (outfilen='NUL') or
       (outfilen='LPT1') or (outfilen='LPT2') or (outfilen='LPT3') or
       (outfilen='COM1') or (outfilen='COM2') or
       (outfilen='COM3') or (outfilen='COM4') or
       (outfilen='CLOCK$') then
        illegal := true;

{isdev works here, but may not be perfect - don't run it if you don't have to}

      if not illegal then
        if isdev(outfilen) then
          illegal := true;

    end;

  if doit and illegal then
    begin
      warn('unable to use that filename');
    end;

  if doit and not illegal then
    begin
      if not trusted then
        outfilen := home+'\'+outfilen;

      appendoverwriteforgetit := 'o';

      if fexists(outfilen) then
        begin
          xclreolxy(1,lpp);
          appendoverwriteforgetit :=
           onekey('<o>verwrite <a>ppend <f>orget it (f)','oaf '+chr(13));

          if (appendoverwriteforgetit<>'a') and
           (appendoverwriteforgetit<>'o') then
            appendoverwriteforgetit := 'f';

        end;

      if appendoverwriteforgetit<>'f' then
        begin

          xclreolxy(1,lpp);

          appending := (appendoverwriteforgetit='a');

          if appending then
            xwritesss('appending to ',outfilen,' ...')
          else
            xwritesss('writing to ',outfilen,' ...');

          assign(outfile,outfilen);

          if appending then
            begin
              append(outfile);
              writeln(outfile);
              writeln(outfile,outputseparator);
              writeln(outfile);
            end
          else
            begin
              rewrite(outfile);
            end;

    {need to check fullheaders here!}

          artreset;
          while not arteof do
            begin
              getartl(s,255,false);
              writeln(outfile,s);
            end;
          close(outfile);

          xclreolxy(1,lpp);
          xwrites('done.');
        end;
    end;
  browserefresh;
end;

procedure writeart;

begin
  savewriteart(false);
end;

procedure saveart;

begin
  savewriteart(true);
end;

procedure editart;

var
  doserr: integer;

begin
  if trusted then
    begin
      close(artf);
      mousehide;
      execp(editor,editoroptions+' '+artfn);
      mouseshow;
      doserr := doserror;
      if doserr<>0 then
        warnerr(editor,doserr);
      artreset;
      browserefresh;
    end;
end;

procedure replytoart;

var
  subject: string;
  inreplyto: string;
  replyaddr: string;
  artreplyto: string;
  newreplyaddr: string;
  replyname: string;
  defaultreply: boolean;
  author: string;
  originalfrom: string;
  ccaddr: string;

begin
  close(artf);
  subject := artsubject;
  subject := 'Re: '+nore(subject);
  inreplyto := artmessageid;

  artreplyto := getheaderline(artfn,'reply-to:');
  
  replyaddr := artreplyto;
  if replyaddr='' then
    replyaddr := artfrom;
  if replyaddr='' then
    replyaddr := mailfrom;

  author := getfromaddr(replyaddr);

{handle case where Reply-To: is same as From:, but without name - keep it}
  if getfromname(replyaddr)='' then
    if author=getfromaddr(artfrom) then
      replyaddr := artfrom;

  replyname := getfromname(replyaddr);
  replyaddr := getfromaddr(replyaddr);

  xclreolxy(1,lpp);
  xwrites('Reply To: ');
  newreplyaddr := replyaddr;
  xreadlns(newreplyaddr,cols-15,true);
  if newreplyaddr='' then
    newreplyaddr := replyaddr;
  defaultreply := (newreplyaddr=replyaddr);
  if not defaultreply then
    begin
      replyaddr := newreplyaddr;
      replyname := '';
    end;

{get the address (if possible) from aliases and user/*/forward files}

  replyaddr := expandmail(replyaddr);

  xclreolxy(1,lpp);

  xwrites('CC: ');
  xreadlns(ccaddr,cols-10,false);
  ccaddr := expandmail(ccaddr);
  xclreolxy(1,lpp);

  if replyaddr<>getfromaddr(artfrom) then
    originalfrom := artfrom
  else
    originalfrom := '';

  editanddeliver(subject,inreplyto,replyaddr,replyname,ccaddr,originalfrom,
   author,defaultreply);

  artreset;

{leave refresh to caller}

end;

procedure mailart;

begin
  warn('using `r''eply instead');
  replytoart;
  browserefresh;
end;

procedure browsecopytofolder;

var
  newgroup: string;
  newgroupdir: string;
  oldlastline: integer;

begin
  if ismailgroup(currgroup) then
    begin
      xclreolxy(1,lpp);
      xwrites('Folder: ');
      xreadlns(newgroup,max(cols-10,70),false);
      xclreolxy(1,lpp);
      if (newgroup<>'') and (numoccur('\',unslash(newgroup))=0) and
       (numoccur(':',newgroup)=0) and (pos('..',newgroup)=0) then
        begin
          if newgroup[1]<>'=' then
            newgroup := '='+newgroup;
          unfoldergroup(newgroup);
          if not joinedtogroup(newgroup) then
            addnewmailgroup(newgroup);
          newgroupdir := getgroupdir(newgroup);
          mkhier(newgroupdir);
          
          oldlastline := lastlineshown;

          close(artf);
          copyfile(artfn,getuniqfile(newgroupdir));

          artreset;
          lastlineshown := oldlastline;

        end;
      browserefresh;
    end;
end;

procedure browsemovetofolder;

var
  newgroup: string;
  newgroupdir: string;

begin
  if ismailgroup(currgroup) then
    begin
      xclreolxy(1,lpp);
      xwrites('Folder: ');
      xreadlns(newgroup,max(cols-10,70),false);
      xclreolxy(1,lpp);
      if (newgroup<>'') and (numoccur('\',unslash(newgroup))=0) and
       (numoccur(':',newgroup)=0) and (pos('..',newgroup)=0) then
        begin
          if newgroup[1]<>'=' then
            newgroup := '='+newgroup;
          unfoldergroup(newgroup);
          if not joinedtogroup(newgroup) then
            addnewmailgroup(newgroup);
          newgroupdir := getgroupdir(newgroup);
          mkhier(newgroupdir);
          
          close(artf);
          movefile(artfn,getuniqfile(newgroupdir));

{ if #3 is the highest-numbered, and you move #3, it'd mess up your }
{ join file.  perhaps it just should just re-enter the group somehow? }
{ or go through the data structures, removing any evidence of this }
{ article (harder when there's more than one!) }

          if (artfn=getuniqfile(newgroupdir)) and willupdatej then
            begin
              warn('join file will not be updated for this group');
              willupdatej := false;
            end;

          artopen := false;
          moreselecting := true;
          donebrowse := true;

        end
      else
        begin
          browserefresh;
        end;
    end;
end;

procedure followtoart(newfollowupto: string);

var
  followupto: string;
  newsgroups: string;
  originalnewsgroups: string;
  originalauthor: string;
  shouldmail: boolean;
  shouldfollow: boolean;
  replyfollow: char;
  subject: string;
  messageid: string;
  references: string;
  inreplyto: string;
  author: string;
  refline: string;
  ref1, ref2: string;

begin
  xclreolxy(1,lpp);
  xwrites('Follow...');

  close(artf);
  followupto := getheaderline(artfn,'followup-to:');
  newsgroups := artnewsgroups;
  originalnewsgroups := newsgroups;

  shouldfollow := true;
  shouldmail := (followupto='poster') or (followupto='sender') or 
   (pos('@',followupto)<>0) or (pos('!',followupto)<>0) or
   (pos('%',followupto)<>0);

{followups redirected to /dev/null - but there are local groups with no .}

  if pos('.',followupto)=0 then
    begin
      ;
    end;

  if shouldmail or ismailgroup(currgroup) then
    begin
      followupto := newsgroups;
      xclreolxy(1,lpp-2);
      xclreolxy(1,lpp-1);
      if ismailgroup(currgroup) then
        xwritelns('this is probably a private mail folder.')
      else
        xwritelns('author seemed to want replies by mail only.');
      replyfollow := 
       onekey('<r>eply by mail, <f>ollowup anyway, <q>uit ','rfq');
      shouldmail := (replyfollow='r');
      shouldfollow := (replyfollow='f');
    end;

{}{} {don't let untrusted users post yet}
  if not trusted then
    shouldmail := true;

  if shouldmail then
    begin
      artreset; {replytoart closes it immediately}
      replytoart;
    end
  else if shouldfollow then
    begin

{ don't propogate errors in the Newsgroups: line if you can help it }

      newsgroups := unspace(newsgroups);
      followupto := unspace(followupto);

{ignore Followup-To: when following up to a new group explicitly}

      if newfollowupto<>'' then
        followupto := '';

      if followupto='' then
        followupto := newsgroups
      else
        begin

{ give the user a warning, to avoid blind Followup-To: misc.test,talk.bizarre }
          if followupto<>newsgroups then
            warn('followups have been changed');
        end;

{ always warn again if there's a .test group in user's post }

      if pos('.test,',followupto+',')<>0 then
        begin
          warn('there is a .test group on this post');
          warn('remove it unless you _really_ understand it!');
        end;

{}{}{} {should warn user if there are unknown groups that might be errors}

{}{}{} {should do each group individually!}

      if newfollowupto<>'' then
        if newfollowupto<>'poster' then
          if pos(','+newfollowupto+',',','+followupto+',')=0 then
            followupto := followupto+','+newfollowupto;

{currgroup isn't necessarily even in the followupto list, so don't warn}
{about moderation when people post followups to, say,}
{news.announce.newgroups where followups are always redirected to news.groups}

{}{}{} {should check if _any_ group in the list is moderated, and give warning}
      if pos(','+currgroup+',',','+followupto+',')<>0 then
        if groupbattr(currgroup,'/mod') then
          warn('this group is moderated');

{}{}{} {should check if _any_ of the groups is marked as /solo => strip it out}
      if groupbattr(currgroup,'/solo') and (pos(',',followupto)<>0) then
        begin
          warn('warning: /solo group - crosspost removed');
          followupto := currgroup;
        end;

{ warn on 5 or more groups, suggest followupto of first group }
{ but don't overwrite previous :follow direction! }

      if (numoccur(',',followupto)>3) and (newfollowupto='') then
        begin
          warn('this is a massive crossposting.  check Followup-To: line');
          newfollowupto := copy(followupto,1,pos(',',followupto)-1);
        end;

      subject := artsubject;
      subject := 'Re: '+nore(subject);
      messageid := artmessageid;
      references := getheaderline(artfn,'references:');

{Andrew system non-compliance, looks like}

      inreplyto := getheaderline(artfn,'in-reply-to:');
      if pos('>',inreplyto)<>0 then
        inreplyto := copy(inreplyto,1,pos('>',inreplyto));

      if length(references)+length(inreplyto)<250 then
        if copy(inreplyto,1,1)='<' then
          references := references+' '+inreplyto;

      author := getheaderline(artfn,'reply-to:');
      if author='' then
        author := getheaderline(artfn,'from:');

{handle case where Reply-To: is same as From:, but without name - keep the}
{name if you can}

      if getfromname(author)='' then
        if getfromaddr(author)=getfromaddr(artfrom) then
          if getfromname(artfrom)<>'' then
            author := getfromaddr(author)+' ('+getfromname(artfrom)+')';

      originalauthor := '';
      if getfromaddr(author)<>getfromaddr(artfrom) then
        originalauthor := artfrom;


{ special-casing in getheaderline() makes sure we get the last few }
{ references always.  well, except on >255 char References: lines }

      ref1 := '';
      ref2 := '';

      refline := references;
      ref1 := chopfirstw(refline);
      if refline<>'' then
        begin
          ref2 := chopfirstw(refline);
        end;
      while numoccur('>',refline)>0 do
        begin
          ref1 := ref2;
          ref2 := chopfirstw(refline);
        end;

      refline := '';
      if ref1<>'' then
        refline := refline+ref1+' ';
      if ref2<>'' then
        refline := refline+ref2+' ';

      refline := refline+messageid;

      createpost(followupto,originalnewsgroups,newfollowupto,subject,
       refline,author,originalauthor);

      editandinjnews(followupto,originalnewsgroups,author);

    end;
  artreset;
  browserefresh;
end;

procedure follow;

var
  newfollowupto: string;

begin
  if trusted then
    begin
      newfollowupto := currgroup;
      xclreolxy(1,lpp);
      xwrites('Followup-To: ');
      xreadlnsp(newfollowupto,max(cols-10,70),true);

{possibly expand the group}
{explicitly does not expand to a mail folder -- that wouldn't make sense}
{neither expand the magic word `poster'}

{}{}{} {should expand _each_ group separately}

      if newfollowupto<>'poster' then
        if numoccur(',',newfollowupto)=0 then
          if joinedtogroup(newfollowupto) then
            ;

      followtoart(newfollowupto);

{followtoart does a browserefresh}

    end
  else
    begin
      warn('you do not have access to post this way');
      browserefresh;
    end;

end;

procedure cancel;

var
  yn: char;
  newsubj: string;

begin
  if trusted then
    begin
      xclreolxy(1,lpp-8);
      xclreolxy(1,lpp-7);
      xwritelnss('          you are: ',newsfrom);
      xclreolxy(1,lpp-6);
      xwritelnss('this article from: ',artfrom);
      xclreolxy(1,lpp-5);
      xclreolxy(1,lpp-4);
      if newsfrom=artfrom then
        xwritelns('(looks the same)')
      else
        xwritelns('NOT THE SAME!');
      xclreolxy(1,lpp-3);
      xclreolxy(1,lpp-2);
      xwritelns('cancel will remove this article from every system');
      xclreolxy(1,lpp-1);
      xwritelns('world-wide.  do not do this unless authorized.');
      xclreolxy(1,lpp);

      yn := onekey('are you SURE you are authorized Y/n (n)',
       'Yn '+chr(13));

      if yn<>'Y' then
        yn := 'n';
      
      if yn='Y' then
        begin
          newsubj := 'cmsg cancel '+artmessageid;
          createcancel(artnewsgroups,newsubj,artmessageid,artfrom);
          editandinjnews(artnewsgroups,'','');
        end;

    end
  else
    begin
      warn('you do not have access to cancel posts');
    end;

{caller must refresh}

end;

procedure killart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekey(
   'kill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtokill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if subjkilled(basesubjs[i]) then
              selected[i] := false;
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtokill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if fromkilled(fromsp^[i]) then
              selected[i] := false;
        end;
      donebrowse := true;
    end;
end;

procedure antikillart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekey(
   'antikill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if subjantikilled(basesubjs[i]) then
              begin
                selected[i] := true;
                indents[i] := indents[i] or 128;
              end;
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if fromantikilled(fromsp^[i]) then
              begin
                selected[i] := true;
                indents[i] := indents[i] or 128;
              end;
        end;
    end;
end;

procedure toggleheaders;

begin
  showallheaders := not showallheaders;
  firstblankline := maxint;
  rewindtopline(0);
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  browserefresh;
end;

procedure quitbrowsenoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  y/n ','yn')='y');
  if doit then
    begin
      xwriteln;
      if willupdatej then
        xwritelnss('quitting without updating join file for ',currgroup);
      xwriteln;
      donebrowse := true;
      donegroup := true;
      if willupdatej then
        begin
          currgroup := '';
          alreadyingroup := true;
          willupdatej := false;
        end;
    end
  else
    browserefresh;
end;

procedure nextgroupnoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmnext then
    doit := (onekey(
     'are you SURE you want to jump directly to the next group?  y/n ',
     'yn')='y');
  if doit then
    begin
      if willupdatej then
        begin
          xwriteln;
          xwritelns('join file not updated');
          xwriteln;
          willupdatej := false;
        end;
      donebrowse := true;
      donegroup := true;
    end
  else
    browserefresh;
end;

{}{} {might want to start at top of screen for this?}

procedure browsesearchnext;

var
  s: string;
  foundatline: integer;
  oldlastline: integer;

begin
  if arteof then
    donebrowse := true
  else
    begin
      oldlastline := lastlineshown;
      foundatline := -1;
      while not arteof and (foundatline<0) do
        begin
          getartl(s,cols-1,true);
          inc(lastlineshown);

{}{}{} {doesn't catch strings split over when you have long, wrapped lines!}

          if pos(uppersearchstring,upper(s))<>0 then
            foundatline := lastlineshown;
        end;
      if foundatline<0 then
        begin
          warn('not found');
          lastlineshown := oldlastline;
          browserefresh;
        end
      else
        rewindtopline(foundatline-2);
    end;
end;

procedure browsesearch;

var
  newsearchstring: string;

begin
  xclreolxy(1,lpp);
  xwrites('/');
  xreadlns(newsearchstring,max(cols-4,76),false);
  if newsearchstring='' then
    begin
      if asearchstring then
        browsesearchnext
      else
        browserefresh;
    end
  else
    begin
      asearchstring := true;
      uppersearchstring := upper(newsearchstring);
      browsesearchnext;
    end;
end;

procedure browsesearchagain;

begin
  if asearchstring then
    browsesearchnext;
end;

procedure browsecommand;

var
  commandline: string;

begin
  xclreolxy(1,lpp);
  xwrites(':');
  xreadlns(commandline,max(cols-4,76),false);
  if commandline='' then
    browserefresh
  else
    begin
      if commandline='help' then browsehelppage
      else if commandline='post' then begin post; browserefresh; end
      else if commandline='mail' then begin mail; browserefresh; end
      else if commandline='follow' then follow
      else if commandline='cancel' then begin cancel; browserefresh; end
      else if commandline='quit' then quitbrowsenoupdate
      else begin warn('unrecognized command'); browserefresh; end
    end;
end;

procedure geteopkey;

var
  ch: char;
  needakey: boolean;
  dataline: string[80];

begin
  repeat
    needakey := false;
    if hasmouse then
      dataline := '--'+time+'--?=help =<>npu^$'' --'+numlefts+'--'
    else
      dataline := '--'+time+'--?=help--'+numlefts+'--';
    if arteof then
      dataline := dataline+'(Bottom)--';
    if length(dataline)+length(currgroup)>(cols-6) then
      dataline := '--'+
       copy(currgroup,length(currgroup)-((cols-6)-length(dataline)),255)+
       dataline
    else
      dataline := '--'+currgroup+dataline;
    xwritess(dataline,' ');
    ch := xreadkey;
    xwrites(^M);
    xclreol;
    ch := browsemap[ch];
    if ch='?' then browsehelppage
    else if ch='n' then donebrowse := true
    else if ch='p' then begin donebrowse := true; browsedir := -1; end
    else if ch='b' then browseback
    else if ch='a' then browseahead
    else if ch='u' then rewindtopline(lastlineshown-lpp-(lpp div 2))
    else if ch='<' then rewindtopline(lastlineshown-lpp-(lpp div 2))
    else if ch='^' then rewindtopline(0)
    else if ch='$' then showlastline
    else if ch=#13 then morelines(1)
    else if ch=' ' then morelines(lpp-3)
    else if ch='>' then morelines(lpp-3)
    else if ch='d' then morelines(lpp div 2)
    else if ch='w' then begin writeart; needakey := true; end
    else if ch='s' then begin saveart; needakey := true; end
    else if ch='r' then begin replytoart; needakey := true; browserefresh; end
    else if ch='m' then begin mailart; needakey := true; end
    else if ch='C' then begin browsecopytofolder; needakey := true; end
    else if ch='M' then begin browsemovetofolder; needakey := true; end
    else if ch='f' then begin followtoart(''); needakey := true; end
    else if ch='k' then begin killart; needakey := true; browserefresh; end
    else if ch='K' then begin antikillart; needakey := true; browserefresh; end
    else if ch='e' then begin editart; needakey := true; end
    else if ch='D' then begin rot13ing := not rot13ing; browserefresh; end
    else if ch='h' then toggleheaders
    else if ch=^L  then browserefresh
    else if ch=^R  then begin rereadkillfiles; needakey := true; end
    else if ch='Q' then quitbrowsenoupdate
    else if ch='N' then nextgroupnoupdate
    else if ch='!' then begin shellout; browserefresh; end
    else if ch='=' then begin moreselecting := true; donebrowse := true; end
    else if ch=^I  then begin skipsection := true; donebrowse := true; end
    else if ch='/' then browsesearch
    else if ch='.' then browsesearchagain
    else if ch=':' then browsecommand
    else needakey := true;
  until donebrowse or not needakey;
end;

begin

  rot13ing := false;
  showallheaders := false;

  numlefts := itoa(numleft)+' more';
  if numleft=0 then
    numlefts := 'LAST';

  if not willupdatej then
    numlefts := numlefts+' (no update)';

  newbrowsescreen;
  nonactedleft := false;
  lastlineshown := 0;

  totlines := -1;
  firstblankline := maxint;
  asearchstring := false;
  uppersearchstring := '';

{ searchstring vars look redundant, but it's quicker to check a boolean }
{ than to do a string compare, I'm sure }

  artfn := groupdir+'\'+filenamesp^[artnum];

{don't get from fromsp^[] - need full name _and_ address for kill file}
  artfrom := getheaderline(artfn,'from:');

  artsubject := getheaderline(artfn,'subject:');
  artmessageid := getheaderline(artfn,'message-id:');
  artnewsgroups := getheaderline(artfn,'newsgroups:');

  assign(artf,artfn);

  donebrowse := false;  {artreset could change this}

  browserefresh;  {does an artreset itself}

  while not donebrowse do
    begin

{if we've already read off the end of the article, it's time for a new one}
      if arteof and not nonactedleft then
        donebrowse := true
      else
        begin

{otherwise indicate all has been seen and get a key}

          nonactedleft := false;
          geteopkey;
        end;
    end;

  if artopen then
    close(artf);

end;

procedure viewarts(lowest,highest: integer; updatehighestread: boolean);

var
  numleft: integer;
  i: integer;
  willupdatej: boolean;
  currsubj: subjstringt;

begin

  willupdatej := updatehighestread;

  currart := lowest;
  donegroup := false;
  browsedir := 1;
  browseonlysel := true;
  while not moreselecting and not donegroup do
    begin

      if skipsection then
        begin

          currsubj := basesubjs[currart];
          while (currart<=highest) and subjseq(currsubj,basesubjs[currart]) do
            inc(currart);

{short-circuit}

           while (currart<=highest) and not selected[currart] do
             inc(currart);
        end

      else

        if browseonlysel then
          while (currart>=lowest) and (currart<=highest) and
           not selected[currart] do
            inc(currart,browsedir);


      skipsection := false;
      browseonlysel := true;

      if currart>highest then
        donegroup := true;
      if currart<lowest then
        browsedir := 1;
      if (currart>=lowest) and (currart<=highest) then
        begin
          browsedir := 1;

{using k/b/a can mess this up any nice and simple way, so do it this way}
{will still show LAST when you're past the last selected one - so what}

          numleft := 0;
          for i := currart+1 to highest do
            if selected[i] then
              inc(numleft);

          browseart(currart,numleft,willupdatej);
          if (atow(filenamesp^[currart])>highestread) and willupdatej then
            highestread := atow(filenamesp^[currart]);
        end;

{ handle case of going to non-selected-also articles on extremes (first/last) }

{ allow `n' etc. to indicate finished reading, but not `a',`p',`b' }

      if ((browsedir>0) or (currart>lowest)) and
       (browseonlysel or (browsedir<0) or (currart<highest)) and
       not skipsection then
        inc(currart,browsedir);

    end;

{willupdatej can change to false part way through}

  if not willupdatej then
    highestread := 0;

end;

procedure selectandbrowse;

var
  i: integer;
  donepagesel: boolean;
  donegroupsel: boolean;
  topline,botline: integer;
  selsubjs: array[1..maxlpp] of string;
  inkey,lastinkey: char;
  highestlegalsellet: char;
  highestlegalseldig: char;

function isselchar(ch: char): boolean;

begin
  isselchar :=
   ((ch<=highestlegalsellet) and (islower(ch))) or
   ((ch<=highestlegalseldig) and (isdigit(ch)));
end;

function selcharnum(ch: char): integer;

begin
  if isdigit(ch) then
    selcharnum := ord(ch)-ord('0')+26
  else
    selcharnum := ord(ch)-ord('a');
end;

procedure writetotalselln(lineno: integer; c: char);

var
  ycoord: integer;
  printsubj: string;
  i: integer;

begin
  if selected[lineno] then
    xhighvideo
  else
    xlowvideo;
  ycoord := lineno-topline+1+selheaderlines+1;
  if lineno-topline<26 then
    writexy(1,ycoord,chr(ord('a')+lineno-topline))
  else
    writexy(1,ycoord,chr(ord('0')+lineno-topline-26));

  xwrites(c);
  xwrites(nobeep(copy(fromsp^[lineno],1,20)));

{$ifdef testsort}
  writexy(3,ycoord,'               ');
  writexy(3,ycoord,filenamesp^[lineno]);
{$endif}

  xgotoxy(24,ycoord);
  xwriteiw(sizeink[lineno],4);
  printsubj := '';
  for i := 1 to (indents[lineno] and $f) do
    printsubj := printsubj+'>';
  printsubj := printsubj+selsubjs[lineno-topline+1];
  printsubj := nobeep(printsubj);
  if printsubj='' then
    writexy(29,ycoord,'-')
  else
    writexy(29,ycoord,copy(printsubj,1,50));
  xlowvideo;
  xgotoxy(1,sellpp+selheaderlines+4);
end;

procedure clearstar;

begin
  if starbeside<>0 then
    begin
      writexy(2,starbeside-topline+1+selheaderlines+1,' ');
      starbeside := 0;
    end;
end;

procedure writeselln(lineno: integer);

begin
  clearstar;
  writetotalselln(lineno,' ');
end;

procedure writesellnstar(lineno: integer);

begin
  clearstar;
  writetotalselln(lineno,'*');
  starbeside := lineno;
end;

procedure selrefresh;

var
  i: integer;
  prevsubj: subjstringt;
  percent: integer;

begin
  prevsubj := '';
  xclrscr;
  xgotoxy(1,1);
  if hasmouse then
    begin
      xwritess(currgroup,' ');
      xwrites(mousecharsheader);
      xwrites('  Articles: ');
      xwritei(numarts);
      xclreol;
    end
  else
    xwritessis(currgroup,' Articles: ',numarts,'                      ');
  botline := topline-1;
  for i := topline to min(topline+sellpp-1,numarts) do
    begin
      if subjseq(basesubjs[i],prevsubj) then
        selsubjs[i-topline+1] := ''
      else
        selsubjs[i-topline+1] := basesubjs[i];
      prevsubj := basesubjs[i];
      writeselln(i);
      botline := i;
    end;

  if numarts>600 then
    percent := (10*botline) div (numarts div 10)
  else if numarts>300 then
    percent := (20*botline) div (numarts div 5)
  else
    percent := (100*botline) div numarts;
  if percent>100 then
    percent := 100;   {handle roundoffs more gracefully!}

  xgotoxy(1,sellpp+selheaderlines+3);
  xwritelnsssisis('?=help  ',time,'   ',percent,'% through this group   ',
   numarts-botline,' more on later screen(s)');
  xclreol;
  xgotoxy(1,sellpp+selheaderlines+4);

{there will always be at least one letter, but not always any digits}

  highestlegalsellet := 'z';
  highestlegalseldig := ' ';

  if botline-topline<26 then
    highestlegalsellet := chr(ord('a')+botline-topline)
  else
    highestlegalseldig := chr(ord('0')+botline-topline-26);
end;

procedure togglekey(inkey: char);

var
  artnum: integer;

begin
  artnum := topline+selcharnum(inkey);
  if artnum<=botline then
    begin
      selected[artnum] := not selected[artnum];
      if hasmouse and selected[artnum] then
        writesellnstar(artnum)
      else
        writeselln(artnum)
    end;
end;

procedure selreversepage;

var
  artnum: integer;

begin
  for artnum := topline to botline do
    begin
      selected[artnum] := not selected[artnum];
      writeselln(artnum);
    end;
end;

procedure selclearall;

var
  artnum: integer;

begin
  for artnum := 1 to numarts do
    selected[artnum] := false;
end;

procedure dostar(inkey: char);

var
  artnum: integer;
  currsubj: subjstringt;

begin
  artnum := topline+selcharnum(inkey);
  currsubj := basesubjs[artnum];
  while (artnum<=numarts) and subjseq(currsubj,basesubjs[artnum]) do
    begin
      if not selected[artnum] then
        begin
          selected[artnum] := true;
          if artnum<=botline then
            writeselln(artnum);
        end;
      inc(artnum);
    end;
end;

procedure dodash(inkey: char);

var
  inkeyint: integer;
  artnum: integer;
  newkey: char;
  newkeyint: integer;

begin
  inkeyint := selcharnum(inkey);
  xclreolxy(1,lpp);
  xwritess(inkey,'-');
  newkey := xreadkey;
  newkey := selmap[newkey];
  if isselchar(newkey) then
    begin
      newkeyint := selcharnum(newkey);
      if (newkeyint<botline-topline+1) and (newkeyint>=inkeyint) then
        for artnum := topline+inkeyint to topline+newkeyint do
          if not selected[artnum] then
            begin
              selected[artnum] := true;
              writeselln(artnum);
            end;
    end;
  xclreolxy(1,lpp);
end;

procedure backpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if topline=1 then
        topline := numarts-((numarts-1) mod sellpp)
      else
        dec(topline,sellpp);
      selrefresh;
    end;
end;

procedure forwardpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if botline=numarts then
        topline := 1
      else
        inc(topline,sellpp);
      selrefresh;
    end;
end;

procedure firstpage;

begin
  if topline<>1 then
    begin
      topline := 1;
      selrefresh;
    end;
end;

procedure lastpage;

begin
  if botline<>numarts then
    begin
      topline := numarts-((numarts-1) mod sellpp);
      selrefresh;
    end;
end;

procedure browseandreturn;

var
  anyselected: boolean;
  currart: integer;

begin
  anyselected := false;
  for currart := topline to botline do
    if selected[currart] then
      anyselected := true;
  if anyselected then
    begin
      viewarts(topline,botline,false);
{ if hit `=', don't reset selected[] }
      if not moreselecting then
        for currart := topline to botline do
          selected[currart] := false;
      if currgroup<>'' then
        selrefresh;
    end;
  moreselecting := false;
end;

procedure writehighlightedarts;

var
  currart: integer;
  ch: char;

begin
  warn('W - not implemented yet - sorry');
end;

procedure unsubscribe;

var
  doit: boolean;
  nextgroup: string;

begin
  doit := (onekey('are you SURE you want to unsubscribe?  y/n ','yn')='y');
  if doit then
    begin
      nextgroup := getnextgroup;  {empty string is ok, too}
      xclreolxy(1,lpp);
      updatejoinunsubscribe;
      selclearall;
      currgroup := nextgroup;
      alreadyingroup := true;
      donegroupsel := true;
    end
  else
    selrefresh;
end;

procedure gotonewgroup;

var
  possgroup: string;

begin
  possgroup := '';
  pickagroup(possgroup);
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      selrefresh;
    end
  else
    begin
      selclearall;
      currgroup := possgroup;
      alreadyingroup := true;
      donegroupsel := true;
    end;
end;

{

NO LONGER USED HERE -- see pickagroup in rusnproc.pas

procedure gotonewgroup;

var
  possgroup: string;
  howto: char;

begin
  xclreolxy(1,lpp);
  xwrites('Goto group (or initials): ');
  possgroup := currgroup;
  xreadlns(possgroup,cols-30,true);
  if (possgroup='') then
    xclreolxy(1,lpp)
  else
    if joinedtogroup(possgroup) then
      begin
        selclearall;
        alreadyingroup := true;
        currgroup := possgroup;
        donegroupsel := true;
        howto := 
         onekey('<j>ump normally, <a>ll, <r>ecent (default=j) ','jar '+#13);
        if (howto=' ') or (howto=#13) then
          howto := 'j';
        xclreolxy(1,lpp);
        if howto='a' then
          readallarts := true;
        if howto='r' then
          readrecentarts := true;
      end
    else
      warn('could not find a group to match');
end;
}


procedure selprevgroup;

var
  prevgroup: string;
  foundgroup: string;

begin
  selclearall;
  prevgroup := '..invalid..';
  foundgroup := prevgroup;
  reset(joinf);
  repeat
    prevgroup := foundgroup;
    readln(joinf,foundgroup);
    foundgroup := getfirstw(foundgroup);
  until foundgroup=currgroup;
{}{should check eof - I guess}
  if prevgroup<>'..invalid..' then
    begin
      currgroup := prevgroup;
      donegroupsel := true;
      alreadyingroup := true;
    end;
{}{need more error checking here...}
{}{also, it just goes back 1 group - not to the one with something to read!}
end;

procedure selsearch;

var
  searchstring: string;
  i: integer;

begin
  xclreolxy(1,lpp);
  xwrites('=');
  xreadlns(searchstring,max(cols-4,76),false);
  if searchstring<>'' then
    begin
      searchstring := upper(searchstring);
      for i := 1 to numarts do
        if pos(searchstring,upper(fromsp^[i]))<>0 then
          selected[i] := true
        else if pos(searchstring,upper(basesubjs[i]))<>0 then
          selected[i] := true;
    end;
  selrefresh;
end;

procedure selquit;

var
  doit: boolean;
  i: integer;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  y/n ','yn')='y');
  if doit then
    begin
      alreadyingroup := true;
      currgroup := '';
      donegroupsel := true;
      for i := 1 to numarts do
        selected[i] := false;
    end
  else
    selrefresh;
end;

procedure selhelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (940524)');
  writexy(1,4,'letter,digit - toggle whether or not to read that article');
  writexy(1,5,'c-f - highlight c through and including f');
  writexy(1,6,'g*  - highlight g and all with same subject');
  writexy(1,7,'space, enter - go to next screen (or start browsing at end)');
  writexy(1,8,'N   - go to next group (but browse first)');
  writexy(1,9,'X   - like N, but mark _all_ articles as read after');
  writexy(1,10,'P   - go to previous group      = select matching');
  writexy(1,11,'@   - reverse all selections on this page');
  writexy(1,12,'~   - clear all selections (all pages)');
  writexy(1,13,'^L  - refresh screen    ^R - reread kill and antikill files');
  writexy(1,14,'<   - go back a page (wraps)      ^ - first page');
  writexy(1,15,'>   - go forward a page (wraps)   $ - last page');
  writexy(1,16,'Z   - browse articles on this page (will not mark as read)');
  writexy(1,17,'W   - write selected articles (this or all pages) (not yet)');
  writexy(1,18,'G   - goto group; can shorten each word (eg. c.b.waf)');
  writexy(1,19,'!   - shell escape        + - select antikilled articles');
  writexy(1,20,'U   - unsubscribe from this group');
  writexy(1,21,'?   - help                Q - quit');
  writexy(1,23,'press any key to return ');
  ch := xreadkey;
  selrefresh;
end;

procedure selcommand;

var
  commandline: string;

begin
  xclreolxy(1,lpp);
  xwrites(':');
  xreadlns(commandline,max(cols-4,76),false);
  if commandline='' then
    selrefresh
  else
    begin
      if commandline='help' then selhelppage
      else if commandline='post' then begin post; selrefresh; end
      else if commandline='mail' then begin mail; selrefresh; end
      else if commandline='quit' then selquit
      else begin warn('unrecognized command'); selrefresh; end
    end;
end;

procedure selcatch;

begin
  donegroupsel := true;
  highestread := highestart;
end;

procedure selspace;

var
  artnum: integer;
  anyselected: boolean;

begin
  if makespacelikex and (botline=numarts) then
    begin
      anyselected := false;
      for artnum := 1 to numarts do
        if selected[artnum] then
          anyselected := true;
      if anyselected then
        selcatch
      else
        donepagesel := true;
    end
  else
    donepagesel := true;
end;

procedure selantikill(veryfirsttime: boolean);

var
  i: integer;
  firstnew: integer;  {firstnew=maxint <=> no articles antikilled}

begin
  firstnew := maxint;
  for i := 1 to numarts do
    if ((indents[i] and 128)<>0) and not selected[i] then
      begin
        if i<firstnew then
          firstnew := i;
        selected[i] := true;
      end;

  if firstnew<=numarts then
    begin
      if (firstnew>sellpp) and warnautoantikill then
        begin
          if veryfirsttime then
            selrefresh;
          warn('at least one article antikilled');
        end;

      if not veryfirsttime then
        selrefresh;
    end;
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  if autoantikill then
    selantikill(false);
  selrefresh;
end;




begin
  for i := 1 to numarts do
    selected[i] := false;

  donegroupsel := (numarts=0);
  lastinkey := ' ';
  topline := 1;

  if not donegroupsel and autoantikill then
    selantikill(true);

  moreselecting := false;
  skipsection := false;
  starbeside := 0;

  while not moreselecting and not donegroupsel and (currgroup<>'') do
    begin
      donepagesel := false;
      selrefresh;
      while not donegroupsel and not donepagesel and (currgroup<>'') do
        begin
          inkey := xreadkey;
          inkey := selmap[inkey];
          if inkey='?' then selhelppage
          else if isselchar(inkey) then togglekey(inkey)
          else if inkey='<' then backpage
          else if inkey='>' then forwardpage
          else if inkey='^' then firstpage
          else if inkey='$' then lastpage
          else if inkey=' ' then selspace
          else if inkey=#13 then selspace
          else if (inkey='*') and isselchar(lastinkey) then dostar(lastinkey)
          else if (inkey='-') and isselchar(lastinkey) then dodash(lastinkey)
          else if inkey='Z' then browseandreturn
          else if inkey='W' then writehighlightedarts
          else if inkey='U' then unsubscribe
          else if inkey='G' then gotonewgroup
          else if inkey='N' then donegroupsel := true
          else if inkey='@' then selreversepage
          else if inkey='~' then begin selclearall; selrefresh; end
          else if inkey='X' then selcatch
          else if inkey='P' then selprevgroup
          else if inkey=^L  then selrefresh
          else if inkey=^R  then rereadkillfiles
          else if inkey='!' then begin shellout; selrefresh; end
          else if inkey='+' then selantikill(false)
          else if inkey='=' then selsearch
          else if inkey=':' then selcommand
          else if inkey='Q' then selquit;
          lastinkey := inkey;
        end;

      if botline<numarts then
        inc(topline,sellpp)
      else
        donegroupsel := true;

{moreselecting is always false here}

      if donegroupsel then
        viewarts(1,numarts,true);

      if moreselecting then
        donegroupsel := false;

      moreselecting := false;

    end;

end;

end.
