/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

#include "st.h"

/*
 * Sound Tools file format and effect tables.
 */

/* File format handlers. */

char *rawnames[] = {
	"raw",
	(char *) 0
};
extern rawstartread(), rawread();
extern rawstartwrite(), rawwrite(), rawstopwrite();

char *vocnames[] = {
	"voc",
	(char *) 0
};
extern vocstartread(), vocread(), vocstopread();
extern vocstartwrite(), vocwrite(), vocstopwrite();


char *wavnames[] = {
	"wav",
	(char *) 0
};

extern wavstartread(),wavread();
extern wavstartwrite(),wavwrite(),wavstopwrite();

char *matnames[] = {
	"mat",
	(char *) 0
};

extern matstartread(),matread();
extern matstartwrite(),matwrite(),matstopwrite();

extern nothing();

format_t formats[] = {
	{matnames,matstartread,matread,nothing,
		matstartwrite,matwrite,matstopwrite},   /* Matlab .mat files */
	{rawnames, rawstartread, rawread, nothing, 	/* Raw format */
		rawstartwrite, rawwrite, nothing},
	{vocnames, vocstartread, vocread, vocstopread,  /* Sound Blaster .VOC */
		vocstartwrite, vocwrite, vocstopwrite},
	{wavnames,wavstartread,wavread,nothing,
		wavstartwrite,wavwrite,wavstopwrite},   /* Windows 3.0 .wav */
	0
};

/* Effects handlers. */

extern null_drain();		/* dummy drain routine */

extern copy_getopts(), copy_start(), copy_flow(), copy_stop();

/*
 * EFF_CHAN means that the number of channels can change.
 * EFF_RATE means that the sample rate can change.
 * The first effect which can handle a data rate change, stereo->mono, etc.
 * is the default handler for that problem.
 * 
 * EFF_MCHAN just means that the effect is coded for multiple channels.
 */

effect_t effects[] = {
	{"copy", EFF_MCHAN,
        	copy_getopts, copy_start, copy_flow, null_drain, nothing},
	0
};

