
{$I-}   {I/O checking must be off.}

program setini;

uses dos,strings;

{  Program to make automated modifications to Windows style .INI files.  }

const {initialised variables}
  status : (looking, in_section, done) = looking;

var

  filename      : string;                             {file name to process}
  section       : string;                             {file section to find}
  keyname       : string;                             {keyname to find}
  value         : string;                             {new value}
  option        : string;                             {may be /add or /del}
  thisline      : string;                             {current line}
  oldline       : string;                             {line to search for}
  newline       : string;                             {line to substitute, or
                                                       blank for delete}
  tempfile      : pathstr;                            {temp file name}
  tempdir       : dirstr;                             {components of temp}
  tempname      : namestr;                            {file name}
  tempext       : extstr;
  inputfile, outputfile : text;


procedure syntaxerror;

  begin
    writeln('SETINI Windows Configuration Changer v1.3 - (C) Cardiology Dept, RMH.');
    writeln('  by Peter Summers <U5533129@ucsvc.ucs.unimelb.edu.au> - 16 Mar 94');
    writeln;
    writeln('SYNTAX: SETINI <file> <section> <keyname> <value> <option>');
    writeln;
    writeln('  eg. SETINI c:\windows\system.ini 386Enh TimerCriticalSection 10000');
    writeln('      SETINI c:\windows\win.ini "Microsoft Word 2.0" DOC-path h:\');
    writeln('      SETINI c:\windows\system.ini 386Enh device *vtd /del');
    writeln('      SETINI c:\windows\system.ini 386Enh device vtda.386 /add');
    halt(1);
  end;


function nextarg:string;

{retrieves the next arguement from command line, using quotes for delimiting}

  const param : integer = 1;            {use for parsing command line}
  var   arg : string;

  begin
    arg := paramstr(param);
    param := param + 1;

    if arg[1] = '"' then
      begin
        delete(arg,1,1);                        {delete starting quote}
        while (arg[length(arg)] <> '"') do
        begin
          if param > paramcount then syntaxerror;
          arg := arg + ' ' + paramstr(param);
          param := param + 1;
        end;
        delete(arg,length(arg),1);              {delete ending quote}
      end;
    nextarg := arg;
  end;


function match(string1,string2:string):boolean;

{case sensitive check that first string matches start of second string.
 note that match('ab','abc') = true
           match('abc','ab') = false }

  var i:integer;

  begin
    for i:=1 to length(string1) do
      if (i>length(string2)) or (upcase(string1[i])<>upcase(string2[i])) then
        begin
          match:=false;
          exit;
        end;
    match:=true;
  end;


procedure writeout(line:string);

{write a line to output file and check the result}

  begin
    writeln(outputfile,line);
    if IOresult<>0 then
      begin
        writeln('Can''t write to file '+tempfile+'.');
        halt(5);
      end;
  end;


begin {program}

  if paramcount<4 then syntaxerror;

  filename:=nextarg;
  assign(inputfile, filename);               {open input file}
  reset(inputfile);
  if IOresult<>0 then
    begin
      writeln('Can''t open for reading file '+filename+'.');
      halt(2);
    end;

  section := nextarg;
  if section = '' then syntaxerror;
  if section[1] <> '[' then section := '[' + section + ']';

  keyname := nextarg;
  if keyname = '' then syntaxerror;

  value := nextarg;

  option := nextarg;

  if match('/add',option) then
    begin
      oldline := keyname+'='+value;
      newline := keyname+'='+value;
    end
  else if match('/del',option) then
    begin
      oldline := keyname+'='+value;
      newline := '';
    end
  else {default}
    begin
      oldline := keyname+'=';
      newline := keyname+'='+value;
    end;

  fsplit(filename,tempdir,tempname,tempext);
  tempfile := tempdir+tempname+'.$$$';

  assign(outputfile, tempfile);
  rewrite(outputfile);
  if IOresult<>0 then
    begin
      writeln('Can''t open for writing file '+tempfile+'.');
      halt(3);
    end;

  while(not eof(inputfile)) do
    begin
      readln(inputfile,thisline);               {read a line from input file}
      if IOresult<>0 then
        begin
          writeln('Can''t read from file '+filename+'.');
          halt(4);
        end;

      if thisline[1] = '[' then                 {we've started a new section}
        case status of
          looking:
            if match(section,thisline) then
              status := in_section;
          in_section:
            if newline<>'' then
              begin
                writeout(newline);
                writeln('"'+newline+'" added to '+section+' section of '
                  +filename+'.');
                status:=done;
              end;
        end;

      if (status = in_section) and match(oldline,thisline) then {do our stuff}
        begin
          if newline='' then
            writeln('"'+oldline+'" deleted from '+section+' section of '
              +filename+'.')
          else
            begin
              writeout(newline);
              writeln('"'+newline+'" set in '+section+' section of '
                +filename+'.');
            end;
          status:=done;
        end
      else if thisline <> '' then          {otherwise just write out the line}
        begin
          if thisline[1] = '[' then writeout('');
          writeout(thisline);
        end;
    end;                                            {end of main loop}

  if newline <> '' then
    case status of
      looking:
        begin
          writeout('');
          writeout(section);
          writeout(newline);
          writeln('"'+newline+'" added to new '+section+' section of '
            +filename+'.');
        end;
      in_section:
        begin
          writeout(newline);
          writeln('"'+newline+'" added to '+section+' section of '
            +filename+'.');
        end;
    end
  else if status<>done then
    writeln('"'+oldline+'" not found in '+section+' section of '+filename+'.');

  close(inputfile);
  close(outputfile);

  erase(inputfile);

  if IOResult<>0 then
    begin
      writeln('Couldn''t delete old version of '+filename+'.');
      halt(6);
    end;

  rename(outputfile,filename);

  if IOResult<>0 then
    begin
      writeln('Couldn''t rename temporary file '+tempfile+'.');
      halt(7);
    end;

end.
