#ifndef HEXMAZE_H
#define HEXMAZE_H

//      Each instance of this class is a maze having hexagonal rooms.

//      This class uses the classes "cell" (room of a maze) and "oracle"
// (random number generator).

class hexmaze
  {
    private:
      oracle       *column_selector;
//      Random number generator to select column to start constructing maze.

      struct
        {
           int row_num;
           int column_num;
        }          current;
//      Current location in maze.

      void         draw_line_on_page(int x1,int y1,int x2,int y2);
//      Draw wall (of bricks) on "page".

      struct
        {
           int row_num;
           int column_num;
        }          first;
//      Location of the starting room.

      int          max_x;

      int          memory_allocated;
//      The memory for the maze has been allocated.

      int          num_columns;
//      Number of columns in maze.

      int          num_rows;
//      Number of rows in maze.

      int          num_x_dots;
//      Number of columns of bricks in maze.

      int          num_y_dots;
//      Number of rows of bricks in maze.

      oracle       *order_selector;
//      Random number generator to select the order walls are to considered.

      char         **page;
//      Two dimensional plot of maze, one element per possible brick position.
// 'W' if brick is present; ' ' otherwise.

      cell         **room;
//      Two dimensional array of rooms composing the maze.

      oracle       *row_selector;
//      Random number generator to select row to start constructing maze.

      void         set_point_on_page(int x,int y);
//      Place a section of wall on "page".  Each section is "wall_thickness"
// bricks long and "wall_thickness" bricks wide.

      int          wall_thickness;
//      Thickness of wall in "bricks".

      TFrameWindow *window_ptr;

      int          x_dot_max;
//      num_x_dots-1

      int          y_dot_max;
//      num_y_dots-1

    public:

      int    constructed(void) {return memory_allocated;}
//      Return TRUE if and only if the maze is successfully constructed.

      int    external_to_maze(double x,double y);
//      Return TRUE if and only if a point (x,y) is external to the maze.

      double f(double x,double y);
//      Return 5.0*wall_thickness if a point (x,y) is on a wall, 0.0 otherwise.

             hexmaze(int row_count,int column_count,int thickness_of_wall,
              char *seed,TFrameWindow *win_ptr);
//      Contruct a maze having "row_count" rows and "column_count" columns of
// rooms.  The walls should be "thickness_of_wall" (bricks) thick.  A different
// (8 character of less) "seed" generally yields a different maze.

             ~hexmaze(void);

      int    maze_okay(void);
//      TRUE if and only if solving the maze is difficult enough.

      int    num_x_divisions(void) {return num_y_dots+2;}
//      Recommended number of x divisions for plotting f(x,y).

      int    num_y_divisions(void) {return num_x_dots+2;}
//      Recommended number of y divisions for plotting f(x,y).

      int    part_of_solution(double x,double y);
//      Return TRUE if and only if a point (x,y) is on a wall outlining the
// solution to the maze.

      double x_max(void) {return double(num_y_dots);}
//      Recommended maximum value of x for plotting f(x,y).

      double x_min(void) {return(-1.0);}
//      Recommended minimum value of x for plotting f(x,y).

      double y_max(void) {return double(num_x_dots);}
//      Recommended maximum value of y for plotting f(x,y).

      double y_min(void) {return(-1.0);}
//      Recommended minimum value of y for plotting f(x,y).
  };

#endif
