//***************************************************************************
//
//  PROGRAM:    WinZip.c
//
//  PURPOSE:    Windows Zip/Unzip Application
//
//  FUNCTIONS:
//
//      WinMain() - calls initialization function, processes message loop
//      InitApplication() - initializes window data and registers window
//      InitInstance() - saves instance handle and creates main window
//      MainWndProc() - processes messages
//      StatusWndProc() - processes status bar messages
//      About() - processes messages for "About" dialog box
//      PadCol() - pad with spaces
//      ErrorHandler() - processes DB-Library errors
//      MessageHandler() - processes SQL Server messages
//
//  COMMENTS:
//
//***************************************************************************

#if (_M_IX86 > 300)
	#define WIN32
#endif

#define STRICT
#include <windows.h>            // standard Windows include file
#include <shellapi.h>			// drag & drop include file
#include <commdlg.h>            // common dialog include file
#include <string.h>             // standard C string include file
#define DBMSWIN                 // needed to define environment
#include "winutil.h"            // utility function include file

#include "winzip.h"             // dialogs include file
#include "windlg.h"             // dialogs include file
#include "resources.h"
#include "unzip.h"

// GLOBAL VARIABLES

char szAppName[] = "WinZip";          // application name
char szStatusName[] = "WZStatusBar";    // status bar name
char szDblibVersion[] = "ZIP Info 1.1";

FARPROC lpMessageHandler,               // pointer to MessageHandler
    lpErrorHandler;                     // pointer to ErrorHandler
HINSTANCE hInst;                        // current instance
HWND hWnd;                              // current window
HWND hResult,                            // handle to result edit control 
     hStatus;                            // handle to status bar

HGLOBAL hResultDS;
LPSTR lpResultDS;
HGLOBAL hQueryDS;
LPSTR lpQueryDS;

char szStatus[100] = "Ready";           // string displayed on status bar

HCURSOR hHourGlass, hSaveCursor;

HMENU hMenu;

GLOBALMEM glbmemResult, 
    glbmemSend, 
    glbmemRow, 
    glbmemHeader, 
    glbmemUnderline;

//HGLOBAL hResultBuffer;                  // handle to result buffer
//LPSTR lpResultBuffer;                   // long pointer to result buffer

// Variables for file I/O and common dialogs
OPENFILENAME ofnZIP;
OPENFILENAME ofnResult;

char lpstrFilterQuery[128] = "ZIP File (*.zip)\0*.zip\0All Files (*.*)\0*.*\0";
char lpstrCustomFilterQuery[128] = "";
char lpstrInitDirQuery[128] = "\0";
char lpstrFileQuery[128] = "\0";

char lpstrFilterResult[128] = "Result File (*.lst)\0*.lst\0All Files (*.*)\0*.*\0";
char lpstrCustomFilterResult[128] = "";
char lpstrInitDirResult[128] = "\0";
char lpstrFileResult[128] = "\0";

char  *argv[20];
int argc;

//***************************************************************************
//
//  FUNCTION:   StatusWndProc()
//
//  PURPOSE:    Processes messages
//
//  MESSAGES:
//
//      WM_PAINT -
//
//  COMMENTS:
//
//**************************************************************************

LRESULT CALLBACK StatusWndProc(
    HWND hWindow,
    UINT message,
    WPARAM wParam,
    LPARAM lParam)
{
    PAINTSTRUCT ps;
    TEXTMETRIC tm;
    char szStr[100];
    int wCharWidth;

    switch (message)
    {
    case WM_PAINT:    // message: repaint status bar window
        BeginPaint (hWindow, &ps);
        SetBkMode (ps.hdc, TRANSPARENT);
        GetTextMetrics (ps.hdc, &tm);
        wCharWidth = tm.tmAveCharWidth;
        wsprintf (szStr, szStatus);
        TextOut (ps.hdc, 0, 0, szStr, lstrlen(szStr));
        if (*zipfn == '\0')
            wsprintf (szStr, "Server: %s", (LPSTR)"(none)");
        else
            wsprintf (szStr, "ZIP Name: %s", (LPSTR)zipfn);
        TextOut (ps.hdc, wCharWidth*20, 0, szStr, lstrlen(szStr));
        EndPaint (hWindow, &ps);
        break;
    default:
        return (DefWindowProc(hWindow, message, wParam, lParam));
    }
    return (NULL);
}

//****************************************************************************
//
//  FUNCTION:   About()
//
//  PURPOSE:    Processes messages for "About" dialog box
//
//  MESSAGES:
//
//      WM_INITDIALOG - initialize dialog box
//      WM_COMMAND    - Input received
//
//  COMMENTS:   TRUE must be returned to Windows.
//
//**************************************************************************

BOOL FAR PASCAL About(
    HWND hDlg,
    UINT message,
    WPARAM wParam,
    LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:     // message: initialize dialog box
        SetDlgItemText(hDlg,
            SFQL_DBLIBVERSION,
            szDblibVersion);
        return (TRUE);

    case WM_COMMAND:    // message: received a command

        switch (wParam)
        {
        case IDOK:
        case IDCANCEL:
            EndDialog(hDlg, TRUE);
            return (TRUE);
            break;
        }
        break;
    }
    return (FALSE);     // Didn't process a message
}

//***************************************************************************
//
//  FUNCTION:   InitInstance()
//
//  PURPOSE:    Saves instance handle and creates main window
//
//  COMMENTS:
//
//**************************************************************************

BOOL InitInstance(
    HINSTANCE hInstance,
    int nCmdShow)
{
    DWORD dwEditStyle;      // style bits for edit controls
    HFONT hFixedFont;       // handle to stock fixed font

    // Save the instance handle in static variable, which will be used in
    // many subsequent calls from this application to Windows.
    hInst = hInstance;

    // Create a main window for this application instance
    hWnd = CreateWindow(szAppName,  // Class to use
        "Zip Info v1.1a",                 // Text for window title bar
        WS_OVERLAPPEDWINDOW,        // Window style
        CW_USEDEFAULT,              // Default horizontal position
        CW_USEDEFAULT,              // Default vertical position
        CW_USEDEFAULT,              // Default width
        CW_USEDEFAULT,              // Default height
        NULL,                       // Overlapped windows have no parent
        NULL,                       // Use the window class menu
        hInstance,                  // This instance owns this window
        NULL);                      // Pointer not needed

    // If window could not be created, return "failure"
    if (!hWnd)
        return (FALSE);

    // Set style bit for edit controls
    dwEditStyle = WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
        ES_LEFT | ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL;

    hMenu = LoadMenu(hInstance, "WinQueryMenu");
    SetMenu(hWnd, hMenu);

#if defined (WIN32)
    // Create result edit window
    hResult = CreateWindow("edit",  // edit control class
        NULL,                       // text of control
        dwEditStyle,                // style params
        0, 0, 0, 0,                 // initial dimensions all 0
        hWnd,                       // parent handle
        (HMENU) IDE_RESULT,         // unique child-window identifier
        hInst,                      // instance handle
        NULL);

#else
    hResultDS = GlobalAlloc (GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
        MAX_EDIT_SIZE);

    if (hResultDS)
    {
        lpResultDS = GlobalLock (hResultDS);
        if (lpResultDS)
        {
            lpResultDS = GlobalLock (hResultDS);
            LocalInit (HIWORD((LONG)lpResultDS),
                0,
                (UINT)(GlobalSize(hResultDS) - 16));
            UnlockSegment (HIWORD((LONG)lpResultDS));
    
            // Create result edit window
            hResult = CreateWindow("edit",  // edit control class
                NULL,                       // text of control
                dwEditStyle,                // style params
                0, 0, 0, 0,                 // initial dimensions all 0
                hWnd,                       // parent handle
                (HMENU) IDE_RESULT,         // unique child-window identifier
                (HINSTANCE) HIWORD((LONG)lpResultDS),     // instance handle
                NULL);
        }
    }
    if (!hResultDS || !lpResultDS)
    {
        ERRBOX (hWnd, "Result window will have limited space available");
        // Create result edit window
        hResult = CreateWindow("edit",  // edit control class
            NULL,                       // text of control
            dwEditStyle,                // style params
            0, 0, 0, 0,                 // initial dimensions all 0
            hWnd,                       // parent handle
            (HMENU) IDE_RESULT,         // unique child-window identifier
            hInst,                      // instance handle
            NULL);
    }

    hQueryDS = GlobalAlloc (GMEM_DDESHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
        MAX_EDIT_SIZE);

#endif

    SendMessage (hResult,
        EM_LIMITTEXT,
        (WPARAM)MAX_EDIT_SIZE,
        0);

    // Create status bar window
    hStatus = CreateWindow(szStatusName,    // edit control class
        NULL,                               // text of control
        WS_CHILD | WS_VISIBLE | WS_BORDER,  // style params
        0, 0, 0, 0,                         // initial dimensions all 0
        hWnd,                               // parent handle
        (HMENU) IDE_STATUS,                 // unique child-window identifier
        hInst,                              // instance handle
        NULL);

    // Get stock fixed font, set both edit controls to this fixed font
    hFixedFont = GetStockObject (ANSI_FIXED_FONT);
    SendMessage(hResult,
        WM_SETFONT,
        (WPARAM)hFixedFont,
        FALSE);

	// Initialize drag & drop
	DragAcceptFiles(hWnd, TRUE);

    // Initialize edit controls window text
    SetWindowText (hResult, "");

//    SendMessage (hResult, WM_COMMAND, (WPARAM)IDM_MAXRESULT, 0L);
    SetFocus (hResult);
    
    hHourGlass = LoadCursor (NULL, IDC_WAIT);

    // Fill in OPENFILENAME struct
    ofnZIP.lStructSize = sizeof(OPENFILENAME);
    ofnZIP.hwndOwner = hWnd;
    ofnZIP.lpstrFilter = lpstrFilterQuery;
    ofnZIP.nFilterIndex = 1;
    ofnZIP.lpstrFile = lpstrFileQuery;
    ofnZIP.nMaxFile = sizeof(lpstrFileQuery);
    ofnZIP.lpstrCustomFilter = lpstrCustomFilterQuery;
    ofnZIP.nMaxCustFilter = sizeof(lpstrCustomFilterQuery);
    ofnZIP.lpstrInitialDir = lpstrInitDirQuery;
    ofnZIP.Flags = OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT;
    ofnZIP.lpfnHook = NULL;
    ofnZIP.lpstrTitle = NULL;

    ofnResult.lStructSize = sizeof(OPENFILENAME);
    ofnResult.hwndOwner = hWnd;
    ofnResult.lpstrFilter = lpstrFilterResult;
    ofnResult.nFilterIndex = 1;
    ofnResult.lpstrFile = lpstrFileResult;
    ofnResult.nMaxFile = sizeof(lpstrFileResult);
    ofnResult.lpstrCustomFilter = lpstrCustomFilterResult;
    ofnResult.nMaxCustFilter = sizeof(lpstrCustomFilterResult);
    ofnResult.lpstrInitialDir = lpstrInitDirResult;
    ofnResult.Flags = OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT;
    ofnResult.lpfnHook = NULL;
    ofnResult.lpstrTitle = NULL;

    AllocMem (&glbmemResult);
    AllocMem (&glbmemSend);
    AllocMem (&glbmemRow);
    AllocMem (&glbmemHeader);
    AllocMem (&glbmemUnderline);
    //MemAlloc (&hResultBuffer, &lpResultBuffer);

	if (argc)
    	SendMessage(hWnd, WM_COMMAND, IDM_OPEN, 1L);
    ShowWindow(hWnd, nCmdShow);     // Show the window
    UpdateWindow(hWnd);             // Sends WM_PAINT message
    return (TRUE);
}

//***************************************************************************
//
//  FUNCTION:   MainWndProc()
//
//  PURPOSE:    Processes messages
//
//  MESSAGES:
//
//      WM_COMMAND - application menu
//      WM_CREATE - create window
//      WM_DESTROY - destroy window
//      WM_SETFOCUS - window got focus
//      WM_SIZE - size window
//
//  COMMENTS:
//
//**************************************************************************

LRESULT CALLBACK MainWndProc(
    HWND hWindow,
    UINT message,
    WPARAM wParam,
    LPARAM lParam)
{
    DLGPROC lpDlgProc;              // pointer to dialog function
//    HDC hDC;
//    TEXTMETRIC tm;
    int nWidth, nHeight;            // width and height of window
    int yResult, nHeightQuery, nHeightResult;
    RECT rect;
    static int nWindowState;
    static HWND hCurrentFocus;      // handle of edit control with focus
    static int wCharHeight;
    OPENFILENAME *pofn;
    static char opts[3]="-l";
    int i,len;						// for Drag And Drop
    
    switch (message)
    {
    case WM_COMMAND:    // message: command from application menu
        switch (LOWORD(wParam))
        {
        case IDM_OPEN:
        	
			hSaveCursor = SetCursor(hHourGlass);
            pofn = &ofnZIP;
            if (lParam)
            {
            	ZipInfo(lflag, pofn->lpstrFile);
            }
            else if (GetOpenFileName (pofn))
            {
           		ZipInfo(lflag, pofn->lpstrFile);
            }
            SetCursor(hSaveCursor);
            break;

        case IDM_SAVE:
            pofn = &ofnResult;

            if (pofn->lpstrFile[0] != '\0')
            {
                if (!WriteFileFromEdit (hCurrentFocus, pofn->lpstrFile))
                {
                    ERRBOX (hWindow, "Error writing to file");
                    pofn->lpstrFile[0] = '\0';
                }
                break;
            }
            // fall through to Save As processing 
            // break;

        case IDM_SAVEAS:
                pofn = &ofnResult;

            if (GetSaveFileName (pofn))
            {
                if (!WriteFileFromEdit (hCurrentFocus, pofn->lpstrFile))
                {
                    ERRBOX (hWindow, "Error writing to file");
                    pofn->lpstrFile[0] = '\0';
                }
            }
            break;

        case IDM_EXIT:
            DestroyWindow (hWindow);
            break;

        case IDM_UNDO:
            // Undo last change in edit control
            SendMessage (hCurrentFocus, WM_UNDO, 0, 0L);
            break;

        case IDM_CUT:
            // Cut selected text from edit control
            SendMessage (hCurrentFocus, WM_CUT, 0, 0L);
            break;

        case IDM_COPY:
            // Copy selected text from edit control
            SendMessage (hCurrentFocus, WM_COPY, 0, 0L);
            break;

        case IDM_PASTE:
            // Paste text from clipboard into edit control
            SendMessage (hCurrentFocus, WM_PASTE, 0, 0L);
            break;

        case IDM_DELETE:
            // Delete text from edit control
            SendMessage (hCurrentFocus, WM_CLEAR, 0, 0L);
            break;

        case IDM_CLEAR:
                ofnZIP.lpstrFile[0] = '\0';
                ofnResult.lpstrFile[0] = '\0';

                FreeMem (&glbmemResult);
                AllocMem (&glbmemResult);
                //SetWindowText (hResult, glbmemResult.lpvMem);
                SetWindowText (hResult, "");
            break;

		case IDM_MAXUSE:	// Maximize on Use
			// check it, then verify the previous state, and uncheck if necessary
			if (CheckMenuItem(hMenu, IDM_MAXUSE, MF_CHECKED) == MF_CHECKED)
				CheckMenuItem(hMenu, IDM_MAXUSE, MF_UNCHECKED);

        case IDM_FOCUSRESULT:
            nWindowState = WIN_SPLIT;
            hCurrentFocus = hResult;
            GetClientRect(hWindow, &rect);
            SendMessage (hWindow,
                WM_SIZE,
                (WPARAM)SIZE_RESTORED,
                (LPARAM)MAKELONG(rect.right, rect.bottom));
            break;

        case IDM_MAXRESULT:
            nWindowState = WIN_MAXRESULT;
            hCurrentFocus = hResult;
            GetClientRect(hWindow, &rect);
            SendMessage (hWindow,
                WM_SIZE,
                (WPARAM)SIZE_RESTORED,
                (LPARAM)MAKELONG(rect.right, rect.bottom));
            break;

        case IDM_CYCLE:
            if (nWindowState == WIN_SPLIT)
            {
                nWindowState = WIN_MAXRESULT;
                hCurrentFocus = hResult;
            }

            GetClientRect(hWindow, &rect);
            SendMessage (hWindow,
                WM_SIZE,
                (WPARAM)SIZE_RESTORED,
                (LPARAM)MAKELONG(rect.right, rect.bottom));
            break;

        case IDM_ABOUT:
            lpDlgProc = (DLGPROC) MakeProcInstance((FARPROC)About, hInst);

            DialogBox(hInst,        // current instance
                "AboutBox",         // resource to use
                hWindow,            // parent handle
                lpDlgProc);         // About() instance address

            FreeProcInstance((FARPROC)lpDlgProc);
            break;

        case IDE_QUERY:
#if defined (WIN32)
            switch (HIWORD(wParam))
#else
            switch (HIWORD(lParam))
#endif
            {
            case EN_ERRSPACE:
                MSGBOX (hWindow, "Query edit control out of space");
                //CancelQuery(pDbproc);
                break;
            case EN_SETFOCUS:
//                hCurrentFocus = hQuery;
                break;
            }
            break;

        case IDE_RESULT:
#if defined (WIN32)
            switch (HIWORD(wParam))
#else
            switch (HIWORD(lParam))
#endif
            {
            case EN_ERRSPACE:
                MSGBOX (hWindow, "Result edit control out of space");
                //CancelQuery(pDbproc);
                break;
            case EN_SETFOCUS:
                hCurrentFocus = hResult;
                break;
            }
            break;

		case IDM_VERBOSE:	// verbose
			if (CheckMenuItem(hMenu, IDM_VERBOSE, MF_CHECKED) != MF_CHECKED) {
				CheckMenuItem(hMenu, IDM_EXTENDED, MF_UNCHECKED);
				CheckMenuItem(hMenu, IDM_NAMEONLY, MF_UNCHECKED);
			}
			lflag = 10;
			break;
			
		case IDM_EXTENDED:	// -l
			if (CheckMenuItem(hMenu, IDM_EXTENDED, MF_CHECKED) != MF_CHECKED) {
				CheckMenuItem(hMenu, IDM_VERBOSE, MF_UNCHECKED);
				CheckMenuItem(hMenu, IDM_NAMEONLY, MF_UNCHECKED);
			}
			lflag = 2;
			break;
			
		case IDM_NAMEONLY:	// fname               
			if (CheckMenuItem(hMenu, IDM_NAMEONLY, MF_CHECKED) != MF_CHECKED) {
				CheckMenuItem(hMenu, IDM_VERBOSE, MF_UNCHECKED);
				CheckMenuItem(hMenu, IDM_EXTENDED, MF_UNCHECKED);
			}
			lflag = 0;
			break;
		
        default:
            // Pass it on if unproccessed
            return (DefWindowProc(hWindow, message, wParam, lParam));

        }
        break; // case WM_COMMAND

    case WM_CREATE:     // message: window being created
        break; // case WM_CREATE

    case WM_QUERYENDSESSION:    // message: OK to exit Windows?
        return (TRUE);
        break; // case WM_QUERYENDSESSION
        
    case WM_CLOSE:      // message: window being closed
        DestroyWindow (hWnd);
        break; // case WM_CLOSE
        
    case WM_DESTROY:    // message: window being destroyed
        
        FreeMem (&glbmemResult);
        FreeMem (&glbmemSend);
        FreeMem (&glbmemRow);
        FreeMem (&glbmemHeader);
        FreeMem (&glbmemUnderline);

        PostQuitMessage(0);
        break; // case WM_DESTORY

    case WM_SETFOCUS:   // message: window now has focus
        SetFocus (hCurrentFocus);
        break; // case WM_SETFOCUS

    case WM_SIZE:       // message: window resized
        // Resize query and result windows to take up half of window
        nWidth = LOWORD(lParam);
        nHeight = HIWORD(lParam);
        
//        if (nWindowState == WIN_SPLIT)
//        {
//            yResult = (nHeight)-(wCharHeight);
//            nHeightQuery = (nHeight)-(wCharHeight);
//            nHeightResult = (nHeight)-(wCharHeight);
//        }

//        if (nWindowState == WIN_MAXQUERY)
//        {
//            yResult = 0;
//            nHeightQuery = nHeight-wCharHeight;
//            nHeightResult = 0;
//        }
        
//        if (nWindowState == WIN_MAXRESULT)
//        {
            yResult = 0;
            nHeightQuery = 0;
            nHeightResult = nHeight-wCharHeight;
//        }
        
        MoveWindow(hResult,     // window to move
            0,                  // x coord
            yResult,            // y coord
            nWidth,             // width
            nHeightResult,      // height
            TRUE);              // repaint

        MoveWindow(hStatus,         // window to move
            0,                      // x coord
            nHeight-wCharHeight,    // y coord
            nWidth,                 // width
            wCharHeight,            // height
            TRUE);                  // repaint
            
        SetFocus (hCurrentFocus);
            

        break; // case WM_SIZE

    case WM_DROPFILES:
    	argv[1]=zipfn;
    	argv[2]='\0';
    	len=DragQueryFile((HDROP)wParam, (UINT)-1, (LPSTR)NULL, NULL);
		for(i=0;i<len;i++) 
		{
			DragQueryFile((HDROP)wParam, (UINT)i, zipfn, FILNAMSIZ);
			ofnZIP.lpstrFile = zipfn;
			SendMessage(hWnd, WM_COMMAND, IDM_OPEN, 1L);
    	}
		
        // if Maximize on Use then Show the window
		if (GetMenuState(hMenu, IDM_MAXUSE, MF_BYCOMMAND) == MF_CHECKED) {
		    ShowWindow(hWnd, SW_RESTORE);     // Show the window
		}
		
    	break;
    
    default:
        // Pass it on if unproccessed
        return (DefWindowProc(hWindow, message, wParam, lParam));
    }
    return (NULL);
}

//***************************************************************************
//
//  FUNCTION:   PadCol()
//
//  PURPOSE:    Pad string with extra spaces, then add one space
//
//  COMMENTS:
//
//**************************************************************************

BOOL PadCol(
    LPSTR lpBuffer,
    char chPadChar,
    int iNumPadChars)
{
    LPSTR lpPtr;        // scratch pointer

    lpPtr = lpBuffer + lstrlen(lpBuffer);
#if defined (WIN32)
    memset (lpPtr, chPadChar, iNumPadChars);
#else
    _fmemset (lpPtr, chPadChar, iNumPadChars);
#endif
    lpPtr += iNumPadChars;
    *lpPtr = ' ';
    lpPtr++;
    *lpPtr = '\0';

    return (TRUE);
}

//***************************************************************************
//
//  FUNCTION:   InitApplication()
//
//  PURPOSE:    Initializes window data and registers window class
//
//  COMMENTS:
//
//***************************************************************************

BOOL InitApplication(
    HINSTANCE hInstance)
{
    WNDCLASS  wcMain, wcStat;

    // Fill in window class structure with parameters that describe the
    // main window.
    wcMain.style = NULL;                    // Class style(s)
    // Function to retrieve messages for windows of this class
    wcMain.lpfnWndProc = (WNDPROC) MainWndProc;
    wcMain.cbClsExtra = 0;                  // No per-class extra data
    wcMain.cbWndExtra = 0;                  // No per-window extra data
    wcMain.hInstance = hInstance;           // Application that owns the class
    wcMain.hIcon = LoadIcon(hInstance, "WinQueryIcon"); // winquery icon
    wcMain.hCursor = LoadCursor(NULL, IDC_ARROW);       // arrow cursor
    wcMain.hbrBackground = GetStockObject(WHITE_BRUSH); // white background
    wcMain.lpszMenuName =  "WinQueryMenu";  // Name of menu resource in .RC file
    wcMain.lpszClassName = szAppName;       // Name used in call to CreateWindow

    // Register the window class and return success/failure code
    if (!RegisterClass(&wcMain))
        return (FALSE);

    // Fill in window class structure with parameters that describe the
    // status bar window.
    wcStat.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;  // Class style(s)
    // Function to retrieve messages for windows of this class
    wcStat.lpfnWndProc = StatusWndProc;
    wcStat.cbClsExtra = 0;                  // No per-class extra data
    wcStat.cbWndExtra = 0;                  // No per-window extra data
    wcStat.hInstance = hInstance;           // Application that owns the class
    wcStat.hIcon = NULL;                    // no icon
    wcStat.hCursor = LoadCursor(NULL, IDC_ARROW);       // arrow cursor
    wcStat.hbrBackground = GetStockObject(WHITE_BRUSH); // white background
    wcStat.lpszMenuName =  NULL;            // Name of menu resource in .RC file
    wcStat.lpszClassName = szStatusName;    // Name used in call to CreateWindow

    if (!RegisterClass(&wcStat))
        return (FALSE);

    return (TRUE);

}

//***************************************************************************
//
//  FUNCTION:   WinMain()
//
//  PURPOSE:    Calls initialization function, processes message loop
//
//  COMMENTS:
//
//***************************************************************************

int PASCAL WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine,
    int nCmdShow)
{
    MSG msg;            // message
    HACCEL hAccel;      // handle to accelerator table
//    LPSTR       p;
//    static char  buf[200],*buf_ptr = buf;

    if (!hPrevInstance)
        // Initialize shared things
        if (!InitApplication(hInstance))
            return (FALSE);

    // Perform initializations that apply to a specific instance
    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    hAccel = LoadAccelerators (hInstance, "WinQueryAccelerators");
    while (TRUE)
    {
        if (PeekMessage(&msg,
            NULL,
            0,
            0,
            PM_REMOVE))
        {
            // Message in queue, process it
            if (msg.message != WM_QUIT)
            {
                if (!TranslateAccelerator (hWnd, hAccel, &msg))
                {
                    TranslateMessage(&msg); // Translates virtual key codes
                    DispatchMessage(&msg);  // Dispatches message to window
                }
            }
            else // WM_QUIT message
            {
                break; // while loop
            }
        }
        else // no message in queue */
        {
            // Do background processing if necessary
//            if (!DoBackgroundPart())
            {
                WaitMessage();
            }
        }
    }

    return (msg.wParam);        // Returns the value from PostQuitMessage
}

//***************************************************************************
//
//  FUNCTION:   PrintRow()
//
//  PURPOSE:    Builds a result row
//
//  COMMENTS:
//
//**************************************************************************

#ifdef TEST1
BOOL PrintRow(LPSTR str)
{

	EditStrCat (hResult, str);
	
    return (TRUE);
}
#endif
#ifdef TEST2
BOOL PrintRow(LPSTR str)
{
	LPSTR p=str;
	int len = lstrlen(str);
	
	if (zipout) {
		fprintf(zipout, "%s\r\n",str);
	} else {
		while (*++p) {
			if (*p == '\r') *p=' ';
			if (*p == '\n') {
				*p='\0';
				EditLineCat (hResult, str);
				str = p+1;
			}
		}
		EditLineCat (hResult, str);
	}		
    return (TRUE);
}
#endif
//#ifdef TEST3
BOOL PrintRow(LPSTR lpstr)
{
	LPSTR p=lpstr;
    long unsigned int nAddStrLen;
    nAddStrLen = lstrlen(lpstr);
	
	if (zipout) {
		fprintf(zipout, "%s\r\n",lpstr);
	} else {
		if (!ReAllocMem (&glbmemResult, nAddStrLen))
			return (FALSE);
	    AddStrToMem (&glbmemResult, lpstr);
	}
    SetWindowText (hResult, glbmemResult.lpvMem);
    return (TRUE);

}
//#endif                
