         PUBLIC REQHDR,DONE,INVALID,DONE2,ERROUT,XFER
;
;request header pointer
;
REQHDR   LABEL  DWORD
REQHDRo  DW     ?       ;offset
REQHDRs  DW     ?       ;segment
;
;        Strategy Entry Point
;
STRAT_ENT:
         MOV    CS:REQHDRo,BX             ;save offset of request header ptr
         MOV    CS:REQHDRs,ES             ;save segment of request header ptr
         RET                              ;far return
;
;        "Interrupt" Entry Point
;
;         Note: DOS's stack allows saving registers
;          but if your routines need more stack space than
;          that, it will be necessary to define a local stack.
;
INT_ENT: 
         PUSHF                  ;preserve flags
         CLD                    ;  set up forward string operations
         PUSH   SI              ;preserve registers
         PUSH   AX              ;
         PUSH   CX              ;
         PUSH   DX              ;
         PUSH   DI              ;
         PUSH   BP              ;
         PUSH   DS              ;
         PUSH   ES              ;
         PUSH   BX              ;
         ;
         LDS    BX,CS:REQHDR            ;DS:BX pts to request header
         MOV    CX,[BX+CNT]             ;get byte count
         MOV    AL,[BX+CMD]             ;get command code
         CMP    AL,HIFUNC               ; check for invalid command code
         JA     INVALID                 ;
         XOR    AH,AH                   ;
         ROL    AL,1                    ; convert to offset
         LEA    SI,FUNTBL               ;set up ptr to function table
         ADD    SI,AX                   ; select table entry
         LES    DI,DWORD PTR [BX+BUF]   ;get buffer address ES:DI
         PUSH   CS                      ;
         POP    DS                      ;destination addr = DS:SI
         JMP    WORD PTR [SI]           ;   and jump to it
;
INVALID: MOV    AL,UNKCMD               ;unknown command error
         SUB    [BX+CNT],CX             ;zero bytes transferred
ERROUT:  MOV    AH,ERROR+REQDON         ;set error and done bits
         JMP    SHORT   EXIT            ;
;
DONE2:   MOV    AH,REQDON+BUSY          ;set done+busy bits in request header status byte
         JMP    SHORT   EXIT            ;
;
XFER:    LDS    BX,CS:REQHDR            ;
         SUB    [BX+CNT],CX             ;return number of bytes transferred
DONE:    MOV    AH,REQDON               ;set done bit in request header status byte
EXIT:    LDS    BX,CS:REQHDR            ;
         MOV    [BX+STAT],AX            ;request header status
         ;
         POP    BX                      ;restore registers
         POP    ES                      ;
         POP    DS                      ;
         POP    BP                      ;
         POP    DI                      ;
         POP    DX                      ;
         POP    CX                      ;
         POP    AX                      ;
         POP    SI                      ;
         POPF                           ;
         RET                            ;far return
;

