/* MAPOVL.C

	programmed in the small memory model of Turbo C version 2.0

    Show file information for overlays appended to a root .EXE file

*/

#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "io.h"
#include "conio.h"
#include "stdlib.h"

FILE *fp;

char fname[128];
char f_noext_name[125];	/* file name in fname without extension */
unsigned char header[27];
char buff[8192];	/* file buffer for setvbuf */

unsigned int filecount=0;
unsigned long filelen;	/* length of .exe file (overlay or root) */
unsigned long len_no_hdr;	/* length of file without .exe header byte */
unsigned int relocation_count;	/* number of relocation table items */
unsigned long relocation_bytes;	/* byte count of relocation table items */
unsigned int header_size;	/* size of .exe header */
unsigned long ovl_largest=0L;	/* size of largest overlay file */
unsigned int which_ovl=0;	/* overlay file number that is largest */

void operate(),report();
int get_info();

void main(int argc, char *argv[])
{
	char *period_pos;	/* position of period in fname */
	char temp[180];

	if(argc<2){	/* file name was not provided on command line */
		cprintf("\n\rInput filename for report\r\n");
		gets(fname);
	}
	else{	/* command link provided file name */
		strcpy(fname,argv[1]);
	}
	strcpy(f_noext_name,fname);
	if((period_pos=strchr(f_noext_name,'.'))==NULL){	/* need to add default .exe file extension */
		strcat(fname,".exe");	/* add the .exe extension */
	}
	else{
		period_pos[0]=0;	/* kill the extension */
	}
	sprintf(temp,"Report on file %s",fname);
	printf("\n\n%s",temp);	/* print header */
	strset(temp,'=');	/* make a separation just as long as the header line */
	printf("\n%s",temp);	/* print separation line */
	operate();
}

void operate()
{
	int breakflag=0;

	if((fp=fopen(fname,"rb"))==NULL){	/* error opening file */
		printf("\n\007Error opening file %s\n",fname);
		exit(1);
	}
	setvbuf(fp,buff,_IOFBF,8192);	/* speed up i/o */
	while(!feof(fp)){	/* split out .exe files until end of file or invalid .exe information */
		breakflag=get_info();
		if(breakflag)	/* no more files, or error */
			break;
		report();
		filecount++;	/* increment count of overlay files */
	}
	if(ovl_largest>0){	/* only print if there is an overlay file */
		printf("\n\nOverlay file %d always loads into the standard overlay area.",
			which_ovl);
	}
	fclose(fp);

	printf("\n\nReport complete: %d overlay file%s\n",filecount-1,filecount!=2?"s":"");
}

int get_info()
{
	int signature,ovl_number;
	fread(header,27,1,fp);	/* read in first 27 .exe header bytes */
	fseek(fp,-27L,SEEK_CUR);	/* position back to start of .exe file */

	signature=(header[0]=='M' && header[1]=='Z');	/* check for valid MZ .exe signature */
	ovl_number=header[26];	/* get overlay number */
	if(!signature || ovl_number!=filecount){	/* header bytes have invalid values */
		return(1);	/* not a proper .exe file */
	}
	header[0]=header[1]=0;	/* force invalid signature if no more bytes to read */

	filelen=header[5];
	filelen*=256L;
	filelen+=header[4];	/* size of file in 512 byte pages */
	filelen*=512L;	/* get length of .exe file to nearest 512 byte page */

	header_size=header[9];
	header_size*=256;
	header_size+=header[8];	/* size of header in paragraphs */
	header_size*=16;	/* size of header in bytes */

	len_no_hdr=filelen-header_size;	/* size of file without any .exe header bytes (size of code) */

	relocation_count=header[7];
	relocation_count*=256;
	relocation_count+=header[6];	/* get number of relocation table items */

	relocation_bytes=(long)relocation_count*4L;	/* get byte count of relocation table items */

	fseek(fp,filelen,SEEK_CUR);	/* position to read info of next .exe file */

	return(0);	/* successful read of information */
}

void report()
{
	if(!filecount){	/* root file */
		printf("\n\nRoot file:  File size %6ld (%lx hex) bytes",len_no_hdr,len_no_hdr);
		printf("\n    Relocation table %5d (%x hex) items, %6ld (%lx hex) bytes",
			relocation_count,relocation_count,relocation_bytes,relocation_bytes);
		printf("\n    Unaffected by /ZBn option");
	}
	else{	/* overlay file */
		printf("\n\nOverlay file %2d:  File size %6ld (%lx hex) bytes",filecount,
			len_no_hdr,len_no_hdr);
		printf("\n    Relocation table %5d (%x hex) items, %6ld (%lx hex) bytes",
			relocation_count,relocation_count,relocation_bytes,relocation_bytes);
		printf("\n    /ZBn option requires 'n' of %d for no table reload",
			relocation_count==0?1:1+(int)((relocation_bytes-1)/1024));
		if(len_no_hdr>ovl_largest){	/* new largest overlay file */
			ovl_largest=len_no_hdr;
			which_ovl=filecount;
		}
	}
}
