.I 0 19
/*
**  TAIL.C
**  ----------------------------------------------------------------------
**  Display the last n lines of a file (20 lines by default).
**
**  Revision history
**  ================
**  Modified  19930604 by Ruurd Pels:
**  - Increased default line numbers from 5 to 20
**  - Made ANSI C conformant (I hope)
**  - Added '-' support for commandline
**  - Outputs header to stderr instead of stdout to leave it out when
**    redirecting files
**  - Fixed \r\r\n bug for MSDOS machines
**
**  Modified  19861005 by Joe Huffman:
**  - Utilize prototyping, fixed a bug, added (a few) comments and help.
**
**  Written   19860204 by Joe Huffman.
.D 1 5
.I 7 2
*/

.D 8 2
.I 11 9

char            head1[] = {"\n------- \""};
char            head2[] = {" -------\n"};
FILE *          fp;
int             filenum;
int             cc;
unsigned int    linenum = 20;
unsigned int    indx;
long int *      tail;
.D 12 47
.I 64 1
void getlinenum(int n, char * str[])
.D 65 1
.I 69 3
            if ((**str == '/') || (**str == '-'))
            {
                  linenum = atoi(*(str) + 1);
.D 70 3
.I 73 5
                        linenum = 20;
            }
      }

      /* Because we save a pointer to the end of the PREVIOUS line */
.D 74 3
.D 78 1
.I 85 1
void gettail(void)
.D 86 1
.D 89 1
.I 91 1
      tail = (long int *)malloc(sizeof(*tail) * linenum);
.D 92 1
.I 94 7
            fputs("Insufficient memory.", stderr);
            exit(1);
      }
      tail[0] = ftell(fp);
      indx = 0;

      for (cc = getc(fp); cc != EOF; cc = getc(fp))
.D 95 7
.I 105 1
                  cc = getc(fp);
.D 106 1
.I 107 1
                        ungetc(cc, fp);
.D 108 1
.I 110 1
                  tail[indx] = ftell(fp);
.D 111 1
.I 117 1
                        cc = getc(fp);
.D 118 1
.I 119 1
                              ungetc(cc, fp);
.D 120 1
.I 122 1
                        tail[indx] = ftell(fp);
.D 123 1
.I 126 4
      fputs("\" ", stderr);
      ltoa(currline, outstr, 10);
      fputs(outstr, stderr);
      fputs(" lines", stderr);
.D 127 4
.I 137 6
      if (fseek(fp, tail[indx], 0) == -1)
      {
            fputs("\nFile seek error.", stderr);
            exit(1);
      }
      free(tail);
.D 138 34
.I 177 7
void help(void)
{
      char *ptr;
      static char help_str[] =  "Usage:\n\nTAIL <filename> [filename] "
            "[/n]\n\n<filename>  - The name of a valid file, wildcards "
            "accepted.\nn           - Number of lines to print out, 20 "
            "by default.";
.D 178 10
.I 189 47
            fputc(*ptr, stdout);
}

int main(int argc, char **argv)
{
      if (argc <= 1)
      {
            help();
            exit(1);
      }

      getlinenum(argc, argv);

      for (filenum = 1; filenum < argc; ++filenum)
      {
            if (*argv[filenum] == '/')
                  continue;
            fp = fopen(argv[filenum], "rb");
            if (!fp)
            {
                  fputs(head1, stderr);
                  fputs(argv[filenum], stderr);
                  fputs("\" not found.", stderr);
                  fputs(head2, stderr);
            }
            else
            {
                  fputs(head1, stderr);
                  fputs(argv[filenum], stderr);
                  gettail();
                  fputs(head2, stderr);
                  for (cc = getc(fp); cc != EOF; cc = getc(fp))
                  {
#ifdef __MSDOS__
                        if (cc != '\r')
                        {
                              fputc(cc, stdout);
                        }
#else
                        fputc(cc, stdout);
#endif
                  }
                  fclose(fp);
            }
      }
      return EXIT_SUCCESS;
}
.D 190 2
