#include	<stdio.h>
#include	<dos.h>

int		t1stack[512];
int		lastch;

/*
 *	mini terminal.
 *
 *	a very few featured terminal program.
 */

int		comport;

kbsvc()
{
	t_signal(0);		/* signal keyboard hit */
	return 0;			/* chain on */
}

int	kgetc()
{
	union REGS	r;
	
	for(;;)
	{
		r.h.ah = 0x0b;
		intdos(&r,&r);
		if( r.h.al != 0 )
		{
			return getch();
		}
		t_wait(0);
	}
}

task1()
{
	int		c;
	
	for(;;)
	{
		c = kgetc();
		if( c == 0 )
		{
			kgetc();	/* get rid of extra key */
			cclose(comport);
			int_restore(9);
			exit(0);
		}
		cputc(comport,c);
	}
}

int	getnum()
{
	int		i;
	
	i = 0;
	lastch = cgetc(comport);
	while( isdigit(lastch) )
	{
		i = i * 10 + (lastch - '0');
		lastch = cgetc(comport);
	}
	return i;
}

escseq()
{
	int		p1, p2, c;
	
	p1 = 0;
	p2 = 0;
	if( cgetc(comport) == '[' )
	{
		p1 = getnum();
		if( lastch == ',' || lastch == ';' )
		{
			p2 = getnum();
		}
		switch( lastch )
		{
			case 'H': case 'f':
				disp_move(p1,p2);
				break;
			
			case 'J':
				disp_move(0,0);
				disp_eeop();
				break;
			
			case 'K':
				disp_eeol();
				break;
		}
	}
	disp_flush();
}

main()
{
	int		c;

	comport = copen(0,512,512);
	if( comport < 0 )
	{
		printf("cant open com port\n");
		exit(1);
	}
	cbaud(comport,1200);
	cmode(comport,'n',8,1);

	disp_open();
	int_intercept(9,kbsvc,256);
	t_create(1,task1,t1stack,sizeof(t1stack));
	
	for(;;)
	{
		c = cgetc(comport);
		if( c != '\033' )
		{
			disp_putc(c);
			disp_flush();
		}
		else
		{
			escseq();
		}
	}
}
