/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 46                        
                                                                            
 This example shows the use of the whline command to draw fast horizontal   
 lines. It will also use the wtimer command to make the demo run for as     
 close to 5 seconds as possible (regardless of CPU speed).                  
                                                                            
  PROJECT                                                             
 This program requires the WGT4.LIB file to be linked.                      
                                                                            
  DATA FILES                                                          
 None.                                                                      
                                                                            
ͼ
*/

#include <dos.h>
#include <time.h>
#include <stdlib.h>
#include <wgt4.h>

  struct time start, finish;
  struct time start2, finish2;

void main(void)
{
  int loopctr, row;
  int oldmode;

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();		/* Gets the current mode 	*/
  vga256();			/* Initializes WGT system 	*/
  wcls(0); 			/* Clear screen with color 0 	*/

  row = 0;                      /* Start drawing at top row of screen */
  gettime (&start);             /* Find starting time of routine */
  do {
    wsetcolor (rand () % 256);  /* Pick a random color */
    whline (0, 319, row++);     /* Draw the line */
    if (row > 199)              /* Loop at end of screen */
      row = 0;
    gettime (&finish);          /* Find current time */
  } while (wtimer (start, finish) < 500);       

  /* As soon as we reach 500 hundredths of a second (5 secs), end the routine
     and reset the video mode */

  wsetmode(oldmode);		/* Restore old video mode	*/
}