
#line 22 "as31.y"

#include <setjmp.h>
#include <stdio.h>
#define NOPE
#include "as31.h"
#undef NOPE

#define YYSTYPE union ystack

extern int lineno;
extern int dashl;
extern char *asmfile;
extern jmp_buf main_env;
extern FILE *listing;

int pass,fatal;
unsigned long lc;

static unsigned char bytebuf[1024];		/* used by dumplist() */
static int bytecount;

/* ------------------------ G R A M M E R ----------------------------- */

# define STRING 257
# define D_ORG 258
# define D_BYTE 259
# define D_WORD 260
# define D_SKIP 261
# define D_EQU 262
# define D_FLAG 263
# define D_END 264
# define ACALL 265
# define ADD 266
# define ADDC 267
# define AJMP 268
# define ANL 269
# define CJNE 270
# define CLR 271
# define CPL 272
# define DA 273
# define DEC 274
# define DIV 275
# define DJNZ 276
# define INC 277
# define JB 278
# define JBC 279
# define JC 280
# define JMP 281
# define JNB 282
# define JNC 283
# define JNZ 284
# define JZ 285
# define LCALL 286
# define LJMP 287
# define MOV 288
# define MOVC 289
# define MOVX 290
# define NOP 291
# define MUL 292
# define ORL 293
# define POP 294
# define PUSH 295
# define RET 296
# define RETI 297
# define RL 298
# define RLC 299
# define RR 300
# define RRC 301
# define SETB 302
# define SJMP 303
# define SUBB 304
# define SWAP 305
# define XCH 306
# define XCHD 307
# define XRL 308
# define AB 309
# define A 310
# define C 311
# define PC 312
# define DPTR 313
# define BITPOS 314
# define R0 315
# define R1 316
# define R2 317
# define R3 318
# define R4 319
# define R5 320
# define R6 321
# define R7 322
# define VALUE 323
# define SYMBOL 324
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 949 "as31.y"


/* ---------------------------------------------------------------------- */

yyerror(s)
char *s;
{
	error(s);
}


/* ----------------------------------------------------------------------
 * error:
 *	Uses semi-variable arguments. This causes immediate assembler
 *	termination.
 */

error(cs,a1,a2,a3,a4,a5,a6)
char *cs,*a1,*a2,*a3,*a4,*a5,*a6;
{
	fprintf(stderr,"File: %s, line: %d, ",asmfile,lineno);
	fprintf(stderr,cs,a1,a2,a3,a4,a5,a6);
	fprintf(stderr,".\n");
	longjmp(main_env,1);
}

/* ----------------------------------------------------------------------
 * warning:
 *	Produce error message. This will abort assembly at
 *	the end of the current pass.
 *
 */

warning(cs,a1,a2,a3,a4,a5,a6)
char *cs,*a1,*a2,*a3,*a4,*a5,*a6;
{
	fatal++;
	fprintf(stderr,"File: %s, line: %d, ",asmfile,lineno);
	fprintf(stderr,cs,a1,a2,a3,a4,a5,a6);
	fprintf(stderr,".\n");
}


/* ----------------------------------------------------------------------
 * makeop:
 *	This function makes an opcode based on the instruction symbol table
 *	entry, and an addressing mode structure.
 *	This function is called from both passes, but
 *	only generates code in pass 2.
 *
 *	Resultant opcode bytes are passed to genbyte().
 *
 *	Returns the nuumber of bytes that the instruction
 *	occupies.
 *
 */

makeop(op,m,add)
struct opcode *op;
struct mode *m;
{
	register unsigned int newop;

	if( m == NULL ) {
		if(pass2) genbyte(op->bytes[0+add]);
		return(1);
	}

	if( pass2 ) {
		newop = op->bytes[ get_md(*m)+add ] | get_ov(*m);
		genbyte(newop);
		if( get_sz(*m) > 0 ) genbyte( get_b1(*m) );
		if( get_sz(*m) > 1 ) genbyte( get_b2(*m) );
	}
	return( get_sz(*m)+1 );
}


/* ----------------------------------------------------------------------
 * inclc:
 *	Increments the Location Counter by 'i' amount.
 *	Check to see if 'i' overflows 64K.
 *	Checks to see if assembler is overlapping previous sections
 *	of code. (using a large bit field).
 *
 */

#define indx(a) ( (a)/(sizeof(long)*8) )
#define bit(a)	( 1 << ((a)%(sizeof(long)*8)) )

#define getloc(a) (regions[indx(a)] & bit(a))
#define setloc(a) (regions[indx(a)] |= bit(a))

inclc(i)
{
	static unsigned long regions[ 0x10000/(sizeof(long)*8) ];

	while(i-- > 0) {
		if( pass2 && getloc(lc) )
			error("Location counter overlaps");
		if( pass2 ) setloc(lc);
		lc += 1;
	}
		
	if( lc > 0xffff )
		error("Location counter has exceeded 16-bits");
}

/* ----------------------------------------------------------------------
 * padline:
 *	This routine returns a new string, which is equivilant to
 *	'line' except that all tabs have been expanded to spaces, and
 *	the total length has been truncated to 60 chars.
 */

char *padline(line)
char *line;
{
	static char newline[61];
	char *p1;
	int pos=0,nxtpos;

	for(p1=line; pos<sizeof(newline)-1 && *p1; p1++ ) {
		if( *p1 == '\t' ) {
			nxtpos = pos+8-pos%8;
			while(pos<sizeof(newline)-1 && pos <= nxtpos)
				newline[pos++] = ' ';
		} else if( *p1 != '\n' )
			newline[pos++]= *p1;
	}
	newline[pos] = '\0';
	return(newline);
}


/* ----------------------------------------------------------------------
 * dumplist:
 *	Outputs the current location counter, bytebuf[] array, and
 *	the string 'txt' to the listing file.
 *	This routine is called for every source line encountered in the
 *	source file. (Only in pass 2, and if listing is turned on).
 *
 */

dumplist(txt,show)
char *txt;
{
	int i,j;

	fprintf(listing,show?"%04X: ":"      ",lc);

	j=0;
	for(i=0; i<bytecount; i++ ) {
		fprintf(listing,"%02X ",bytebuf[i]);
		if( ++j >= 4 ) {
			j = 0;
			fprintf(listing,"\n      ");
		}
	}
	while(++j <= 4)
		fprintf(listing,"   ");

	fprintf(listing," %s\n",padline(txt));
}

/* ----------------------------------------------------------------------
 * gen* routines:
 *	Place information into the bytebuf[] array, and also
 *	call emitbyte with the byte.
 *
 */

genbyte(b)
int b;
{
	if( bytecount < sizeof(bytebuf) )
		bytebuf[bytecount++] = b;
	emitbyte(b);
}

genstr(s)
char *s;
{
	while( *s )
		genbyte(*s++);
}

genword(w)
unsigned long w;
{
	genbyte( (w & 0xff00) >> 8 );
	genbyte( (w & 0x00ff) );
}

short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 161
# define YYLAST 742
short yyact[]={

   9, 286, 168, 182, 183, 184, 185, 186, 187, 188,
 189, 208, 229, 182, 183, 184, 185, 186, 187, 188,
 189,   6, 121, 120, 226, 289, 228, 263, 262,  69,
 282,  68, 284, 283,  70, 192,  10, 182, 183, 184,
 185, 186, 187, 188, 189, 116, 117, 190, 302, 301,
 191, 269, 276, 243, 304, 156, 303, 288, 121, 120,
   9, 287, 270, 154,  75, 113, 112, 111, 110, 109,
 105, 108, 106,  59,  60,  61,  62,  63,  64,  65,
 170, 253, 252, 173, 170, 107, 226,   4, 171,  69,
  56,  68, 158, 172,  70,   5,  10, 139, 300, 292,
 291, 271, 255,  79,  69, 199,  68, 254, 297,  70,
 224, 249, 245, 151, 280,  69, 235,  68, 212,  69,
  70,  68,  83,  87,  70, 211, 210, 209,  95, 206,
  69, 205,  68, 204, 296,  70, 203, 201, 198, 223,
  69, 197,  68, 196, 295,  70, 194, 141, 142, 193,
 129, 167, 157, 248,  95, 166, 147, 233,  69, 231,
  68, 180,  69,  70,  68, 179, 169,  70, 178,  69,
 169,  68,  74,  69,  70,  68, 126, 230,  70, 138,
  69, 274,  68, 250, 234,  70,  90,  66,  76,  77,
  78,  82,  86,  89, 131, 132, 133, 134,  58,  84,
 115,  73,  57,   3, 119, 238,  55, 114, 148, 104,
  69, 143,  68, 135, 261,  70, 260, 163, 128,  88,
 160,  69,   8,  68,   7, 146,  70,   2,   1,   0,
 236,   0,   0,   0,   0,   0, 164, 122, 123,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  12,  14,  15,  13,  18,
  47,  35,  36,  23,  22,  24,  51,  21,  48,  50,
  42,  25,  49,  43,  44,  45,  41,  40,  52,  53,
  54,  11,  26,  19,  39,  38,  27,  28,  29,  30,
  31,  32,  37,  46,  16,  33,  20,  34,  17, 225,
 244, 155, 121, 120,  96,  97,  98,  99, 100, 101,
 102, 103,  72,  71,   6,  12,  14,  15,  13,  18,
  47,  35,  36,  23,  22,  24,  51,  21,  48,  50,
  42,  25,  49,  43,  44,  45,  41,  40,  52,  53,
  54,  11,  26,  19,  39,  38,  27,  28,  29,  30,
  31,  32,  37,  46,  16,  33,  20,  34,  17,  75,
 153, 225, 152,   0,  96,  97,  98,  99, 100, 101,
 102, 103,  72,  71,  92, 200,   0,  91,   0,  96,
  97,  98,  99, 100, 101, 102, 103,  72,  71, 278,
  96,  97,  98,  99, 100, 101, 102, 103,  72,  71,
  92,   0,  72,  71, 181,  96,  97,  98,  99, 100,
 101, 102, 103,  72,  71,  96,  97,  98,  99, 100,
 101, 102, 103,  72,  71, 136,  81, 257, 246, 240,
  96,  97,  98,  99, 100, 101, 102, 103, 162,  67,
  67,  72,  71,  75,  85,  72,  71, 258,   0,   0,
  75,   0,  72,  71,   0,   0,  72,  71,   0, 118,
  80,   0,   0,  72,  71,   0,  93, 127, 127, 130,
 130, 130, 130, 130,   0,   0,   0,   0,   0,   0,
   0,   0,  94,  94,   0,   0, 159, 281, 165, 159,
   0,   0,   0,  72,  71,   0, 176, 177,   0, 124,
 125,   0, 290,   0,  72,  71,   0,   0, 140, 140,
 140,   0, 145, 149, 137,   0,   0,   0, 144, 150,
   0, 161, 298, 299, 173, 170,   0,   0, 220, 171,
 175, 305, 174,   0, 172,   0,   0,   0,   0, 173,
 170,   0,   0, 195, 171, 175,   0, 174,   0, 172,
   0,   0,   0,   0,   0,   0, 202,   0,   0,   0,
   0, 207,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 213, 214, 215, 216,
 217, 218, 219,   0,   0,   0,   0,   0,   0,   0,
   0, 169,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 237, 239, 237, 169,   0, 264,   0,
   0,   0,   0,   0,   0,   0,   0, 165, 259, 222,
 227,   0,   0,   0,   0, 221,   0,   0, 275,   0,
   0,   0,   0,   0, 232,   0,   0,   0, 285,   0,
 242,   0, 247,   0, 251,   0, 241,   0,   0,   0,
 256,   0,   0,   0,   0,   0,   0, 165,   0,   0,
   0,   0,   0,   0,   0, 265,   0, 266, 267, 268,
   0,   0,   0,   0, 272, 273,   0,   0, 237,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 277,
 279,   0,   0,   0,   0,   0,   0,   0, 237, 237,
   0,   0,   0,   0,   0,   0,   0, 237,   0,   0,
   0,   0,   0,   0,   0, 293,   0,   0,   0,   0,
   0, 294 };
short yypact[]={

 -10,-1000, -10,-1000,  32,-1000,-1000, 192, 188,-1000,
-185,-1000, 129, 129,-246,-246,-246, 140, 133, 133,
-246,  64,  90,-240,-237,  21,-238,-1000,-1000,-241,
-242,-243,-244,-245,-246,-265,-265,-265, 129, 129,
 129, 129, 129, 129, 129, 129, 129, 115,-301,-301,
-301, 100,  49,-247,  -9,-1000,  50,-1000,-1000, 129,
 181, 129, 129,-303,-322,-1000,-1000, 502,-1000, 129,
 129,-1000,-1000,-1000,-1000, 124,-1000,-1000,-1000,-1000,
 121, 502,-1000,-1000,-1000, 117,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-278,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-263,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-279,
-1000,-1000,-1000,-1000,-1000,-1000,-1000, 502,-1000,-1000,
 502,-1000,-1000,-1000,-1000,-1000, 105, 102,-278,-1000,
  99,-1000,-1000,-1000,  97,  94,-1000,-1000,-1000,  61,
  93,-278,  92,  89,  87,  85,-302,-1000,-1000, 502,
  83,-1000,-1000,  82,-1000, 502,-1000,  81,  74, 129,
 129, 129, 129, 129, 129, 129, 487,  42,  75,  51,
 -21,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
 134, 116,-1000, 122, 149,  72, 129, 129, 129, -11,
  68, 118,  67, 148,-301,  18,  17,  63,  58, 170,
 129, 129,-296,-1000,-1000,  42,  42,  42,  46,  46,
-1000,-1000,-1000,-278, 129,-1000, 129,-1000,-301,-301,
-262,-248,  57, 129, 129, 146,-1000, 502,-1000, 502,
-1000,-1000,-1000,-278,-1000,-259,-1000,-1000, 129,  79,
 129,-1000,-280,-312,-249,-253,-1000,-1000,-1000, 502,
-1000,-289,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000, 129,  56,  55, 129,-1000,-1000,-1000,-1000,-1000,
 129,-1000, 101,  91,  65,-1000,-1000,-1000,-1000,-1000,
-1000, 129, 129,  54,-1000,-264,-254,-256,-1000,-1000,
 129,-1000,-1000,-1000,-1000,-1000 };
short yypgo[]={

   0, 228, 227, 203,  87,  95, 224, 222,  92, 220,
 217, 426, 216, 214, 460, 236, 187, 172, 103, 199,
 186, 200, 176, 150, 213,  97, 211, 208, 404, 466,
 459, 230, 205, 204 };
short yyr1[]={

   0,   1,   2,   2,   3,   3,   5,   5,   5,   6,
   6,   6,   6,   6,   6,   6,   8,  12,  13,  13,
   4,   9,   9,   9,   9,  10,  10,  11,  11,  11,
  11,  11,  11,  11,  11,  11,  11,  11,  11,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,  17,  17,
  17,  17,  18,  18,  19,  19,  19,  25,  26,  26,
  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,
  27,  27,  27,  20,  20,  20,  20,  21,  21,  21,
  24,  24,  24,  24,  31,  32,  30,  30,  33,  33,
  29,  29,  29,  29,  29,  29,  29,  29,  28,  28,
  28,  28,  28,  28,  28,  28,  14,  15,  16,  22,
  23 };
short yyr2[]={

   0,   1,   2,   1,   3,   1,   2,   2,   1,   3,
   3,   3,   3,   5,   5,   2,   1,   2,   1,   1,
   1,   3,   3,   1,   1,   3,   1,   1,   3,   2,
   3,   3,   3,   3,   3,   3,   3,   1,   1,   1,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   5,
   5,   2,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   7,   7,   7,   7,   5,   5,   5,   5,   3,   3,
   4,   4,   3,   4,   3,   4,   4,   3,   3,   3,
   3,   3,   4,   3,   3,   4,   4,   4,   5,   4,
   3,   3,   4,   1,   1,   1,   2,   1,   1,   1,
   5,   6,   6,   7,   1,   1,   2,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1 };
short yychk[]={

-1000,  -1,  -2,  -3,  -4,  -5, 324,  -6,  -7,  10,
  46, 291, 265, 268, 266, 267, 304, 308, 269, 293,
 306, 277, 274, 273, 275, 281, 292, 296, 297, 298,
 299, 300, 301, 305, 307, 271, 272, 302, 295, 294,
 287, 286, 280, 283, 284, 285, 303, 270, 278, 282,
 279, 276, 288, 289, 290,  -3,  58,  10,  10, 258,
 259, 260, 261, 262, 263, 264, -16, -11,  42,  40,
  45, 324, 323, -16, -17, 310, -17, -17, -17, -18,
 -14, -11, -17, -18, -19, 311, -17, -18, -19, -17,
 -20, 313, 310, -29, -14,  64, 315, 316, 317, 318,
 319, 320, 321, 322, -20, 310, 309,  64, 309, 310,
 310, 310, 310, 310, -17, -21, 310, 311, -30, -33,
 324, 323, -21, -21, -14, -14, -22, -11, -22, -23,
 -11, -23, -23, -23, -23, -24, 310, -29,  64, -25,
 -30, -25, -25, -26, -29, -14, -17, -18, -27, -14,
 -29,  64, 313, 311, 310, 310,  64,  -5,  -8, -11,
  -9, -14, 257, -10, -15, -11,  -8,  -4, 324, 124,
  38,  42,  47,  37,  45,  43, -11, -11,  44,  44,
  44, -28, 315, 316, 317, 318, 319, 320, 321, 322,
 310, 313, 314,  44,  44, -28,  44,  44,  44,  44,
 314,  44, -28,  44,  44,  44,  44, -28, 313,  44,
  44,  44,  44, -11, -11, -11, -11, -11, -11, -11,
  41, -29, -14,  64,  35, 310,  35, -30,  47,  33,
  43,  43, -14,  35,  35,  44, -31, -11, -32, -11,
 -31, -29, -14,  64, 311,  44, 310, -14,  35,  44,
  35, -30,  64,  64,  44,  44, -14, 257, -15, -11,
 -12, -13, 324, 323, -28, -14, -14, -30, -30, 313,
 310,  44, -14, -14,  35, -28, 311, -14, 310, -14,
  35, -15, 310, 313, 312, -28, 313, 310, 310, 314,
 -31,  44,  44, -14, -14,  43,  43,  43, -31, -31,
  44, 313, 312, 310, 310, -31 };
short yydef[]={

   0,  -2,   1,   3,   0,   5,  20,   0,   0,   8,
   0,  39,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  62,  63,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   2,   0,   6,   7,   0,
   0,   0,   0,   0,   0,  15,  40, 158,  27,   0,
   0,  37,  38,  41,  42,   0,  43,  44,  45,  46,
   0, 156,  47,  48,  49,   0,  50,  51,  52,  53,
  54,  55, 123, 124, 125,   0, 140, 141, 142, 143,
 144, 145, 146, 147,  56,  57,  58,   0,  61,  64,
  65,  66,  67,  68,  69,  70, 127, 128, 129, 137,
 138, 139,  71,  72,  73,  74,  75, 159,  76,  77,
 160,  78,  79,  80,  81,  82,   0,   0,   0,  83,
   0,  84,  85,  86,   0,   0,  87,  88,  89,   0,
   0,   0,   0,   0,   0,   0,   0,   4,   9,  16,
  10,  23,  24,  11,  26, 157,  12,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  29,   0,   0,
   0, 126, 148, 149, 150, 151, 152, 153, 154, 155,
   0,   0, 136,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  30,  31,  32,  33,  34,  35,  36,
  28,  98,  99,   0,   0, 102,   0, 104,   0,   0,
   0,   0,   0,   0,   0,   0, 107, 134, 108, 135,
 109, 113, 114,   0, 121,   0, 110, 111,   0,   0,
   0, 120,   0,   0,   0,   0,  21,  22,  25,  13,
  14,   0,  18,  19, 100, 101, 103, 105, 106,  59,
  60,   0,   0,   0,   0, 115, 122, 112, 116, 117,
   0, 119,   0,   0,   0,  94,  95,  96,  97,  17,
 130,   0,   0,   0, 118,   0,   0,   0, 131, 132,
   0,  90,  92,  91,  93, 133 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#define YYFLAG -1000
#define YYERROR goto yyerrlab
#define YYACCEPT return(0)
#define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){

case 1:
# line 124 "as31.y"
{
} break;
case 4:
# line 133 "as31.y"
{
	if( pass1 ) {
		yypvt[-2].sym->type = LABEL;
		yypvt[-2].sym->value = lc;
	}
	inclc(yypvt[-0].value);
	bytecount = 0;
} break;
case 5:
# line 141 "as31.y"
{ inclc(yypvt[-0].value); bytecount = 0; } break;
case 6:
# line 144 "as31.y"
{
						yyval.value = yypvt[-1].value;
						if( dashl && pass2 )
							dumplist(yypvt[-0].str,1);
					} break;
case 7:
# line 149 "as31.y"
{
						yyval.value = yypvt[-1].value;
						if( dashl && pass2 )
							dumplist(yypvt[-0].str,1);

					} break;
case 8:
# line 155 "as31.y"
{
						yyval.value = 0;
						if( dashl && pass2 )
							dumplist(yypvt[-0].str,0);
					} break;
case 9:
# line 172 "as31.y"
{
	lc = yypvt[-0].val.v;
	if( pass2 ) emitaddr(lc);
	bytecount = 0;
	yyval.value = 0;
} break;
case 10:
# line 178 "as31.y"
{ yyval.value = yypvt[-0].value; } break;
case 11:
# line 179 "as31.y"
{ yyval.value = yypvt[-0].value; } break;
case 12:
# line 180 "as31.y"
{ yyval.value = yypvt[-0].val.v;
					  if( pass2 )
						emitaddr(lc+yyval.value); } break;
case 13:
# line 184 "as31.y"
{
	if( yypvt[-0].val.d == 0 )
		error("Expression is undefined in pass 1");
	yypvt[-2].sym->type = LABEL;
	yypvt[-2].sym->value = yypvt[-0].val.v;
	yyval.value = 0;
} break;
case 14:
# line 193 "as31.y"
{
	yypvt[-2].sym->type = LABEL;
	yypvt[-2].sym->value = yypvt[-0].value;
	yyval.value = 0;
} break;
case 15:
# line 198 "as31.y"
{ yyval.value = 0; } break;
case 16:
# line 202 "as31.y"
{
		if( yypvt[-0].val.d == 0 )
			error("Expression is undefined in pass 1");
		if( !(isbit16(yypvt[-0].val.v)) )
			error("Value greater than 16-bits");
		yyval.value = yypvt[-0].val.v;
} break;
case 17:
# line 212 "as31.y"
{
	if( !isbit8(yypvt[-1].value) )
		warning("Bit address exceeds 8-bits");
	if( isbmram(yypvt[-1].value) )
		yyval.value = (yypvt[-1].value-0x20)*8+ yypvt[-0].value;
	else if( isbmsfr(yypvt[-1].value) )
		yyval.value = yypvt[-1].value + yypvt[-0].value;
	else
		warning("Invalid bit addressable RAM location");
} break;
case 18:
# line 225 "as31.y"
{
	if( yypvt[-0].sym->type == UNDEF )
		error("Symbol %s must be defined in pass 1",yypvt[-0].sym->name);
	yyval.value = yypvt[-0].sym->value;
} break;
case 19:
# line 230 "as31.y"
{ yyval.value = yypvt[-0].value; } break;
case 20:
# line 235 "as31.y"
{
	if( yypvt[-0].sym->type != UNDEF && pass1)
		error("Attempt to redefine symbol: %s",yypvt[-0].sym->name);
	yyval.sym = yypvt[-0].sym;
} break;
case 21:
# line 243 "as31.y"
{
	if( pass2 ) genbyte(yypvt[-0].value);
	yyval.value = yypvt[-2].value + 1;
} break;
case 22:
# line 248 "as31.y"
{
	if( pass1 )
		yyval.value = yypvt[-2].value + yypvt[-0].value;
	else {
		yyval.value = yypvt[-2].value + strlen(yypvt[-0].str);
		genstr(yypvt[-0].str);

		free(yypvt[-0].str);
	}
} break;
case 23:
# line 259 "as31.y"
{
	if( pass2 ) genbyte(yypvt[-0].value);
	yyval.value = 1;
} break;
case 24:
# line 264 "as31.y"
{
	if( pass1 )
		yyval.value = yypvt[-0].value;
	else {
		yyval.value = strlen(yypvt[-0].str);
		genstr(yypvt[-0].str);
		free(yypvt[-0].str);
	}
} break;
case 25:
# line 276 "as31.y"
{
	if( pass2 ) genword(yypvt[-0].value);
	yyval.value = yypvt[-2].value + 2;
} break;
case 26:
# line 281 "as31.y"
{
	if( pass2 ) genword(yypvt[-0].value);
	yyval.value = 2;
} break;
case 27:
# line 294 "as31.y"
{ yyval.val.v = lc;
					  yyval.val.d = 1; } break;
case 28:
# line 297 "as31.y"
{ yyval.val.v = yypvt[-1].val.v;
					  yyval.val.d = yypvt[-1].val.d; } break;
case 29:
# line 300 "as31.y"
{ yyval.val.v = -yypvt[-0].val.v;
					  yyval.val.d = yypvt[-0].val.d;  } break;
case 30:
# line 303 "as31.y"
{ yyval.val.v = yypvt[-2].val.v | yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 31:
# line 306 "as31.y"
{ yyval.val.v = yypvt[-2].val.v & yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 32:
# line 309 "as31.y"
{ yyval.val.v = yypvt[-2].val.v * yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 33:
# line 312 "as31.y"
{ yyval.val.v = yypvt[-2].val.v / yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 34:
# line 315 "as31.y"
{ yyval.val.v = yypvt[-2].val.v % yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 35:
# line 318 "as31.y"
{ yyval.val.v = yypvt[-2].val.v - yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 36:
# line 321 "as31.y"
{ yyval.val.v = yypvt[-2].val.v + yypvt[-0].val.v;
					  yyval.val.d = yypvt[-2].val.d && yypvt[-0].val.d; } break;
case 37:
# line 324 "as31.y"
{
	if( pass1 ) {
		yyval.val.v = yypvt[-0].sym->value;
		yyval.val.d = (yypvt[-0].sym->type != UNDEF);
	}
	else {
		if( yypvt[-0].sym->type == UNDEF )
			error("Undefined symbol %s",yypvt[-0].sym->name);
		yyval.val.v = yypvt[-0].sym->value;
		yyval.val.d = 1;
	}
} break;
case 38:
# line 336 "as31.y"
{ yyval.val.v = yypvt[-0].val.v; yyval.val.d=1; } break;
case 39:
# line 349 "as31.y"
{ yyval.value = makeop(yypvt[-0].op,NULL,0); } break;
case 40:
# line 351 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 41:
# line 353 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 42:
# line 355 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 43:
# line 357 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 44:
# line 359 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 45:
# line 361 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 46:
# line 363 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,4); } break;
case 47:
# line 365 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 48:
# line 367 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,4); } break;
case 49:
# line 369 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,6); } break;
case 50:
# line 371 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 51:
# line 373 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,4); } break;
case 52:
# line 375 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,6); } break;
case 53:
# line 377 "as31.y"
{ if( get_md(yypvt[-0].mode) == 3 )
					error("Immediate mode is illegal");
				  yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0);
				} break;
case 54:
# line 382 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 55:
# line 384 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,4); } break;
case 56:
# line 386 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 57:
# line 388 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 58:
# line 390 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 59:
# line 392 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,0); } break;
case 60:
# line 394 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,0); } break;
case 61:
# line 396 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 62:
# line 398 "as31.y"
{ yyval.value = makeop(yypvt[-0].op,NULL,0); } break;
case 63:
# line 400 "as31.y"
{ yyval.value = makeop(yypvt[-0].op,NULL,0); } break;
case 64:
# line 402 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 65:
# line 404 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 66:
# line 406 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 67:
# line 408 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 68:
# line 410 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,NULL,0); } break;
case 69:
# line 412 "as31.y"
{ if( get_md(yypvt[-0].mode) != 2 )
					error("Invalid addressing mode");
				  yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,-2); } break;
case 70:
# line 416 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 71:
# line 418 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 72:
# line 420 "as31.y"
{ if( get_md(yypvt[-0].mode) == 0 )
					error("Invalid addressing mode");
				  yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,-1); } break;
case 73:
# line 424 "as31.y"
{
				   struct mode tmp;
					set_md(tmp,0);
					set_ov(tmp,0);
					set_sz(tmp,1);
					set_b1(tmp,yypvt[-0].value);
					yyval.value = makeop(yypvt[-1].op,&tmp,0);
				} break;
case 74:
# line 433 "as31.y"
{
				   struct mode tmp;
					set_md(tmp,0);
					set_ov(tmp,0);
					set_sz(tmp,1);
					set_b1(tmp,yypvt[-0].value);
					yyval.value = makeop(yypvt[-1].op,&tmp,0);
				} break;
case 75:
# line 442 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 76:
# line 444 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 77:
# line 446 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 78:
# line 448 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 79:
# line 450 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 80:
# line 452 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 81:
# line 454 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 82:
# line 456 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 83:
# line 458 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 84:
# line 460 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 85:
# line 462 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 86:
# line 464 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 87:
# line 466 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,0); } break;
case 88:
# line 468 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,4); } break;
case 89:
# line 470 "as31.y"
{ yyval.value = makeop(yypvt[-1].op,&yypvt[-0].mode,6); } break;
case 90:
# line 474 "as31.y"
{ yyval.value = makeop(yypvt[-6].op,NULL,0); } break;
case 91:
# line 476 "as31.y"
{ yyval.value = makeop(yypvt[-6].op,NULL,0); } break;
case 92:
# line 478 "as31.y"
{ yyval.value = makeop(yypvt[-6].op,NULL,1); } break;
case 93:
# line 480 "as31.y"
{ yyval.value = makeop(yypvt[-6].op,NULL,1); } break;
case 94:
# line 483 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,yypvt[-0].value); } break;
case 95:
# line 485 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,2); } break;
case 96:
# line 487 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,yypvt[-2].value+3); } break;
case 97:
# line 489 "as31.y"
{ yyval.value = makeop(yypvt[-4].op,NULL,5); } break;
case 98:
# line 501 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode, yypvt[-0].value);
					set_sz(yyval.mode, 0);
				} break;
case 99:
# line 507 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 100:
# line 514 "as31.y"
{
					set_md(yyval.mode,2);
					set_ov(yyval.mode,yypvt[-0].value);
					set_sz(yyval.mode,0);
				} break;
case 101:
# line 520 "as31.y"
{
					set_md(yyval.mode,3);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 102:
# line 529 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-2].value);
				} break;
case 103:
# line 536 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-3].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 104:
# line 546 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 105:
# line 553 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 106:
# line 560 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 107:
# line 569 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 108:
# line 579 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,yypvt[-2].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 109:
# line 586 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 110:
# line 596 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,yypvt[-2].value);
					set_sz(yyval.mode,0);
				} break;
case 111:
# line 602 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,yypvt[-2].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 112:
# line 609 "as31.y"
{
					set_md(yyval.mode,2);
					set_ov(yyval.mode,yypvt[-3].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 113:
# line 616 "as31.y"
{
					set_md(yyval.mode,3);
					set_ov(yyval.mode,yypvt[-0].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-2].value);
				} break;
case 114:
# line 623 "as31.y"
{
					set_md(yyval.mode,4);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-0].value);
					set_b2(yyval.mode,yypvt[-2].value);
				} break;
case 115:
# line 631 "as31.y"
{
					set_md(yyval.mode,5);
					set_ov(yyval.mode,yypvt[-0].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-3].value);
				} break;
case 116:
# line 638 "as31.y"
{
					set_md(yyval.mode,6);
					set_ov(yyval.mode,yypvt[-2].value);
					set_sz(yyval.mode,0);
				} break;
case 117:
# line 644 "as31.y"
{
					set_md(yyval.mode,7);
					set_ov(yyval.mode,yypvt[-2].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 118:
# line 651 "as31.y"
{
					set_md(yyval.mode,8);
					set_ov(yyval.mode,yypvt[-3].value);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 119:
# line 658 "as31.y"
{
				set_md(yyval.mode,9);
				set_ov(yyval.mode,0);
				set_sz(yyval.mode,2);
				set_b1(yyval.mode, (yypvt[-0].value & 0xff00) >> 8 );
				set_b2(yyval.mode, (yypvt[-0].value & 0x00ff) );
			} break;
case 120:
# line 666 "as31.y"
{
					set_md(yyval.mode,10);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 121:
# line 682 "as31.y"
{
					set_md(yyval.mode,11);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-2].value);
				} break;
case 122:
# line 689 "as31.y"
{
	if( pass2 ) {
		if( !isbit8(yypvt[-3].value) )
			warning("Bit address exceeds 8-bits");
		if( isbmram(yypvt[-3].value) )
			set_b1(yyval.mode, (yypvt[-3].value-0x20)*8+ yypvt[-2].value );
		else if( isbmsfr(yypvt[-3].value) )
			set_b1(yyval.mode, yypvt[-3].value + yypvt[-2].value );
		else
			warning("Invalid bit addressable RAM location");
	}
	set_md(yyval.mode,11);
	set_ov(yyval.mode,0);
	set_sz(yyval.mode,1);
} break;
case 123:
# line 708 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,0);
				} break;
case 124:
# line 715 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,yypvt[-0].value);
					set_sz(yyval.mode,0);
				} break;
case 125:
# line 721 "as31.y"
{
					set_md(yyval.mode,2);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 126:
# line 728 "as31.y"
{
					set_md(yyval.mode,3);
					set_ov(yyval.mode,yypvt[-0].value);
					set_sz(yyval.mode,0);
				} break;
case 127:
# line 736 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,0);
				} break;
case 128:
# line 742 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,0);
				} break;
case 129:
# line 748 "as31.y"
{
					set_md(yyval.mode,2);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,1);
					set_b1(yyval.mode,yypvt[-0].value);
				} break;
case 130:
# line 757 "as31.y"
{
					set_md(yyval.mode,0);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 131:
# line 765 "as31.y"
{
					set_md(yyval.mode,1);
					set_ov(yyval.mode,0);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 132:
# line 773 "as31.y"
{
					set_md(yyval.mode,2);
					set_ov(yyval.mode,yypvt[-5].value);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 133:
# line 781 "as31.y"
{
					set_md(yyval.mode,3);
					set_ov(yyval.mode,yypvt[-5].value);
					set_sz(yyval.mode,2);
					set_b1(yyval.mode,yypvt[-2].value);
					set_b2(yyval.mode,yypvt[-0].value);
				} break;
case 134:
# line 791 "as31.y"
{
		long offset;
		if( pass2 ) {
			offset = yypvt[-0].val.v - (lc+3);
			if( offset > 127 || offset < -128 )
			   warning("Relative offset exceeds -128 / +127");
			yyval.value = offset;
		}
} break;
case 135:
# line 808 "as31.y"
{
		long offset;
		if( pass2 ) {
			offset = yypvt[-0].val.v - (lc+2); /* different! */
			if( offset > 127 || offset < -128 )
			   warning("Relative offset exceeds -128 / +127");
			yyval.value = offset;
		}
} break;
case 136:
# line 821 "as31.y"
{
	if( pass2 ) {
		if( !isbit8(yypvt[-1].value) )
			warning("Bit address exceeds 8-bits");
		if( isbmram(yypvt[-1].value) )
			yyval.value = (yypvt[-1].value-0x20)*8+yypvt[-0].value;
		else if( isbmsfr(yypvt[-1].value) )
			yyval.value = yypvt[-1].value + yypvt[-0].value;
		else
			warning("Invalid bit addressable RAM location");
	}
} break;
case 137:
# line 834 "as31.y"
{
	if( pass2 ) {
		if( !isbit8(yypvt[-0].value) )
			warning("Bit address exceeds 8-bits");
		yyval.value = yypvt[-0].value;
	}
} break;
case 138:
# line 844 "as31.y"
{
	if( yypvt[-0].sym->type == UNDEF && pass2 )
		error("Symbol %s undefined",yypvt[-0].sym->name);
	yyval.value = yypvt[-0].sym->value;
} break;
case 139:
# line 849 "as31.y"
{ yyval.value = yypvt[-0].value; } break;
case 140:
# line 852 "as31.y"
{ yyval.value = 0; } break;
case 141:
# line 853 "as31.y"
{ yyval.value = 1; } break;
case 142:
# line 854 "as31.y"
{ yyval.value = 2; } break;
case 143:
# line 855 "as31.y"
{ yyval.value = 3; } break;
case 144:
# line 856 "as31.y"
{ yyval.value = 4; } break;
case 145:
# line 857 "as31.y"
{ yyval.value = 5; } break;
case 146:
# line 858 "as31.y"
{ yyval.value = 6; } break;
case 147:
# line 859 "as31.y"
{ yyval.value = 7; } break;
case 148:
# line 862 "as31.y"
{ yyval.value = 0; } break;
case 149:
# line 863 "as31.y"
{ yyval.value = 1; } break;
case 150:
# line 865 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r2"); } break;
case 151:
# line 868 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r3"); } break;
case 152:
# line 871 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r4"); } break;
case 153:
# line 874 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r5"); } break;
case 154:
# line 877 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r6"); } break;
case 155:
# line 880 "as31.y"
{ yyval.value = 0;
				  warning("Illegal indirect register: @r7"); } break;
case 156:
# line 885 "as31.y"
{
	if( pass2 ) {
		if( !isbit8(yypvt[-0].val.v) )
			warning("Expression greater than 8-bits");
	}
	yyval.value = yypvt[-0].val.v;
} break;
case 157:
# line 895 "as31.y"
{
	if( pass2 ) {
		if( !isbit16(yypvt[-0].val.v) )
			warning("Expression greater than 16-bits");
	}
	yyval.value = yypvt[-0].val.v;
} break;
case 158:
# line 905 "as31.y"
{
		if( pass2 ) {
			if( !isbit16(yypvt[-0].val.v)  )
				warning("Address greater than 16-bits");
			if( (yypvt[-0].val.v & size11) != ((lc+2) & size11) )
				warning("Address outside current 2K page");
		}
		set_md(yyval.mode,0);
		set_ov(yyval.mode, (yypvt[-0].val.v&0x0700)>>3 );
		set_sz(yyval.mode,1);
		set_b1(yyval.mode,yypvt[-0].val.v&0x00ff);
} break;
case 159:
# line 920 "as31.y"
{
		if( pass2 ) {
			if( !isbit16(yypvt[-0].val.v)  )
				warning("Address greater than 16-bits");
		}
		set_md(yyval.mode,0);
		set_ov(yyval.mode, 0 );
		set_sz(yyval.mode,2);
		set_b1(yyval.mode, (yypvt[-0].val.v & 0xff00 ) >> 8 );
		set_b2(yyval.mode, (yypvt[-0].val.v & 0x00ff ) );
} break;
case 160:
# line 934 "as31.y"
{
		long offset;
		if( pass2 ) {
			offset = yypvt[-0].val.v - (lc+2);
			if( offset>127 || offset<-128 )
			   warning("Relative offset exceeds -128 / +127");
		}
		set_md(yyval.mode,0);
		set_ov(yyval.mode,0);
		set_sz(yyval.mode,1);
		set_b1(yyval.mode,offset);

} break;
		}
		goto yystack;  /* stack new state and value */

	}

