/* MKTABLE.C: Makes a data table with header record */

#include <stdio.h>
#include <string.h>
#define  SIG  19364            /* application file signature */

typedef struct {
  char      fname [20];
  int       ftype, flen;
} DESCR;

struct {                           /* header record for file */
  unsigned  signature;
  int       nrecs;
  char      tablename [10];
  int       reclen;
  long      datastart;
  int       descrsize;
  int       ndescr;
} header;

struct {                             /* data record for file */
  char      name [20];
  int       age;
} data;

main ()
{
FILE  *fp;
char  age [3];
int   n;
DESCR descr;

  fp = fopen ("database.xyz", "w");           /* create file */

  header.signature = SIG;               /* initialize header */
  header.nrecs = 0;
  strcpy (header.tablename, "Age list");
  header.reclen = sizeof data;
  header.datastart = 256L;
  header.descrsize = sizeof (descr);
  header.ndescr = 2;
  fwrite (&header, sizeof header, 1, fp);   /* write to file */

  strcpy (descr.fname, "NAME");     /* initialize descriptor */
  descr.ftype = 1;
  descr.flen  = 20;
  fwrite (&descr, sizeof (descr), 1, fp);   /* write to file */

  strcpy (descr.fname, "AGE");                /* ditto above */
  descr.ftype = 0;
  descr.flen  = 2;
  fwrite (&descr, sizeof (descr), 1, fp);

  fseek (fp, 256L, SEEK_SET);

  do {                                       /* capture data */
    printf ("\nName? ");
    gets (data.name);
    if (strlen (data.name)) {        /* continue until blank */
      printf ("Age?  ");
      gets (age);
      data.age = atoi (age);
      fwrite (&data, sizeof data, 1, fp);    /* write record */
      header.nrecs += 1;                     /* count record */
    }
  } while (strlen (data.name));     /* until no more entered */

  fseek (fp, 0L, SEEK_SET);           /* go to start of file */
  fwrite (&header, sizeof header, 1, fp);   /* update header */
  fclose (fp);                                 /* close file */
}
