/* Example Program Using Virtual Arrays */

#include <varray.h>

/* Access Macros */

#define VREC(i) ((items *)access_v_rec(item_array,i))
#define item(i) VREC(i)->v_item
#define qty(i) VREC(i)->v_qty
#define desc(i) VREC(i)->v_desc

/* Array element structure typedef */

typedef struct {
   int v_item,
       v_qty;
   char v_desc[24];
} items;

main()
{
   VACB *item_array;
   long i;

   /* create a virtual array setting element size to */
   /* the size of items structure and setting the    */
   /* initialization char to the space char          */

   init_v_array("ITEMS.VAR",sizeof(items),' ');

   /* open the virtual array, reserve buffer space for 10 elements */

   item_array = open_v_array("ITEMS.VAR",10);


   /* create 50 array items */

   for (i = 0; i < 50 ; i++) {
      item(i) = i + 1;
      qty(i)  = 0;
      sprintf(desc(i)," Item # %ld", i + 1);
   }

   /* print contents of the 50 array items */
   /* plus the ascii code of last char in v_desc */

   for (i = 0; i < 50; i++)
      printf("Element # %ld  Item = %d  Qty = %d Desc = %s  %d\n",
             i, item(i), qty(i), desc(i), (int) desc(i)[23]);

   /* close virtual array */

   close_v_array(item_array);
}
