/* Types.h - integer types defined for portability between compilers and
 * notational convenience. 
 *
 * Copyright (c) 1992 Jim Kent.  This file may be freely used, modified,
 * copied and distributed.  This file was first published as part of
 * an article for Dr. Dobb's Journal March 1993 issue.
 */

#ifndef TYPES_H		/* Prevent file from being included twice. */
#define TYPES_H

typedef signed char Char;		/* Signed 8 bits. */
typedef unsigned char Uchar;	/* Unsigned 8 bits. */
typedef short Short;			/* Signed 16 bits please. */
typedef unsigned short Ushort;	/* Unsigned 16 bits please. */
typedef long Long;				/* Signed 32 bits. */
typedef unsigned long Ulong;	/* Unsigned 32 bits. */

typedef int Boolean;			/* TRUE or FALSE value. */
typedef int ErrCode;			/* ErrXXX or Success. */
typedef int FileHandle;			/* OS file handle. */

	/* Values for Boolean types */
#define FALSE 0
#define TRUE (!FALSE)

	/* Values for ErrCodes */
#define Success		0		/* Things are fine. */
#define Error		-1		/* Unclassified error. */

#endif /* TYPES_H */
