// ------------- button.cpp

#include "button.h"
#include "desktop.h"

PushButton::PushButton(char *lbl, int lf, int tp, DFWindow *par)
                : TextBox(lf, tp, 1, strlen(lbl)+2, par)
{
    OpenWindow();
    String lb(" ");
    lb += lbl;
    lb += " ";
    SetText(lb);
}

// ----------- common constructor code
void PushButton::OpenWindow()
{
    windowtype = PushButtonWindow;
    if (windowstate == CLOSED)
        TextBox::OpenWindow();
    SetColors();
    pressed = False;
    cmdfunction = NULL;
}

void PushButton::CloseWindow()
{
    TextBox::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void PushButton::SetColors()
{
    colors.fg = BLACK;
    colors.bg = CYAN;
    colors.sfg = WHITE;
    colors.sbg = CYAN;
    colors.ffg = BLACK;
    colors.fbg = CYAN;
    colors.hfg = DARKGRAY;    // Inactive FG
    colors.hbg = CYAN;        // Inactive BG
    shortcutfg = RED;
}

void PushButton::Paint()
{
    if (visible)    {
        Colors fg;
        Colors bg;
        if (!pressed)    {
            if (isEnabled())    {
                if (this == desktop.InFocus())
                    fg = colors.sfg;
                else
                    fg = colors.fg;
                WriteShortcutLine(0, fg, colors.bg);
            }
            else 
                WriteTextLine(0, colors.hfg, colors.hbg);
        }
        else     {
            // ---- display a pressed button
            fg = ClientBG();
            bg = Parent()->ClientBG();
            int wd = Width();
            WriteWindowChar(' ', 0, 0, fg, bg);
            for (int x = 0; x < wd; x++)    {
                WriteWindowChar(220, x+1, 0, fg, bg);
                WriteWindowChar(223, x+1, 1, fg, bg);
            }
        }
    }
}

void PushButton::Shadow()
{
    if (visible && (attrib & SHADOW))    {
        Colors bg = Parent()->ClientBG();
        int wd = Width();
        WriteWindowChar(220, wd, 0, BLACK, bg);
        for (int x = 1; x <= wd; x++)
            WriteWindowChar(223, x, 1, BLACK, bg);
    }
}

Bool PushButton::SetFocus()
{
    TextBox::SetFocus();
    Paint();
    return True;
}

void PushButton::ResetFocus()
{
    TextBox::ResetFocus();
    Paint();
}

void PushButton::Keyboard(int key)
{
    if (key == '\r')
        PressButton();
    else 
        TextBox::Keyboard(key);
}

void PushButton::LeftButton(int mx, int my)
{
    if (ClientRect().Inside(mx,my))    {
        PressButton();
        CaptureFocus();
    }
}

void PushButton::MouseMoved(int mx, int my)
{
    if (desktop.FocusCapture() == this)
        if (ClientRect().Inside(mx,my))
            PressButton();
        else
            ReleaseButton();
}

void PushButton::ButtonReleased(int, int)
{
    ReleaseFocus();
    ButtonCommand();
}

void PushButton::KeyReleased()
{
    ButtonCommand();
}

void PushButton::ButtonCommand()
{
    if (pressed)    {
        ReleaseButton();
        if (cmdfunction != NULL && owner != NULL)
            (owner->*cmdfunction)();
    }
}

void PushButton::PressButton()
{
    if (!pressed)    {
        pressed = True;
        Paint();
    }
}

void PushButton::ReleaseButton()
{
    if (pressed)    {
        pressed = False;
        Paint();
        Shadow();
    }
}





