// ------------- checkbox.cpp

#include "checkbox.h"
#include "desktop.h"

CheckBox::CheckBox(char *lbl, int lf, int tp, DFWindow *par)
                : TextBox(lf, tp, 1, strlen(lbl)+5, par)
{
    OpenWindow();
    String lb("[ ] ");
    lb += lbl;
    lb += " ";
    SetText(lb);
}

// ----------- common constructor code
void CheckBox::OpenWindow()
{
    windowtype = CheckBoxWindow;
    if (windowstate == CLOSED)
        TextBox::OpenWindow();
    SetColors();
    setting = False;
}

void CheckBox::CloseWindow()
{
    TextBox::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void CheckBox::SetColors()
{
    colors.fg =
    colors.sfg =
    colors.ffg =
    colors.hfg = Parent()->ClientFG(); 
    colors.bg =
    colors.sbg =
    colors.fbg =
    colors.hbg = Parent()->ClientBG();
    shortcutfg = RED;
}

void CheckBox::Paint()
{
    if (visible)    {
        if (isEnabled())
            WriteShortcutLine(0, colors.fg, colors.bg);
        else 
            WriteTextLine(0, colors.hfg, colors.hbg);
    }
}

Bool CheckBox::SetFocus()
{
    TextBox::SetFocus();
    desktop.cursor().normalcursor();
    desktop.cursor().SetPosition(Left()+1, Top());
    desktop.cursor().Show();
    return True;
}

void CheckBox::ResetFocus()
{
    TextBox::ResetFocus();
    desktop.cursor().Hide();
}

void CheckBox::Keyboard(int key)
{
    if (key == ' ')
        InvertCheckBox();
    else 
        TextBox::Keyboard(key);
}

void CheckBox::LeftButton(int mx, int my)
{
    if (ClientRect().Inside(mx,my))
        InvertCheckBox();
}

void CheckBox::InvertCheckBox()
{
    setting = setting ? False : True;
    (*text)[1] = setting ? 'X' : ' ';
    Paint();
}







