// --------------- ctlmenu.cpp

#include "dflatpp.h"
#include "frame.h"

MenuSelection RestoreCmd  ("~Restore",  &DFWindow::Restore);
MenuSelection MoveCmd     ("~Move",     &DFWindow::CtlMenuMove);
MenuSelection SizeCmd     ("~Size",	    &DFWindow::CtlMenuSize);
MenuSelection MinimizeCmd ("Mi~nimize", &DFWindow::Minimize);
MenuSelection MaximizeCmd ("Ma~ximize", &DFWindow::Maximize);
MenuSelection CloseCmd    ("~Close  [Ctrl+F4]",
										&DFWindow::CloseWindow, CTRL_F4);

MenuSelection *ControlMenu[8];

MenuBarItem CtlMenu[] = {
	MenuBarItem( "", ControlMenu ),
	MenuBarItem(MENU_TERMINATOR)
};

void DFWindow::OpenCtlMenu()
{
	if (ctlmenu != NULL)
		delete ctlmenu;

	int mn = 0;

	if (attrib & (MINBOX | MAXBOX))
		ControlMenu[mn++] = &RestoreCmd;
	if (attrib & MOVEABLE)
		ControlMenu[mn++] = &MoveCmd;
	if (attrib & SIZEABLE)
		ControlMenu[mn++] = &SizeCmd;
	if (attrib & MINBOX)
		ControlMenu[mn++] = &MinimizeCmd;
	if (attrib & MAXBOX)
		ControlMenu[mn++] = &MaximizeCmd;
	if (mn != 0)
		ControlMenu[mn++] = &SelectionSeparator;
	ControlMenu[mn++] = &CloseCmd;
	ControlMenu[mn] = &SelectionTerminator;

	MinimizeCmd.Disable();
	MaximizeCmd.Disable();
	RestoreCmd.Disable();
	SizeCmd.Disable();
	MoveCmd.Disable();

	switch (windowstate)	{
		case ISRESTORED:
			if (attrib & MINBOX)
				MinimizeCmd.Enable();
			if (attrib & MAXBOX)
				MaximizeCmd.Enable();
			MoveCmd.Enable();
			SizeCmd.Enable();
			break;
		case ISMINIMIZED:
			RestoreCmd.Enable();
			MoveCmd.Enable();
			break;
		case ISMAXIMIZED:
			RestoreCmd.Enable();
			if (attrib & MINBOX)
				MinimizeCmd.Enable();
			break;
	}
	ctlmenu = new PopDown(this, ControlMenu);
	ctlmenu->OpenMenu(Left()+1, Top()+1);
}

void DFWindow::DeleteCtlMenu()
{
	if (ctlmenu != NULL)
		delete ctlmenu;
	ctlmenu = NULL;
}

void DFWindow::CtlMenuMove()
{
	desktop.mouse().SetPosition(Left(), Top());
	new Frame(this, Left());
}

void DFWindow::CtlMenuSize()
{
	desktop.mouse().SetPosition(Right(), Bottom());
	new Frame(this);
}


