// -------- dflatdef.h

#ifndef DFLATDEF_H
#define DFLATDEF_H

// -------- window class types
enum WndType {
    DFlatWindow,
    ApplicationWindow,
    TextboxWindow,
    FrameWindow,
    ScrollbarWindow,
    MenubarWindow,
    ListboxWindow,
    PopdownWindow,
    EditboxWindow,
    DialogboxWindow,
    PushButtonWindow,
    RadioButtonWindow,
	CheckBoxWindow,
    StatusbarWindow
};

enum Bool {False, True};

inline int max(int a, int b) { return a > b ? a : b; }
inline int min(int a, int b) { return a < b ? a : b; }

// ----- portablility layer for MSC C++
#ifdef MSC

#define keyhit       kbhit
#undef FP_OFF
#undef FP_SEG
#undef MK_FP
#define FP_OFF(p)    ((unsigned)(p))
#define FP_SEG(p)    ((unsigned)((unsigned long)(p) >> 16))
#define MK_FP(s,o)   ((void far *) \
               (((unsigned long)(s) << 16) | (unsigned)(o)))
#define outp         _outp
#define inp          _inp
#define bioskey      _bios_keybrd
#define getvect(v)   _dos_getvect(v)
#define setvect(v,f) _dos_setvect(v,f)

#define INTERRUPTARGS void
#else
#define INTERRUPTARGS ...
#endif

#define poke(a,b,c) (*((int far*)MK_FP((a),(b))) = (int)(c))
#define peek(a,b)   (*((int far*)MK_FP((a),(b))))

#endif

