// -------- editbox.h 

#ifndef EDITBOX_H
#define EDITBOX_H

#include "textbox.h"

class EditBox : public TextBox	{
protected:
    int column;       /* Current column                */
    Bool changed;     /* True if text has changed      */
	virtual void Home();
	virtual void End();
	virtual void NextWord();
	virtual void PrevWord();
	virtual void Forward();
	virtual void Backward();
	virtual void DeleteCharacter();
	virtual void CharacterEntry(int key);
public:
	EditBox(char *ttl, int lf, int tp, int ht, int wd, DFWindow *par)
						: TextBox(ttl, lf, tp, ht, wd, par)
			{ OpenWindow(); }
	EditBox(char *ttl, int ht, int wd, DFWindow *par)
						: TextBox(ttl, ht, wd, par)
			{ OpenWindow(); }
	EditBox(int lf, int tp, int ht, int wd, DFWindow *par)
						: TextBox(lf, tp, ht, wd, par)
			{ OpenWindow(); }
	EditBox(int ht, int wd, DFWindow *par) : TextBox(ht, wd, par)
			{ OpenWindow(); }
	EditBox(char *ttl)	: TextBox(ttl)
			{ OpenWindow(); }
	virtual ~EditBox()
		{ if (windowstate != CLOSED) CloseWindow(); }
	// -------- API messages
	virtual void OpenWindow();
	virtual void CloseWindow();
	virtual Bool SetFocus();
	virtual void ResetFocus();
	virtual void SetCursor(int x, int y);
	virtual void ResetCursor() { SetCursor(column, 0); }
	virtual void Keyboard(int key);
	virtual void Move(int x, int y);
	virtual void Paint();
	virtual void ClearText();
    virtual void LeftButton(int mx, int my);
};

#endif


