// ------------- frame.cpp

#include "desktop.h"
#include "frame.h"

Frame::Frame(DFWindow *par, int mx)
	: DFWindow(par->Left(), par->Top(), par->Height(), par->Width(), par)
{
	windowtype = FrameWindow;
	SetAttribute(BORDER | NOCLIP | SAVESELF);
	SetColors();
	DblBorder = False;
	moving = (Bool) (mx != -1);
	diff = moving ? mx-Left() : 0;
	CaptureFocus();
	minx = 0;
	miny = 0;
	maxx = desktop.screen().Width()-1;
	maxy = desktop.screen().Height()-1;
	DFWindow *pp = par->Parent();
	if (pp != NULL)	{
		maxx = pp->ClientRight();
		maxy = pp->ClientBottom();
	}
	if (moving)	{
		if (pp != NULL)	{
			minx = pp->ClientLeft();
			miny = pp->ClientTop();
		}
	}
	else	{
		minx = par->Left()+5;
		miny = par->Top()+3;
	}
	desktop.mouse().SetTravel(minx+diff, maxx, miny, maxy);
}

// -------- set the fg/bg colors for the window 
void Frame::SetColors()
{
	colors.fg =
	colors.sfg =
	colors.ffg =
	colors.hfg = GREEN;
	colors.fbg =
	colors.sbg = 
	colors.bg =
	colors.hbg = LIGHTGRAY;
}

// ---------- display the frame
void Frame::Show()
{
	if (!visible)	{
		visible = True;
		videosave = new char[rect.Height() * rect.Width() * 2];
		desktop.screen().GetBuffer(rect, videosave);
		Border();
	}
}

// ----------- hide the frame
void Frame::Hide()
{
	if (visible)	{
		visible = False;
		desktop.screen().PutBuffer(rect, videosave);
		delete videosave;
		videosave = NULL;
	}
}

void Frame::LeftButton(int, int)
{
	// --- intercept the left button
}

void Frame::DestroyFrame()
{
	delete this;
	desktop.mouse().SetTravel(0, desktop.screen().Width()-1, 0, desktop.screen().Height()-1);
}

void Frame::CloseFrame(int lf, int tp, int rt, int bt)
{
	DFWindow *par = parent;
	DestroyFrame();
	if (moving)	{
		if (par->Left() != lf || par->Top() != tp)
			par->Move(lf, tp);
	}
	else if (par->Right() != rt || par->Bottom() != bt)
		par->Size(rt, bt);
}

void Frame::ButtonReleased(int, int)
{
	CloseFrame(Left(), Top(), Right(), Bottom());
}

void Frame::MouseMoved(int mx, int my)
{
	if (mx != prevmousecol || my != prevmouseline)	{
		if (moving)
			Move(mx-diff, my);
		else
			Size(mx, my);
	}
}

void Frame::Keyboard(int key)
{
	int lf = Left();
	int tp = Top();
	int rt = Right();
	int bt = Bottom();
	switch (key)	{
		case ESC:
			DestroyFrame();
			break;
		case '\r':
			CloseFrame(Left(), Top(), Right(), Bottom());
			break;
		case FWD:
			if (moving)	{
				if (lf < maxx)
					Move(lf+1, tp);
			}
			else
				if (rt < maxx)
					Size(rt+1, bt);
			break;
		case BS:
			if (moving)	{
				if (lf > minx)
					Move(lf-1, tp);
			}
			else if (rt > minx)
				Size(rt-1, bt);
			break;
		case UP:
			if (moving)	{
				if (tp > miny)
					Move(lf, tp-1);
			}
			else if (bt > miny)
				Size(rt, bt-1);
			break;
		case DN:
			if (moving)	{
				if (tp < maxy)
					Move(lf, tp+1);
			}
			else if (bt < maxy)
				Size(rt, bt+1);
			break;
		default:
			break;
	}
}


