// ------------- menubar.cpp

#include <ctype.h>
#include "desktop.h"
#include "menubar.h"
#include "menusel.h"

MenuBarItem::MenuBarItem(char *Title, MenuSelection **Ms,
						 void (*MenuPrep)())
{
	title = new String(Title);
	ms = Ms;
	menuprep = MenuPrep;
	popdown = NULL;
	terminator = False;
}

MenuBarItem::MenuBarItem(MenuTerminator)
{
	title = NULL;
	terminator = True;
	ms = NULL;
	menuprep = NULL;
	popdown = NULL;
}

MenuBar::MenuBar( MenuBarItem *MenuItems, DFWindow *par) :
			TextBox( par->ClientLeft(),	par->ClientTop()-1,
						1, par->ClientWidth(), par)
{
	windowtype = MenubarWindow;
	menuitems = MenuItems;
	SetAttribute(NOCLIP);
	SetColors();
	selection = -1;
	ispoppeddown = False;
	MenuBarItem *menu = menuitems;
	menucount = 0;
	oldfocus = NULL;
	int off = 2;
	SetTextLength(desktop.screen().Width()*2);
	while (!menu->terminator)	{
		int len = menu->title->Strlen()-1;
		menu->x1 = off;
		menu->x2 = off+len-1;
		off += len+2;
		String ttl("  ");
		ttl += *(menu->title);
		AddText(ttl);
		int n = text->Strlen()-1;
		(*text)[n] = '\0';
		menu->popdown = new PopDown(this, menu->ms);
		menu++;
		menucount++;
	}
}

MenuBar::~MenuBar()
{
	// destructor code
	MenuBarItem *menu = menuitems;
	while (!menu->terminator)	{
		delete menu->popdown;
		menu++;
	}
    TextBox::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void MenuBar::SetColors()
{
	colors.fg = BLACK;
	colors.bg = LIGHTGRAY;
	colors.sfg = BLACK;
	colors.sbg = CYAN;
	colors.ffg = BLACK;
	colors.fbg = LIGHTGRAY;
	colors.hfg = BLACK;
	colors.hbg = LIGHTGRAY;
	shortcutfg = RED;
}

Bool MenuBar::SetFocus()
{
	if (oldfocus == NULL)
		if (desktop.InFocus() != NULL)
			if (desktop.InFocus()->State() != ISCLOSING)
				oldfocus = desktop.InFocus();
	return TextBox::SetFocus();
}

void MenuBar::ResetFocus()
{
	if (!ispoppeddown)	{
		SetSelection(-1);
		oldfocus = NULL;
	}
	TextBox::ResetFocus();
}

void MenuBar::Paint()
{
	WriteShortcutLine(0, colors.fg, colors.bg);
	if (selection != -1)	{
		int x = menuitems[selection].x1;
		int len = menuitems[selection].x2-x+2;
		String sel = text->mid(len, x+selection);
		DisplayShortcutField(sel, x, 0, colors.sfg, colors.sbg);
	}
}

void MenuBar::LeftButton(int mx, int)
{
	mx -= Left();
	MenuBarItem *menu = menuitems;
	int sel = 0;
	while (!menu->terminator)	{
		if (mx >= menu->x1 && mx <= menu->x2)	{
			if (selection != sel || !ispoppeddown)	{
				if (ispoppeddown)	{
					PopDown *pd = menuitems[selection].popdown;
					if (pd->isOpen())
						pd->CloseMenu(False);
				}
				Select(sel);
			}
			return;
		}
		sel++;
		menu++;
	}
	if (selection == -1)
		SetSelection(0);
}

void MenuBar::SetSelection(int sel)
{
	selection = sel;
	Paint();
}

void MenuBar::Select(int sel)	{
	selection = sel;
	Select();
}

void MenuBar::Select()
{
	Paint();
	ispoppeddown = True;
	MenuBarItem &mb = *(menuitems+selection);
	int lf = Left() + mb.x1;
	int tp = Top()+1;
	if (mb.menuprep != NULL)
		(*mb.menuprep)();
	mb.popdown->OpenMenu(lf, tp);
}

Bool MenuBar::AcceleratorKey(int key)
{
	MenuBarItem *menu = menuitems;
	while (!menu->terminator)	{
		PopDown *pd = menu->popdown;
		if (pd->AcceleratorKey(key))
			return True;
		menu++;
	}
	return False;
}

Bool MenuBar::ShortCutKey(int key)
{
	int altkey = desktop.keyboard().AltConvert(key);
	MenuBarItem *menu = menuitems;
	int sel = 0;
	while (!menu->terminator)	{
		int off = menu->title->FindChar(SHORTCUTCHAR);
		if (off != -1)	{
			String &cp = *(menu->title);
			int c = cp[off+1];
			if (tolower(c) == altkey)	{
				SetFocus();
				Select(sel);
				return True;
			}
		}
		sel++;
		menu++;
	}
	return False;
}

void MenuBar::Keyboard(int key)
{
	if (AcceleratorKey(key))
		return;
	if (!ispoppeddown && ShortCutKey(key))
		return;
	switch (key)	{
		case F10:
			if (ispoppeddown)
				break;
			if (this != desktop.InFocus())	{
				if (selection == -1)
					selection = 0;
				SetFocus();
				break;
			}
			// ------ fall through
		case ESC:
			ispoppeddown = False;
			SetSelection(-1);
			if (oldfocus != NULL)
				oldfocus->SetFocus();
			else
				parent->SetFocus();
			break;
		case FWD:
			selection++;
			if (selection == menucount)
				selection = 0;
			if (ispoppeddown)
				Select();
			else
				Paint();
			break;
		case BS:
			if (selection == 0)
				selection = menucount;
			--selection;
			if (ispoppeddown)
				Select();
			else
				Paint();
			break;
		case '\r':
			if (selection != -1)
				Select();
			break;
		case ALT_F6:
			TextBox::Keyboard(key);
			break;
		default:
			break;
	}
}

void MenuBar::ParentSized(int xdif, int)
{
	Size(Right()+xdif, Bottom());
}


