// ---------- paint.cpp

#include "desktop.h"
#include "dfwindow.h"

void DFWindow::PaintOverLappers()
{
	Rect src = ShadowedRect();
	DFWindow *Wnd = parent->first;
	while (Wnd != NULL)	{
		if (Wnd->visible && Wnd != this)	{
			Rect rc = Wnd->ShadowedRect();
			rc = rc.subRectangle(src);
			if (rc.ValidRectangle())	{
				Wnd->clipoverride = True;
				Wnd->Show();
				Wnd->clipoverride = False;
			}
		}
		Wnd = Wnd->next;
	}
}

void DFWindow::ClearWindow()
{
	String ln(ClientWidth(), clearch);

	int h = ClientHeight();
	for (int y = 0; y < h; y++)
		WriteClientString(ln, 0, y, colors.fg, colors.bg);
}

void DFWindow::Paint(Rect rc)
{
	if (visible)	{
		String ln(rc.Width(), clearch);
		int x = rc.Left()-ClientLeft();
		int y = rc.Top()-ClientTop();
		clipoverride = True;
		for (int i = 0; i < rc.Height(); i++)
			WriteClientString(ln, x, y+i, colors.fg, colors.bg);
		clipoverride = False;
	}
}

void DFWindow::Paint()
{
	if (visible)
		ClearWindow();
}

static Bool ClipRectangle(Rect &rc, String &ln, int x, int y)
{
	if (y < rc.Top() || y > rc.Bottom())
		return True;
	if (x + ln.Strlen() <= rc.Left())
		return True;
	if (x > rc.Right())
		return True;
	if (x < rc.Left())	{
		ln = ln.left(rc.Left() - x);
		x = rc.Left();
	}
	int len = ln.Strlen();
	if (x+len-1 > rc.Right())
		ln[rc.Right()-x+1] = '\0';
	return False;
}

static Bool ClipChar(Rect &rc, int x, int y)
{
	if (y < rc.Top() || y > rc.Bottom())
		return True;
	if (x < rc.Left() || x > rc.Right())
		return True;
	return False;
}

Bool DFWindow::ClipParent(int &x, int y, String *ln = NULL)
{
	if (!(attrib & NOCLIP))	{
		DFWindow *Wnd = parent;
		Rect rc;
		if (attrib & FRAMEWND)
			rc = Wnd->rect;
		else
			rc = Wnd->ClientRect();
		while (Wnd != NULL)	{
			if (ln != NULL)	{
				if (ClipRectangle(rc, *ln, x, y))
					return True;
			}
			else
				if (ClipChar(rc, x, y))
					return True;
			if ((Wnd = Wnd->parent) != NULL)
				rc = Wnd->ClientRect();
		}
	}
	return False;
}

void DFWindow::WriteString(String &ln, int x, int y, Rect &rc, int fg, int bg)
{
	if (this == desktop.InFocus() || clipoverride)	{
		if (!ClipRectangle(rc, ln, x, y))
			if (!ClipParent(x, y, &ln))
				desktop.screen().WriteVideoString(ln, x, y, fg, bg);
	}
	else 	{
		char *cp = ln;
		while (*cp)
			WriteChar(*cp++, x++, y, rc, fg, bg);
	}
}

void DFWindow::WriteChar(int ch, int x, int y, Rect &rc, int fg, int bg)
{
	if (this != desktop.InFocus() && !clipoverride)
		if (this != inWindow(x, y, fg, bg))
			return;
	if (ClipChar(rc, x, y))
		return;
	if (ClipParent(x, y))
		return;
	desktop.screen().PutVideoChar(x, y, (ch & 255) | (clr(fg,bg) << 8));
}

inline Bool inShadow(Rect &rc, int x, int y)
{
	return (Bool)
	(((x == rc.Right()+1) && (y > rc.Top() && y < rc.Bottom()+2))
							||
	((y == rc.Bottom()+1) && (x > rc.Left() && x < rc.Right()+2)));
}

// ---- find the window that coordinates are in
DFWindow *inWindow(int x, int y, int &fg, int &bg)
{
	DFWindow *Hit = NULL;
	DFWindow *Wnd = desktop.ApplWnd();
	while (Wnd != NULL)	{
		if (Wnd->visible)	{
			Rect rc = Wnd->VisibleRect();
			if (rc.Inside(x, y))	{
				Hit = Wnd;
				Wnd = Wnd->last;
				continue;
			}
			// --- in case the char is writing under a shadow
			if ((fg || bg) && (Wnd->attrib & SHADOW))	{
				if (rc.Right() == Wnd->rect.Right() ||
						rc.Bottom() == Wnd->rect.Bottom())	{
					if (inShadow(rc, x, y))	{
						fg = ShadowFG;
						bg = ShadowBG;
					}
				}
			}
		}
		Wnd = Wnd->prev;
	}
	return Hit;
}

Rect &DFWindow::VisibleRect()
{
	static Rect rc;
	rc = rect;
	if (!(attrib & NOCLIP))	{
		DFWindow *Wnd = parent;
		Rect prc;
		if (attrib & FRAMEWND)
			prc = Wnd->rect;
		else
			prc = Wnd->ClientRect();
		while (Wnd != NULL)	{
			if (Wnd->attrib & NOCLIP)
				break;
			rc = rc.subRectangle(prc);
			if (!rc.ValidRectangle())
				break;
			if ((Wnd = Wnd->parent) != NULL)
				prc = Wnd->ClientRect();
		}
	}
	return rc;
}



