// ----------- timer.h

#ifndef TIMER_H
#define TIMER_H

#include "dflatdef.h"

const int TIMER = 8;		// timer interrupt vector
const int MAXTIMERS = 5;	// maximum timers at one time

class Timer	{
	int timer;
	static Timer *timers[MAXTIMERS];
	static int timerct;
#ifdef MSC
	static void (interrupt *OldTimer)(INTERRUPTARGS);
#else
	static void interrupt (*OldTimer)(INTERRUPTARGS);
#endif
	friend void interrupt NewTimer(INTERRUPTARGS);
public:
	Timer();
	~Timer();
	Bool TimedOut()			 { return (Bool) (timer == 0); }
	void SetTimer(int ticks) { timer = ticks; }
	void DisableTimer() 	 { timer = -1; }
	Bool TimerRunning() 	 { return (Bool) (timer > 0); }
	void Countdown() 		 { --timer; }
	Bool TimerDisabled() 	 { return (Bool) (timer == -1); }
};

#endif


