;; DIGPLAY.ASM			August 15, 1991, John W. Ratciff
;;
;; This piece of source provides C procedure call hooks down into
;; the resident TSR sound driver.  Use the call CheckIn to find out
;; if the sound driver is in memory.  See the C header file DIGPLAY.H
;; for prototype information.
;;
;; This file is in the format for Turbo Assembler's IDEAL mode.  The
;; IDEAL mode syntax makes a lot more sense for 8086 than the old
;; MASM format.  MASM has recently been updated to provide some of the
;; functions that Turbo Assembler has had for a number of years.  I prefer
;; to consider Turbo Assembler the standard for 8086 assemblers.
;; IDEAL mode functionality includes true local labels, real data structures,
;; typecasting, automatic argument passing and local memory.
;; Converting any of this code into MASM format is an exercise left for
;; the student.


	LOCALS			;; Enable local labels

        IDEAL                   ;; Use Turbo Assembler's IDEAL mode
	JUMPS

        INCLUDE "PROLOGUE.MAC"          ;; common prologue

SMALL_MODEL	equ	0	; True if wanting to assemble near procs.

SEGMENT  _TEXT BYTE PUBLIC 'CODE'               ;; Set up _TEXT segment
        ENDS

	ASSUME	CS: _TEXT, DS: _TEXT, SS: NOTHING, ES: NOTHING

SEGMENT _TEXT

Macro	CPROC	name		; Macro to establish a C callable procedure.
	public	_&name
IF	SMALL_MODEL
Proc	_&name	near
ELSE
Proc	_&name	far
ENDIF
	endm

;;	int  DigPlay(SNDSTRUC far *sndplay);	     // 688h -> Play 8 bit digitized sound.
CPROC	DigPlay
	ARG	DATA:DWORD
	PENTER	0
	push	ds
	push	si

	call	CheckIn        ; Is sound driver in memory?
	or	ax,ax		; no-> don't invoke interupt...
	jz	@@EXT		;
	mov	ax,0688h	; Function #1, DigPlay
	lds	si,[DATA]	; Data structure.
	int	66h		; Do sound interupt.
	mov	ax,1		; Return sound played.
@@EXT:
	pop	si
	pop	ds
	PLEAVE
	ret
	endp

;;	int  SoundStatus(void); 					 // 689h -> Report sound driver status.
CPROC	SoundStatus
	mov	ax,0689h	; Check sound status.
	int	66h		; Sound driver interrupt.
	ret
	endp

;;	void MassageAudio(SNDSTRUC far *sndplay);// 68Ah -> Preformat 8 bit digitized sound.
CPROC	MassageAudio
	ARG	DATA:DWORD
	PENTER	0
	push	ds
	push	si

	mov	ax,068Ah	; Identity
	lds	si,[DATA]	; Data structure.
	int	66h		; Do sound interupt.

	pop	si
	pop	ds
	PLEAVE
	ret
	endp

;;	int  DigPlay2(SNDSTRUC far *sndplay);  // 68Bh -> Play preformatted data.
CPROC	DigPlay2
	ARG	DATA:DWORD
	PENTER	0
	push	ds
	push	si

	mov	ax,068Bh	; Identity
	lds	si,[DATA]	; Data structure.
	int	66h		; Do sound interupt.

	pop	si
	pop	ds
	PLEAVE
	ret
	endp

;;	int  AudioCapabilities(void);		 // 68Ch -> Report audio driver capabilities.
CPROC	AudioCapabilities
	mov	ax,068Ch	; Check sound status.
	int	66h
	ret
	endp

;;	int  ReportSample(void);					 // 68Dh -> Report current sample address.
CPROC	ReportSample
	mov	ax,068Dh	; Report audio sample.
	int	66h
	ret
	endp

;; void SetCallBackAddress(void far *proc); // 68Eh -> Set procedure callback address.
CPROC	SetCallBackAddress
	ARG	COFF:WORD,CSEG:WORD
	PENTER	0

	mov	bx,[COFF]
	mov	dx,[CSEG]
	mov	ax,68Eh
	int	66h

	PLEAVE
	ret
	endp

;; void StopSound(void);    // 68Fh -> Stop current sound from playing.
CPROC	StopSound
	mov	ax,68Fh
	int	66h
	ret
	endp

CPROC	ReportCallbackAddress
	mov	ax,691h
	int	66h
	ret
	endp

CPROC	WaitSound
@@WS:	mov	ax,689h
	int	66h
	or	ax,ax
	jnz	@@WS
	ret
	endp

;;	int  CheckIn(void);							 // Is sound driver available?
CPROC	CheckIn
	call	CheckIn
	ret
	endp

Proc	CheckIn near
	push	ds		; Save ds register.
	push	si

	mov	si,66h*4h	; get vector number
        xor     ax,ax           ; zero
        mov     ds,ax           ; point it there
	lds	si,[ds:si]	; get address of interupt vector
        or      si,si           ; zero?
        jz      @@CIOUT         ; exit if zero
        sub     si,6            ; point back to identifier

	cmp	[word si],'IM'  ; Midi driver?
	jne	@@NEX
	cmp	[word si+2],'ID'  ; full midi driver identity string?
	jne	@@NEX
;; Ok, a MIDI driver is loaded at this address.
	mov	ax,701h 	; Digitized Sound capabilities request.
	int	66h		; Request.
	or	ax,ax		; digitized sound driver available?
	jnz	@@OK		; yes, report that to the caller.
	jz	@@CIOUT 	; exit, sound driver not available.
@@NEX:
	cmp	[word si],454Bh ; equal?
        jne     @@CIOUT         ; exit if not equal
	cmp	[word si+2],4E52h    ; equal?
        jne     @@CIOUT
@@OK:	mov	ax,1
@@EXT:
	pop	si
	pop	ds
	ret
@@CIOUT: xor	ax,ax		; Zero return code.
	jmp short @@EXT
	endp


	ends
	end
