; *************************************************************************************************
; *
; *	Title:	NE2000.INC
; *	Copyright (c) October 1992, Ryu Consulting
; *	Written by Rahner James
; *
; *	This file contains the functions to support low-level NE2000 access
; *
; *	Notes:
; *		NIC = Network Interface Controller
; *
; *************************************************************************************************

	.286			; Let's let the 8086 die, OK?
	.model	small,c

; *************************************************************************************************
; *
; *					General Equates
; *
; *************************************************************************************************

MAX_XMIT_RETRIES	equ	16		; Maximum number of retransmission retries

READ_PRIORITY		equ	3
WRITE_PRIORITY		equ	5
REPEAT_PRIORITY	equ	0		; Lowest priority, repeats continuously

IPX_HEADER_SIZE	equ	30		; Size of an IPX header


; *************************************************************************************************
; *
; *					Memory Flags
; *
; *************************************************************************************************

MEM_FREE		equ	0		; The memory block is free to be allocated
MEM_ALLOC		equ	(1 shl 0)	; The block is allocated
MEM_RECEIVE		equ	(1 shl 1)	; Memory block is being used for reception
MEM_TRANSMIT		equ	(1 shl 2)	; Memory block used to transmit


; *************************************************************************************************
; *
; *					ECB Flags
; *
; *************************************************************************************************

ECB_OWNER_DRIVER	equ	0		; ECB is owned by the driver
ECB_OWNER_APP		equ	1		; ECB is owned by the application
ECB_FREE_XMIT		equ	(1 shl 1)	; ECB memory is to be freed once transmitted


; *************************************************************************************************
; *
; *					In Use Flags
; *
; *************************************************************************************************

IU_DONE		equ	0		; Indicates that the ECB has been processed and completion code is valid
IU_HOLDING		equ	0FBh		; Send/receive has occurred, but ECB is in holding queue waiting to be processed
IU_SCHEDULED		equ	0FDh		; Event has been scheduled and is waiting for time-out
IU_LISTENING		equ	0FEh		; IPX is listening for incoming packets at a socket
IU_SENDING		equ	0FFh		; ECB is being sent or in the process of being sent
IU_PROCESSING		equ	0FAh		; ECB is being processed by IPX
IU_WAITING		equ	0F8h		; ECB has been put in a waiting queue because IPX was busy


; *************************************************************************************************
; *
; *					Completion Codes
; *
; *************************************************************************************************

CC_SUCCESS		equ	0		; The packet has been sent successfully
CC_CANCELLED		equ	0FCh		; Send request for this ECB has been cancelled, just like Twin Peaks
CC_CHALLEDGED		equ	0FDh		; Packet was malformed (eg. IPX packet <30 bytes, SPX<42 bytes, packet > 576 bytes)
CC_UNDELIVERED		equ	0FEh		; Packet couldn't be sent, no listener available
CC_FAILURE		equ	0FFh		; Network was physically unable to deliver the packet

; *
; * Additional completion codes for reception ECBs
; *

CC_OVERFLOW		equ	0FDh		; The size of the fragment received is either 0 or too large (>576 bytes)
CC_CLOSED		equ	0FFh		; The reception socket was not open

; *
; * Additional completion codes for cancellation of an ECB
; *

CC_CANCEL_FAIL		equ	0F9h		; The ECB could not be cancelled


; *************************************************************************************************
; *
; *					Register Definitions
; *
; *************************************************************************************************

; *
; * Base + 0: Command Register (R/W)
; *
STOP			equ	(1 shl 0)	; Software reset, takes controller off-line
START			equ	(1 shl 1)	; Activate the NIC
XMIT_PACKET		equ	(1 shl 2)	; Initiates the transmission of the packet
REMOTE_READ		equ	(1 shl 3)	; Read data from the remote source
REMOTE_WRITE		equ	(1 shl 4)	; Write data to the DMA
SEND_PACKET		equ	(3 shl 3)	; Send a packet to the remote
ABORT			equ	(1 shl 5)	; Stops or finishes the current DMA operation
PAGE0			equ	(0 shl 6)	; Activate register page 0, controls, status and the like
PAGE1			equ	(1 shl 6)	; Activate register page 1, network ID, multicast, et al
PAGE2			equ	(1 shl 7)	; Activate register page 2, address assignments

; *
; * Base + 4: Transmit Status Register (R)
; *
PACKET_TRANSMITTED	equ	(1 shl 0)	; Transmission occurred without error
TRANSMIT_COLLIDED	equ	(1 shl 2)	; Indicates that the packet collided at least once with another station
TRANSMIT_ABORTED	equ	(1 shl 3)	; Aborted transmission because of excessive collisions
CARRIER_SENSE_LOST	equ	(1 shl 4)	; Carrier lost during transmission of packet
FIFO_UNDERRUN		equ	(1 shl 5)	; NIC could not gain access to the bus before the FIFO emptied
CD_HEARTBEAT		equ	(1 shl 6)	; Transceiver failed to transmit a collision signal after transmission of a packet
OUT_OF_WINDOW_COLLISON	equ	(1 shl 7)	; Collision occurred after a slot time (51.2 usec)

; *
; * Base + 7: Interrupt Status Register (R/W)
; * Base + 0Fh: Interrupt Mask Register (W)
; *
PACKET_RECEIVED	equ	(1 shl 0)	; Indicates that a packet was received with no errors
PACKET_XMITTED		equ	(1 shl 1)	; Indicates that a packet was transmitted with no errors
RECEIVE_ERROR		equ	(1 shl 2)	; Packet received with one or more errors (CRC, Alignment, Overrun, Missed)
XMIT_ERROR		equ	(1 shl 3)	; Packet transmitted with one or more errors (Excessive Collisions, FIFO Underrun)
OVERWRITE_WARNING	equ	(1 shl 4)	; No more receive buffers are available, lost data imminent
COUNTER_OVERFLOW	equ	(1 shl 5)	; MSB of one or more of the Network Tally Counters has been set
REMOTE_DMA_COMPLETE	equ	(1 shl 6)	; Set when Remote DMA operation has been completed
RESET_STATUS		equ	(1 shl 7)	; NIC has been reset (can't be used for on Mask Register)

; *
; * Base + 0Ch: Receive Status Register (R)
; *
PACKET_RECEIVED_INTACT	equ	(1 shl 0)	; Indicates that the packet was received A-OK, bits 1-4 are 0
CRC_ERROR		equ	(1 shl 1)	; Packet was received with a CRC error
FRAME_ALLIGNMENT_ERROR	equ	(1 shl 2)	; Incoming packet did not end on a byte boundary
FIFO_OVERRUN		equ	(1 shl 3)	; FIFO not serviced in time, reception aborted
MISSED_PACKET		equ	(1 shl 4)	; No receive buffers were available for an incoming packet
MULTICAST_BROADCAST	equ	(1 shl 5)	; Set if the incoming packet had a multicast or broadcast match
RECEIVER_DISABLED	equ	(1 shl 6)	; Set whenever Monitor Mode is entered
DEFERRING		equ	(1 shl 7)	; Set when CRS or COL inputs are active.  If NIC asserted CD line because of
						; jabber, this bit will stay set

; *
; * Base + 0Ch: Receive Configuration Register (W)
; *
SAVE_BAD_PACKETS	equ	(1 shl 0)	; 0:packets with errors are discarded, 1:error packets are saved
ACCEPT_RUNT_PACKETS	equ	(1 shl 1)	; 0:runts are discarded, 1:packets with < 64 bytes are accepted as one of us
ACCEPT_BROADCAST	equ	(1 shl 2)	; 0:broadcasts are ignored, 1:broadcasts accepted
ACCEPT_MULTICAST	equ	(1 shl 3)	; 0:multicast address not checked, 1:multicast address checked
SLUT			equ	(1 shl 4)	; 0:physical address must match PAR0-PAR5, 1:accepts all packets
MONITOR_MODE		equ	(1 shl 5)	; 0:accepted packets are buffered, 1:packets are checked and ACKed but not saved

; *
; * Base + 0Dh: Transmit Configuration Register (W)
; *
INHIBIT_CRC		equ	(1 shl 0)	; 0:CRC appended by transmitter, 1:CRC inhibited
NO_LOOPBACK		equ	(0 shl 1)	; No loopback test performed, used with LOOPBACK of Configuration Register
INTERNAL_LOOPBACK	equ	(1 shl 1)	; Internal loopback test, mode 1
EXTERNAL_LOOPBACK1	equ	(1 shl 2)	; External loopback test, mode 2
EXTERNAL_LOOPBACK2	equ	(3 shl 1)	; External loopback test, mode 3
AUTOTRANSMIT		equ	(1 shl 3)	; Allows another station to disable the NIC's transmitter
COLLISION_OFFSET	equ	(1 shl 4)	; 0:collision backup uses normal algorthm, 1:shortens the delay for 1st 3 times

; *
; * Base + 0Eh: Configuration Register (W)
; *
WORD_TRANSFER		equ	(1 shl 0)	; 0:byte wide DMA transfers, 1:word wide DMA transfers
BYTE_ORDER		equ	(1 shl 1)	; 0:Intel, 1:Motorola
LONG_ADDRESS		equ	(1 shl 2)	; 0:dual 16-bit DMA mode, 1:single 32-bit DMA mode
LOOPBACK		equ	(1 shl 3)	; 0:loopback mode selected, 1:NOT!
AUTOINITIALIZE		equ	(1 shl 4)	; 0:all packets removed from Buffer Ring under program control
						; 1:send command executed, remote DMA autoinitialized to remove packets from Ring
FIFO_THRESHOLD1	equ	(0 shl 5)	; Receive threshold for FIFO is 1 word or 2 bytes
FIFO_THRESHOLD2	equ	(1 shl 5)	; Receive threshold for FIFO is 2 words or 4 bytes
FIFO_THRESHOLD4	equ	(1 shl 6)	; Receive threshold for FIFO is 4 words or 8 bytes
FIFO_THRESHOLD6	equ	(3 shl 5)	; Receive threshold for FIFO is 6 words or 12 bytes


; *************************************************************************************************
; *
; *					Structures
; *
; *************************************************************************************************

NIC_S struct
	command		db	?	; Command Register
	page_start	db	?	; Page Start Register			+ 1
	page_stop	db	?	; Page Stop Register			+ 2
	boundary_ptr	db	?	; Boundary Pointer Register		+ 3
	xmit_page_start	db	?	; Transmit Page Start Address		+ 4
	xmit_count	dw	?	; Transmit Byte Count 0 & 1 Registers	+ 5
	int_status	db	?	; Interrupt Status Register		+ 7
	remote_start	dw	?	; Remote Start Address 0 & 1 Registers	+ 8
	remote_count	dw	?	; Remote Byte Count 0 & 1 Registers	+ A
	recv_config	db	?	; Receive Configuration Register	+ C
	xmit_config	db	?	; Transmit Configuration Register	+ D
	data_config	db	?	; Data Configuration Register		+ E
	int_mask	db	?	; Interrupt Mask Register		+ F
	data_port	dw	?	; Data I/O port				+ 10h
			db	13 dup(?)
	reset		db	?	; Reset port (read)			+ 1Fh
NIC_S ends


NIC_ECB_S struct
	next		dw	?	; -> next ECB in this list					(00)
	flags		dw	?	; General flags used by the drivers				(02)
	esr		dd	?	; -> function to call when this packet is processed		(04)
	in_use		db	?	; Contains the current usage value				(08)
	completion	db	?	; Contains the completion code					(09)
	node		db	6 dup(?); Destination or source ID for the packet for the NIC		(0A)
	NIC_length	dw	?	; Length gotten from or given to NIC, not including this and above (10)

; *
; * The IPX (or whatever) structure follows:
; *
	checksum	dw	?	; Checksum of the entire packet (Moto)				(12)
	ipx_length	dw	?	; Length of the entire packet, including the IPX header (Moto)	(14)
	transport	db	?	; Transport control						(16)
	packet_type	db	?	; Packet type, 4=IPX, 5=SPX					(17)
	dest_network	dd	?	; Destination network number (Moto)				(18)
	dest_node	db	6 dup(?); Destination node						(1C)
	dest_socket	dw	?	; Destination socket (Moto)					(22)
	src_network	dd	?	; Source network number (Moto)					(24)
	src_node	db	6 dup(?); Source node							(28)
	src_socket	dw	?	; Source socket (Moto)						(2E)

; *
; * SPX portion starts here
; *
	connect_control	db	?	; Connection control field					(30)
	datastream_type	db	?	; Datastream type						(31)
	src_connection	dw	?	; Source connection ID (Moto					(32)
	dest_connection	dw	?	; Destination connection ID (Moto)				(34)
	sequence	dw	?	; Sequence number (Moto)					(36)
	ack_number	dw	?	; Acknowledge number (Moto)					(38)
	alloc_number	dw	?	; Allocation number (Moto)					(3A)
NIC_ECB_S ends


PACKET_HEADER_S struct	; This MUST be an even size
	status		db	?	; Receive status						(00)
	next_packet	db	?	; Next packet pointer for the NIC's internal buffer		(01)
	count		dw	?	; Receive byte count (Intel)					(02)
	destination	db	6 dup(?); Destination node ID						(04)
	source		db	6 dup(?); Source node ID						(0A)
	xmit_length	dw	?	; Number of bytes intended to be transmitted (Moto)		(10)
PACKET_HEADER_S ends


MCB_S struct		; Memory Control Block, one paragraph before any allocated memory block
	next		dw	?	; Segment number of the next memory chunk, 0 is end of the line
	prev		dw	?	; Segment number of the previous memory chunk, 0 is beginning of the line
	msize		dw	?	; Size of this chunk of memory, in paragraphs
	flags		dw	?	; Flags used to indicate the type of memory block
	under_chunk	dw	?	; Segment number of the chunk that physically precedes this one, 0 means we are the 1st
MCB_S ends


TASK_S struct
	next		dd	?
	prev		dd	?
	priority	db	?	; Task priority (255 = highest, 0=lowest)
	status		db	?	; Current status of the task, <=0 = done with return code, 1 in list, 2 processing
	function	dd	?	; Function to call, near call for now, called with ptr to TASK_T in DX:AX
	buffer		dd	?	; -> buffer to send to the function
TASK_S ends


DELAY	macro
	jmp	short $+2
	endm

