/**************************************************************************************************
*
*		Title:	SNOOP.C
*		Copyright (c) October 1992, Ryu Consulting
*		Written by Rahner James - that spunky guy
*
*		This file contains the main entry and looping functions
*
**************************************************************************************************/

#define		_SNOOP_C_
#include	"snoop.h"


/**************************************************************************************************
*
*	Global Data Items
*
*	Note:
*		All variables that have global accessibility have the first letters of each whole
*		word within their name capitalized.
*		All variable names (local or global) begin with a noun or a word that is a noun by
*		context.
*
**************************************************************************************************/

/*
** Names of the type of packets that will be passed
*/
uc *Type_Names[] =
{
	"Unknown Type, maybe IPX",	// 00 - anything, but probably IPX
	"Routing Info",				// 01 - Routing information packet
	"Echo Packet",				// 02 - Hello, hello, hello ...
	"Error Packet",				// 03 - Never saw one
	"IPX",						// 04 - IPX packet
	"SPX",						// 05 - SPX packet
	"unknown",					// 06
	"unknown",					// 07
	"unknown",					// 08
	"unknown",					// 09
	"unknown",					// 10
	"unknown",					// 11
	"unknown",					// 12
	"unknown",					// 13
	"unknown",					// 14
	"unknown",					// 15
	"unknown",					// 16
	"NCP"						// 17 - Netware Core Protocol packet
};

int 	Match_ID_Count = 0;		// Number of ID in the match array that follows
uc		Match_IDs[20][6];		// Storage for the arrays we have to match
int		Match_Socket_Count = 0;	// Number of sockets in the socket match array
us		Match_Socket[20];		// Sockets we have to match
int		Handle = -1;			// Handle for the loggin file
int		Full_Display = 1;		// !0 if we want to see the entire packet
char	And_Flag = 1;			// 0 = socket or ID, !0 = socket and ID
char	Broadcast_Flag = 1;		// 0 = check broadcasts, !0 = no checking on broadcasts


/**************************************************************************************************
*
*	void PARSE_LINE( int ARGC, char *ARGV[] )
*	Parses the command line
*
*	Given:
*		ARGC = number of command line tokens
*		ARGV -> array of pointers to the command line tokens
*
*	Returns:
*		Command line parsed and variables updated
*
**************************************************************************************************/
void parse_line( int argc, char *argv[] )
{
	int		i,j;

	farset( NE2000_Address, 0, 6 );
	for ( i=1 ; i < argc ; ++i )
	{
		if ( (*argv[i] == '/') || (*argv[i] == '\\') || (*argv[i] == '-') )
			++*argv[i];
		switch ( *argv[i] )
		{
			case 'A':		// Catch all packets
			case 'a':
				NIC_Normal_Recv_Config |= SLUT;
				break;

			case 'B':		// Check broadcast as well
			case 'b':
				Broadcast_Flag = 0;
				break;

			case 'C':		// AND flag
			case 'c':
				And_Flag = 1;
				break;

			case 'D':		// OR flag
			case 'd':
				And_Flag = 0;
				break;

			case 'F':		// File to output the packet to
			case 'f':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				print( "\fOpening file %s ...", argv[i] );
				Handle = dos_open( argv[i], OPEN_RW+OPEN_CREATE );
				print( "\nReturn = %d", Handle );
				if ( Handle < 0 )
					exit( 2 );
				dos_write( Handle, &i, 0 );
				break;

			case 'I':		// Match ID
			case 'i':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				atoaddr( Match_IDs[Match_ID_Count++], argv[i] );
				break;

			case 'N':		// Set current node ID
			case 'n':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				if ( strlen(argv[i]) == 12 )
					atoaddr( NE2000_Address, argv[i] );
				break;

			case 'P':		// Base port
			case 'p':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				j = atoh( argv[i] );
				if ( (j >= 0x200) && (j <= 0x360) )
					Base_Port = j;
				break;

			case 'R':		// IRQ number
			case 'r':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				j = atoi( argv[i] );
				if ( (j > 1) && (j < 16) )
					IRQ_Number = j;
				break;

			case 'S':		// Match socket
			case 's':
				++argv[i];
				if ( (*argv[i] == '=') || (*argv[i] == ' ') )
					++argv[i];
				Match_Socket[Match_Socket_Count++] = atoh( argv[i] );
				break;

			case '?':
				print(	"\n\nCommand lin syntax is:"
						"\n\ttest [option 1] [option 2] ... [option n]" );
				print(	"\n\nCommand line options:"
						"\n\tA         - accept all packets"
						"\n\tB         - accept broadcast packets (use with I option)"
						"\n\tC         - accept only correct IDs and sockets"
						"\n\tD         - accept only correct IDs or sockets"
						"\n\tFxxxxxxxx - name of output file for data logging"
						"\n\tI######## - node ID to accept data for"
						"\n\tN######## - set our packet ID as this number"
						"\n\tP###      - set base port address (in hex)"
						"\n\tR##       - IRQ number (in decimal)"
						"\n\tS####     - socket number to accept data for (in hex)"
						"\n" );
				exit( 0 );
				break;

			default:
				break;
		}
	}
}


/**************************************************************************************************
*
*	int DISPLAY_PACKET( NIC_ECB_T FAR *NP )
*	Displays the contents of a packet
*
*	Given:
*		NP -> reception packet
*
*	Returns:
*		0 if nothing going on, !0 if exit program
*
**************************************************************************************************/
int display_packet( NIC_ECB_T FAR *np )
{
	int			y, i, j;
	char FAR	*cp;
	static char	first_time = 1;

	if ( first_time )
	{
		clear_line( 0, BLUE + (WHITE BACKGROUND) );
		clear_line( 1, (INTENSE WHITE)+(CYAN BACKGROUND) );
		center( "IPX and NIC Header Information", 1, (INTENSE WHITE)+(CYAN BACKGROUND) );
		print( "%p%r[            ]", 34,0 );
		print( "%p%rTransport:%pType:", 2,2, 26,2 );
		print( "%p%rIPX Length:%pSrc:", 2,3, 26,3 );
		print( "%p%rNIC Length:%pDest:", 2,4, 26,4 );
		first_time = 0;
		no_cursor();
	}
	print( "%p%r%ld packets%pUnread =%4d", 2,0, Total_Recv_Packets, 67,0,Total_Unread_Buffers );
	show_node_address( 35,0, np->node );
	if ( Full_Display == 0 )
		return 0;

	show_net_address( 32,3,	&np->src_network );
	show_net_address( 32,4,	&np->dest_network );

	clear_area( 36,2, _Screen_Width-1,2, 0 );
	print( "%p%r%4d%p%4d%p%2X%p%d - %s",	14,3,	np->ipx_length,
											14,4,	np->NIC_length,
											16,2,	np->transport,
											32,2,	np->packet_type,
													np->packet_type > 17 ? "unknown" : Type_Names[np->packet_type] );
	switch ( np->src_socket )
	{
		case 0x451:
			print( " (File Service)" );
			break;

		case 0x452:
			print( " (SAP)" );
			break;

		case 0x453:
			print( " (Route Information)" );
			break;

		case 0x455:
			print( " (NetBIOS Packet)" );
			break;

		case 0x456:
			print( " (Diagnostic Packet)" );
			break;

		default:
			break;
	}
	show_packet_body( &np[1], np->ipx_length, np->NIC_length );

	return 0;
}


/**************************************************************************************************
*
*	int INIT_SNOOPER( int ARGC, char *ARGV[] )
*	Initializes this snooper program's internals and the display
*
*	Given:
*		ARGC = number of command line tokens
*		ARGV -> array of pointers to the command line tokens
*
*	Returns:
*		0 if all went well; otherwise an exit code
*
**************************************************************************************************/
int init_snooper( int argc, char *argv[] )
{
	int	i;

	print(	"\fEthernet Snooper for NE-2000 Compatible Adapters on Netware, version 1.00"
			"\nCopyright (c) September 1992, Ryu Consulting, 916/722-1939"
			"\nWritten by Rahner James\n" );
	if ( is_ipx() )
	{
		print( "\nIPX is currently installed, please remove it" );
		beep();
		return 1;
	}
	if ( argc > 1 )
		parse_line( argc, argv );
	print( "\nReturn from initialization of memory pool = %d", init_memory() );
	print( "\nReturn from initialization of NE2000 = %d", i=init_ne2000() );
	if ( i )
		return 2;
	clear_screen( (INTENSE WHITE)+(BLUE BACKGROUND) );
	clear_line( 5, (INTENSE WHITE)+(CYAN BACKGROUND) );
	center( "IPX Packet Data Display", 5, (INTENSE WHITE)+(CYAN BACKGROUND) );
	clear_area( 0,6, _Screen_Width-1,_Screen_Height-1, (INTENSE WHITE)+(GREEN BACKGROUND) );
	print( "%p%rEthernet Snooper, version 1.00, waiting for first packet\n%58c", 2,0, 0xc4 );

	return 0;
}


/**************************************************************************************************
*
*	int MAIN( int ARGC, char *ARGV[] )
*	Initial entry point into this program
*
*	Given:
*		ARGC = number of command line tokens
*		ARGV -> array of pointers to the command line tokens
*
*	Returns:
*		Exit code
*
**************************************************************************************************/
main( int argc, char *argv[] )
{
	int		i,j, x,y, loop_flag = 1;
	ui		key;
	uc		FAR *cp;
	NIC_ECB_T	FAR *np;

/*
** First, set everthing up
*/
	if ( i=init_snooper(argc,argv) )
		return i;

/*
** Now, loop waiting for packets or a keystroke
*/
	while ( loop_flag )
	{
		do_next_task();
		if ( kbhit() )
		{
			if ( charin() == ESC )
				loop_flag = 0;
		}
		if ( Total_Unread_Buffers )
		{
			if ( (np = read_packet()) == NULL )
			{
				print( "%p%a\nGot a packet but no data", 0,_Screen_Height-1, WHITE );
				beep();
				break;
			}
			if ( is_packet_valid(np) )
			{
				display_packet( np );
				if ( Handle >= 0 )
					dos_write( Handle, np, np->NIC_length+0x12 );
			}
			free_NIC_ecb( np );
		} // if (Total_Unread_Buffers)
	} // while

/*
** Close everything up and go home
*/
	if ( Handle >= 0 )
		dos_close( Handle );
	print( "%p%a\n", 0,_Screen_Height-1, WHITE );
	clear_line( _Screen_Height-1, WHITE );
	print( "%p%aStopping ...\n", 0,_Screen_Height-1, WHITE );
	i = stop_ne2000_interrupts();
	stop_time_isr();
	print( "Return     = %d", i );
	print( "\nTotal interrupts received = %ld", Int_Count );

	show_cursor();
}

