/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: XPINCALL.H

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  These definitions are only used by the caller. If you are
  designing your own caller interface, this file has to be modified.

  Mac NOTE: These routines use the FSSpec mechanism to identify
  a file. The FSSpec is particular to System 7. Using these
  functions with versions before 7.0 requires switching from FSSpec
  to filename or vRefnum, directoryID identifiers. Using FSSpec's
  also means that you do not have to muck about with the current
  "Working Directory", so for previous versions the working directory
  has to be set and restored around every PINCall call. The stubs
  are there because DOS has to do it, so making the changes are
  fairly easy.

  We are also assuming Think C5.0 or above. The Mac specific
  include files were rearranged and renamed after version 5.0.
  Other than the names of include files, there is no Think or TCL
  specific code here, however.
  @End-Description.

*/
#ifndef	XPINCALL_H
#define	XPINCALL_H

#include "XCONFIG.h"
#include "XPINTYPE.h"		// simplified common data types
#include "XPINSHR.h"		// Common XPIN definitions

// The internal state of the plug-in in memory is maintained
// with these flags.

    struct	XPINstate {
	unsigned bad	: 1;	// Not a valid plug-in.
	unsigned valid	: 1;	// It's been validated
	unsigned open	: 1;	// Resource file is open.
	unsigned loaded	: 1;	// Loaded
	unsigned locked	: 1;	// Resource is loaded and locked
	};
typedef struct XPINstate XPINstate;

/*
  * The bookkeeping values for a single plug-in is stored in memory in
  * the XElement structure. This is a linked list and can get as large
  * as you want it. XPINMAX is an arbitrary maximum number of plug-ins.
  * It's there only as a backstop. When you call XPINInit, you tell
  * it the maximum number of plug-ins you want it to look for. If you
  * say -1, it goes until it finds all of the, or it runs out of memory.
  *
  * Macintosh NOTE: To make this code work with pre-system 7.0 code,
  * the FSSpec should be changed to vRefNum, dirID, fileName type
  * settings. Working directories should also be changed between calls
  * loading plug-ins. The FSSpec mechanism bypasses all that.
  */
struct	XElement {
		void			*next;			// Link to next item in list
		Ubyte		label[XPINLABEL+1];	// short label for description
		Ubyte		desc[XPINDESC+1];	// long description label
		XVersion		version;		// Internal Version number for the plug-in
		PathSpec		pathSpec;		// plug-in was loaded from this path/file
		LibSpec		pluginID;		// ID for plug-in file.
		XPINFunction 	code;		// Entry point for the code
		XPINstate		state;		// state of the plug-in.
		};
typedef struct XElement XElement;

// The big one. The caller keeps track of the plug-ins in this
// structure.
struct	XPIN {
		Uword	magic;			// magic PIN cookie
		Uword	version;			// version number of plug-in toolkit
		long		max;				// maximum number of plug-ins to load
		long		count;			// number of plug-ins loaded
		Lbuf		directory;			// where plug-ins are located
		FileSpec	fileType;			// File type for the plug-in.
		PathSpec	appPath;			// Application path setting.
		PathSpec	sysPath;			// System path setting.
		PathSpec	xpinPath;			// Path to the PIN directory
		XElement	*head;			// First item in list.
		XElement	*tail;			// Last item in list.
		};
typedef struct XPIN XPIN;

/*
  *  Function prototypes for publicly accessible glue functions
  */
XPINErr	XPINInit(XPIN *xpin, char *directory, FType fileType);
long		XPINCount(XPIN *xpin);
Ubyte	*XPINLabel(XPIN *xpin, long idx);
Ubyte	*XPINDesc(XPIN *xpin, long idx);
void		XPINVersion(XPIN *xpin, long idx, XVersion *version);
XPINErr	XPINCall(XPIN *xpin, long idx, XBlock *xBlock);
void		XPINDone(XPIN *xpin);

#endif
