/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: XPINOP.C

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  When a plug-in is called, an action-code is passed down to it
  as part of the XBlock structure. If the action-code is less than
  XOP_CONTROL, then the functions XPINopXXXX contained herein are
  called. These functions takes care of all the miscellaneous bookkeeping
  control stuff that needs to happen for each plug-in. If the
  action-code is greater than XOP_CONTROL, the plug-in just falls
  through and executes the body of the code. Most calls will do just
  that (the action-code is set to XOP_DO). As a designer of cool
  plug-ins, you can define your own canned action routines and add
  them do this list so you can have plug-ins called with all manner
  of control functions...
  - To keep things simple, we only provide two functions:

	XPINopINIT - Called when the caller passes XOP_INIT
	XPINopDONE - Called when the caller passes XOP_DONE

  @End-Description.

*/
#ifndef XPINOP_H
#define	XPINOP_H

#include "XCONFIG.h"

#ifdef OS_WIN
#include <windows.h>
#include <memory.h>
#elif OS_MAC
#include <string.h>
// #include <SetUpA4.h>			// NOTE: this file actually generates inline code
#endif

#include "XPINTYPE.h"		// XPIN data types
#include "XPINSHR.h"		// Caller/PIN shared items

#ifdef OS_WIN
void FAR PASCAL XPINopINIT(XBlockP xblk, LPSTR label, LPSTR desc,
					  int major, int minor)
{
	_fmemcpy((LPSTR) XGETp(xblk,0), label, XPINLABEL);
	_fmemcpy((LPSTR) XGETp(xblk,1), desc,  XPINDESC);
#elif OS_MAC
void  XPINopINIT(XBlockP xblk, char *label, char *desc,
					  int major, int minor)
{
//	SetUpA4();
	memcpy((char *) XGETp(xblk, 0), label, XPINLABEL);
	memcpy((char *) XGETp(xblk,1), desc,  XPINDESC);
#endif
// Common Code

	XSETw(xblk, 2, major);
	XSETw(xblk, 3, minor);
	// Do any action that needs to be done whenever they
	// call XOP_INIT here. Leave the above lines intact.
	// They are needed to let the caller store the labels
	// and descriptions, so that calls to XPINLabel and
	// XPINDesc don't invoke any DLL loading overhead...

#ifdef COMPILER_THINK
//	RestoreA4();
#endif
}

#ifdef OS_WIN
void FAR PASCAL XPINopDONE(XBlockP xblk)
#elif OS_MAC
void XPINopDONE(XBlockP xblk)
#endif
{
#ifdef	COMPILER_THINK
//	SetUpA4();
#endif
    // Do anything that needs to be done when they call
    // XPINDone here...

#ifdef COMPILER_THINK
//	RestoreA4();
#endif
}


#endif
