/*
  @Project: The cross-platform plug-in toolkit (XPIN).
  @Project-Version: 1.2
  @Project-Date: December 1992.
  @Filename: XPINTYPE.H

  @Author: Ramin Firoozye - rp&A Inc.
  @Copyright: (c) 1992, rp&A Inc. - San Francisco, CA.
  @License.
  The portable plug-in toolkit source and library code is
  presented without any warranty or assumption of responsibility
  from rp&A Inc. and the author. You can not sell this toolkit in
  source or library form as a standalone product without express
  permission of rp&A Inc. You are, however, encouraged to use this
  code in your personal or commercial application without any
  royalties. You can modify the sources as long as the license
  and credits are included with the source.

  For bugs, updates, thanks, or suggestions you can contact the
  author at:
	CompuServe: 70751,252
	Internet: rpa@netcom.com

  @End-License.

  @Description.
  These are common XPIN data types.
  NOTE: This is where also where we decide what platform and
  compiler we're running with. This simplifies the #ifdef's
  we have to do later.
  Basically, here's how it gets figured out:

  @End-Description.

*/
#ifndef	XPINTYPE_H
#define	XPINTYPE_H

#include "XCONFIG.h"	// for compatibility flags.

typedef	unsigned char	Ubyte;
typedef	unsigned int	Uword;
typedef	unsigned long	Ulong;
typedef	unsigned char	Bool;

#ifdef OS_WIN
#define Uptr		LPSTR
#define	LibSpec	HINSTANCE	// value associated with a DLL library
#elif OS_MAC
typedef unsigned char *Uptr;
typedef	int 	LibSpec;			// value associated with a Resource file
typedef	char * LPSTR;
#endif

#define	SMALLBUF		80
#define	MEDIUMBUF		128
#define	LARGEBUF		255

typedef	unsigned char Sbuf[SMALLBUF];
typedef	unsigned char Mbuf[MEDIUMBUF];
typedef	unsigned char Lbuf[LARGEBUF];

// NOTE: The FType field in DOS is the three letter extension to a filename to look for.
// It is passed as poiner to a null-terminated string. On the Mac, it's a 4-byte long.
// To make the API consistent, we require the Mac version to be passed as a pointer
// to a null-terminated string as well. At the right moment, we just extract the
// first four bytes of the string and use it as the Mac Filetype.
typedef	char *FType;		// FileType object
#define	DIRSIZE		128     // Full pathname size
#define	FILESIZE	15		// FileName size
#define	PATHSIZE	DIRSIZE+FILESIZE
typedef	char FileSpec[FILESIZE];

#ifdef OS_WIN
typedef	char PathSpec[PATHSIZE];
#elif OS_MAC
// We just use system 7's FSSpec's.
#define	PathSpec	FSSpec
#endif

#ifndef NIL
#define	NIL	0L
#endif

#ifndef TRUE
#define	TRUE	true
#endif

#ifndef	FALSE
#define	FALSE	false
#endif

/*
 * The error status datatype.
 */
#define XPINErr int				// NOTE: It's signed.

#endif
