{ perm1.pas -- Algorithm #2: Permutation One by Tom Swan }

program Perm1;

const
  MAX = 4;

var
  i: Integer;
  a: array[1 .. MAX] of Integer;

{ Display contents of global array a }
procedure ShowArray;
var
  i: Integer;
begin
  for i := 1 to MAX do
    Write(a[i]:3);
  Writeln
end;

{ Arrange global array a in all possible ways }
procedure Permute(n: Integer);
var
  i, temp: Integer;
begin
  if n = 1 then ShowArray else
  begin
    Permute(n - 1);
    for i := 1 to n - 1 do
    begin
      temp := a[i];  { Swap a[i] and a[n] }
      a[i] := a[n];
      a[n] := temp;
      Permute(n - 1);
      temp := a[i];  { Restore a[i] and a[n] }
      a[i] := a[n];
      a[n] := temp
    end
  end
end;

begin
  for i := 1 to MAX do
    a[i] := i;
  Permute(MAX)
end.


(*
// ---------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 02/13/1993   Time: 02:14 pm
*)
